/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.point;

import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.jcin2.BJciN2Device;
import com.tridium.jcin2.BJciN2Network;
import com.tridium.jcin2.enums.BJciN2ObjectType;
import com.tridium.jcin2.messages.JciN2Response;
import com.tridium.jcin2.point.BSetpointAction;
import com.tridium.jcin2.point.SetpointRequest;
import com.tridium.jcin2.point.WriteRequest;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BJciN2ProxyExt
extends BProxyExt
implements BIBasicPollable {
    public static final Property networkPointType = BJciN2ProxyExt.newProperty((int)0, (BValue)BJciN2ObjectType.unconfigured, null);
    public static final Property networkPointAddress = BJciN2ProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)256));
    public static final Property shortName = BJciN2ProxyExt.newProperty((int)0, (String)"", null);
    public static final Property longName = BJciN2ProxyExt.newProperty((int)0, (String)"", null);
    public static final Property profileName = BJciN2ProxyExt.newProperty((int)0, (String)"", null);
    public static final Property pollFrequency = BJciN2ProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property traceThisPoint = BJciN2ProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Property currentTime = BJciN2ProxyExt.newProperty((int)4, (int)0, null);
    public static final Property lastTime = BJciN2ProxyExt.newProperty((int)4, (int)0, null);
    public static final Property pointTime = BJciN2ProxyExt.newProperty((int)4, (int)0, null);
    public static final Property roundTripTime = BJciN2ProxyExt.newProperty((int)4, (int)0, null);
    public static final Property roundTripTimeAverage = BJciN2ProxyExt.newProperty((int)4, (int)0, null);
    public static final Property roundTripTimeSum = BJciN2ProxyExt.newProperty((int)4, (int)0, null);
    public static final Property elpasedDeviceTime = BJciN2ProxyExt.newProperty((int)4, (int)0, null);
    public static final Property elpasedDeviceTimeAverage = BJciN2ProxyExt.newProperty((int)4, (int)0, null);
    public static final Property elpasedDeviceTimeSum = BJciN2ProxyExt.newProperty((int)4, (int)0, null);
    public static final Property traceCount = BJciN2ProxyExt.newProperty((int)4, (int)0, null);
    public static final Action forceRead = BJciN2ProxyExt.newAction((int)0, null);
    public static final Action forceWrite = BJciN2ProxyExt.newAction((int)0, null);
    public static final Type TYPE;
    static final Context rewriteCx;
    boolean overridden;
    static /* synthetic */ Class class$com$tridium$jcin2$point$BJciN2ProxyExt;
    static /* synthetic */ Class class$com$tridium$jcin2$point$BSetpointAction;

    public BJciN2ObjectType getNetworkPointType() {
        return (BJciN2ObjectType)this.get(networkPointType);
    }

    public void setNetworkPointType(BJciN2ObjectType bJciN2ObjectType) {
        this.set(networkPointType, (BValue)bJciN2ObjectType, null);
    }

    public int getNetworkPointAddress() {
        return this.getInt(networkPointAddress);
    }

    public void setNetworkPointAddress(int n) {
        this.setInt(networkPointAddress, n, null);
    }

    public String getShortName() {
        return this.getString(shortName);
    }

    public void setShortName(String string) {
        this.setString(shortName, string, null);
    }

    public String getLongName() {
        return this.getString(longName);
    }

    public void setLongName(String string) {
        this.setString(longName, string, null);
    }

    public String getProfileName() {
        return this.getString(profileName);
    }

    public void setProfileName(String string) {
        this.setString(profileName, string, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public boolean getTraceThisPoint() {
        return this.getBoolean(traceThisPoint);
    }

    public void setTraceThisPoint(boolean bl) {
        this.setBoolean(traceThisPoint, bl, null);
    }

    public long getCurrentTime() {
        return this.getLong(currentTime);
    }

    public void setCurrentTime(long l) {
        this.setLong(currentTime, l, null);
    }

    public long getLastTime() {
        return this.getLong(lastTime);
    }

    public void setLastTime(long l) {
        this.setLong(lastTime, l, null);
    }

    public long getPointTime() {
        return this.getLong(pointTime);
    }

    public void setPointTime(long l) {
        this.setLong(pointTime, l, null);
    }

    public long getRoundTripTime() {
        return this.getLong(roundTripTime);
    }

    public void setRoundTripTime(long l) {
        this.setLong(roundTripTime, l, null);
    }

    public long getRoundTripTimeAverage() {
        return this.getLong(roundTripTimeAverage);
    }

    public void setRoundTripTimeAverage(long l) {
        this.setLong(roundTripTimeAverage, l, null);
    }

    public long getRoundTripTimeSum() {
        return this.getLong(roundTripTimeSum);
    }

    public void setRoundTripTimeSum(long l) {
        this.setLong(roundTripTimeSum, l, null);
    }

    public long getElpasedDeviceTime() {
        return this.getLong(elpasedDeviceTime);
    }

    public void setElpasedDeviceTime(long l) {
        this.setLong(elpasedDeviceTime, l, null);
    }

    public long getElpasedDeviceTimeAverage() {
        return this.getLong(elpasedDeviceTimeAverage);
    }

    public void setElpasedDeviceTimeAverage(long l) {
        this.setLong(elpasedDeviceTimeAverage, l, null);
    }

    public long getElpasedDeviceTimeSum() {
        return this.getLong(elpasedDeviceTimeSum);
    }

    public void setElpasedDeviceTimeSum(long l) {
        this.setLong(elpasedDeviceTimeSum, l, null);
    }

    public long getTraceCount() {
        return this.getLong(traceCount);
    }

    public void setTraceCount(long l) {
        this.setLong(traceCount, l, null);
    }

    public void forceRead() {
        this.invoke(forceRead, null, null);
    }

    public void forceWrite() {
        this.invoke(forceWrite, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.checkSetpoint();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        super.changed(property, context);
        if (property.equals((Object)networkPointType)) {
            this.setStale(true, null);
            this.checkSetpoint();
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        }
        if (property.equals((Object)networkPointAddress)) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
            this.getN2Log().trace("Prop NPA Changed: " + this.getN2Device().getName() + ": " + (Object)((Object)this));
        }
        if (property.equals((Object)status)) {
            BStatus bStatus = this.getStatus();
            BStatusValue bStatusValue = this.getReadValue();
            String string = "???";
            if (this.getN2Device() != null) {
                string = this.getN2Device().getName();
            }
            this.getN2Log().trace("STATUS Changed for: " + string + ": " + (Object)((Object)this) + ", status: " + bStatus + ", value: " + bStatusValue + ", cause: " + this.getFaultCause() + ", cx: " + context);
        }
        if (property.equals((Object)traceThisPoint)) {
            if (this.getTraceThisPoint()) {
                this.setFlags(this.getSlot("lastTime"), 0);
                this.setFlags(this.getSlot("currentTime"), 0);
                this.setFlags(this.getSlot("pointTime"), 0);
                this.setFlags(this.getSlot("roundTripTime"), 0);
                this.setFlags(this.getSlot("roundTripTimeAverage"), 0);
                this.setFlags(this.getSlot("elpasedDeviceTime"), 0);
                this.setFlags(this.getSlot("elpasedDeviceTimeAverage"), 0);
                this.setFlags(this.getSlot("traceCount"), 0);
                this.setLastTime(0L);
                this.setCurrentTime(0L);
                this.setPointTime(0L);
                this.setRoundTripTime(0L);
                this.setRoundTripTimeAverage(0L);
                this.setRoundTripTimeSum(0L);
                this.setElpasedDeviceTime(0L);
                this.setElpasedDeviceTimeAverage(0L);
                this.setElpasedDeviceTimeSum(0L);
                this.setTraceCount(0L);
            } else {
                this.setFlags(this.getSlot("lastTime"), 4);
                this.setFlags(this.getSlot("currentTime"), 4);
                this.setFlags(this.getSlot("pointTime"), 4);
                this.setFlags(this.getSlot("roundTripTime"), 4);
                this.setFlags(this.getSlot("roundTripTimeAverage"), 4);
                this.setFlags(this.getSlot("elpasedDeviceTime"), 4);
                this.setFlags(this.getSlot("elpasedDeviceTimeAverage"), 4);
                this.setFlags(this.getSlot("traceCount"), 4);
            }
            this.getN2Log().trace("Prop traceThisPoint Changed: " + this.getN2Device().getName() + ": " + (Object)((Object)this));
        }
    }

    public void doForceRead() {
        this.getN2Network().postAsync(new Runnable(){

            public final void run() {
                BJciN2ProxyExt.this.poll();
            }
        });
    }

    public void doForceWrite() {
        try {
            this.write((Context)null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void readSubscribed(Context context) throws Exception {
        this.getN2Log().trace("readSubscribed on " + (Object)((Object)this));
        this.getN2Network().getPollScheduler().subscribe((BIPollable)this);
    }

    public void readUnsubscribed(Context context) throws Exception {
        this.getN2Log().trace("readUnsubscribed on " + (Object)((Object)this));
        this.getN2Network().getPollScheduler().unsubscribe((BIPollable)this);
    }

    public final boolean write(Context context) throws Exception {
        this.getN2Log().trace("...write on " + this.getN2Device().getName() + ": " + (Object)((Object)this) + ", val: " + this.getWriteValue() + ", ovr: " + this.overridden);
        if (!this.isValid()) {
            return false;
        }
        BStatusValue bStatusValue = this.getWriteValue();
        if ((bStatusValue == null || bStatusValue.getStatus().isNull()) && !this.overridden) {
            return false;
        }
        this.getN2Network().postWrite(new WriteRequest(this, bStatusValue));
        return true;
    }

    public abstract void setValue(JciN2Response var1);

    abstract void write(BStatusValue var1);

    abstract void setpoint(BValue var1);

    private final void checkSetpoint() {
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$jcin2$point$BSetpointAction;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$point$BSetpointAction = BJciN2ProxyExt.class("[Lcom.tridium.jcin2.point.BSetpointAction;", false);
        }
        BSetpointAction[] bSetpointActionArray = (BSetpointAction[])bControlPoint.getChildren(clazz);
        if (BJciN2ObjectType.hasSetpoint(this.getNetworkPointType().getOrdinal()) && this.getParentPoint().isWritablePoint()) {
            if (bSetpointActionArray.length == 0) {
                BSetpointAction bSetpointAction = new BSetpointAction();
                bSetpointAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
                this.getParentPoint().add("Setpoint", (BValue)bSetpointAction, 4);
            }
        } else {
            int n = 0;
            while (n < bSetpointActionArray.length) {
                this.getParentPoint().remove((BComplex)bSetpointActionArray[n]);
                ++n;
            }
        }
    }

    public void setpoint(BValue bValue, Context context) {
        this.getN2Log().trace("Setpoint on " + this.getN2Device().getName() + ": " + (Object)((Object)this) + ": value= " + bValue);
        if (!this.isValid()) {
            return;
        }
        if (!BJciN2ObjectType.hasSetpoint(this.getNetworkPointType().getOrdinal())) {
            return;
        }
        this.getN2Network().postWrite(new SetpointRequest(this, bValue));
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        if (this.getN2Device() != null) {
            string = this.getN2Device().getName();
        }
        try {
            string = SlotPath.unescape((String)this.getParent().getParent().getParent().getName());
        }
        catch (RuntimeException runtimeException) {}
        stringBuffer.append("N2Px:").append(string).append(":").append(this.getShortName()).append(" [").append((Object)this.getNetworkPointType()).append(':').append(this.getNetworkPointAddress()).append("] ");
        return stringBuffer.toString();
    }

    public BJciN2Network getN2Network() {
        return (BJciN2Network)this.getNetwork();
    }

    public BJciN2Device getN2Device() {
        BJciN2Device bJciN2Device = null;
        try {
            bJciN2Device = (BJciN2Device)this.getDevice();
        }
        catch (Exception exception) {}
        return bJciN2Device;
    }

    public final void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"JciN2ProxyExt", 2);
        spyWriter.prop((Object)"overridden", this.overridden);
        spyWriter.prop((Object)"isValid", this.isValid());
        this.n2spy(spyWriter);
        spyWriter.endProps();
    }

    public void n2spy(SpyWriter spyWriter) throws Exception {
    }

    boolean isValid() {
        boolean bl = false;
        if (this.getNetworkPointType() != BJciN2ObjectType.unconfigured && this.getNetworkPointAddress() > 0) {
            bl = true;
        }
        return bl;
    }

    Log getN2Log() {
        try {
            if (this.getN2Device().getTraceThisDevice()) {
                return this.getN2Network().getN2Log();
            }
            return Log.getLog((String)"jcin2.x");
        }
        catch (Exception exception) {
            return Log.getLog((String)"jcin2.x");
        }
    }

    public void pointTrace(BJciN2ProxyExt bJciN2ProxyExt, boolean bl) {
        if (bJciN2ProxyExt.getTraceThisPoint()) {
            long l = System.currentTimeMillis();
            if (bl) {
                bJciN2ProxyExt.setLastTime(bJciN2ProxyExt.getCurrentTime());
                bJciN2ProxyExt.setCurrentTime(l);
                if (bJciN2ProxyExt.getLastTime() > 0L) {
                    bJciN2ProxyExt.setRoundTripTime(bJciN2ProxyExt.getCurrentTime() - bJciN2ProxyExt.getLastTime());
                    bJciN2ProxyExt.setTraceCount(bJciN2ProxyExt.getTraceCount() + 1L);
                    bJciN2ProxyExt.setRoundTripTimeSum(bJciN2ProxyExt.getRoundTripTimeSum() + bJciN2ProxyExt.getRoundTripTime());
                    if (bJciN2ProxyExt.getTraceCount() > 0L) {
                        bJciN2ProxyExt.setRoundTripTimeAverage(bJciN2ProxyExt.getRoundTripTimeSum() / bJciN2ProxyExt.getTraceCount());
                    }
                }
            } else {
                bJciN2ProxyExt.setPointTime(l - bJciN2ProxyExt.getCurrentTime());
                BJciN2ProxyExt bJciN2ProxyExt2 = null;
                BJciN2ProxyExt bJciN2ProxyExt3 = null;
                BControlPoint[] bControlPointArray = null;
                bControlPointArray = this.getN2Device().getPoints().getPoints();
                bJciN2ProxyExt2 = (BJciN2ProxyExt)bControlPointArray[0].getProxyExt();
                bJciN2ProxyExt3 = (BJciN2ProxyExt)bControlPointArray[bControlPointArray.length - 1].getProxyExt();
                if (bJciN2ProxyExt == bJciN2ProxyExt3) {
                    long l2 = 0L;
                    l2 = l - bJciN2ProxyExt2.getCurrentTime();
                    bJciN2ProxyExt.setElpasedDeviceTime(l2);
                    bJciN2ProxyExt.setElpasedDeviceTimeSum(bJciN2ProxyExt.getElpasedDeviceTimeSum() + l2);
                    if (bJciN2ProxyExt.getTraceCount() > 0L) {
                        bJciN2ProxyExt.setElpasedDeviceTimeAverage(bJciN2ProxyExt.getElpasedDeviceTimeSum() / bJciN2ProxyExt.getTraceCount());
                    }
                }
            }
        }
    }

    public boolean isOverridden() {
        return this.overridden;
    }

    public void setOverridden(boolean bl) {
        this.overridden = bl;
    }

    static final void d(String string) {
        System.out.println(string);
    }

    public void readFail(String string) {
        super.readFail(string);
        boolean bl = this.getN2Log().isTraceOn();
        if (bl) {
            this.getN2Log().trace("READ FAILED for: " + this.getN2Device().getName() + ": " + (Object)((Object)this) + ", " + string);
        }
    }

    public void writeFail(String string) {
        super.writeFail(string);
        boolean bl = this.getN2Log().isTraceOn();
        if (bl) {
            this.getN2Log().trace("WRITE FAILED for: " + this.getN2Device().getName() + ": " + (Object)((Object)this) + ", " + string);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.overridden = false;
    }

    public BJciN2ProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$jcin2$point$BJciN2ProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$point$BJciN2ProxyExt = BJciN2ProxyExt.class("[Lcom.tridium.jcin2.point.BJciN2ProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        rewriteCx = new BasicContext(){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (this == object) {
                    bl = true;
                }
                return bl;
            }

            public final String toString() {
                return "jcin2:rewrite";
            }
        };
    }
}

