/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.point;

import com.tridium.jcin2.messages.JciN2OResponse;
import com.tridium.jcin2.messages.JciN2Response;
import com.tridium.jcin2.messages.N2OOverrideMessage;
import com.tridium.jcin2.messages.N2OOverrideRelease;
import com.tridium.jcin2.messages.N2OReadMessage;
import com.tridium.jcin2.messages.N2OReadResponse;
import com.tridium.jcin2.messages.N2OSetpointMessage;
import com.tridium.jcin2.point.BJciN2OPointDeviceExt;
import com.tridium.jcin2.point.BJciN2ProxyExt;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BJciN2OProxyExt
extends BJciN2ProxyExt {
    public static final Type TYPE;
    private static final int AI_VALUE_ATTRIBUTE = 3;
    private static final int BI_VALUE_ATTRIBUTE = 2;
    private static final int AO_VALUE_ATTRIBUTE = 3;
    private static final int BO_VALUE_ATTRIBUTE = 2;
    private static final int ADF_VALUE_ATTRIBUTE = 2;
    private static final int ADI_VALUE_ATTRIBUTE = 2;
    private static final int BD_VALUE_ATTRIBUTE = 2;
    static final int RELIABILITY_MASK = 1;
    static final int OVERRIDE_MASK = 2;
    static final int HIGH_RANGE_MASK = 4;
    static final int LOW_RANGE_MASK = 8;
    static final int SATURATED_HIGH_MASK = 4;
    static final int SATURATED_LOW_MASK = 8;
    static final int NORMAL_STATE_MASK = 2;
    static final int ALARM_MASK = 16;
    static final int TROUBLE_MASK = 32;
    static final int VALUE_MASK = 64;
    static final int COS_MASK = 112;
    static final int COS_SHIFT = 4;
    static final int NORMAL = 0;
    static final int TROUBLE = 1;
    static final int UNAVAILABLE = 2;
    static final int LOW_WARNING = 3;
    static final int LOW_ALARM = 4;
    static final int HIGH_WARNING = 5;
    static final int HIGH_ALARM = 6;
    static final int UNDEFINED = 7;
    static /* synthetic */ Class class$com$tridium$jcin2$point$BJciN2OProxyExt;

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BJciN2OPointDeviceExt.TYPE;
    }

    public void poll() {
        if (!this.isValid()) {
            return;
        }
        this.pointTrace(this, true);
        N2OReadMessage n2OReadMessage = new N2OReadMessage(this.getN2Device().getAddress(), this.getNetworkPointType().getOrdinal(), this.getNetworkPointAddress(), this.getValueAttribute());
        N2OReadResponse n2OReadResponse = (N2OReadResponse)this.getN2Network().sendSync(n2OReadMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (n2OReadResponse != null) {
            if (n2OReadResponse.isNakError()) {
                this.getN2Log().trace("N2O NAK response from: " + this.getN2Device().getName() + ", NPT:" + (Object)((Object)this.getNetworkPointType()) + ", NPA:" + this.getNetworkPointAddress() + ", EC: " + TextUtil.byteToHexString((int)n2OReadResponse.getNakErrorCode()));
            }
            if (!n2OReadResponse.isError()) {
                try {
                    if (this.getNetworkPointType().getOrdinal() == 1 && n2OReadResponse.getResponseMsgLength() != 13) {
                        this.getN2Log().trace("AI Read RESP msg improper length = " + n2OReadResponse.getResponseMsgLength() + " from: " + this.getN2Device().getName() + ", NPT:" + (Object)((Object)this.getNetworkPointType()) + ", NPA:" + this.getNetworkPointAddress());
                        return;
                    }
                    if (this.getNetworkPointType().getOrdinal() == 5 && n2OReadResponse.getResponseMsgLength() != 13) {
                        this.getN2Log().trace("ADF Read RESP msg improper length = " + n2OReadResponse.getResponseMsgLength() + " from: " + this.getN2Device().getName() + ", NPT:" + (Object)((Object)this.getNetworkPointType()) + ", NPA:" + this.getNetworkPointAddress());
                        return;
                    }
                }
                catch (Exception exception) {
                    this.getN2Log().trace("BJciN2OProxyExt Read Message response length test ERROR");
                }
                this.getN2Device().pingOk();
                this.setValue(n2OReadResponse);
            } else {
                this.getN2Log().trace("Read Response is Error! " + n2OReadResponse.getError() + " on " + this.getN2Device().getName() + ": " + (Object)((Object)this));
                if (n2OReadResponse.getErrorCode() == 0) {
                    this.getN2Device().pingFail("Device Reset");
                    this.getN2Device().setFaultCause("Device has Reset");
                    this.getN2Device().setNeedsId(true);
                }
                this.readFail(n2OReadResponse.getError());
            }
        } else {
            this.getN2Log().trace("Read Failed N2O - null response from: " + (Object)((Object)this));
            this.readFail("Null Response");
            this.getN2Device().pingFail("null response to point poll of " + (Object)((Object)this));
        }
        this.pointTrace(this, false);
    }

    void write(BStatusValue bStatusValue) {
        BStatusValue bStatusValue2 = this.getWriteValue();
        this.getN2Log().trace("write(" + bStatusValue + ") on " + this.getN2Device().getName() + ": " + (Object)((Object)this) + ", status: " + bStatusValue.getStatus() + ", ovr: " + this.overridden + ", writeValue = " + bStatusValue2);
        bStatusValue = bStatusValue2;
        if (bStatusValue == null || bStatusValue.getStatus().isNull()) {
            if (this.overridden) {
                N2OOverrideRelease n2OOverrideRelease = new N2OOverrideRelease(this.getN2Device().getAddress(), this.getNetworkPointType().getOrdinal(), this.getNetworkPointAddress());
                JciN2Response jciN2Response = (JciN2Response)this.getN2Network().sendSync(n2OOverrideRelease, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciN2Response != null) {
                    if (jciN2Response instanceof N2OReadResponse && ((N2OReadResponse)jciN2Response).isNakError()) {
                        this.getN2Log().trace("N2O NAK response from: " + this.getN2Device().getName() + ", NPT:" + (Object)((Object)this.getNetworkPointType()) + ", NPA:" + this.getNetworkPointAddress() + ", EC: " + TextUtil.byteToHexString((int)((N2OReadResponse)jciN2Response).getNakErrorCode()));
                    }
                    if (!jciN2Response.isError()) {
                        this.getN2Device().pingOk();
                        this.getN2Log().trace("N2 Override Release Succeeded on: " + this.getN2Device().getName() + ": " + (Object)((Object)this));
                        this.overridden = false;
                        this.writeOk(bStatusValue);
                        this.doForceRead();
                        this.getN2Log().trace("N2O Proxy doForceRead on: " + this.getN2Device().getName() + ": " + (Object)((Object)this));
                    } else {
                        this.getN2Log().trace("N2 Override Release Error on: " + this.getN2Device().getName() + ": " + (Object)((Object)this));
                        if (jciN2Response.getErrorCode() == 0) {
                            this.getN2Device().setNeedsId(true);
                            this.getN2Device().ping();
                            try {
                                this.write(rewriteCx);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        this.writeFail(jciN2Response.getError());
                    }
                } else {
                    this.getN2Log().trace("N2 Override Release Failed - null response!");
                    this.writeFail("Null Response");
                    this.getN2Device().pingFail("null response to point poll of " + (Object)((Object)this));
                }
            }
        } else {
            N2OOverrideMessage n2OOverrideMessage = new N2OOverrideMessage(this.getN2Device().getAddress(), this.getNetworkPointType().getOrdinal(), this.getNetworkPointAddress(), bStatusValue);
            JciN2OResponse jciN2OResponse = (JciN2OResponse)this.getN2Network().sendSync(n2OOverrideMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
            this.overridden = true;
            if (jciN2OResponse != null) {
                if (jciN2OResponse.isNakError()) {
                    this.getN2Log().trace("N2O NAK response from: " + this.getN2Device().getName() + ", NPT:" + (Object)((Object)this.getNetworkPointType()) + ", NPA:" + this.getNetworkPointAddress() + ", EC: " + TextUtil.byteToHexString((int)jciN2OResponse.getNakErrorCode()));
                }
                if (!jciN2OResponse.isError()) {
                    this.getN2Device().pingOk();
                    this.getN2Log().trace("N2 Override Succeeded on: " + this.getN2Device().getName() + ": " + (Object)((Object)this));
                    this.writeOk(bStatusValue);
                    this.doForceRead();
                    this.getN2Log().trace("N2O Proxy doForceRead on: " + this.getN2Device().getName() + ": " + (Object)((Object)this));
                } else {
                    this.getN2Log().trace("N2 Override Error! ec = " + jciN2OResponse.getErrorCode() + ", on: " + this.getN2Device().getName() + ": " + (Object)((Object)this));
                    if (jciN2OResponse.getErrorCode() == 0) {
                        this.getN2Device().setNeedsId(true);
                        this.getN2Device().ping();
                        try {
                            this.write(rewriteCx);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    this.writeFail(jciN2OResponse.getError());
                }
            } else {
                this.getN2Log().trace("N2 Override Failed - null response!");
                this.writeFail("Null Response");
                this.getN2Device().pingFail("null response to point poll of " + (Object)((Object)this));
            }
        }
    }

    void setpoint(BValue bValue) {
        this.getN2Log().trace("Setpoint(" + bValue + ") on " + this.getN2Device().getName() + (Object)((Object)this));
        N2OSetpointMessage n2OSetpointMessage = new N2OSetpointMessage(this.getN2Device().getAddress(), this.getNetworkPointType().getOrdinal(), this.getNetworkPointAddress(), bValue);
        JciN2OResponse jciN2OResponse = (JciN2OResponse)this.getN2Network().sendSync(n2OSetpointMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (jciN2OResponse != null) {
            if (jciN2OResponse.isNakError()) {
                this.getN2Log().trace("N2O NAK response from: " + this.getN2Device().getName() + ", NPT:" + (Object)((Object)this.getNetworkPointType()) + ", NPA:" + this.getNetworkPointAddress() + ", EC: " + TextUtil.byteToHexString((int)jciN2OResponse.getNakErrorCode()));
            }
            if (!jciN2OResponse.isError()) {
                this.getN2Device().pingOk();
                this.getN2Log().trace("N2 Setpoint Succeeded on: " + this.getN2Device().getName() + ':' + (Object)((Object)this) + ", to value = " + bValue);
                this.doForceRead();
                this.getN2Log().trace("N2O Setpoint doForceRead on: " + this.getN2Device().getName() + ": " + (Object)((Object)this));
            } else {
                this.getN2Log().trace("N2 Setpoint Error on: " + this.getN2Device().getName() + ": " + (Object)((Object)this));
                if (jciN2OResponse.getErrorCode() == 0) {
                    this.getN2Device().setNeedsId(true);
                    this.getN2Device().ping();
                    try {
                        this.setpoint(bValue, rewriteCx);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.writeFail(jciN2OResponse.getError());
            }
        } else {
            this.getN2Log().trace("N2 Setpoint Failed - null response!");
            this.writeFail("Null Response");
            this.getN2Device().pingFail("null response to point poll of " + (Object)((Object)this));
        }
    }

    private final int getValueAttribute() {
        switch (this.getNetworkPointType().getOrdinal()) {
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 2;
            }
        }
        return 0;
    }

    private final boolean isInternal() {
        boolean bl = false;
        if (this.getNetworkPointType().getOrdinal() > 4) {
            bl = true;
        }
        return bl;
    }

    boolean aiInAlarm(int n) {
        int n2 = n & 7;
        switch (n2) {
            case 0: 
            case 2: 
            case 3: 
            case 5: {
                return false;
            }
            case 1: 
            case 4: 
            case 6: {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid COS status:" + n2);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$jcin2$point$BJciN2OProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$point$BJciN2OProxyExt = BJciN2OProxyExt.class("[Lcom.tridium.jcin2.point.BJciN2OProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

