/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.point;

import com.tridium.jcin2.messages.JciN2InputStream;
import com.tridium.jcin2.messages.JciN2Response;
import com.tridium.jcin2.messages.N2OReadMessage;
import com.tridium.jcin2.messages.N2OReadResponse;
import com.tridium.jcin2.point.BJciN2OProxyExt;
import javax.baja.control.BNumericPoint;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJciN2ONumericProxyExt
extends BJciN2OProxyExt {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$jcin2$point$BJciN2ONumericProxyExt;

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BNumericPoint;
    }

    public void poll() {
        if (this.getNetworkPointType().getOrdinal() == 2) {
            if (!this.isValid()) {
                return;
            }
            N2OReadMessage n2OReadMessage = new N2OReadMessage(this.getN2Device().getAddress(), this.getNetworkPointType().getOrdinal(), this.getNetworkPointAddress(), 4);
            N2OReadResponse n2OReadResponse = (N2OReadResponse)this.getN2Network().sendSync(n2OReadMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
            if (n2OReadResponse != null) {
                if (!n2OReadResponse.isError()) {
                    this.getN2Device().pingOk();
                    this.setValue(n2OReadResponse);
                } else {
                    this.getN2Log().trace("Read Response is Error! BI msg = " + n2OReadMessage);
                    if (n2OReadResponse.getErrorCode() == 0) {
                        this.getN2Device().setNeedsId(true);
                        this.getN2Device().ping();
                    }
                    this.readFail(n2OReadResponse.getError());
                }
            } else {
                this.getN2Log().trace("Read Failed - null response!");
                this.readFail("Null Response");
                this.getN2Device().pingFail("null response to point poll of " + (Object)((Object)this));
            }
        } else {
            super.poll();
        }
    }

    public void setValue(JciN2Response jciN2Response) {
        try {
            boolean bl;
            BStatusNumeric bStatusNumeric = (BStatusNumeric)this.getReadValue().newCopy();
            JciN2InputStream jciN2InputStream = jciN2Response.getIn();
            int n = jciN2InputStream.readByte();
            boolean bl2 = false;
            if ((n & 1) != 0) {
                bl2 = bl = true;
            }
            if (this.getN2Network().getUseMessageOverrideFlag()) {
                boolean bl3 = false;
                if ((n & 2) != 0) {
                    bl3 = true;
                }
                bStatusNumeric.setStatusOverridden(bl3);
            }
            boolean bl4 = false;
            if ((n & 2) != 0) {
                bl4 = true;
            }
            this.overridden = bl4;
            switch (this.getNetworkPointType().getOrdinal()) {
                case 1: {
                    double d;
                    boolean bl5;
                    boolean bl6 = false;
                    if ((n & 4) != 0) {
                        bl6 = true;
                    }
                    boolean bl7 = bl6;
                    boolean bl8 = false;
                    if ((n & 8) != 0) {
                        bl8 = bl5 = true;
                    }
                    if (Double.isNaN(d = jciN2InputStream.readFloat())) {
                        this.getN2Log().trace("N2ONumeric SetValue for AI is NaN! Dev/Pt = " + this.getN2Device().getName() + '/' + this.getName());
                        break;
                    }
                    bStatusNumeric.setValue(d);
                    boolean bl9 = false;
                    if (bl || bl7 || bl5) {
                        bl9 = true;
                    }
                    bStatusNumeric.setStatusFault(bl9);
                    bStatusNumeric.setStatusInAlarm(this.aiInAlarm(n));
                    break;
                }
                case 2: {
                    int n2 = jciN2InputStream.readByte();
                    bStatusNumeric.setValue((double)jciN2InputStream.readInt());
                    bStatusNumeric.setStatusFault(false);
                    bStatusNumeric.setStatusInAlarm(false);
                    break;
                }
                case 3: {
                    double d;
                    boolean bl10;
                    boolean bl11 = false;
                    if ((n & 4) != 0) {
                        bl11 = true;
                    }
                    boolean bl12 = bl11;
                    boolean bl13 = false;
                    if ((n & 8) != 0) {
                        bl13 = bl10 = true;
                    }
                    if (Double.isNaN(d = jciN2InputStream.readFloat())) {
                        this.getN2Log().trace("N2ONumeric SetValue for AO is NaN! Dev/Pt = " + this.getN2Device().getName() + '/' + this.getName());
                        break;
                    }
                    bStatusNumeric.setValue(d);
                    boolean bl14 = false;
                    if (bl || bl12 || bl10) {
                        bl14 = true;
                    }
                    bStatusNumeric.setStatusFault(bl14);
                    break;
                }
                case 4: {
                    boolean bl15;
                    boolean bl16 = false;
                    boolean bl17 = false;
                    if ((n & 0x20) != 0) {
                        bl17 = true;
                    }
                    boolean bl18 = bl17;
                    boolean bl19 = false;
                    if ((n & 0x40) != 0) {
                        bl19 = true;
                    }
                    bStatusNumeric.setValue((bl15 = bl19) ? 1.0 : 0.0);
                    bStatusNumeric.setStatusFault(bl);
                    bStatusNumeric.setStatusInAlarm(bl16 | bl18);
                    break;
                }
                case 5: {
                    double d = jciN2InputStream.readFloat();
                    if (Double.isNaN(d)) {
                        this.getN2Log().trace("N2ONumeric SetValue for ADF is NaN! Dev/Pt = " + this.getN2Device().getName() + '/' + this.getName());
                        break;
                    }
                    bStatusNumeric.setValue(d);
                    bStatusNumeric.setStatusFault(bl);
                    break;
                }
                case 6: {
                    bStatusNumeric.setValue((double)jciN2InputStream.readInt());
                    bStatusNumeric.setStatusFault(bl);
                    break;
                }
                case 7: {
                    bStatusNumeric.setValue((double)jciN2InputStream.readByte());
                    bStatusNumeric.setStatusFault(bl);
                    break;
                }
                default: {
                    throw new RuntimeException("setValue on unconfigured point!");
                }
            }
            this.readOk((BStatusValue)bStatusNumeric);
        }
        catch (Exception exception) {
            this.readFail(exception.toString());
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$jcin2$point$BJciN2ONumericProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$point$BJciN2ONumericProxyExt = BJciN2ONumericProxyExt.class("[Lcom.tridium.jcin2.point.BJciN2ONumericProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

