/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.point;

import com.tridium.jcin2.messages.JciN2BResponse;
import com.tridium.jcin2.messages.N2BCancelSignupMessage;
import com.tridium.jcin2.messages.N2BReadMessage;
import com.tridium.jcin2.messages.N2BReadResponse;
import com.tridium.jcin2.messages.N2BReadWithSignupMessage;
import com.tridium.jcin2.messages.N2BReadWithSignupResponse;
import com.tridium.jcin2.messages.N2BWriteMessage;
import com.tridium.jcin2.messages.N2BWriteResponse;
import com.tridium.jcin2.point.BJciN2BPointDeviceExt;
import com.tridium.jcin2.point.BJciN2ProxyExt;
import java.util.HashMap;
import javax.baja.driver.util.BIPollable;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BJciN2BProxyExt
extends BJciN2ProxyExt {
    public static final Type TYPE;
    private static HashMap cosOffenders;
    private int cancelNPT;
    private int cancelNPA;
    private int oldNPT;
    private int oldNPA;
    private boolean cov;
    static /* synthetic */ Class class$com$tridium$jcin2$point$BJciN2BProxyExt;

    public Type getType() {
        return TYPE;
    }

    public void started() {
        super.started();
        this.oldNPT = this.getNetworkPointType().getOrdinal();
        this.oldNPA = this.getNetworkPointAddress();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)networkPointType) || property.equals((Object)networkPointAddress)) {
            this.cancelNPT = this.oldNPT;
            this.cancelNPA = this.oldNPA;
            this.getN2Network().post(new Runnable(){

                public final void run() {
                    BJciN2BProxyExt.this.updateSubscription();
                }
            });
            this.oldNPT = this.getNetworkPointType().getOrdinal();
            this.oldNPA = this.getNetworkPointAddress();
        }
        if (property.equals((Object)status)) {
            BStatus bStatus = this.getStatus();
            BStatusValue bStatusValue = this.getReadValue();
            if (bStatus.isFault()) {
                this.getN2Log().trace("N2B STATUS Changed for: " + this.getN2Device().getName() + ": " + (Object)((Object)this) + ", status: " + bStatus + ", value: " + bStatusValue + ", cause: " + this.getFaultCause());
            }
        }
    }

    private final void updateSubscription() {
        if (this.cov) {
            this.cancelSignup(this.cancelNPT, this.cancelNPA);
        }
        this.getN2Network().getPollScheduler().unsubscribe((BIPollable)this);
        this.cov = false;
        if (this.isCOVPoint() && this.signup()) {
            this.cov = true;
        }
        if (!this.cov) {
            this.getN2Network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public boolean signup() {
        if (!this.isValid()) {
            return false;
        }
        boolean bl = this.getN2Log().isTraceOn();
        N2BReadWithSignupMessage n2BReadWithSignupMessage = new N2BReadWithSignupMessage(this.getN2Device().getAddress(), this.getNetworkPointType().getOrdinal(), this.getNetworkPointAddress());
        BRelTime bRelTime = BRelTime.make((long)(this.getN2Network().getResponseTimeout().getMillis() * (long)4));
        N2BReadWithSignupResponse n2BReadWithSignupResponse = (N2BReadWithSignupResponse)this.getN2Network().sendSync(n2BReadWithSignupMessage, bRelTime, this.getN2Network().getRetryCount());
        if (n2BReadWithSignupResponse != null) {
            if (!n2BReadWithSignupResponse.isError()) {
                this.getN2Device().pingOk();
                if (bl) {
                    this.getN2Log().trace("Read With Signup Succeeded on " + (Object)((Object)this));
                }
                this.setValue(n2BReadWithSignupResponse);
                return true;
            }
            if (bl) {
                this.getN2Log().trace("Read With Signup on " + (Object)((Object)this) + ": Response is Error!");
            }
            if (n2BReadWithSignupResponse.getErrorCode() == 0) {
                this.getN2Device().setNeedsId(true);
                this.getN2Device().ping();
            }
            this.readFail(n2BReadWithSignupResponse.getError());
            this.getN2Network().getPollScheduler().subscribe((BIPollable)this);
            return false;
        }
        if (bl) {
            this.getN2Log().trace("Read With Signup Failed on " + (Object)((Object)this) + ": null response!");
        }
        this.readFail("Null Response");
        this.getN2Device().pingFail("null response to point poll of " + (Object)((Object)this));
        this.getN2Network().getPollScheduler().subscribe((BIPollable)this);
        return false;
    }

    public boolean cancelSignup(int n, int n2) {
        if (!this.isValid(n, n2)) {
            return false;
        }
        boolean bl = this.getN2Log().isTraceOn();
        N2BCancelSignupMessage n2BCancelSignupMessage = new N2BCancelSignupMessage(this.getN2Device().getAddress(), n, n2);
        BRelTime bRelTime = BRelTime.make((long)(this.getN2Network().getResponseTimeout().getMillis() * (long)4));
        JciN2BResponse jciN2BResponse = (JciN2BResponse)this.getN2Network().sendSync(n2BCancelSignupMessage, bRelTime, this.getN2Network().getRetryCount());
        if (jciN2BResponse != null) {
            if (!jciN2BResponse.isError()) {
                this.getN2Device().pingOk();
                if (bl) {
                    this.getN2Log().trace("Cancel Signup Succeeded on " + (Object)((Object)this));
                }
                return true;
            }
            if (bl) {
                this.getN2Log().trace("Cancel Signup(" + n + ',' + n2 + ") on " + (Object)((Object)this) + ": Response is Error!");
            }
            if (jciN2BResponse.getErrorCode() == 0) {
                this.getN2Device().setNeedsId(true);
                this.getN2Device().ping();
            }
            return false;
        }
        if (bl) {
            this.getN2Log().trace("Cancel Signup(" + n + ',' + n2 + ") Failed on " + (Object)((Object)this) + ": null response!");
        }
        this.getN2Device().pingFail("null response to point poll of " + (Object)((Object)this));
        return false;
    }

    public Type getDeviceExtType() {
        return BJciN2BPointDeviceExt.TYPE;
    }

    public void readSubscribed(Context context) throws Exception {
        this.getN2Log().trace("readSubscribed on " + (Object)((Object)this));
        if (this.isCOVPoint()) {
            this.getN2Network().postAsync(new Runnable(){

                public final void run() {
                    BJciN2BProxyExt.this.cov = BJciN2BProxyExt.this.signup();
                }
            });
        } else {
            this.getN2Network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void readUnsubscribed(Context context) throws Exception {
        this.getN2Log().trace("readUnsubscribed on " + (Object)((Object)this));
        if (!this.isRunning()) {
            return;
        }
        if (this.cov && !this.getN2Device().getStatus().isDown()) {
            this.getN2Network().postAsync(new Runnable(){

                public final void run() {
                    BJciN2BProxyExt.this.cancelSignup(BJciN2BProxyExt.this.getNetworkPointType().getOrdinal(), BJciN2BProxyExt.this.getNetworkPointAddress());
                }
            });
        }
        this.cov = false;
        this.getN2Network().getPollScheduler().unsubscribe((BIPollable)this);
    }

    public void poll() {
        boolean bl = this.getN2Log().isTraceOn();
        if (!this.isValid()) {
            return;
        }
        this.pointTrace(this, true);
        N2BReadMessage n2BReadMessage = new N2BReadMessage(this.getN2Device().getAddress(), this.getNetworkPointType().getOrdinal(), this.getNetworkPointAddress());
        BRelTime bRelTime = BRelTime.make((long)(this.getN2Network().getResponseTimeout().getMillis() * (long)4));
        N2BReadResponse n2BReadResponse = (N2BReadResponse)this.getN2Network().sendSync(n2BReadMessage, bRelTime, this.getN2Network().getRetryCount());
        if (n2BReadResponse != null) {
            if (!n2BReadResponse.isError()) {
                this.getN2Device().pingOk();
                this.setValue(n2BReadResponse);
            } else {
                if (n2BReadResponse.getErrorCode() == 0) {
                    this.getN2Device().setNeedsId(true);
                    this.getN2Device().ping();
                }
                this.readFail(n2BReadResponse.getError());
                this.getN2Log().trace("Read Response is Error!, msg = " + n2BReadResponse.getError());
            }
        } else {
            if (bl) {
                this.getN2Log().trace("Read Failed on " + (Object)((Object)this) + ": null response!");
            }
            this.readFail("Null Response");
            this.getN2Device().pingFail("null response to point poll of " + (Object)((Object)this));
        }
        this.pointTrace(this, false);
    }

    void write(BStatusValue bStatusValue) {
        boolean bl = this.getN2Log().isTraceOn();
        if (bl) {
            this.getN2Log().trace("Write(" + bStatusValue + ") on " + (Object)((Object)this));
        }
        N2BWriteMessage n2BWriteMessage = new N2BWriteMessage(this.getN2Device().getAddress(), this.getNetworkPointType().getOrdinal(), this.getNetworkPointAddress(), (BValue)bStatusValue);
        BRelTime bRelTime = BRelTime.make((long)(this.getN2Network().getResponseTimeout().getMillis() * (long)4));
        N2BWriteResponse n2BWriteResponse = (N2BWriteResponse)this.getN2Network().sendSync(n2BWriteMessage, bRelTime, this.getN2Network().getRetryCount());
        this.overridden = true;
        if (n2BWriteResponse != null) {
            if (!n2BWriteResponse.isError()) {
                this.getN2Device().pingOk();
                if (bl) {
                    this.getN2Log().trace("Write Succeeded on: " + this.getN2Device().getName() + ": " + (Object)((Object)this));
                }
                this.writeOk(bStatusValue);
                this.doForceRead();
                if (bl) {
                    this.getN2Log().trace("N2B doForceRead on: " + this.getN2Device().getName() + ": " + (Object)((Object)this));
                }
            } else {
                if (bl) {
                    this.getN2Log().trace("Write on " + (Object)((Object)this) + ": Response is Error!");
                }
                if (n2BWriteResponse.getErrorCode() == 0) {
                    this.getN2Device().setNeedsId(true);
                    this.getN2Device().ping();
                    try {
                        this.write(rewriteCx);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.writeFail(n2BWriteResponse.getError());
            }
        } else {
            if (bl) {
                this.getN2Log().trace("Write Failed on " + (Object)((Object)this) + ": null response!");
            }
            this.writeFail("Null Response");
            this.getN2Device().pingFail("null response to point poll of " + (Object)((Object)this));
        }
    }

    void setpoint(BValue bValue) {
        boolean bl = this.getN2Log().isTraceOn();
        if (bl) {
            this.getN2Log().trace("Setpoint(" + bValue + ") on " + (Object)((Object)this));
        }
        N2BWriteMessage n2BWriteMessage = new N2BWriteMessage(this.getN2Device().getAddress(), this.getNetworkPointType().getOrdinal(), this.getNetworkPointAddress(), bValue, true);
        BRelTime bRelTime = BRelTime.make((long)(this.getN2Network().getResponseTimeout().getMillis() * (long)4));
        N2BWriteResponse n2BWriteResponse = (N2BWriteResponse)this.getN2Network().sendSync(n2BWriteMessage, bRelTime, this.getN2Network().getRetryCount());
        this.overridden = true;
        if (n2BWriteResponse != null) {
            if (!n2BWriteResponse.isError()) {
                this.getN2Device().pingOk();
                if (bl) {
                    this.getN2Log().trace("Setpoint Succeeded on " + (Object)((Object)this));
                }
                BStatusValue bStatusValue = (BStatusValue)this.getWriteValue().newCopy();
                bStatusValue.setValueValue(bValue);
                bStatusValue.setStatusNull(false);
                this.setWriteValue(bStatusValue);
                this.writeOk(bStatusValue);
                this.doForceRead();
                this.getN2Log().trace("N2B Setpoint doForceRead on: " + this.getN2Device().getName() + ": " + (Object)((Object)this));
            } else {
                if (bl) {
                    this.getN2Log().trace("Setpoint on " + (Object)((Object)this) + ": Response is Error!");
                }
                if (n2BWriteResponse.getErrorCode() == 0) {
                    this.getN2Device().setNeedsId(true);
                    this.getN2Device().ping();
                    try {
                        this.setpoint(bValue, rewriteCx);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.writeFail(n2BWriteResponse.getError());
            }
        } else {
            if (bl) {
                this.getN2Log().trace("Setpoint Failed on " + (Object)((Object)this) + ": null response!");
            }
            this.writeFail("Null Response");
            this.getN2Device().pingFail("null response to point poll of " + (Object)((Object)this));
        }
    }

    public void n2spy(SpyWriter spyWriter) throws Exception {
        spyWriter.prop((Object)"cov", this.cov);
        spyWriter.prop((Object)"oldNPT", this.oldNPT);
        spyWriter.prop((Object)"oldNPA", this.oldNPA);
    }

    private final boolean isValid(int n, int n2) {
        boolean bl = false;
        if (n != 0 && n2 > 0 && n2 <= 256) {
            bl = true;
        }
        return bl;
    }

    private final boolean isCOVPoint() {
        try {
            BBoolean bBoolean = (BBoolean)this.get("useCov");
            if (bBoolean != null) {
                return bBoolean.getBoolean();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    static /* synthetic */ boolean access$1(BJciN2BProxyExt bJciN2BProxyExt) {
        return bJciN2BProxyExt.cov;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.oldNPT = 0;
        this.oldNPA = 0;
        this.cov = false;
    }

    public BJciN2BProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$jcin2$point$BJciN2BProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$point$BJciN2BProxyExt = BJciN2BProxyExt.class("[Lcom.tridium.jcin2.point.BJciN2BProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        cosOffenders = new HashMap();
    }
}

