/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.messages;

import com.tridium.jcin2.messages.JciN2OMessage;
import com.tridium.jcin2.messages.JciN2OutputStream;

public class N2OWriteMessage
extends JciN2OMessage {
    private static final int FLOAT = 0;
    private static final int INT = 1;
    private static final int BYTE = 2;
    private int objectType;
    private int objectNumber;
    private int attribute;
    private int valType;
    private float fval;
    private int ival;

    void writeBytes(JciN2OutputStream jciN2OutputStream) {
        jciN2OutputStream.writeByte(this.objectNumber - 1);
        if (this.objectType < 5) {
            jciN2OutputStream.writeByte(this.attribute);
        }
        switch (this.valType) {
            case 0: {
                jciN2OutputStream.writeFloat(this.fval);
                break;
            }
            case 1: {
                jciN2OutputStream.writeInt(this.ival);
                break;
            }
            case 2: {
                jciN2OutputStream.writeByte(this.ival);
                break;
            }
        }
    }

    public String toString() {
        return "N2 Write (" + this.address + ") " + this.objectType + ':' + this.objectNumber + ';' + this.attribute + ':' + this.value();
    }

    private final String value() {
        switch (this.valType) {
            case 0: {
                return String.valueOf(this.fval);
            }
            case 1: {
                return String.valueOf(this.ival);
            }
            case 2: {
                return String.valueOf(this.ival & 0xFF);
            }
        }
        return "?";
    }

    public N2OWriteMessage(int n, int n2, int n3, int n4, double d) {
        super(n, 2, n2);
        this.objectType = n2;
        this.objectNumber = n3;
        this.attribute = n4;
        this.valType = 0;
        this.fval = (float)d;
    }

    public N2OWriteMessage(int n, int n2, int n3, int n4, int n5) {
        super(n, 2, n2);
        this.objectType = n2;
        this.objectNumber = n3;
        this.attribute = n4;
        this.valType = this.objectType == 7 ? 2 : 1;
        this.ival = n5;
    }

    public N2OWriteMessage(int n, int n2, int n3, int n4, boolean bl) {
        super(n, 2, n2);
        this.objectType = n2;
        this.objectNumber = n3;
        this.attribute = n4;
        this.valType = 2;
        this.ival = bl ? 1 : 0;
    }
}

