/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.messages;

import com.tridium.jcin2.messages.JciN2OMessage;
import com.tridium.jcin2.messages.JciN2OutputStream;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;

public class N2OSetpointMessage
extends JciN2OMessage {
    private int objectType;
    private int objectNumber;
    private BValue value;

    void writeBytes(JciN2OutputStream jciN2OutputStream) {
        Type type = this.value.getType();
        switch (this.objectType) {
            case 5: {
                jciN2OutputStream.writeByte(this.objectNumber - 1);
                if (type.is(BDouble.TYPE)) {
                    jciN2OutputStream.writeFloat(((BDouble)this.value).getDouble());
                    break;
                }
                if (type.is(BBoolean.TYPE)) {
                    jciN2OutputStream.writeFloat(((BBoolean)this.value).getBoolean() ? 1.0 : 0.0);
                    break;
                }
                if (type.is(BDynamicEnum.TYPE)) {
                    jciN2OutputStream.writeFloat(((BDynamicEnum)this.value).getOrdinal());
                    break;
                }
                jciN2OutputStream.writeFloat(Double.parseDouble(((BString)this.value).getString()));
                break;
            }
            case 6: {
                jciN2OutputStream.writeByte(this.objectNumber - 1);
                if (type.is(BDouble.TYPE)) {
                    jciN2OutputStream.writeInt((int)((BDouble)this.value).getDouble());
                    break;
                }
                if (type.is(BDynamicEnum.TYPE)) {
                    jciN2OutputStream.writeInt(((BDynamicEnum)this.value).getOrdinal());
                    break;
                }
                if (type.is(BBoolean.TYPE)) {
                    jciN2OutputStream.writeInt(((BBoolean)this.value).getBoolean() ? 1 : 0);
                    break;
                }
                jciN2OutputStream.writeInt(Integer.parseInt(((BString)this.value).getString()));
                break;
            }
            case 7: {
                jciN2OutputStream.writeByte(this.objectNumber - 1);
                if (type.is(BBoolean.TYPE)) {
                    jciN2OutputStream.writeByte(((BBoolean)this.value).getBoolean() ? 1 : 0);
                    break;
                }
                if (type.is(BDouble.TYPE)) {
                    jciN2OutputStream.writeByte((byte)((BDouble)this.value).getDouble());
                    break;
                }
                if (type.is(BDynamicEnum.TYPE)) {
                    jciN2OutputStream.writeByte(((BDynamicEnum)this.value).getOrdinal());
                    break;
                }
                jciN2OutputStream.writeByte(Integer.parseInt(((BString)this.value).getString()) & 0xFF);
                break;
            }
            case 1: 
            case 3: {
                jciN2OutputStream.writeByte(this.objectType);
                jciN2OutputStream.writeByte(this.objectNumber - 1);
                if (type.is(BDouble.TYPE)) {
                    jciN2OutputStream.writeFloat(((BDouble)this.value).getDouble());
                    break;
                }
                if (type.is(BBoolean.TYPE)) {
                    jciN2OutputStream.writeFloat(((BBoolean)this.value).getBoolean() ? 1.0 : 0.0);
                    break;
                }
                if (type.is(BDynamicEnum.TYPE)) {
                    jciN2OutputStream.writeFloat(((BDynamicEnum)this.value).getOrdinal());
                    break;
                }
                jciN2OutputStream.writeFloat(Double.parseDouble(((BString)this.value).getString()));
                break;
            }
            case 2: 
            case 4: {
                jciN2OutputStream.writeByte(this.objectType);
                jciN2OutputStream.writeByte(this.objectNumber - 1);
                if (type.is(BBoolean.TYPE)) {
                    jciN2OutputStream.writeByte(((BBoolean)this.value).getBoolean() ? 1 : 0);
                    break;
                }
                if (type.is(BDouble.TYPE)) {
                    jciN2OutputStream.writeByte(BDouble.equals((double)0.0, (double)((BDouble)this.value).getDouble()) ^ 1);
                    break;
                }
                if (type.is(BDynamicEnum.TYPE)) {
                    int n = 0;
                    if (((BDynamicEnum)this.value).getOrdinal() != 0) {
                        n = 1;
                    }
                    jciN2OutputStream.writeByte(n);
                    break;
                }
                jciN2OutputStream.writeByte(Integer.parseInt(((BString)this.value).getString()));
                break;
            }
        }
    }

    public String toString() {
        return "N2O Setpoint (" + this.address + ") " + this.objectType + ':' + this.objectNumber + ':' + this.value.toString(null);
    }

    public N2OSetpointMessage(int n, int n2, int n3, BValue bValue) {
        super(n, 2);
        if (n2 == 5) {
            this.setSubcommand(5);
        } else if (n2 == 6) {
            this.setSubcommand(6);
        } else if (n2 == 7) {
            this.setSubcommand(7);
        } else {
            this.setSubcommand(2);
        }
        this.objectType = n2;
        this.objectNumber = n3;
        this.value = bValue;
    }
}

