/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.messages;

import com.tridium.jcin2.messages.JciN2OMessage;
import com.tridium.jcin2.messages.JciN2OutputStream;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDouble;
import javax.baja.sys.Type;

public class N2OOverrideMessage
extends JciN2OMessage {
    private int objectType;
    private int objectNumber;
    private BStatusValue value;

    void writeBytes(JciN2OutputStream jciN2OutputStream) {
        jciN2OutputStream.writeByte(this.objectType);
        jciN2OutputStream.writeByte(this.objectNumber - 1);
        Type type = this.value.getType();
        switch (this.objectType) {
            case 1: 
            case 3: 
            case 5: {
                if (type.is(BStatusNumeric.TYPE)) {
                    jciN2OutputStream.writeFloat(((BStatusNumeric)this.value).getValue());
                    break;
                }
                if (type.is(BStatusBoolean.TYPE)) {
                    jciN2OutputStream.writeFloat(((BStatusBoolean)this.value).getValue() ? 1.0 : 0.0);
                    break;
                }
                if (type.is(BStatusEnum.TYPE)) {
                    jciN2OutputStream.writeFloat(((BStatusEnum)this.value).getValue().getOrdinal());
                    break;
                }
                jciN2OutputStream.writeFloat(Double.parseDouble(((BStatusString)this.value).getValue()));
                break;
            }
            case 2: 
            case 4: {
                if (type.is(BStatusBoolean.TYPE)) {
                    jciN2OutputStream.writeByte(((BStatusBoolean)this.value).getValue() ? 1 : 0);
                    break;
                }
                if (type.is(BStatusNumeric.TYPE)) {
                    jciN2OutputStream.writeByte(BDouble.equals((double)0.0, (double)((BStatusNumeric)this.value).getValue()) ^ 1);
                    break;
                }
                if (type.is(BStatusEnum.TYPE)) {
                    int n = 0;
                    if (((BStatusEnum)this.value).getValue().getOrdinal() != 0) {
                        n = 1;
                    }
                    jciN2OutputStream.writeByte(n);
                    break;
                }
                jciN2OutputStream.writeByte(Integer.parseInt(((BStatusString)this.value).getValue()));
                break;
            }
            case 6: {
                if (type.is(BStatusNumeric.TYPE)) {
                    jciN2OutputStream.writeInt((int)((BStatusNumeric)this.value).getValue());
                    break;
                }
                if (type.is(BStatusEnum.TYPE)) {
                    jciN2OutputStream.writeInt(((BStatusEnum)this.value).getValue().getOrdinal());
                    break;
                }
                if (type.is(BStatusBoolean.TYPE)) {
                    jciN2OutputStream.writeInt(((BStatusBoolean)this.value).getValue() ? 1 : 0);
                    break;
                }
                jciN2OutputStream.writeInt(Integer.parseInt(((BStatusString)this.value).getValue()));
                break;
            }
            case 7: {
                if (type.is(BStatusBoolean.TYPE)) {
                    jciN2OutputStream.writeByte(((BStatusBoolean)this.value).getValue() ? 1 : 0);
                    break;
                }
                if (type.is(BStatusNumeric.TYPE)) {
                    jciN2OutputStream.writeByte((byte)((BStatusNumeric)this.value).getValue());
                    break;
                }
                if (type.is(BStatusEnum.TYPE)) {
                    jciN2OutputStream.writeByte(((BStatusEnum)this.value).getValue().getOrdinal());
                    break;
                }
                jciN2OutputStream.writeInt(Integer.parseInt(((BStatusString)this.value).getValue()));
                break;
            }
        }
    }

    public String toString() {
        return "N2O Override (" + this.address + ") " + this.objectType + ':' + this.objectNumber + ':' + this.value.valueToString(null);
    }

    public N2OOverrideMessage(int n, int n2, int n3, BStatusValue bStatusValue) {
        super(n, 7, 2);
        this.objectType = n2;
        this.objectNumber = n3;
        this.value = bStatusValue;
    }
}

