/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.messages;

import com.tridium.jcin2.messages.JciN2BMessage;
import com.tridium.jcin2.messages.JciN2BOutputStream;
import com.tridium.jcin2.messages.JciN2ReceivedMessage;
import com.tridium.jcin2.messages.JciN2Response;
import com.tridium.jcin2.messages.N2BWriteResponse;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;

public class N2BWriteMessage
extends JciN2BMessage {
    protected static final byte WRITE_PERMANENT_HIBYTE = 1;
    protected static final byte WRITE_PERMANENT_LOBYTE = 5;
    protected static final int AUTO_PRIORITY_OFFSET = 29;
    protected static final byte[] N2B_WRITE_AUTO_MSG;
    protected static final int REAL_VALUE_OFFSET = 28;
    protected static final int REAL_PRIORITY_OFFSET = 33;
    protected static final byte[] N2B_WRITE_REAL_MSG;
    protected static final int UNSIGNED1_VALUE_OFFSET = 28;
    protected static final int UNSIGNED1_VALUE_MASK = 255;
    protected static final int UNSIGNED1_PRIORITY_OFFSET = 30;
    protected static final byte[] N2B_WRITE_UNSIGNED1_MSG;
    protected static final int UNSIGNED2_VALUE_OFFSET = 28;
    protected static final int UNSIGNED2_VALUE_LENGTH = 2;
    protected static final int UNSIGNED2_VALUE_MASK = 65535;
    protected static final int UNSIGNED2_PRIORITY_OFFSET = 31;
    protected static final byte[] N2B_WRITE_UNSIGNED2_MSG;
    private int objectType;
    private int objectNumber;
    private BValue writeValue;
    private int priority;
    private boolean permanent;

    JciN2Response getResponse(JciN2ReceivedMessage jciN2ReceivedMessage) {
        return new N2BWriteResponse(jciN2ReceivedMessage);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("N2B Write (").append(this.address).append(") ").append(this.objectType).append(":").append(this.objectNumber).append("->").append(this.writeValue).append("@").append(this.priority);
        return stringBuffer.toString();
    }

    private static final boolean isAuto(BStatusValue bStatusValue) {
        if (bStatusValue == null) {
            return true;
        }
        if (bStatusValue.isNull()) {
            return true;
        }
        boolean bl = false;
        if (bStatusValue.getStatus().geti("activeLevel", 17) == 17) {
            bl = true;
        }
        return bl;
    }

    private static final double getReal(BValue bValue) {
        Type type = bValue.getType();
        if (type.is(BStatusNumeric.TYPE)) {
            return ((BStatusNumeric)bValue).getValue();
        }
        if (type.is(BDouble.TYPE)) {
            return ((BDouble)bValue).getDouble();
        }
        if (type.is(BStatusBoolean.TYPE)) {
            return ((BStatusBoolean)bValue).getValue() ? 1.0 : 0.0;
        }
        if (type.is(BBoolean.TYPE)) {
            return ((BBoolean)bValue).getBoolean() ? 1.0 : 0.0;
        }
        if (type.is(BStatusEnum.TYPE)) {
            return ((BStatusEnum)bValue).getValue().getOrdinal();
        }
        if (type.is(BEnum.TYPE)) {
            return ((BEnum)bValue).getOrdinal();
        }
        if (type.is(BStatusString.TYPE)) {
            return Double.parseDouble(((BStatusString)bValue).getValue());
        }
        if (type.is(BString.TYPE)) {
            return Double.parseDouble(((BString)bValue).getString());
        }
        return 0.0;
    }

    private static final int getBinary(BValue bValue) {
        Type type = bValue.getType();
        if (type.is(BStatusBoolean.TYPE)) {
            return ((BStatusBoolean)bValue).getValue() ? 1 : 0;
        }
        if (type.is(BBoolean.TYPE)) {
            return ((BBoolean)bValue).getBoolean() ? 1 : 0;
        }
        if (type.is(BStatusNumeric.TYPE)) {
            int n = 0;
            if (((BStatusNumeric)bValue).getValue() != 0.0) {
                n = 1;
            }
            return n;
        }
        if (type.is(BDouble.TYPE)) {
            int n = 0;
            if (((BDouble)bValue).getDouble() != 0.0) {
                n = 1;
            }
            return n;
        }
        if (type.is(BStatusEnum.TYPE)) {
            int n = 0;
            if (((BStatusEnum)bValue).getValue().getOrdinal() != 0) {
                n = 1;
            }
            return n;
        }
        if (type.is(BEnum.TYPE)) {
            int n = 0;
            if (((BEnum)bValue).getOrdinal() != 0) {
                n = 1;
            }
            return n;
        }
        if (type.is(BStatusString.TYPE)) {
            int n = 0;
            if (Integer.parseInt(((BStatusString)bValue).getValue()) != 0) {
                n = 1;
            }
            return n;
        }
        if (type.is(BString.TYPE)) {
            int n = 0;
            if (Integer.parseInt(((BString)bValue).getString()) != 0) {
                n = 1;
            }
            return n;
        }
        return 0;
    }

    private static final int getUnsigned(BValue bValue) {
        Type type = bValue.getType();
        if (type.is(BStatusBoolean.TYPE)) {
            return ((BStatusBoolean)bValue).getValue() ? 1 : 0;
        }
        if (type.is(BBoolean.TYPE)) {
            return ((BBoolean)bValue).getBoolean() ? 1 : 0;
        }
        if (type.is(BStatusNumeric.TYPE)) {
            return (int)((BStatusNumeric)bValue).getValue();
        }
        if (type.is(BDouble.TYPE)) {
            return ((BDouble)bValue).getInt();
        }
        if (type.is(BStatusEnum.TYPE)) {
            return ((BStatusEnum)bValue).getValue().getOrdinal();
        }
        if (type.is(BEnum.TYPE)) {
            return ((BEnum)bValue).getOrdinal();
        }
        if (type.is(BStatusString.TYPE)) {
            return Integer.parseInt(((BStatusString)bValue).getValue());
        }
        if (type.is(BString.TYPE)) {
            return Integer.parseInt(((BString)bValue).getString());
        }
        return 0;
    }

    public N2BWriteMessage(int n, int n2, int n3, BValue bValue) {
        this(n, n2, n3, bValue, false);
    }

    public N2BWriteMessage(int n, int n2, int n3, BValue bValue, boolean bl) {
        super(n, 0);
        this.objectType = n2;
        this.objectNumber = n3;
        this.writeValue = bValue;
        this.permanent = bl;
        this.priority = bl ? 16 : 8;
        if (bValue.getType().is(BStatusValue.TYPE) && N2BWriteMessage.isAuto((BStatusValue)bValue)) {
            this.n2bMsg = new byte[N2B_WRITE_AUTO_MSG.length];
            System.arraycopy(N2B_WRITE_AUTO_MSG, 0, this.n2bMsg, 0, this.n2bMsg.length);
            this.n2bMsg[29] = (byte)this.priority;
        }
        if (this.n2bMsg == null) {
            switch (this.objectType) {
                case 1: 
                case 3: 
                case 5: {
                    this.n2bMsg = new byte[N2B_WRITE_REAL_MSG.length];
                    System.arraycopy(N2B_WRITE_REAL_MSG, 0, this.n2bMsg, 0, this.n2bMsg.length);
                    this.n2bMsg[33] = (byte)this.priority;
                    JciN2BOutputStream.writeAsnReal(this.n2bMsg, 28, N2BWriteMessage.getReal(bValue));
                    break;
                }
                case 2: 
                case 4: {
                    this.n2bMsg = new byte[N2B_WRITE_UNSIGNED1_MSG.length];
                    System.arraycopy(N2B_WRITE_UNSIGNED1_MSG, 0, this.n2bMsg, 0, this.n2bMsg.length);
                    this.n2bMsg[30] = (byte)this.priority;
                    JciN2BOutputStream.writeAsnUnsigned(this.n2bMsg, 28, N2BWriteMessage.getBinary(bValue));
                    break;
                }
                case 6: {
                    this.n2bMsg = new byte[N2B_WRITE_UNSIGNED2_MSG.length];
                    System.arraycopy(N2B_WRITE_UNSIGNED2_MSG, 0, this.n2bMsg, 0, this.n2bMsg.length);
                    this.n2bMsg[31] = (byte)this.priority;
                    JciN2BOutputStream.writeAsnUnsigned(this.n2bMsg, 28, N2BWriteMessage.getUnsigned(bValue) & (char)-1, 2);
                    break;
                }
                case 7: {
                    this.n2bMsg = new byte[N2B_WRITE_UNSIGNED1_MSG.length];
                    System.arraycopy(N2B_WRITE_UNSIGNED1_MSG, 0, this.n2bMsg, 0, this.n2bMsg.length);
                    this.n2bMsg[30] = (byte)this.priority;
                    JciN2BOutputStream.writeAsnUnsigned(this.n2bMsg, 28, N2BWriteMessage.getUnsigned(bValue) & 0xFF);
                    break;
                }
            }
        }
        if (bl) {
            this.n2bMsg[20] = 1;
            this.n2bMsg[21] = 5;
        }
        this.n2bMsg[24] = (byte)this.objectType;
        this.n2bMsg[26] = (byte)(this.objectNumber - 1);
    }

    static {
        byte[] byArray = new byte[31];
        byArray[0] = 1;
        byArray[2] = 2;
        byArray[3] = 2;
        byArray[5] = 18;
        byArray[6] = 9;
        byArray[7] = 5;
        byArray[8] = 25;
        byArray[9] = 54;
        byArray[11] = 4;
        byArray[14] = 12;
        byArray[15] = 60;
        byArray[16] = -64;
        byArray[18] = 2;
        byArray[19] = 26;
        byArray[21] = -87;
        byArray[22] = 46;
        byArray[23] = 33;
        byArray[25] = 33;
        byArray[28] = 33;
        byArray[30] = 47;
        N2B_WRITE_AUTO_MSG = byArray;
        byte[] byArray2 = new byte[35];
        byArray2[0] = 1;
        byArray2[2] = 2;
        byArray2[3] = 2;
        byArray2[5] = 18;
        byArray2[6] = 9;
        byArray2[7] = 5;
        byArray2[8] = 25;
        byArray2[9] = 54;
        byArray2[11] = 4;
        byArray2[14] = 12;
        byArray2[15] = 60;
        byArray2[16] = -64;
        byArray2[18] = 2;
        byArray2[19] = 26;
        byArray2[21] = -87;
        byArray2[22] = 46;
        byArray2[23] = 33;
        byArray2[25] = 33;
        byArray2[27] = 68;
        byArray2[32] = 33;
        byArray2[34] = 47;
        N2B_WRITE_REAL_MSG = byArray2;
        byte[] byArray3 = new byte[32];
        byArray3[0] = 1;
        byArray3[2] = 2;
        byArray3[3] = 2;
        byArray3[5] = 18;
        byArray3[6] = 9;
        byArray3[7] = 5;
        byArray3[8] = 25;
        byArray3[9] = 54;
        byArray3[11] = 4;
        byArray3[14] = 12;
        byArray3[15] = 60;
        byArray3[16] = -64;
        byArray3[18] = 2;
        byArray3[19] = 26;
        byArray3[21] = -87;
        byArray3[22] = 46;
        byArray3[23] = 33;
        byArray3[25] = 33;
        byArray3[27] = 33;
        byArray3[29] = 33;
        byArray3[31] = 47;
        N2B_WRITE_UNSIGNED1_MSG = byArray3;
        byte[] byArray4 = new byte[33];
        byArray4[0] = 1;
        byArray4[2] = 2;
        byArray4[3] = 2;
        byArray4[5] = 18;
        byArray4[6] = 9;
        byArray4[7] = 5;
        byArray4[8] = 25;
        byArray4[9] = 54;
        byArray4[11] = 4;
        byArray4[14] = 12;
        byArray4[15] = 60;
        byArray4[16] = -64;
        byArray4[18] = 2;
        byArray4[19] = 26;
        byArray4[21] = -87;
        byArray4[22] = 46;
        byArray4[23] = 33;
        byArray4[25] = 33;
        byArray4[27] = 34;
        byArray4[30] = 33;
        byArray4[32] = 47;
        N2B_WRITE_UNSIGNED2_MSG = byArray4;
    }
}

