/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.messages;

import com.tridium.jcin2.JciN2Exception;
import com.tridium.jcin2.messages.AsnException;
import com.tridium.jcin2.messages.JciN2BResponse;
import com.tridium.jcin2.messages.JciN2ReceivedMessage;
import com.tridium.jcin2.messages.N2BError;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class N2BReadResponse
extends JciN2BResponse {
    public static final int READ_RESPONSE_DATA_TAG = 2;
    boolean reliable;
    boolean asnError;

    protected void parse() {
        try {
            if (!this.isError()) {
                int n = this.n2bIn.skipTag();
                n = this.n2bIn.skipTag();
                this.n2bIn.skip(4);
                n = this.n2bIn.skipTag();
                n = this.n2bIn.skipTag();
                n = this.n2bIn.peekTag();
                if (this.n2bIn.isOpeningTag(2)) {
                    this.n2bIn.skipTag();
                    this.reliable = this.n2bIn.readAsnBoolean();
                } else {
                    this.n2bError = new N2BError();
                    this.n2bError.errorCode = 99;
                }
            }
        }
        catch (AsnException asnException) {
            asnException.printStackTrace();
            System.out.println("N2BReadResponse asnError");
            this.asnError = true;
            this.error = true;
        }
    }

    public boolean isReliable() {
        boolean bl = false;
        if (this.reliable && !this.asnError) {
            bl = true;
        }
        return bl;
    }

    public boolean readBoolean() throws JciN2Exception {
        int n = this.n2bIn.peekTag();
        switch (n) {
            case 1: {
                return this.n2bIn.readAsnBoolean();
            }
            case 9: {
                boolean bl = false;
                if (this.n2bIn.readAsnEnumerated() != 0) {
                    bl = true;
                }
                return bl;
            }
        }
        this.error = true;
        throw new JciN2Exception("Response is not BOOLEAN");
    }

    public int readEnum() throws JciN2Exception {
        int n = this.n2bIn.peekTag();
        switch (n) {
            case 1: {
                return this.n2bIn.readAsnBoolean() ? 1 : 0;
            }
            case 9: {
                return this.n2bIn.readAsnEnumerated();
            }
        }
        this.error = true;
        throw new JciN2Exception("Response is not ENUMERATED");
    }

    public double readFloat() throws JciN2Exception {
        String string = "unknown";
        int n = this.n2bIn.peekTag();
        switch (n) {
            case 4: {
                double d = this.n2bIn.readAsnReal();
                return d;
            }
            case 0: {
                string = "expecting ASN_REAL, found an ASN_NULL";
                break;
            }
            case 1: {
                string = "expecting ASN_REAL, found an ASN_BOOLEAN";
                break;
            }
            case 9: {
                string = "expecting ASN_REAL,) found an ASN_ENUMERATED";
                break;
            }
            case 2: {
                double d = this.n2bIn.readAsnUnsignedInteger();
                return d;
            }
            case 3: {
                double d = this.n2bIn.readInt();
                return d;
            }
            case 5: {
                string = "expecting ASN_REAL, found an ASN_DOUBLE";
                break;
            }
            case 6: {
                string = "expecting ASN_REAL, found an ASN_OCTET_STRING";
                break;
            }
            case 7: {
                string = "expecting ASN_REAL, found an ASN_CHARACTER_STRING";
                break;
            }
            case 8: {
                string = "expecting ASN_REAL, found an ASN_BIT_STRING";
                break;
            }
            case 10: {
                string = "expecting ASN_REAL, found an ASN_DATE";
                break;
            }
            case 11: {
                string = "expecting ASN_REAL, found an ASN_TIME";
                break;
            }
            case 12: {
                string = "expecting ASN_REAL, found an ASN_OBJECT_IDENTIFIER";
                break;
            }
            default: {
                string = "expecting ASN_REAL, found an unknown";
            }
        }
        this.error = true;
        this.asnError = true;
        throw new JciN2Exception("Response is not REAL, " + string);
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer("N2B Rx:");
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.reliable = false;
        this.asnError = false;
    }

    public N2BReadResponse(JciN2ReceivedMessage jciN2ReceivedMessage) {
        super(jciN2ReceivedMessage);
        this.this();
        this.parse();
    }
}

