/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.messages;

import com.tridium.jcin2.JciN2Exception;
import com.tridium.jcin2.messages.AsnException;
import com.tridium.jcin2.messages.JciN2ReceivedMessage;
import com.tridium.jcin2.messages.N2BError;
import com.tridium.jcin2.messages.N2BReadResponse;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class N2BPingResponse
extends N2BReadResponse {
    public static final int DATA_TAG = 1;
    public static final int NPT_NPA_TAG = 2;
    public static final int SIGNUP_STATUS_TAG = 6;
    public static final int PRIORITY_TAG = 7;
    public static final int RELIABILITY_TAG = 9;
    int npt;
    int npa;
    int dataType;
    int signupStatus;
    int priority;
    Object data;
    boolean lastItem;

    protected void parse() {
        try {
            this.reliable = true;
            if (!this.isError()) {
                int n = this.n2bIn.skipTag();
                n = this.n2bIn.skipTag();
                this.n2bIn.skip(4);
                n = this.n2bIn.skipTag();
                n = this.n2bIn.skipTag();
                n = this.n2bIn.peekTag();
                if (this.n2bIn.isOpeningTag(1)) {
                    n = this.n2bIn.skipTag();
                    this.n2bIn.mark(this.n2bIn.available());
                } else {
                    this.n2bError = new N2BError();
                }
            }
        }
        catch (AsnException asnException) {
            asnException.printStackTrace();
            this.asnError = true;
            this.error = true;
        }
    }

    public boolean next() {
        int n = this.n2bIn.available() - 3;
        if (n < 6) {
            return false;
        }
        try {
            int n2 = this.n2bIn.peekTag();
            if (this.n2bIn.isClosingTag(1)) {
                return false;
            }
            int n3 = (int)this.n2bIn.readAsnUnsignedInteger(2);
            this.npa = (n3 & 0xFF) + 1;
            this.npt = n3 >> 8 & 0x7F;
            n2 = this.n2bIn.skipTag();
            this.n2bIn.mark(this.n2bIn.available());
            this.dataType = this.n2bIn.peekTag();
            switch (this.dataType) {
                case 1: {
                    this.data = BBoolean.make((boolean)this.n2bIn.readAsnBoolean());
                    break;
                }
                case 4: {
                    this.data = BDouble.make((double)this.n2bIn.readAsnReal());
                    break;
                }
                case 2: 
                case 9: {
                    this.data = BInteger.make((int)this.n2bIn.readAsnEnumerated());
                    break;
                }
                default: {
                    this.data = null;
                    this.n2bIn.skipTag();
                }
            }
            n2 = this.n2bIn.skipTag();
            n2 = this.n2bIn.peekTag();
            if (this.n2bIn.isValueTag(6)) {
                this.signupStatus = this.n2bIn.readAsnEnumerated(6);
                n2 = this.n2bIn.peekTag();
            }
            if (this.n2bIn.isValueTag(7)) {
                n2 = this.n2bIn.peekTag();
                this.priority = (int)this.n2bIn.readAsnUnsignedInteger(7);
            }
            if (this.n2bIn.isValueTag(9)) {
                int n4 = this.n2bIn.readAsnEnumerated(9);
                boolean bl = false;
                if (n4 == 0) {
                    bl = true;
                }
                this.reliable = bl;
                n2 = this.n2bIn.peekTag();
            }
            if (this.n2bIn.isClosingTag(1)) {
                this.lastItem = true;
            }
        }
        catch (AsnException asnException) {
            asnException.printStackTrace();
            System.out.println("ASN Exception parsing N2B COS resp:" + this + "!!");
            return false;
        }
        return true;
    }

    public int getNetworkPointType() {
        return this.npt;
    }

    public int getNetworkPointAddress() {
        return this.npa;
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getSignupStatus() {
        return this.signupStatus;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean readBoolean() throws JciN2Exception {
        switch (this.dataType) {
            case 1: {
                return ((BBoolean)this.data).getBoolean();
            }
            case 9: {
                boolean bl = false;
                if (((BInteger)this.data).getInt() != 0) {
                    bl = true;
                }
                return bl;
            }
        }
        throw new JciN2Exception("Response is not BOOLEAN");
    }

    public int readEnum() throws JciN2Exception {
        switch (this.dataType) {
            case 1: {
                return ((BBoolean)this.data).getBoolean() ? 1 : 0;
            }
            case 9: {
                return ((BInteger)this.data).getInt();
            }
        }
        throw new JciN2Exception("Response is not ENUMERATED");
    }

    public double readFloat() throws JciN2Exception {
        switch (this.dataType) {
            case 4: {
                return ((BDouble)this.data).getDouble();
            }
        }
        throw new JciN2Exception("Response is not REAL");
    }

    private final /* synthetic */ void this() {
        this.dataType = 0;
        this.signupStatus = 0;
        this.priority = 0;
        this.lastItem = false;
    }

    public N2BPingResponse(JciN2ReceivedMessage jciN2ReceivedMessage) {
        super(jciN2ReceivedMessage);
        this.this();
    }
}

