/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.messages;

import com.tridium.jcin2.messages.JciN2OutputStream;
import java.io.ByteArrayOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JciS91OutputStream
extends ByteArrayOutputStream
implements JciN2OutputStream {
    int s1;
    int s2;

    public static JciS91OutputStream make() {
        return new JciS91OutputStream();
    }

    public void reset() {
        super.reset();
        this.write(62);
        this.s1 = 0;
        this.s2 = 0;
    }

    public void writeChar(int n) {
        this.writeInt(n, 1);
        this.updateBcc(n & 0xF);
    }

    public void writeByte(int n) {
        this.writeInt(n, 2);
        this.updateBcc(n & 0xFF);
    }

    public void writeB(int n) {
        this.writeByte(n);
    }

    public void writeInt(int n) {
        this.writeInt(n, 4);
        this.updateBcc(n & 0xFF);
        this.updateBcc(n / 256 & 0xFF);
    }

    public void writeW(int n) {
        this.writeByte(n & 0xFF);
        this.writeByte(n >>> 8 & 0xFF);
    }

    public void writeExtItemAddress(int n) {
        this.writeByte(n & 0xFF);
        this.writeByte(n >>> 8 & 0xFF);
    }

    public void writeLong(long l) {
        this.writeInt((int)l, 8);
        int n = 1;
        while (n < 4) {
            this.updateBcc((int)l & 0xFF);
            l >>>= 8;
            ++n;
        }
    }

    public void writeL(long l) {
        this.writeByte((int)(l & 0xFFL));
        this.writeByte((int)(l >>> 8 & 0xFFL));
        this.writeByte((int)(l >>> 16 & 0xFFL));
        this.writeByte((int)(l >>> 24 & 0xFFL));
    }

    public void writeFloat(double d) {
        this.writeInt(this.computeFloat(d));
    }

    public void writeN(double d) {
        int n = this.computeFloat(d);
        this.writeByte(n & 0xFF);
        this.writeByte(n >>> 8 & 0xFF);
    }

    private final int computeFloat(double d) {
        float f = (float)d;
        int n = Float.floatToIntBits(f);
        int n2 = n & Integer.MIN_VALUE;
        int n3 = ((n & 0x7F800000) >> 23) - 127;
        int n4 = n & 0x7FFFFF;
        int n5 = n2 >> 20 & 0x800;
        int n6 = 0;
        int n7 = 0;
        if (n3 < 0) {
            n7 = (int)(f * 2048.0f);
            if (n7 < 0) {
                n7 = Math.abs(n7);
            }
        } else {
            n6 = n3 + 1;
            n7 = (int)(((float)n4 / 8388608.0f + 1.0f) / 2.0f * 2048.0f);
        }
        int n8 = n6 << 12 | n5 | n7;
        return n8;
    }

    public byte[] sumcheck() {
        byte[] byArray = this.toByteArray();
        int n = 0;
        int n2 = 1;
        while (n2 < byArray.length) {
            n += byArray[n2];
            ++n2;
        }
        this.writeByte(n & 0xFF);
        this.write(13);
        return this.toByteArray();
    }

    void writeInt(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.write(JciN2OutputStream.ASCII_TO_HEX[n >> 4 * (n2 - n3 - 1) & 0xF]);
            ++n3;
        }
    }

    private final void updateBcc(int n) {
        this.s1 += n;
        if (this.s1 > 255) {
            ++this.s1;
            this.s1 &= 0xFF;
        }
        this.s2 += this.s1;
        if (this.s2 > 255) {
            ++this.s2;
            this.s2 &= 0xFF;
        }
    }

    private final int blocksum() {
        int n = this.s1 + this.s2;
        if (n > 255) {
            ++n;
            n &= 0xFF;
        }
        return (~n << 8) + this.s2;
    }

    public void writeBlocksum() {
        this.writeInt(this.blocksum());
    }

    private final /* synthetic */ void this() {
        this.s1 = 0;
        this.s2 = 0;
    }

    private JciS91OutputStream() {
        this.this();
        this.write(62);
        this.s1 = 0;
        this.s2 = 0;
    }
}

