/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.messages;

import com.tridium.jcin2.messages.JciN2OutputStream;
import java.io.ByteArrayOutputStream;
import javax.baja.nre.util.ByteArrayUtil;

public class JciN2OOutputStream
extends ByteArrayOutputStream
implements JciN2OutputStream {
    public static JciN2OOutputStream make() {
        return new JciN2OOutputStream();
    }

    public void reset() {
        super.reset();
        this.write(62);
    }

    public void writeChar(int n) {
        this.writeInt(n, 1);
    }

    public void writeByte(int n) {
        this.writeInt(n, 2);
    }

    public void writeInt(int n) {
        this.writeInt(n, 4);
    }

    public void writeLong(long l) {
        this.writeInt((int)l, 8);
    }

    public void writeFloat(double d) {
        this.writeInt(Float.floatToIntBits((float)d), 8);
    }

    public byte[] sumcheck() {
        byte[] byArray = this.toByteArray();
        int n = 0;
        int n2 = 1;
        while (n2 < byArray.length) {
            n += byArray[n2];
            ++n2;
        }
        this.writeByte(n & 0xFF);
        this.write(13);
        return this.toByteArray();
    }

    void writeInt(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.write(JciN2OutputStream.ASCII_TO_HEX[n >> 4 * (n2 - n3 - 1) & 0xF]);
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        JciN2OOutputStream jciN2OOutputStream = new JciN2OOutputStream();
        jciN2OOutputStream.writeByte(100);
        jciN2OOutputStream.writeChar(2);
        jciN2OOutputStream.writeChar(3);
        jciN2OOutputStream.writeByte(170);
        jciN2OOutputStream.writeByte(4);
        jciN2OOutputStream.writeInt(47808);
        jciN2OOutputStream.writeFloat(1.0833333);
        byte[] byArray = jciN2OOutputStream.sumcheck();
        System.out.println("msg:" + ByteArrayUtil.toHexString((byte[])byArray));
        System.out.print("    ");
        int n = 0;
        while (n < byArray.length) {
            System.out.print(" " + (char)byArray[n]);
            ++n;
        }
        System.out.println();
    }

    protected JciN2OOutputStream() {
        this.write(62);
    }
}

