/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.messages;

import com.tridium.jcin2.messages.JciN2InputStream;
import com.tridium.jcin2.messages.JciN2ReceivedMessage;
import java.io.ByteArrayInputStream;
import javax.baja.nre.util.TextUtil;

public class JciN2OInputStream
extends ByteArrayInputStream
implements JciN2InputStream {
    public static JciN2OInputStream make(JciN2ReceivedMessage jciN2ReceivedMessage) {
        JciN2OInputStream jciN2OInputStream = new JciN2OInputStream();
        jciN2OInputStream.setBuffer(jciN2ReceivedMessage.getData(), jciN2ReceivedMessage.getLength());
        return jciN2OInputStream;
    }

    public void setBuffer(byte[] byArray, int n) {
        this.buf = byArray;
        this.count = n;
        this.pos = 0;
        this.mark = 0;
    }

    public int readChar() {
        return this.readInt(1);
    }

    public int readByte() {
        return this.readInt(2);
    }

    public int readInt() {
        return (short)this.readInt(4);
    }

    public long readLong() {
        return this.readInt(8);
    }

    public double readFloat() {
        return Float.intBitsToFloat(this.readInt(8));
    }

    private final int readInt(int n) {
        int n2 = 0;
        int n3 = 4 * (n - 1);
        while (n3 >= 0) {
            n2 |= JciN2OInputStream.n2num(this.read()) << n3;
            n3 -= 4;
        }
        return n2;
    }

    static int n2num(int n) {
        if ((n -= 48) > 9) {
            n -= 7;
        }
        return n;
    }

    public boolean sumcheck() {
        int n = this.pos;
        this.pos = this.count - 3;
        int n2 = this.readByte();
        int n3 = 0;
        int n4 = 1;
        while (n4 < this.count - 3) {
            n3 += this.buf[n4];
            ++n4;
        }
        n4 = n3 & 0xFF;
        this.pos = n;
        boolean bl = false;
        if (n2 != n4) {
            bl = true;
        }
        return bl;
    }

    static final void d(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            JciN2OInputStream jciN2OInputStream = new JciN2OInputStream();
            int n = 0;
            while (n < stringArray.length) {
                System.out.println("msg " + (n + 1) + ':' + stringArray[n]);
                char[] cArray = stringArray[n].toCharArray();
                byte[] byArray = new byte[cArray.length];
                System.out.print("  c:");
                int n2 = 0;
                while (n2 < cArray.length - 1) {
                    byArray[n2] = (byte)cArray[n2];
                    System.out.print(cArray[n2]);
                    ++n2;
                }
                byArray[byArray.length - 1] = 13;
                System.out.print("\n  b:");
                n2 = 0;
                while (n2 < byArray.length) {
                    System.out.print(" " + byArray[n2]);
                    ++n2;
                }
                System.out.println();
                jciN2OInputStream.setBuffer(byArray, byArray.length);
                System.out.println("start:" + jciN2OInputStream.readChar());
                System.out.println("byte:" + jciN2OInputStream.readByte());
                System.out.println("float:" + jciN2OInputStream.readFloat());
                System.out.println("csum:" + jciN2OInputStream.readByte());
                jciN2OInputStream.sumcheck();
                ++n;
            }
        } else {
            byte[] byArray = new byte[]{62, 54, 52, 50, 51, 65, 65, 48, 52, 66, 65, 67, 48, 51, 70, 56, 65, 65, 65, 65, 65, 65, 49, 13};
            JciN2OInputStream jciN2OInputStream = new JciN2OInputStream();
            jciN2OInputStream.setBuffer(byArray, byArray.length);
            System.out.println("CHAR1-SOM:" + jciN2OInputStream.readChar());
            System.out.println("CHAR2-addr:" + jciN2OInputStream.readByte());
            System.out.println("CHAR1:" + jciN2OInputStream.readChar());
            System.out.println("CHAR1:" + jciN2OInputStream.readChar());
            System.out.println("CHAR2:" + jciN2OInputStream.readByte());
            System.out.println("CHAR2:" + jciN2OInputStream.readByte());
            System.out.println("CHAR4:" + jciN2OInputStream.readInt());
            System.out.println("CHAR8:" + jciN2OInputStream.readFloat());
            System.out.println("\nchars:");
            int n = 0;
            while (n < byArray.length) {
                System.out.println("n2num(" + byArray[n] + ")=" + JciN2OInputStream.n2num(byArray[n]) + ", TxtUtil.b2c=" + TextUtil.byteToChar((int)(byArray[n] & 0xFF), (char)'.'));
                ++n;
            }
            System.out.println();
        }
    }

    protected JciN2OInputStream() {
        super(new byte[0]);
    }
}

