/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.jcin2.messages.JciN2InputStream;
import com.tridium.jcin2.messages.JciN2MessageConst;
import com.tridium.jcin2.messages.JciN2ReceivedMessage;
import com.tridium.jcin2.messages.JciN2Response;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.baja.nre.util.ByteArrayUtil;

public abstract class JciN2Message
extends Message
implements JciN2MessageConst {
    protected int address;

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int n) {
        this.address = n;
    }

    public void write(OutputStream outputStream) {
        try {
            byte[] byArray = this.toBytes();
            outputStream.write(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final Message toResponse(ReceivedMessage receivedMessage) {
        return this.getResponse((JciN2ReceivedMessage)receivedMessage);
    }

    abstract JciN2Response getResponse(JciN2ReceivedMessage var1);

    void readBytes(JciN2InputStream jciN2InputStream) {
    }

    abstract byte[] toBytes();

    public abstract void writeChar(int var1);

    public abstract void writeByte(int var1);

    public abstract void writeInt(int var1);

    public abstract void writeLong(int var1);

    public abstract void writeFloat(double var1);

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer("N2 Tx:");
        byte[] byArray = this.toBytes();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ByteArrayUtil.hexDump((PrintWriter)printWriter, (byte[])byArray, (int)0, (int)byArray.length);
        stringBuffer.append("\n").append(stringWriter.toString());
        return stringBuffer.toString();
    }

    static final void d(String string) {
        System.out.println(string);
    }

    public JciN2Message(int n) {
        this.address = n;
    }
}

