/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.messages;

import com.tridium.jcin2.messages.JciN2OOutputStream;

public class JciN2BOutputStream
extends JciN2OOutputStream {
    public static JciN2BOutputStream makeN2B() {
        return new JciN2BOutputStream();
    }

    public static void writeAsnBoolean(byte[] byArray, int n, boolean bl) {
        JciN2BOutputStream.writePrimitiveApplicationTag(byArray, n, 1, bl ? 1 : 0);
    }

    public static void writeAsnUnsigned(byte[] byArray, int n, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Unsigned integer values must be >= 0.");
        }
        int n2 = JciN2BOutputStream.findIntegerLength(l);
        JciN2BOutputStream.writeIntegerData(byArray, n, l, n2);
    }

    public static void writeAsnUnsigned(byte[] byArray, int n, long l, int n2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Unsigned integer values must be >= 0.");
        }
        JciN2BOutputStream.writeIntegerData(byArray, n, l, n2);
    }

    public static void writeAsnReal(byte[] byArray, int n, double d) {
        JciN2BOutputStream.encodeReal(byArray, n, (float)d);
    }

    public static void writeAsnEnumerated(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Enumerated values must be greater than zero.");
        }
        int n3 = JciN2BOutputStream.findIntegerLength(n2);
        JciN2BOutputStream.writeIntegerData(byArray, n, n2, n3);
    }

    public void writeOpeningTag(int n) {
        this.writeTag(n, 8, 6);
    }

    public void writeClosingTag(int n) {
        this.writeTag(n, 8, 7);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void writeAsnBoolean(boolean bl) {
        this.writePrimitiveApplicationTag(1, bl ? 1 : 0);
    }

    public void writeAsnUnsigned(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Unsigned integer values must be >= 0.");
        }
        int n = JciN2BOutputStream.findIntegerLength(l);
        this.writePrimitiveApplicationTag(2, n);
        this.writeIntegerData(l, n);
    }

    public void writeAsnReal(double d) {
        this.writePrimitiveApplicationTag(4, 4);
        this.encodeReal((float)d);
    }

    public void writeAsnEnumerated(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Enumerated values must be greater than zero.");
        }
        int n2 = JciN2BOutputStream.findIntegerLength(n);
        this.writePrimitiveApplicationTag(9, n2);
        this.writeIntegerData(n, n2);
    }

    private static final int findIntegerLength(long l) {
        if (l == 0L) {
            return 1;
        }
        if (l > 0L) {
            if (l > 0xFFFFFFFFL) {
                throw new IllegalArgumentException("Number too big for Asn conversion: " + Long.toHexString(l));
            }
            if ((l & 0xFFFFFFFFFF000000L) != 0L) {
                return 4;
            }
            if ((l & 0xFF0000L) != 0L) {
                return 3;
            }
            if ((l & 0xFF00L) != 0L) {
                return 2;
            }
            return 1;
        }
        if (l < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Number too big for Asn conversion: " + Long.toHexString(l));
        }
        if ((l & 0xFFFFFFFFFF000000L) != -16777216L) {
            return 4;
        }
        if ((l & 0x800000L) == 0L) {
            return 4;
        }
        if ((l & 0xFF0000L) != 0xFF0000L) {
            return 3;
        }
        if ((l & 0x8000L) == 0L) {
            return 3;
        }
        if ((l & 0xFF00L) != 65280L) {
            return 2;
        }
        if ((l & 0x80L) == 0L) {
            return 2;
        }
        return 1;
    }

    private static final int writePrimitiveApplicationTag(byte[] byArray, int n, int n2, int n3) {
        return JciN2BOutputStream.writePrimitiveTag(byArray, n, n2, 0, n3);
    }

    private static final int writePrimitiveContextTag(byte[] byArray, int n, int n2, int n3) {
        return JciN2BOutputStream.writePrimitiveTag(byArray, n, n2, 8, n3);
    }

    private static final int writePrimitiveTag(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = n4 <= 4 ? n4 : 5;
        int n6 = 0;
        n6 += JciN2BOutputStream.writeTag(byArray, n, n2, n3, n5);
        if (n5 == 5) {
            n6 += JciN2BOutputStream.writeExtendedLength(byArray, n, n4);
        }
        return n6;
    }

    private static final int writeTag(byte[] byArray, int n, int n2, int n3, int n4) {
        if (n2 <= 14) {
            byArray[n++] = (byte)((n2 <<= 4) | n3 | n4);
            return 1;
        }
        if (n2 <= 254) {
            byArray[n++] = (byte)(0xF0 | n3 | n4);
            byArray[n++] = (byte)n2;
            return 2;
        }
        throw new IllegalArgumentException("Tag number > 254 not permitted !");
    }

    private static final int writeExtendedLength(byte[] byArray, int n, int n2) {
        if (n2 <= 4) {
            throw new IllegalArgumentException("Length too small to be extended");
        }
        if (n2 <= 253) {
            byArray[n++] = (byte)n2;
            return 1;
        }
        if (n2 <= (char)-1) {
            int n3 = (n2 & 0xFF00) >> 8;
            int n4 = n2 & 0xFF;
            byArray[n++] = -2;
            byArray[n++] = (byte)n3;
            byArray[n++] = (byte)n4;
            return 3;
        }
        int n5 = (n2 & 0xFF000000) >> 24;
        int n6 = (n2 & 0xFF0000) >> 16;
        int n7 = (n2 & 0xFF00) >> 8;
        int n8 = n2 & 0xFF;
        byArray[n++] = -1;
        byArray[n++] = (byte)n5;
        byArray[n++] = (byte)n6;
        byArray[n++] = (byte)n7;
        byArray[n++] = (byte)n8;
        return 5;
    }

    private static final int writeIntegerData(byte[] byArray, int n, long l, int n2) {
        int n3 = 1;
        while (n3 <= n2) {
            int n4 = (n2 - n3) * 8;
            byArray[n++] = (byte)(l >> n4);
            ++n3;
        }
        return n2;
    }

    private static final int encodeReal(byte[] byArray, int n, float f) {
        int n2 = Float.floatToIntBits(f);
        int n3 = 24;
        int n4 = 0;
        while (n4 < 4) {
            byArray[n++] = (byte)(n2 >> n3);
            n3 -= 8;
            ++n4;
        }
        return 4;
    }

    private final void writePrimitiveApplicationTag(int n, int n2) {
        this.writePrimitiveTag(n, 0, n2);
    }

    private final void writePrimitiveContextTag(int n, int n2) {
        this.writePrimitiveTag(n, 8, n2);
    }

    private final void writePrimitiveTag(int n, int n2, int n3) {
        int n4 = n3 <= 4 ? n3 : 5;
        this.writeTag(n, n2, n4);
        if (n4 == 5) {
            this.writeExtendedLength(n3);
        }
    }

    private final void writeTag(int n, int n2, int n3) {
        if (n <= 14) {
            this.write((n <<= 4) | n2 | n3);
        } else if (n <= 254) {
            this.write(0xF0 | n2 | n3);
            this.write(n);
        } else {
            throw new IllegalArgumentException("Tag number > 254 not permitted !");
        }
    }

    private final void writeExtendedLength(int n) {
        if (n <= 4) {
            throw new IllegalArgumentException("Length too small to be extended");
        }
        if (n <= 253) {
            this.write(n);
        } else if (n <= (char)-1) {
            int n2 = (n & 0xFF00) >> 8;
            int n3 = n & 0xFF;
            this.write(254);
            this.write(n2);
            this.write(n3);
        } else {
            int n4 = (n & 0xFF000000) >> 24;
            int n5 = (n & 0xFF0000) >> 16;
            int n6 = (n & 0xFF00) >> 8;
            int n7 = n & 0xFF;
            this.write(255);
            this.write(n4);
            this.write(n5);
            this.write(n6);
            this.write(n7);
        }
    }

    private final void writeIntegerData(long l, int n) {
        int n2 = 1;
        while (n2 <= n) {
            int n3 = (n - n2) * 8;
            this.write((int)(l >> n3));
            ++n2;
        }
    }

    private final void encodeReal(float f) {
        int n = Float.floatToIntBits(f);
        int n2 = 24;
        int n3 = 0;
        while (n3 < 4) {
            this.write(n >> n2);
            n2 -= 8;
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[10];
        int n = 0;
        while (n < 10) {
            byArray[n] = 0;
            ++n;
        }
        JciN2BOutputStream.writeAsnUnsigned(byArray, 1, 2);
        n = 0;
        while (n < 10) {
            System.out.println("b[" + n + "]:" + Integer.toHexString(byArray[n]));
            ++n;
        }
        byte[] byArray2 = new byte[10];
        int n2 = 0;
        while (n2 < 10) {
            byArray2[n2] = 0;
            ++n2;
        }
        JciN2BOutputStream.writeAsnUnsigned(byArray2, 1, 2, 2);
        n2 = 0;
        while (n2 < 10) {
            System.out.println("b2[" + n2 + "]:" + Integer.toHexString(byArray2[n2]));
            ++n2;
        }
    }
}

