/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.messages;

import com.tridium.jcin2.messages.JciN2BOutputStream;
import com.tridium.jcin2.messages.JciN2BResponse;
import com.tridium.jcin2.messages.JciN2Message;
import com.tridium.jcin2.messages.JciN2ReceivedMessage;
import com.tridium.jcin2.messages.JciN2Response;

public abstract class JciN2BMessage
extends JciN2Message {
    protected static byte invokeId;
    private static Object syncObject;
    int request;
    JciN2BOutputStream n2bout;
    byte[] byteMsg;
    protected byte[] n2bMsg;

    JciN2Response getResponse(JciN2ReceivedMessage jciN2ReceivedMessage) {
        return new JciN2BResponse(jciN2ReceivedMessage);
    }

    byte[] toBytes() {
        if (this.byteMsg == null) {
            this.n2bout = JciN2BOutputStream.makeN2B();
            this.n2bout.writeByte(this.address);
            this.n2bout.writeChar(11);
            this.n2bout.writeChar(this.request);
            this.n2bMsg[4] = this.getNextInvokeId();
            this.writeN2BData(this.n2bMsg);
            this.byteMsg = this.n2bout.sumcheck();
        }
        return this.byteMsg;
    }

    public void writeChar(int n) {
        this.n2bout.writeChar(n);
    }

    public void writeByte(int n) {
        this.n2bout.writeByte(n);
    }

    public void writeInt(int n) {
        this.n2bout.writeInt(n);
    }

    public void writeLong(int n) {
        this.n2bout.writeLong(n);
    }

    public void writeFloat(double d) {
        this.n2bout.writeFloat(d);
    }

    public String toString() {
        return this.toDebugString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte getNextInvokeId() {
        Object object = syncObject;
        synchronized (object) {
            invokeId = (byte)(invokeId + 1);
            return invokeId;
        }
    }

    protected void writeN2BData(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            switch (byArray[n]) {
                case 16: {
                    this.n2bout.write(16);
                    this.n2bout.write(0);
                    break;
                }
                case 62: {
                    this.n2bout.write(16);
                    this.n2bout.write(1);
                    break;
                }
                case 13: {
                    this.n2bout.write(16);
                    this.n2bout.write(2);
                    break;
                }
                default: {
                    this.n2bout.write(byArray[n]);
                }
            }
            ++n;
        }
    }

    public JciN2BMessage(int n, int n2) {
        super(n);
        this.request = n2;
    }

    static {
        syncObject = new Object();
    }
}

