/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.messages;

import com.tridium.jcin2.messages.AsnException;
import com.tridium.jcin2.messages.JciN2MessageConst;
import com.tridium.jcin2.messages.JciN2OInputStream;
import com.tridium.jcin2.messages.JciN2ReceivedMessage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JciN2BInputStream
extends JciN2OInputStream
implements JciN2MessageConst {
    private boolean csErr;
    private int currentTag;
    private int currentTagNumber;
    private int dataLength;
    private int currentTagIndex;
    private int nextTag;

    public static JciN2BInputStream makeN2B(JciN2ReceivedMessage jciN2ReceivedMessage) {
        JciN2BInputStream jciN2BInputStream = new JciN2BInputStream();
        jciN2BInputStream.csErr = JciN2BInputStream.sumcheck(jciN2ReceivedMessage.data, jciN2ReceivedMessage.len);
        byte[] byArray = jciN2ReceivedMessage.getData();
        byte[] byArray2 = new byte[jciN2ReceivedMessage.getLength()];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray2.length) {
            byArray2[n2] = byArray[n2 + n];
            if (byArray2[n2] == 16) {
                byte by = byArray[n2 + ++n];
                switch (by) {
                    case 0: {
                        byArray2[n2] = 16;
                        break;
                    }
                    case 1: {
                        byArray2[n2] = 62;
                        break;
                    }
                    case 2: {
                        byArray2[n2] = 13;
                        break;
                    }
                }
            }
            ++n2;
        }
        jciN2BInputStream.setBuffer(byArray2, byArray2.length - n);
        return jciN2BInputStream;
    }

    public static String toMsgDebugString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("N2B Rx:");
        return stringBuffer.toString();
    }

    public boolean sumcheck() {
        return this.csErr;
    }

    private static final boolean sumcheck(byte[] byArray, int n) {
        try {
            int n2 = JciN2BInputStream.n2num(byArray[n - 3]) << 4 | JciN2BInputStream.n2num(byArray[n - 2]);
            int n3 = 0;
            int n4 = 1;
            while (n4 < n - 3) {
                n3 += byArray[n4];
                ++n4;
            }
            n4 = n3 & 0xFF;
            boolean bl = false;
            if (n2 != n4) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isOpeningTag(int n) {
        boolean bl = false;
        if (this.currentTagNumber == n && (this.currentTag & 8) == 8 && (this.currentTag & 7) == 6) {
            bl = true;
        }
        return bl;
    }

    public boolean isClosingTag(int n) {
        boolean bl = false;
        if (this.currentTagNumber == n && (this.currentTag & 8) == 8 && (this.currentTag & 7) == 7) {
            bl = true;
        }
        return bl;
    }

    public boolean isValueTag(int n) {
        boolean bl = false;
        if (this.currentTagNumber == n && (this.currentTag & 7) != 6 && (this.currentTag & 7) != 7) {
            bl = true;
        }
        return bl;
    }

    public int peekTag() throws AsnException {
        if (this.available() == 0) {
            return -1;
        }
        int n = this.pos;
        int n2 = this.readTag();
        this.pos = n;
        return n2;
    }

    public int skipTag() throws AsnException {
        if (this.available() == 0) {
            return -1;
        }
        int n = this.readTag();
        if (this.pos != this.nextTag) {
            this.pos = this.nextTag;
        }
        return n;
    }

    public boolean readAsnBoolean() throws AsnException {
        this.readTag();
        this.validateApplicationTag(1);
        return this.dataLength != 0;
    }

    public long readAsnUnsignedInteger() throws AsnException {
        this.readTag();
        this.validateApplicationTag(2);
        return this.decodeUnsignedInteger();
    }

    public long readAsnUnsignedInteger(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return this.decodeUnsignedInteger();
    }

    public double readAsnReal() throws AsnException {
        this.readTag();
        this.validateApplicationTag(4);
        return this.decodeReal();
    }

    public int readAsnEnumerated() throws AsnException {
        this.readTag();
        this.validateApplicationTag(9);
        return (int)this.decodeUnsignedInteger();
    }

    public int readAsnEnumerated(int n) throws AsnException {
        this.readTag();
        this.validateContextTag(n);
        return (int)this.decodeUnsignedInteger();
    }

    private final long decodeUnsignedInteger() throws AsnException {
        long l = 0L;
        if (this.dataLength > 4) {
            throw new AsnException("integer overflow");
        }
        int n = 0;
        while (n < this.dataLength) {
            l <<= 8;
            l |= (long)this.read();
            ++n;
        }
        if (l < 0L) {
            throw new AsnException("integer overflow");
        }
        return l;
    }

    private final float decodeReal() throws AsnException {
        if (this.dataLength != 4) {
            this.csErr = true;
            throw new AsnException("invalid real value");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.dataLength) {
            n <<= 8;
            n |= this.read();
            ++n2;
        }
        return Float.intBitsToFloat(n);
    }

    private final int readTag() throws AsnException {
        this.currentTagIndex = this.pos;
        this.currentTag = this.read();
        this.currentTagNumber = this.readTagNumber(this.currentTag);
        if ((this.currentTag & 0xF) == 14 || (this.currentTag & 0xF) == 15) {
            this.parseConstructedData(this.currentTag);
        } else {
            this.parsePrimitiveData(this.currentTag);
        }
        return this.currentTagNumber;
    }

    private final int readTagNumber(int n) throws AsnException {
        int n2 = 0;
        if ((n & 0xF0) == 240) {
            n2 = this.read();
            if (n2 == 255) {
                this.csErr = true;
                throw new AsnException("invalid tag number:" + n2);
            }
        } else {
            n2 = (n & 0xF0) >> 4;
        }
        return n2;
    }

    private final void parsePrimitiveData(int n) throws AsnException {
        if ((n & 8) == 0 && this.currentTagNumber == 1) {
            this.dataLength = n & 7;
            this.nextTag = this.pos;
            return;
        }
        if ((n & 7) != 5) {
            this.dataLength = n & 7;
        } else {
            int n2 = this.read();
            if (n2 <= 253) {
                this.dataLength = n2;
            } else if (n2 == 254) {
                int n3 = this.read();
                this.dataLength = n3 << 8;
                n3 = this.read();
                this.dataLength |= n3;
            } else if (n2 == 255) {
                this.dataLength = 0;
                int n4 = 0;
                while (n4 < 4) {
                    this.dataLength <<= 8;
                    this.dataLength |= this.read();
                    ++n4;
                }
            } else {
                this.csErr = true;
                throw new AsnException("invalid extended length tag:" + n2);
            }
        }
        if (this.available() < this.dataLength) {
            this.csErr = true;
            throw new AsnException("invalid length tag:: available=" + this.available() + ", dataLength=" + this.dataLength);
        }
        this.nextTag = this.pos + this.dataLength;
    }

    private final void parseConstructedData(int n) throws AsnException {
        this.nextTag = this.pos;
        this.dataLength = 0;
    }

    private final void validateContextTag(int n) throws AsnException {
        if ((this.currentTag & 8) != 8) {
            this.csErr = true;
            throw new AsnException("invalid tag class:tag=" + n + " cur=" + this.currentTag);
        }
        if (!this.isValueTag(n)) {
            this.csErr = true;
            throw new AsnException("not value tag:" + n);
        }
    }

    private final void validateApplicationTag(int n) throws AsnException {
        if ((this.currentTag & 8) != 0) {
            this.csErr = true;
            throw new AsnException("invalid tag class:tag=" + n + " cur=" + this.currentTag);
        }
        if (!this.isValueTag(n)) {
            this.csErr = true;
            throw new AsnException("not value tag:" + n);
        }
    }

    public static void main(String[] stringArray) {
    }

    private final /* synthetic */ void this() {
        this.csErr = true;
    }

    public JciN2BInputStream() {
        this.this();
    }
}

