/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2.job;

import com.tridium.jcin2.BJciN2Device;
import com.tridium.jcin2.BJciN2Network;
import com.tridium.jcin2.job.BJciN2DiscoveryDevice;
import com.tridium.jcin2.messages.JciS91Response;
import com.tridium.jcin2.messages.N2OIdentifyMessage;
import com.tridium.jcin2.messages.N2OIdentifyResponse;
import com.tridium.jcin2.messages.S91ReadSingleItemMessage;
import javax.baja.job.BSimpleJob;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJciN2DiscoverDevicesJob
extends BSimpleJob {
    public static final Type TYPE;
    private BJciN2Network n2net;
    private int startAddress;
    private int stopAddress;
    static /* synthetic */ Class class$com$tridium$jcin2$job$BJciN2DiscoverDevicesJob;

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        if (this.n2net == null) {
            throw new IllegalStateException("Must submit thru JciN2Network.submitDeviceDiscoveryJob()");
        }
        int n = 0;
        int n2 = 0;
        BRelTime bRelTime = BRelTime.make((long)100L);
        if (this.startAddress > this.stopAddress) {
            return;
        }
        int n3 = this.startAddress;
        while (n3 <= this.stopAddress) {
            if (!this.isAlive()) break;
            this.log().message("Scanning address " + n3 + "...");
            JciS91Response jciS91Response = (JciS91Response)this.n2net.sendSync(new S91ReadSingleItemMessage(n3, 0), bRelTime, n);
            if (jciS91Response != null) {
                if (!jciS91Response.isError()) {
                    this.log().message("Found System91 device at address " + n3 + "...");
                    this.add(null, (BValue)new BJciN2DiscoveryDevice(n3, jciS91Response.getIn().readByte(), true));
                } else {
                    N2OIdentifyResponse n2OIdentifyResponse = (N2OIdentifyResponse)this.n2net.sendSync(new N2OIdentifyMessage(n3), bRelTime, n);
                    if (n2OIdentifyResponse != null && !n2OIdentifyResponse.isError()) {
                        n2 = n2OIdentifyResponse.getIn().readByte();
                        String string = BJciN2Device.getDeviceFirmwareVersion(this.n2net, n3, n2);
                        this.log().message("Found device at address " + n3 + ", Device Code: 0x" + Integer.toHexString(n2) + ", Firmware: " + string);
                        this.add(null, (BValue)new BJciN2DiscoveryDevice(n3, n2, false));
                    }
                }
            }
            int n4 = (int)((double)(n3 - this.startAddress + 1) * 100.0 / (double)(this.stopAddress - this.startAddress + 1));
            this.progress(n4);
            ++n3;
        }
    }

    private static final void d(String string) {
        System.out.println(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.startAddress = 1;
        this.stopAddress = 255;
    }

    public BJciN2DiscoverDevicesJob() {
        this.this();
    }

    public BJciN2DiscoverDevicesJob(BJciN2Network bJciN2Network, int n, int n2) {
        this.this();
        this.n2net = bJciN2Network;
        this.startAddress = n;
        this.stopAddress = n2;
    }

    static {
        Class clazz = class$com$tridium$jcin2$job$BJciN2DiscoverDevicesJob;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$job$BJciN2DiscoverDevicesJob = BJciN2DiscoverDevicesJob.class("[Lcom.tridium.jcin2.job.BJciN2DiscoverDevicesJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

