/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2;

import com.tridium.jcin2.BJciS91Device;
import com.tridium.jcin2.messages.JciN2Response;
import com.tridium.jcin2.messages.JciS91InputStream;
import com.tridium.jcin2.messages.JciS91Response;
import com.tridium.jcin2.messages.S91ReadBlockMessage;
import com.tridium.jcin2.messages.S91ReadSingleItemMessage;
import com.tridium.jcin2.messages.S91WriteSingleItemMessage;
import com.tridium.jcin2.point.BJciS91ProxyExt;
import com.tridium.jcin2.util.JciXt9100MapData;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJciXt9100Device
extends BJciS91Device {
    public static final Property dos1 = BJciXt9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property dos2 = BJciXt9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property dis1 = BJciXt9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property dis2 = BJciXt9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property i2ce = BJciXt9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property dom1 = BJciXt9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property dom2 = BJciXt9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property aom = BJciXt9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Type TYPE;
    private int backgroundPollCount;
    static /* synthetic */ Class class$com$tridium$jcin2$BJciXt9100Device;

    public int getDos1() {
        return this.getInt(dos1);
    }

    public void setDos1(int n) {
        this.setInt(dos1, n, null);
    }

    public int getDos2() {
        return this.getInt(dos2);
    }

    public void setDos2(int n) {
        this.setInt(dos2, n, null);
    }

    public int getDis1() {
        return this.getInt(dis1);
    }

    public void setDis1(int n) {
        this.setInt(dis1, n, null);
    }

    public int getDis2() {
        return this.getInt(dis2);
    }

    public void setDis2(int n) {
        this.setInt(dis2, n, null);
    }

    public int getI2ce() {
        return this.getInt(i2ce);
    }

    public void setI2ce(int n) {
        this.setInt(i2ce, n, null);
    }

    public int getDom1() {
        return this.getInt(dom1);
    }

    public void setDom1(int n) {
        this.setInt(dom1, n, null);
    }

    public int getDom2() {
        return this.getInt(dom2);
    }

    public void setDom2(int n) {
        this.setInt(dom2, n, null);
    }

    public int getAom() {
        return this.getInt(aom);
    }

    public void setAom(int n) {
        this.setInt(aom, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isDeviceCodeValid() {
        switch (this.getDeviceCode()) {
            case 8: 
            case 24: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    public boolean isValidPointForDeviceType(int n, int n2) {
        if (n2 < 0) {
            return false;
        }
        switch (n) {
            case 1: {
                return n2 < 8;
            }
            case 2: {
                return n2 < 16;
            }
            case 3: {
                return n2 < 8;
            }
            case 4: {
                return n2 < 16;
            }
            case 6: {
                return n2 < 8;
            }
            case 7: {
                return n2 < 24;
            }
        }
        return false;
    }

    protected boolean identify() {
        boolean bl = this.getN2Log().isTraceOn();
        S91ReadSingleItemMessage s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 0);
        BRelTime bRelTime = this.getN2Network().getResponseTimeout();
        long l = bRelTime.getMillis();
        BRelTime bRelTime2 = BRelTime.make((long)(l * (long)4));
        JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, bRelTime2, 2);
        if (jciS91Response != null) {
            if (!jciS91Response.isError()) {
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                int n = jciS91InputStream.readByte();
                if (bl) {
                    this.getN2Log().trace("Identify XT " + this + ": Device Code = 0x" + Integer.toHexString(n));
                }
                this.setDeviceCode(n);
                if (this.isDeviceCodeValid()) {
                    this.setFirmwareVersion(BJciXt9100Device.getDeviceFirmwareVersion(this.getN2Network(), this.getAddress(), n));
                    this.setNeedsId(false);
                } else {
                    this.setFaultCause("Invalid Device Code: " + n);
                }
            } else if (bl) {
                this.getN2Log().trace("Identify on " + this + ": Error:" + jciS91Response.getError());
            }
            return true;
        }
        if (bl) {
            this.getN2Log().trace("Identify XT " + this + ": Error: null response!");
        }
        if (bl) {
            this.getN2Log().trace("      msg = " + s91ReadSingleItemMessage.toDebugString());
        }
        return false;
    }

    protected void timeSync() {
        this.lastTimeSync = BAbsTime.make();
    }

    protected void transitionToOnline() {
        JciS91InputStream jciS91InputStream;
        this.identify();
        this.timeSync();
        boolean bl = this.getN2Log().isTraceOn();
        S91ReadSingleItemMessage s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 7);
        JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (jciS91Response != null) {
            if (!jciS91Response.isError()) {
                jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setDos1(jciS91InputStream.readByte());
                if (bl) {
                    this.getN2Log().trace("Success reading DOS1 on up transition: " + this);
                }
            } else if (bl) {
                this.getN2Log().trace("Error reading DOS1 on up transition:" + this + ": Error:" + jciS91Response.getError());
            }
        } else if (bl) {
            this.getN2Log().trace("No response reading DOS1 on up transition:" + this);
        }
        s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 8);
        jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (jciS91Response != null) {
            if (!jciS91Response.isError()) {
                jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setDos2(jciS91InputStream.readByte());
                if (bl) {
                    this.getN2Log().trace("Success reading DOS2 on up transition: " + this);
                }
            } else if (bl) {
                this.getN2Log().trace("Error reading DOS2 on up transition:" + this + ": Error:" + jciS91Response.getError());
            }
        } else if (bl) {
            this.getN2Log().trace("No response reading DOS2 on up transition:" + this);
        }
        s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 2);
        jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (jciS91Response != null) {
            if (!jciS91Response.isError()) {
                jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setI2ce(jciS91InputStream.readByte());
                if (bl) {
                    this.getN2Log().trace("Success reading I2CE on up transition: " + this);
                }
            } else if (bl) {
                this.getN2Log().trace("Error reading I2CE on up transition:" + this + ": Error:" + jciS91Response.getError());
            }
        } else if (bl) {
            this.getN2Log().trace("No response reading I2CE on up transition:" + this);
        }
    }

    public void backgroundPoll() {
        if (this.isDown()) {
            return;
        }
        boolean bl = this.getN2Log().isTraceOn();
        switch (this.backgroundPollCount) {
            case 0: 
            case 2: {
                S91ReadBlockMessage s91ReadBlockMessage = new S91ReadBlockMessage(this.getAddress(), 9, 2);
                JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadBlockMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciS91Response == null || jciS91Response.isError()) {
                    this.getN2Log().trace("Background read failed: DIS1 and DIS2");
                    break;
                }
                this.getN2Log().trace("Background Read DIS1 and DIS2 succeeded");
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setDis1(jciS91InputStream.readByte());
                this.setDis2(jciS91InputStream.readByte());
                this.updatePollListeners(9, this.getDis1());
                this.updatePollListeners(10, this.getDis2());
                break;
            }
            case 1: {
                S91ReadSingleItemMessage s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 2);
                JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciS91Response == null || jciS91Response.isError()) {
                    this.getN2Log().trace("Background read failed: I2CE");
                    break;
                }
                this.getN2Log().trace("Background Read I2CE succeeded");
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setI2ce(jciS91InputStream.readByte());
                break;
            }
            default: {
                S91ReadBlockMessage s91ReadBlockMessage = new S91ReadBlockMessage(this.getAddress(), 4, 3);
                JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadBlockMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciS91Response == null || jciS91Response.isError()) {
                    this.getN2Log().trace("Background read DOM1,DOM2,AOM failed");
                    break;
                }
                this.getN2Log().trace("Background read DOM1,DOM2,AOM succeeded.");
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setDom1(jciS91InputStream.readByte());
                this.setDom2(jciS91InputStream.readByte());
                this.setAom(jciS91InputStream.readByte());
                this.updatePollListeners(4, this.getDom1());
                this.updatePollListeners(5, this.getDom2());
                this.updatePollListeners(6, this.getAom());
            }
        }
        ++this.backgroundPollCount;
        this.backgroundPollCount %= 4;
    }

    public void updatePollListeners(int n, int n2) {
        int n3 = 0;
        while (n3 < this.v.size()) {
            BJciS91ProxyExt bJciS91ProxyExt = (BJciS91ProxyExt)this.v.get(n3);
            JciXt9100MapData jciXt9100MapData = (JciXt9100MapData)bJciS91ProxyExt.getMapData();
            boolean bl = false;
            if (n == jciXt9100MapData.getItemValueAddress()) {
                switch (n) {
                    case 4: {
                        boolean bl2 = false;
                        if ((this.getI2ce() & 1) != 0) {
                            bl2 = true;
                        }
                        bl = bl2;
                        break;
                    }
                    case 5: {
                        boolean bl3 = false;
                        if ((this.getI2ce() & 2) != 0) {
                            bl3 = true;
                        }
                        bl = bl3;
                        break;
                    }
                    case 6: {
                        boolean bl4 = false;
                        if ((this.getI2ce() & 0x30) != 0) {
                            bl4 = true;
                        }
                        bl = bl4;
                        break;
                    }
                    case 9: {
                        boolean bl5 = false;
                        if ((this.getI2ce() & 4) != 0) {
                            bl5 = true;
                        }
                        bl = bl5;
                        break;
                    }
                    case 10: {
                        boolean bl6 = false;
                        if ((this.getI2ce() & 0x80) != 0) {
                            bl6 = true;
                        }
                        bl = bl6;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                bJciS91ProxyExt.setValueFromBackgroundPoll(n2, bl ? BStatus.fault : BStatus.ok);
            }
            ++n3;
        }
    }

    protected void failPollListeners(int n) {
        this.getN2Log().trace("fail poll listeners");
        int n2 = 0;
        while (n2 < this.v.size()) {
            BJciS91ProxyExt bJciS91ProxyExt = (BJciS91ProxyExt)this.v.get(n2);
            JciXt9100MapData jciXt9100MapData = (JciXt9100MapData)bJciS91ProxyExt.getMapData();
            if (n == jciXt9100MapData.getItemValueAddress()) {
                bJciS91ProxyExt.readFail("background poll failed");
            }
            ++n2;
        }
    }

    public void setValue(JciN2Response jciN2Response, BJciS91ProxyExt bJciS91ProxyExt) {
        JciS91InputStream jciS91InputStream = (JciS91InputStream)jciN2Response.getIn();
        jciS91InputStream.reset();
        int n = bJciS91ProxyExt.getMapData().getNpt();
        switch (bJciS91ProxyExt.getMapData().getNpt()) {
            case 1: {
                double d = jciS91InputStream.readN(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric(d);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
            case 2: {
                int n2 = bJciS91ProxyExt.getMapData().getItemValueMask();
                int n3 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                boolean bl = false;
                if ((n3 & n2) != 0) {
                    bl = true;
                }
                BStatusBoolean bStatusBoolean = new BStatusBoolean(bl);
                int n4 = bJciS91ProxyExt.getMapData().getFaultMask();
                boolean bl2 = false;
                if ((this.getI2ce() & n4) != 0) {
                    bl2 = true;
                }
                boolean bl3 = bl2;
                bStatusBoolean.setStatusFault(bl3);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusBoolean);
                break;
            }
            case 3: {
                boolean bl;
                double d = jciS91InputStream.readN(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric(d);
                int n5 = bJciS91ProxyExt.getMapData().getOverrideMask();
                int n6 = 0;
                boolean bl4 = false;
                if ((n6 & n5) != 0) {
                    bl4 = bl = true;
                }
                if (this.getN2Network().getUseMessageOverrideFlag()) {
                    bStatusNumeric.setStatusOverridden(bl);
                }
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
            case 4: {
                boolean bl;
                int n7 = bJciS91ProxyExt.getMapData().getItemValueMask();
                int n8 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                boolean bl5 = false;
                if ((n8 & n7) != 0) {
                    bl5 = true;
                }
                BStatusBoolean bStatusBoolean = new BStatusBoolean(bl5);
                int n9 = bJciS91ProxyExt.getMapData().getOverrideMask();
                int n10 = 0;
                boolean bl6 = false;
                if ((n10 & n9) != 0) {
                    bl6 = bl = true;
                }
                if (this.getN2Network().getUseMessageOverrideFlag()) {
                    bStatusBoolean.setStatusOverridden(bl);
                }
                bJciS91ProxyExt.setValue((BStatusValue)bStatusBoolean);
                break;
            }
            case 7: {
                int n11 = bJciS91ProxyExt.getMapData().getItemValueMask();
                int n12 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                boolean bl = false;
                if ((n12 & n11) != 0) {
                    bl = true;
                }
                BStatusBoolean bStatusBoolean = new BStatusBoolean(bl);
                int n13 = bJciS91ProxyExt.getMapData().getFaultMask();
                boolean bl7 = false;
                if ((this.getI2ce() & n13) != 0) {
                    bl7 = true;
                }
                boolean bl8 = bl7;
                bStatusBoolean.setStatusFault(bl8);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusBoolean);
                break;
            }
            case 6: {
                long l = jciS91InputStream.readL(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric((double)l);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
        }
    }

    public void write(BStatusValue bStatusValue, BJciS91ProxyExt bJciS91ProxyExt) {
        this.getN2Log().trace("write callback received on: " + bJciS91ProxyExt);
        int n = this.getDeviceCode();
        int n2 = bJciS91ProxyExt.getNetworkPointType().getOrdinal();
        int n3 = bJciS91ProxyExt.getNetworkPointAddress() - 1;
        int n4 = bJciS91ProxyExt.getMapData().getItemStatusAddress();
        int n5 = bJciS91ProxyExt.getMapData().getOverrideMask();
        int n6 = bJciS91ProxyExt.getMapData().getStatusMaskSize();
        int n7 = bJciS91ProxyExt.getMapData().getItemValueMask();
        boolean bl = false;
        if (bJciS91ProxyExt.getMapData().getItemStatusAddress() != -1) {
            boolean bl2;
            bl = bl2 = true;
        }
        if (!bJciS91ProxyExt.isValid()) {
            return;
        }
        if (this.getN2Log().isTraceOn()) {
            this.getN2Log().trace("Setting Value on " + bJciS91ProxyExt);
        }
        switch (n2) {
            case 3: {
                S91WriteSingleItemMessage s91WriteSingleItemMessage = new S91WriteSingleItemMessage(this.getAddress(), bJciS91ProxyExt.getMapData().getItemValueAddress(), BJciS91ProxyExt.getReal((BValue)bStatusValue));
                bJciS91ProxyExt.sendWrite(s91WriteSingleItemMessage, bStatusValue);
                break;
            }
            case 4: {
                int n8 = n3 < 8 ? this.getDos1() : this.getDos2();
                n8 = BJciS91ProxyExt.getBinary((BValue)bStatusValue) ? (n8 |= bJciS91ProxyExt.getMapData().getItemValueMask()) : (n8 &= ~bJciS91ProxyExt.getMapData().getItemValueMask());
                S91WriteSingleItemMessage s91WriteSingleItemMessage = new S91WriteSingleItemMessage(this.getAddress(), bJciS91ProxyExt.getMapData().getReadStartAddress(), n8);
                bJciS91ProxyExt.sendWrite(s91WriteSingleItemMessage, bStatusValue);
                if (n3 < 8) {
                    this.setDos1(n8);
                    break;
                }
                this.setDos2(n8);
                break;
            }
            case 6: {
                S91WriteSingleItemMessage s91WriteSingleItemMessage = new S91WriteSingleItemMessage(this.getAddress(), bJciS91ProxyExt.getMapData().getItemValueAddress(), 192, BJciS91ProxyExt.getLong((BValue)bStatusValue));
                bJciS91ProxyExt.sendWrite(s91WriteSingleItemMessage, bStatusValue);
                break;
            }
            default: {
                this.getN2Log().trace("Point type is not writable!");
                bJciS91ProxyExt.writeFail("Point type is not writable!");
                return;
            }
        }
        bJciS91ProxyExt.doForceRead();
    }

    public String toString(Context context) {
        return "JciXt9100Device:" + this.getName() + " addr:" + this.getAddress();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.backgroundPollCount = 0;
    }

    public BJciXt9100Device() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$jcin2$BJciXt9100Device;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$BJciXt9100Device = BJciXt9100Device.class("[Lcom.tridium.jcin2.BJciXt9100Device;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

