/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2;

import com.tridium.jcin2.BJciS91Device;
import com.tridium.jcin2.messages.JciN2Response;
import com.tridium.jcin2.messages.JciS91InputStream;
import com.tridium.jcin2.messages.JciS91Response;
import com.tridium.jcin2.messages.S91ReadMessage;
import com.tridium.jcin2.messages.S91ReadSingleItemMessage;
import com.tridium.jcin2.messages.S91WriteSingleItemExtMessage;
import com.tridium.jcin2.messages.S91WriteSingleItemMessage;
import com.tridium.jcin2.point.BJciS91ProxyExt;
import com.tridium.jcin2.util.JciTc9100MapData;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJciTc9100Device
extends BJciS91Device {
    public static final Property ros = BJciTc9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property msk = BJciTc9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property odc = BJciTc9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property hld = BJciTc9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property cmp = BJciTc9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property sup = BJciTc9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property lsc = BJciTc9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Type TYPE;
    private int backgroundPollCount;
    private boolean supValid;
    private boolean dr9100;
    static /* synthetic */ Class class$com$tridium$jcin2$BJciTc9100Device;

    public int getRos() {
        return this.getInt(ros);
    }

    public void setRos(int n) {
        this.setInt(ros, n, null);
    }

    public int getMsk() {
        return this.getInt(msk);
    }

    public void setMsk(int n) {
        this.setInt(msk, n, null);
    }

    public int getOdc() {
        return this.getInt(odc);
    }

    public void setOdc(int n) {
        this.setInt(odc, n, null);
    }

    public int getHld() {
        return this.getInt(hld);
    }

    public void setHld(int n) {
        this.setInt(hld, n, null);
    }

    public int getCmp() {
        return this.getInt(cmp);
    }

    public void setCmp(int n) {
        this.setInt(cmp, n, null);
    }

    public int getSup() {
        return this.getInt(sup);
    }

    public void setSup(int n) {
        this.setInt(sup, n, null);
    }

    public int getLsc() {
        return this.getInt(lsc);
    }

    public void setLsc(int n) {
        this.setInt(lsc, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isDeviceCodeValid() {
        switch (this.getDeviceCode()) {
            case 1: 
            case 6: 
            case 17: 
            case 22: 
            case 118: {
                return true;
            }
        }
        return false;
    }

    public boolean isValidPointForDeviceType(int n, int n2) {
        if (n2 < 0) {
            return false;
        }
        switch (n) {
            case 1: {
                return n2 < 10;
            }
            case 2: {
                return n2 < 14;
            }
            case 3: {
                return n2 < 18;
            }
            case 4: {
                return n2 < 13;
            }
            case 7: {
                return n2 < 2;
            }
            case 9: {
                return n2 < 42;
            }
        }
        return false;
    }

    protected boolean identify() {
        boolean bl = this.getN2Log().isTraceOn();
        S91ReadSingleItemMessage s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 0);
        JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), 0);
        if (jciS91Response != null) {
            if (!jciS91Response.isError()) {
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                int n = jciS91InputStream.readByte();
                if (bl) {
                    this.getN2Log().trace("Identify on " + this + ": Device Code = 0x" + Integer.toHexString(n));
                }
                this.setDeviceCode(n);
                if (this.isDeviceCodeValid()) {
                    this.setNeedsId(false);
                } else {
                    this.setFaultCause("Invalid Device Code: " + n);
                }
                this.dr9100 = this.getDeviceCode() == 1 || this.getDeviceCode() == 17;
            } else if (bl) {
                this.getN2Log().trace("Identify on " + this + ": Error:" + jciS91Response.getError());
            }
            return true;
        }
        this.setNeedsId(true);
        if (bl) {
            this.getN2Log().trace("Identify on TC " + this + ": Null response!");
        }
        return false;
    }

    protected void timeSync() {
        BAbsTime bAbsTime = BAbsTime.make();
        int n = bAbsTime.getMinute();
        int n2 = bAbsTime.getHour();
        int n3 = bAbsTime.getWeekday().getOrdinal();
        if (n3 == 0) {
            n3 = 7;
        }
        int n4 = n | (n3 << 5) + n2 << 8;
        S91WriteSingleItemMessage s91WriteSingleItemMessage = new S91WriteSingleItemMessage(this.getAddress(), 158, 192, n4, 2);
        JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91WriteSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (jciS91Response == null || jciS91Response.isError()) {
            this.getN2Log().trace("time sync failed");
        } else {
            this.getN2Log().trace("time sync succeeded");
            this.lastTimeSync = BAbsTime.make();
        }
    }

    protected void transitionToOnline() {
        JciS91InputStream jciS91InputStream;
        JciS91Response jciS91Response;
        if (!this.identify()) {
            return;
        }
        this.timeSync();
        this.supValid = false;
        if (this.dr9100) {
            S91WriteSingleItemMessage s91WriteSingleItemMessage = new S91WriteSingleItemMessage(this.getAddress(), 132, 0);
            jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91WriteSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
            if (jciS91Response == null || jciS91Response.isError()) {
                this.getN2Log().trace("Dr9100 Clear DIAL failed");
            } else {
                this.getN2Log().trace("Dr9100 Clear DIAL succeeded.");
            }
        }
        boolean bl = this.getN2Log().isTraceOn();
        S91ReadSingleItemMessage s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 32);
        jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (jciS91Response != null) {
            if (!jciS91Response.isError()) {
                jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setRos(jciS91InputStream.readByte());
                if (bl) {
                    this.getN2Log().trace("Success reading ROS on up transition: " + this);
                }
            } else if (bl) {
                this.getN2Log().trace("Error reading ROS on up transition:" + this + ": Error:" + jciS91Response.getError());
            }
        } else if (bl) {
            this.getN2Log().trace("No response reading ROS on up transition:" + this);
        }
        s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 33);
        jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (jciS91Response != null) {
            if (!jciS91Response.isError()) {
                jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setMsk(jciS91InputStream.readByte());
                if (bl) {
                    this.getN2Log().trace("Success reading MSK on up transition: " + this);
                }
            } else if (bl) {
                this.getN2Log().trace("Error reading MSK on up transition:" + this + ": Error:" + jciS91Response.getError());
            }
        } else if (bl) {
            this.getN2Log().trace("No response reading MSK on up transition:" + this);
        }
        s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 34);
        jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (jciS91Response != null) {
            if (!jciS91Response.isError()) {
                jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setOdc(jciS91InputStream.readByte());
                if (bl) {
                    this.getN2Log().trace("Success reading ODC on up transition: " + this);
                }
            } else if (bl) {
                this.getN2Log().trace("Error reading ODC on up transition:" + this + ": Error:" + jciS91Response.getError());
            }
        } else if (bl) {
            this.getN2Log().trace("No response reading ODC on up transition:" + this);
        }
        s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 35);
        jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (jciS91Response != null) {
            if (!jciS91Response.isError()) {
                jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setHld(jciS91InputStream.readByte());
                if (bl) {
                    this.getN2Log().trace("Success reading HLD on up transition: " + this);
                }
            } else if (bl) {
                this.getN2Log().trace("Error reading HLD on up transition:" + this + ": Error:" + jciS91Response.getError());
            }
        } else if (bl) {
            this.getN2Log().trace("No response reading HLD on up transition:" + this);
        }
        s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 36);
        jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (jciS91Response != null) {
            if (!jciS91Response.isError()) {
                jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setCmp(jciS91InputStream.readByte());
                if (bl) {
                    this.getN2Log().trace("Success reading CMP on up transition: " + this);
                }
            } else if (bl) {
                this.getN2Log().trace("Error reading CMP on up transition:" + this + ": Error:" + jciS91Response.getError());
            }
        } else if (bl) {
            this.getN2Log().trace("No response reading CMP on up transition:" + this);
        }
        s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 37);
        jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (jciS91Response != null) {
            if (!jciS91Response.isError()) {
                jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                if (bl) {
                    this.getN2Log().trace("Success reading SUP on up transition: " + this);
                }
                this.setSup(jciS91InputStream.readByte() | 0x80);
                this.supValid = true;
                if (this.dr9100) {
                    S91WriteSingleItemMessage s91WriteSingleItemMessage = new S91WriteSingleItemMessage(this.getAddress(), 37, this.getSup());
                    jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91WriteSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                    if (jciS91Response == null || jciS91Response.isError()) {
                        this.getN2Log().trace("Dr9100 Transition set SUP failed");
                    } else {
                        this.getN2Log().trace("Dr9100 Transition set SUP succeeded.");
                    }
                }
            } else if (bl) {
                this.getN2Log().trace("Error reading SUP on up transition:" + this + ": Error:" + jciS91Response.getError());
            }
        } else if (bl) {
            this.getN2Log().trace("No response reading SUP on up transition:" + this);
        }
    }

    public void backgroundPoll() {
        if (this.isDown()) {
            return;
        }
        boolean bl = this.getN2Log().isTraceOn();
        switch (this.backgroundPollCount) {
            case 0: 
            case 2: {
                S91ReadSingleItemMessage s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 32);
                JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciS91Response == null || jciS91Response.isError()) {
                    this.getN2Log().trace("Background read failed: ROS");
                    break;
                }
                this.getN2Log().trace("Read ROS succeeded");
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setRos(jciS91InputStream.readByte());
                break;
            }
            case 1: 
            case 3: {
                S91ReadSingleItemMessage s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 38);
                JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciS91Response == null || jciS91Response.isError()) {
                    this.getN2Log().trace("Background read failed: LSC");
                    break;
                }
                this.getN2Log().trace("Read LSC succeeded");
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setLsc(jciS91InputStream.readByte());
                break;
            }
            default: {
                JciS91Response jciS91Response;
                S91ReadMessage s91ReadMessage;
                if (this.dr9100) {
                    if (this.supValid) {
                        s91ReadMessage = new S91WriteSingleItemMessage(this.getAddress(), 37, this.getSup());
                        jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                        if (jciS91Response == null || jciS91Response.isError()) {
                            this.getN2Log().trace("Background set SUP failed");
                        } else {
                            this.getN2Log().trace("Set SUP succeeded.");
                        }
                    } else {
                        s91ReadMessage = new S91ReadSingleItemMessage(this.getAddress(), 130);
                        jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                        if (jciS91Response == null || jciS91Response.isError()) {
                            this.getN2Log().trace("Background read SPARE failed");
                        } else {
                            this.getN2Log().trace("read SPARE succeeded.");
                        }
                    }
                } else {
                    s91ReadMessage = new S91WriteSingleItemExtMessage(this.getAddress(), 37, 197, 128, 1);
                    jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                    if (jciS91Response == null || jciS91Response.isError()) {
                        this.getN2Log().trace("Background set SSAR failed");
                    } else {
                        this.getN2Log().trace("Set SSAR succeeded.");
                    }
                }
                s91ReadMessage = new S91ReadSingleItemMessage(this.getAddress(), 37);
                jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciS91Response == null || jciS91Response.isError()) {
                    this.getN2Log().trace("Background read SUP failed");
                    break;
                }
                this.getN2Log().trace("Background read SUP succeeded.");
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setSup(jciS91InputStream.readByte());
            }
        }
        ++this.backgroundPollCount;
        this.backgroundPollCount %= 5;
    }

    public void updatePollListeners(int n, int n2) {
        int n3 = 0;
        while (n3 < this.v.size()) {
            BJciS91ProxyExt bJciS91ProxyExt = (BJciS91ProxyExt)this.v.get(n3);
            JciTc9100MapData jciTc9100MapData = (JciTc9100MapData)bJciS91ProxyExt.getMapData();
            if (n == jciTc9100MapData.getItemValueAddress()) {
                bJciS91ProxyExt.setValueFromBackgroundPoll(n2);
            }
            ++n3;
        }
    }

    protected void failPollListeners(int n) {
        this.getN2Log().trace("fail background poll listeners");
        int n2 = 0;
        while (n2 < this.v.size()) {
            BJciS91ProxyExt bJciS91ProxyExt = (BJciS91ProxyExt)this.v.get(n2);
            JciTc9100MapData jciTc9100MapData = (JciTc9100MapData)bJciS91ProxyExt.getMapData();
            if (n == jciTc9100MapData.getItemValueAddress()) {
                bJciS91ProxyExt.readFail("background poll failed");
            }
            ++n2;
        }
    }

    public void setValue(JciN2Response jciN2Response, BJciS91ProxyExt bJciS91ProxyExt) {
        JciS91InputStream jciS91InputStream = (JciS91InputStream)jciN2Response.getIn();
        jciS91InputStream.reset();
        int n = bJciS91ProxyExt.getMapData().getNpt();
        switch (bJciS91ProxyExt.getMapData().getNpt()) {
            case 1: {
                double d = jciS91InputStream.readN(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric(d);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
            case 2: {
                int n2 = bJciS91ProxyExt.getMapData().getItemValueMask();
                int n3 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                boolean bl = false;
                if ((n3 & n2) != 0) {
                    bl = true;
                }
                BStatusBoolean bStatusBoolean = new BStatusBoolean(bl);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusBoolean);
                break;
            }
            case 3: {
                boolean bl;
                double d = jciS91InputStream.readN(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric(d);
                int n4 = bJciS91ProxyExt.getMapData().getOverrideMask();
                int n5 = bJciS91ProxyExt.getNetworkPointAddress() - 1 < 6 ? this.getHld() : (bJciS91ProxyExt.getNetworkPointAddress() - 1 < 12 ? this.getCmp() : 0);
                boolean bl2 = false;
                if ((n5 & n4) != 0) {
                    bl2 = bl = true;
                }
                if (this.getN2Network().getUseMessageOverrideFlag()) {
                    bStatusNumeric.setStatusOverridden(bl);
                }
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
            case 4: {
                boolean bl;
                int n6 = bJciS91ProxyExt.getMapData().getItemValueMask();
                int n7 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                boolean bl3 = false;
                if ((n7 & n6) != 0) {
                    bl3 = true;
                }
                BStatusBoolean bStatusBoolean = new BStatusBoolean(bl3);
                int n8 = bJciS91ProxyExt.getMapData().getOverrideMask();
                int n9 = bJciS91ProxyExt.getNetworkPointAddress() - 1 < 7 ? this.getMsk() : 0;
                boolean bl4 = false;
                if ((n9 & n8) != 0) {
                    bl4 = bl = true;
                }
                if (this.getN2Network().getUseMessageOverrideFlag()) {
                    bStatusBoolean.setStatusOverridden(bl);
                }
                bJciS91ProxyExt.setValue((BStatusValue)bStatusBoolean);
                break;
            }
            case 7: {
                int n10 = bJciS91ProxyExt.getMapData().getItemValueMask();
                int n11 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric((double)(n11 & n10));
                if (bJciS91ProxyExt.getNetworkPointAddress() == 2) {
                    int n12 = 32;
                    int n13 = this.getSup();
                    boolean bl = false;
                    if ((n13 & n12) != 0) {
                        bl = true;
                    }
                    boolean bl5 = bl;
                } else {
                    boolean bl = false;
                }
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
            case 9: {
                double d = jciS91InputStream.readN(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric(d);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
        }
    }

    public void write(BStatusValue bStatusValue, BJciS91ProxyExt bJciS91ProxyExt) {
        boolean bl;
        boolean bl2;
        if (this.getN2Log().isTraceOn()) {
            this.getN2Log().trace("write callback received on: " + bJciS91ProxyExt);
        }
        int n = this.getDeviceCode();
        int n2 = bJciS91ProxyExt.getNetworkPointType().getOrdinal();
        int n3 = bJciS91ProxyExt.getNetworkPointAddress() - 1;
        int n4 = bJciS91ProxyExt.getMapData().getItemStatusAddress();
        int n5 = bJciS91ProxyExt.getMapData().getOverrideMask();
        int n6 = bJciS91ProxyExt.getMapData().getStatusMaskSize();
        int n7 = bJciS91ProxyExt.getMapData().getItemValueMask();
        boolean bl3 = false;
        if (bJciS91ProxyExt.getMapData().getItemStatusAddress() != -1) {
            bl3 = bl2 = true;
        }
        if (!bJciS91ProxyExt.isValid()) {
            return;
        }
        int n8 = bJciS91ProxyExt.getMapData().getResponseOffsetToStatus();
        int n9 = bJciS91ProxyExt.getMapData().getOverrideMask();
        boolean bl4 = false;
        if ((n8 & n9) != 0) {
            bl4 = bl = true;
        }
        if (this.getN2Log().isTraceOn()) {
            this.getN2Log().trace("Tc9100 Write, pt = " + bJciS91ProxyExt + "\n  statusByte = " + Integer.toHexString(n8) + ", overrideMask = " + Integer.toHexString(n9) + ", isOverridden = " + bJciS91ProxyExt.isOverridden() + ", override = " + bl);
        }
        if (bStatusValue == null || bStatusValue.getStatus().isNull()) {
            if (bJciS91ProxyExt.isOverridden() & bl2) {
                S91ReadMessage s91ReadMessage;
                if (n2 == 3) {
                    n8 = n3 < 6 ? this.getHld() : this.getCmp();
                    s91ReadMessage = new S91WriteSingleItemMessage(this.getAddress(), n4, n8 & ~n5);
                    if (!bJciS91ProxyExt.sendWrite(s91ReadMessage, bStatusValue)) {
                        return;
                    }
                    this.setHld(n8 & ~n5);
                }
                if (n2 == 4) {
                    n8 = this.getMsk();
                    if (this.getN2Log().isTraceOn()) {
                        this.getN2Log().trace("clearing override, -address:" + n4 + " -byte:" + Integer.toHexString(n8) + " -mask:" + Integer.toHexString(n5));
                    }
                    if (!bJciS91ProxyExt.sendWrite(s91ReadMessage = new S91WriteSingleItemMessage(this.getAddress(), n4, n8 & ~n5), bStatusValue)) {
                        return;
                    }
                    this.setMsk(n8 & ~n5);
                }
                if (n2 == 7) {
                    if (n3 != 1) {
                        return;
                    }
                    if (this.dr9100) {
                        n8 = this.getSup();
                        s91ReadMessage = new S91WriteSingleItemMessage(this.getAddress(), n4, n8 & ~n5);
                        if (!bJciS91ProxyExt.sendWrite(s91ReadMessage, bStatusValue)) {
                            return;
                        }
                        this.setSup(n8 & ~n5);
                    } else {
                        s91ReadMessage = new S91WriteSingleItemExtMessage(this.getAddress(), n4, 198, n5, 1);
                        if (!bJciS91ProxyExt.sendWrite(s91ReadMessage, bStatusValue)) {
                            return;
                        }
                        this.setSup(this.getSup() & ~n5);
                    }
                }
                bJciS91ProxyExt.setOverridden(false);
            } else {
                this.getN2Log().trace("writeValue is null, but we are not overridden! do nothing...");
            }
        } else {
            S91ReadMessage s91ReadMessage;
            if (bl2) {
                if (this.getN2Log().isTraceOn()) {
                    this.getN2Log().trace("Setting Override mask on " + bJciS91ProxyExt);
                }
                if (n2 == 3) {
                    n8 = n3 < 6 ? this.getHld() : this.getCmp();
                    s91ReadMessage = new S91WriteSingleItemMessage(this.getAddress(), n4, n8 | n5);
                    if (!bJciS91ProxyExt.sendWrite(s91ReadMessage, bStatusValue)) {
                        return;
                    }
                    this.setHld(n8 | n5);
                }
                if (n2 == 4) {
                    n8 = this.getMsk();
                    s91ReadMessage = new S91WriteSingleItemMessage(this.getAddress(), n4, n8 | n5);
                    if (!bJciS91ProxyExt.sendWrite(s91ReadMessage, bStatusValue)) {
                        return;
                    }
                    this.setMsk(n8 | n5);
                }
                if (n2 == 7) {
                    if (n3 != 1) {
                        return;
                    }
                    if (this.dr9100) {
                        n8 = this.getSup();
                        s91ReadMessage = new S91WriteSingleItemMessage(this.getAddress(), n4, n8 | n5);
                        if (!bJciS91ProxyExt.sendWrite(s91ReadMessage, bStatusValue)) {
                            return;
                        }
                        this.setSup(n8 | n5);
                    } else {
                        s91ReadMessage = new S91WriteSingleItemExtMessage(this.getAddress(), n4, 198, n5, 1);
                        if (!bJciS91ProxyExt.sendWrite(s91ReadMessage, bStatusValue)) {
                            return;
                        }
                        this.setSup(this.getSup() | n5);
                    }
                }
                bJciS91ProxyExt.setOverridden(true);
            }
            if (this.getN2Log().isTraceOn()) {
                this.getN2Log().trace("Setting Value on " + bJciS91ProxyExt);
            }
            switch (n2) {
                case 3: 
                case 9: {
                    s91ReadMessage = new S91WriteSingleItemMessage(this.getAddress(), bJciS91ProxyExt.getMapData().getItemValueAddress(), BJciS91ProxyExt.getReal((BValue)bStatusValue));
                    bJciS91ProxyExt.sendWrite(s91ReadMessage, bStatusValue);
                    break;
                }
                case 4: {
                    int n10;
                    if (n3 < 7) {
                        n10 = this.getOdc();
                    } else if (n3 < 12) {
                        n10 = this.getSup();
                    } else {
                        s91ReadMessage = new S91WriteSingleItemMessage(this.getAddress(), bJciS91ProxyExt.getMapData().getReadStartAddress(), BJciS91ProxyExt.getBinary((BValue)bStatusValue) ? 128 : 0);
                        bJciS91ProxyExt.sendWrite(s91ReadMessage, bStatusValue);
                        return;
                    }
                    s91ReadMessage = this.dr9100 ? new S91WriteSingleItemMessage(this.getAddress(), bJciS91ProxyExt.getMapData().getItemValueAddress(), BJciS91ProxyExt.getBinary((BValue)bStatusValue) ? n10 | n7 : n10 & ~n7) : new S91WriteSingleItemExtMessage(this.getAddress(), bJciS91ProxyExt.getMapData().getItemValueAddress(), 198 - BJciS91ProxyExt.getBinary((BValue)bStatusValue), bJciS91ProxyExt.getMapData().getItemValueMask(), bJciS91ProxyExt.getMapData().getValueMaskSize());
                    bJciS91ProxyExt.sendWrite(s91ReadMessage, bStatusValue);
                    break;
                }
                case 7: {
                    int n11;
                    if (n3 != 1) {
                        return;
                    }
                    Type type = bStatusValue.getType();
                    if (type.is(BStatusBoolean.TYPE)) {
                        n11 = ((BStatusBoolean)bStatusValue).getValue() ? 2 : 0;
                    } else {
                        double d = BJciS91ProxyExt.getReal((BValue)bStatusValue);
                        if (d > (double)3) {
                            d = 3;
                        }
                        if (d < 0.0) {
                            d = 0.0;
                        }
                        n11 = (int)d;
                    }
                    if (this.dr9100) {
                        int n12 = this.getSup() & 0xFC;
                        n12 = n12 | n11 | 0x20;
                        s91ReadMessage = new S91WriteSingleItemMessage(this.getAddress(), 37, n12);
                        bJciS91ProxyExt.sendWrite(s91ReadMessage, bStatusValue);
                        break;
                    }
                    s91ReadMessage = new S91WriteSingleItemExtMessage(this.getAddress(), 37, 198, 35, 1);
                    bJciS91ProxyExt.sendWrite(s91ReadMessage, bStatusValue);
                    s91ReadMessage = new S91WriteSingleItemExtMessage(this.getAddress(), 37, 197, n11 | 0x20, 1);
                    bJciS91ProxyExt.sendWrite(s91ReadMessage, bStatusValue);
                    break;
                }
                default: {
                    this.getN2Log().trace("Point type is not writable!");
                    bJciS91ProxyExt.writeFail("Point type is not writable!");
                    return;
                }
            }
            bJciS91ProxyExt.doForceRead();
            if (this.getN2Log().isTraceOn()) {
                this.getN2Log().trace("N2 TC9100 doForceRead on: " + bJciS91ProxyExt);
            }
        }
    }

    public String toString(Context context) {
        return "JciTc9100Device:" + this.getName() + " addr:" + this.getAddress();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.backgroundPollCount = 0;
        this.supValid = false;
        this.dr9100 = false;
    }

    public BJciTc9100Device() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$jcin2$BJciTc9100Device;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$BJciTc9100Device = BJciTc9100Device.class("[Lcom.tridium.jcin2.BJciTc9100Device;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

