/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2;

import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.jcin2.BJciN2Device;
import com.tridium.jcin2.messages.JciN2MessageConst;
import com.tridium.jcin2.messages.JciN2Response;
import com.tridium.jcin2.point.BJciN2PointDeviceExt;
import com.tridium.jcin2.point.BJciS91PointDeviceExt;
import com.tridium.jcin2.point.BJciS91ProxyExt;
import com.tridium.jcin2.util.BJciPollGroup;
import java.util.Vector;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.util.IntHashMap;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BJciS91Device
extends BJciN2Device
implements BIBasicPollable,
JciN2MessageConst {
    public static final Property pollFrequency = BJciS91Device.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property points = BJciS91Device.newProperty((int)0, (BValue)new BJciS91PointDeviceExt(), null);
    public static final Property inhibitDevicePoll = BJciS91Device.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE;
    Vector v;
    private IntHashMap hashtableOfPollGroups;
    static /* synthetic */ Class class$com$tridium$jcin2$BJciS91Device;

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public BJciN2PointDeviceExt getPoints() {
        return (BJciN2PointDeviceExt)this.get(points);
    }

    public void setPoints(BJciN2PointDeviceExt bJciN2PointDeviceExt) {
        this.set(points, (BValue)bJciN2PointDeviceExt, null);
    }

    public boolean getInhibitDevicePoll() {
        return this.getBoolean(inhibitDevicePoll);
    }

    public void setInhibitDevicePoll(boolean bl) {
        this.setBoolean(inhibitDevicePoll, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        try {
            long l = System.currentTimeMillis();
            this.transitionToOnline();
            this.getN2Network().getPollScheduler().subscribe((BIPollable)this);
            long l2 = System.currentTimeMillis() - l;
        }
        catch (Exception exception) {}
    }

    public void stopped() throws Exception {
        this.getN2Network().getPollScheduler().unsubscribe((BIPollable)this);
        super.stopped();
    }

    public abstract boolean isDeviceCodeValid();

    public abstract boolean isValidPointForDeviceType(int var1, int var2);

    public abstract void setValue(JciN2Response var1, BJciS91ProxyExt var2);

    public abstract void write(BStatusValue var1, BJciS91ProxyExt var2);

    public void doPing() {
        if (this.identify()) {
            if (this.isDeviceCodeValid()) {
                this.pingOk();
                this.setFaultCause("");
                BAbsTime bAbsTime = BAbsTime.make();
                if (this.lastTimeSync == null || this.lastTimeSync.add(BRelTime.DAY).isBefore(bAbsTime)) {
                    this.timeSync();
                }
            } else {
                int n = this.getAddress();
                int n2 = this.getDeviceCode();
                String string = this.getName();
                this.pingFail("device code invalid for configured device: " + string + ", addr = " + n + ", devcode = " + n2);
                this.setFaultCause("Device code invalid: " + n2);
                this.setDeviceCode(0);
            }
        } else {
            this.pingFail("null response to identify - doPing in BJciS91Device");
            this.setFaultCause("Null response to identify");
        }
    }

    protected abstract boolean identify();

    public void poll() {
        if (this.isDown()) {
            return;
        }
        if (this.isDisabled()) {
            return;
        }
        if (this.isFatalFault()) {
            return;
        }
        if (this.getInhibitDevicePoll()) {
            return;
        }
        this.backgroundPoll();
    }

    public abstract void backgroundPoll();

    public String toString(Context context) {
        return "JciS91Device:" + this.getName() + " addr:" + this.getAddress();
    }

    public void registerListener(BJciS91ProxyExt bJciS91ProxyExt) {
        if (!this.v.contains(bJciS91ProxyExt)) {
            this.v.addElement(bJciS91ProxyExt);
        }
    }

    public void unregisterListener(BJciS91ProxyExt bJciS91ProxyExt) {
        while (this.v.contains(bJciS91ProxyExt)) {
            this.v.removeElement(bJciS91ProxyExt);
        }
    }

    protected abstract void updatePollListeners(int var1, int var2);

    protected abstract void failPollListeners(int var1);

    public void registerToPollGroup(BJciS91ProxyExt bJciS91ProxyExt) {
        int n = bJciS91ProxyExt.getMapData().getReadStartAddress();
        BJciPollGroup bJciPollGroup = (BJciPollGroup)((Object)this.hashtableOfPollGroups.get(n));
        if (bJciPollGroup == null) {
            bJciPollGroup = new BJciPollGroup(this);
            this.hashtableOfPollGroups.put(n, (Object)bJciPollGroup);
        }
        bJciPollGroup.registerProxy(bJciS91ProxyExt);
    }

    public void unregisterToPollGroup(BJciS91ProxyExt bJciS91ProxyExt) {
        int n = bJciS91ProxyExt.getMapData().getReadStartAddress();
        BJciPollGroup bJciPollGroup = (BJciPollGroup)((Object)this.hashtableOfPollGroups.get(n));
        if (bJciPollGroup == null) {
            return;
        }
        bJciPollGroup.unregisterProxy(bJciS91ProxyExt);
    }

    public void subscribeToPollGroup(BJciS91ProxyExt bJciS91ProxyExt) throws Exception {
        int n = bJciS91ProxyExt.getMapData().getReadStartAddress();
        BJciPollGroup bJciPollGroup = (BJciPollGroup)((Object)this.hashtableOfPollGroups.get(n));
        if (bJciPollGroup == null) {
            bJciPollGroup = new BJciPollGroup(this);
            this.hashtableOfPollGroups.put(n, (Object)bJciPollGroup);
        }
        bJciPollGroup.readSubscribed(bJciS91ProxyExt);
    }

    public void unsubscribeToPollGroup(BJciS91ProxyExt bJciS91ProxyExt) throws Exception {
        int n = bJciS91ProxyExt.getMapData().getReadStartAddress();
        BJciPollGroup bJciPollGroup = (BJciPollGroup)((Object)this.hashtableOfPollGroups.get(n));
        if (bJciPollGroup == null) {
            return;
        }
        bJciPollGroup.readUnsubscribed(bJciS91ProxyExt);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.v = new Vector(8, 8);
        this.hashtableOfPollGroups = new IntHashMap();
    }

    public BJciS91Device() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$jcin2$BJciS91Device;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$BJciS91Device = BJciS91Device.class("[Lcom.tridium.jcin2.BJciS91Device;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

