/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2;

import com.tridium.jcin2.BJciN2Device;
import com.tridium.jcin2.messages.JciN2InputStream;
import com.tridium.jcin2.messages.JciN2OResponse;
import com.tridium.jcin2.messages.N2OIdentifyMessage;
import com.tridium.jcin2.messages.N2OIdentifyResponse;
import com.tridium.jcin2.messages.N2OPingMessage;
import com.tridium.jcin2.messages.N2OPingResponse;
import com.tridium.jcin2.messages.N2OTimeSynchMessage;
import com.tridium.jcin2.point.BJciN2OPointDeviceExt;
import com.tridium.jcin2.point.BJciN2PointDeviceExt;
import com.tridium.jcin2.point.BJciN2ProxyExt;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJciN2ODevice
extends BJciN2Device {
    public static final Property points = BJciN2ODevice.newProperty((int)0, (BValue)new BJciN2OPointDeviceExt(), null);
    public static final Type TYPE;
    private boolean cos;
    static /* synthetic */ Class class$com$tridium$jcin2$BJciN2ODevice;

    public BJciN2PointDeviceExt getPoints() {
        return (BJciN2PointDeviceExt)this.get(points);
    }

    public void setPoints(BJciN2PointDeviceExt bJciN2PointDeviceExt) {
        this.set(points, (BValue)bJciN2PointDeviceExt, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doPing() throws Exception {
        boolean bl = this.getN2Log().isTraceOn();
        if (this.needsId()) {
            this.identify();
            return;
        }
        N2OPingResponse n2OPingResponse = (N2OPingResponse)this.getN2Network().sendSync(new N2OPingMessage(this.getAddress(), this.cos), this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (n2OPingResponse != null) {
            if (!n2OPingResponse.isError()) {
                JciN2InputStream jciN2InputStream;
                this.setFaultCause("");
                if (n2OPingResponse.isCOS()) {
                    jciN2InputStream = n2OPingResponse.getIn();
                    while (jciN2InputStream.available() > 0) {
                        int n = jciN2InputStream.readByte();
                        int n2 = jciN2InputStream.readByte();
                        BJciN2ProxyExt[] bJciN2ProxyExtArray = this.getPoints().getN2Points(n, n2);
                        jciN2InputStream.mark(jciN2InputStream.available());
                        int n3 = 0;
                        while (n3 < bJciN2ProxyExtArray.length) {
                            if (bl) {
                                this.getN2Log().trace("COS in " + (Object)((Object)this) + ": ptType:" + n + ", ptNum:" + n2 + " Niagara point:" + (Object)((Object)bJciN2ProxyExtArray[n3]));
                            }
                            jciN2InputStream.reset();
                            bJciN2ProxyExtArray[n3].setValue(n2OPingResponse);
                            ++n3;
                        }
                    }
                    this.cos = true;
                } else {
                    this.cos = false;
                }
                jciN2InputStream = BAbsTime.make();
                if (this.lastTimeSync == null || this.lastTimeSync.add(BRelTime.DAY).isBefore((BAbsTime)jciN2InputStream)) {
                    this.timeSync();
                }
                this.pingOk();
            } else if (n2OPingResponse.getErrorCode() == 0) {
                if (bl) {
                    this.getN2Log().trace("doPing Error: N2O_ERR_IDLE_DEVICE on: " + (Object)((Object)this));
                }
                this.pingFail("Device Reset");
                this.setFaultCause("Device has Reset");
                this.setNeedsId(true);
            } else if (bl) {
                this.getN2Log().trace("doPing ErrorCode = " + n2OPingResponse.getErrorCode() + " on: " + (Object)((Object)this));
            }
        } else {
            if (bl) {
                this.getN2Log().trace("doPing Null Response on: " + (Object)((Object)this));
            }
            this.pingFail("Null Response");
            this.setFaultCause("Null Response to Ping");
            this.setNeedsId(true);
        }
    }

    protected void transitionToOnline() {
        this.timeSync();
    }

    protected void timeSync() {
        JciN2OResponse jciN2OResponse;
        boolean bl = this.getN2Log().isTraceOn();
        if (bl) {
            this.getN2Log().trace("Synch Time on " + (Object)((Object)this));
        }
        if ((jciN2OResponse = (JciN2OResponse)this.getN2Network().sendSync(new N2OTimeSynchMessage(this.getAddress()), this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount())) != null) {
            if (jciN2OResponse.isError()) {
                this.getN2Log().trace("Sync Response is Error! " + jciN2OResponse.getError());
                if (jciN2OResponse.getErrorCode() == 0) {
                    this.pingFail("Device has Reset");
                    this.setNeedsId(true);
                }
            } else {
                this.lastTimeSync = BAbsTime.make();
            }
        } else {
            this.pingFail("Null Response to Time Synch");
            this.setNeedsId(true);
        }
    }

    public String toString(Context context) {
        return "JciN2ODevice:" + this.getName() + " addr:" + this.getAddress();
    }

    protected void identify() {
        boolean bl = this.getN2Log().isTraceOn();
        N2OIdentifyResponse n2OIdentifyResponse = (N2OIdentifyResponse)this.getN2Network().sendSync(new N2OIdentifyMessage(this.getAddress()), this.getN2Network().getResponseTimeout(), 0);
        if (n2OIdentifyResponse != null) {
            if (!n2OIdentifyResponse.isError()) {
                int n = n2OIdentifyResponse.getIn().readByte();
                if (bl) {
                    this.getN2Log().trace("Identify on " + (Object)((Object)this) + ": Device Code = 0x" + Integer.toHexString(n));
                }
                this.setDeviceCode(n);
                if (this.isDeviceCodeValid()) {
                    this.setFirmwareVersion(BJciN2ODevice.getDeviceFirmwareVersion(this.getN2Network(), this.getAddress(), n));
                    this.setNeedsId(false);
                } else {
                    this.setFaultCause("Invalid Device Code: " + n);
                }
            } else if (bl) {
                this.getN2Log().trace("Identify on " + (Object)((Object)this) + ": Error: " + n2OIdentifyResponse.getError());
            }
            this.pingOk();
        } else {
            this.pingFail("Null Response to Identify");
        }
    }

    public boolean isDeviceCodeValid() {
        switch (this.getDeviceCode()) {
            case 5: 
            case 16: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 193: 
            case 194: 
            case 195: {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.cos = false;
    }

    public BJciN2ODevice() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$jcin2$BJciN2ODevice;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$BJciN2ODevice = BJciN2ODevice.class("[Lcom.tridium.jcin2.BJciN2ODevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

