/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.serial.SerialComm;
import com.tridium.jcin2.BJciN2Device;
import com.tridium.jcin2.BJciN2DeviceFolder;
import com.tridium.jcin2.comm.JciN2CommReceiver;
import com.tridium.jcin2.job.BDeviceDiscoveryConfig;
import com.tridium.jcin2.job.BJciN2DiscoverDevicesJob;
import com.tridium.jcin2.messages.JciN2Message;
import com.tridium.jcin2.messages.JciN2Response;
import com.tridium.jcin2.messages.N2BReadMessage;
import com.tridium.jcin2.ping.BJciN2PingMonitor;
import com.tridium.jcin2.point.BJciN2SlaveTuningPolicy;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJciN2Network
extends BSerialNetwork {
    public static final Property monitor = BJciN2Network.newProperty((int)0, (BValue)new BJciN2PingMonitor(), null);
    public static final Property responseTimeout = BJciN2Network.newProperty((int)0, (BValue)BRelTime.make((long)500L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)250L), (String)"max", (BIDataValue)BRelTime.makeSeconds((int)12)));
    public static final Property useMessageOverrideFlag = BJciN2Network.newProperty((int)4, (boolean)true, null);
    public static final Action submitDeviceDiscoveryJob = BJciN2Network.newAction((int)4, (BValue)new BDeviceDiscoveryConfig(), null);
    public static final Type TYPE;
    public static final int MAX_N2_DEVICE_ADDRESS = 255;
    private Log n2log;
    private Log n2Sendlog;
    static /* synthetic */ Class class$com$tridium$jcin2$BJciN2Network;

    public boolean getUseMessageOverrideFlag() {
        return this.getBoolean(useMessageOverrideFlag);
    }

    public void setUseMessageOverrideFlag(boolean bl) {
        this.setBoolean(useMessageOverrideFlag, bl, null);
    }

    public BOrd submitDeviceDiscoveryJob(BDeviceDiscoveryConfig bDeviceDiscoveryConfig) {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, (BValue)bDeviceDiscoveryConfig, null);
    }

    public Type getType() {
        return TYPE;
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.toTop("jciFxDriver:FxDriverDeviceManager");
        return agentList;
    }

    public void started() throws Exception {
        super.started();
        this.getN2Log();
    }

    public Type getDeviceType() {
        return BJciN2Device.TYPE;
    }

    public Type getDeviceFolderType() {
        return BJciN2DeviceFolder.TYPE;
    }

    protected Comm makeComm() {
        return new SerialComm((BSerialNetwork)this, (CommReceiver)new JciN2CommReceiver());
    }

    public BOrd doSubmitDeviceDiscoveryJob(BDeviceDiscoveryConfig bDeviceDiscoveryConfig, Context context) {
        return new BJciN2DiscoverDevicesJob(this, bDeviceDiscoveryConfig.getStartAddress(), bDeviceDiscoveryConfig.getStopAddress()).submit(context);
    }

    public Log getN2Log() {
        String string = "jcin2." + this.getName();
        if (this.n2log != null && string.equals(this.n2log.getLogName())) {
            return this.n2log;
        }
        this.n2log = Log.getLog((String)string);
        return this.n2log;
    }

    public Log getN2SendLog() {
        String string = "jcin2.SendMessage";
        if (this.n2Sendlog != null && string.equals(this.n2Sendlog.getLogName())) {
            return this.n2Sendlog;
        }
        this.n2Sendlog = Log.getLog((String)string);
        return this.n2Sendlog;
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "jcin2");
    }

    public Message sendSync(Message message, BRelTime bRelTime, int n) {
        Message message2 = null;
        message2 = super.sendSync(message, bRelTime, n);
        this.getN2SendLog().trace("COMM ...Send Message = " + this.toSendDebugString((JciN2Message)message));
        int n2 = 0;
        while (n2 < n) {
            if (message2 == null) {
                this.getN2Log().trace("...retry after NULL Response, cnt = " + n2 + ": " + this.toSendDebugString((JciN2Message)message));
                message2 = super.sendSync(message, bRelTime, n);
            } else {
                JciN2Response jciN2Response = (JciN2Response)message2;
                if (jciN2Response.isError()) {
                    if (n2 == 0) {
                        this.getN2Log().trace("retry for sendSync error: " + jciN2Response.getError() + ", msg type = " + message.getClass().getName() + ",\n...TX Msg = " + this.toSendDebugString((JciN2Message)message));
                    }
                    this.getN2Log().trace("...retry after error, cnt = " + n2 + ", resp msg = " + this.toMsgDebugString(jciN2Response));
                    message2 = super.sendSync(message, bRelTime, n);
                    if (!((JciN2Response)message2).isError()) {
                        this.getN2Log().trace("...successful retry after error, resp = " + this.toMsgDebugString((JciN2Response)message2));
                    }
                } else {
                    boolean bl = true;
                    if (!(message instanceof N2BReadMessage)) {
                        if (bl) {
                            return message2;
                        }
                        this.getN2Log().trace("...retry after INVALID reply msg content, cnt = " + n2 + ", original msg = " + message.toDebugString());
                        message2 = super.sendSync(message, bRelTime, n);
                    }
                }
            }
            ++n2;
        }
        return message2;
    }

    public String toMsgDebugString(JciN2Response jciN2Response) {
        StringBuffer stringBuffer = new StringBuffer("BJciN2Network N2 Rx:");
        stringBuffer.append(jciN2Response.toDebugString());
        return stringBuffer.toString();
    }

    public String toSendDebugString(JciN2Message jciN2Message) {
        return jciN2Message.toDebugString();
    }

    public BTuningPolicy findSlaveTuningPolicy(BTuningPolicyMap bTuningPolicyMap) {
        BTuningPolicy bTuningPolicy = null;
        BTuningPolicy[] bTuningPolicyArray = bTuningPolicyMap.getPolicies();
        int n = 0;
        while (n < bTuningPolicyArray.length) {
            if (bTuningPolicyArray[n] instanceof BTuningPolicy) {
                bTuningPolicy = bTuningPolicyArray[n];
                BRelTime bRelTime = bTuningPolicy.getMaxWriteTime();
                BRelTime bRelTime2 = bTuningPolicy.getMinWriteTime();
                if (bRelTime.getMinutes() == 10 && bRelTime2.getMinutes() == 1) break;
                bTuningPolicy = null;
            }
            ++n;
        }
        return bTuningPolicy;
    }

    public boolean isValidHexMessage(JciN2Response jciN2Response) {
        boolean bl = true;
        jciN2Response.getIn().mark(0);
        jciN2Response.getIn().reset();
        byte[] byArray = new byte[256];
        int n = jciN2Response.getIn().read(byArray, 0, 256);
        String string = new String(byArray);
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            char c = string.charAt(n2);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F')) {
                if (c == '\r') {
                    if (n2 != n - 1) {
                        this.getN2Log().trace("Response LEN != buffer size! i= " + n2 + ", len = " + n);
                    }
                    bl = true;
                    jciN2Response.getIn().mark(0);
                    jciN2Response.getIn().reset();
                    return true;
                }
                this.getN2Log().trace("INVALID Character found in response: idx = " + n2 + ", len = " + n + ", ch = " + TextUtil.byteToHexString((int)by));
                jciN2Response.getIn().mark(0);
                jciN2Response.getIn().reset();
                return false;
            }
            bl = true;
            ++n2;
        }
        jciN2Response.getIn().mark(0);
        jciN2Response.getIn().reset();
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BJciN2Network() {
        Object object;
        BTuningPolicyMap bTuningPolicyMap = this.getTuningPolicies();
        if (bTuningPolicyMap instanceof BTuningPolicyMap && (object = this.findSlaveTuningPolicy(bTuningPolicyMap)) == null) {
            object = new BJciN2SlaveTuningPolicy();
            bTuningPolicyMap.add("SlavePolicy", (BValue)object);
        }
        object = this.getSerialPortConfig();
        object.setFlags((Slot)BSerialHelper.baudRate, object.getFlags((Slot)BSerialHelper.baudRate) | 1);
        object.setFlags((Slot)BSerialHelper.dataBits, object.getFlags((Slot)BSerialHelper.dataBits) | 1);
        object.setFlags((Slot)BSerialHelper.stopBits, object.getFlags((Slot)BSerialHelper.stopBits) | 1);
        object.setFlags((Slot)BSerialHelper.parity, object.getFlags((Slot)BSerialHelper.parity) | 1);
        object.setFlags((Slot)BSerialHelper.flowControlMode, object.getFlags((Slot)BSerialHelper.flowControlMode) | 1);
    }

    static {
        Class clazz = class$com$tridium$jcin2$BJciN2Network;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$BJciN2Network = BJciN2Network.class("[Lcom.tridium.jcin2.BJciN2Network;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

