/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.jcin2.BJciN2Network;
import com.tridium.jcin2.BJciS91Device;
import com.tridium.jcin2.messages.N2OVersionMessage;
import com.tridium.jcin2.messages.N2OVersionResponse;
import com.tridium.jcin2.point.BJciN2PointDeviceExt;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.IntHashMap;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BJciN2Device
extends BBasicDevice {
    public static final Property address = BJciN2Device.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt((int)1, (int)255));
    public static final Property deviceCode = BJciN2Device.newProperty((int)1, (int)0, (BFacets)BFacets.makeInt((BUnit)BUnit.NULL, (int)0, (int)255, (int)16));
    public static final Property controllerType = BJciN2Device.newProperty((int)4, (String)"", null);
    public static final Property firmwareVersion = BJciN2Device.newProperty((int)1, (String)"", null);
    public static final Property displayType = BJciN2Device.newProperty((int)1, (String)"", null);
    public static final Property traceThisDevice = BJciN2Device.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE;
    private static final int DEVICE_CODE_MIG_DX = 5;
    private static final String CONTROLLER_TYPE_MIG = "MIG Metasys Integrator";
    private static final String CONTROLLER_TYPE_DX = "DX-9100 Digital Controller";
    private static final String DISPLAY_TYPE_MIG = "MIG";
    private static final String DISPLAY_TYPE_DX = "DX";
    private static final IntHashMap deviceMap;
    private boolean needsId;
    protected BAbsTime lastTimeSync;
    static /* synthetic */ Class class$com$tridium$jcin2$BJciN2Device;

    public int getAddress() {
        return this.getInt(address);
    }

    public void setAddress(int n) {
        this.setInt(address, n, null);
    }

    public int getDeviceCode() {
        return this.getInt(deviceCode);
    }

    public void setDeviceCode(int n) {
        this.setInt(deviceCode, n, null);
    }

    public String getControllerType() {
        return this.getString(controllerType);
    }

    public void setControllerType(String string) {
        this.setString(controllerType, string, null);
    }

    public String getFirmwareVersion() {
        return this.getString(firmwareVersion);
    }

    public void setFirmwareVersion(String string) {
        this.setString(firmwareVersion, string, null);
    }

    public String getDisplayType() {
        return this.getString(displayType);
    }

    public void setDisplayType(String string) {
        this.setString(displayType, string, null);
    }

    public boolean getTraceThisDevice() {
        return this.getBoolean(traceThisDevice);
    }

    public void setTraceThisDevice(boolean bl) {
        this.setBoolean(traceThisDevice, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)deviceCode)) {
            this.setControllerType(BJciN2Device.getControllerType(this.getDeviceCode(), this.getType().is(BJciS91Device.TYPE)));
            this.setDisplayType(BJciN2Device.getDisplayType(this.getDeviceCode(), this.getType().is(BJciS91Device.TYPE)));
        }
    }

    public void clockChanged(BRelTime bRelTime) throws Exception {
        if (bRelTime.getMinutes() > 2) {
            this.lastTimeSync = null;
        }
    }

    public Type getNetworkType() {
        return BJciN2Network.TYPE;
    }

    public void pingOk() {
        if (this.isDown()) {
            this.transitionToOnline();
        }
        super.pingOk();
    }

    public abstract BJciN2PointDeviceExt getPoints();

    protected void transitionToOnline() {
    }

    protected void timeSync() {
    }

    public BJciN2Network getN2Network() {
        return (BJciN2Network)this.getNetwork();
    }

    public void setNeedsId(boolean bl) {
        this.needsId = bl;
    }

    public boolean needsId() {
        return this.needsId;
    }

    Log getN2Log() {
        try {
            if (this.getTraceThisDevice()) {
                return this.getN2Network().getN2Log();
            }
            return Log.getLog((String)"jcin2.x");
        }
        catch (Exception exception) {
            return Log.getLog((String)"jcin2.x");
        }
    }

    public final void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"JciN2Device", 2);
        spyWriter.prop((Object)"needsId", this.needsId);
        spyWriter.prop((Object)"lastTimeSync", (Object)this.lastTimeSync);
        this.n2spy(spyWriter);
        spyWriter.endProps();
    }

    public void n2spy(SpyWriter spyWriter) throws Exception {
    }

    public static String getControllerType(int n, boolean bl) {
        if (n == 5) {
            return bl ? CONTROLLER_TYPE_DX : CONTROLLER_TYPE_MIG;
        }
        DeviceType deviceType = (DeviceType)deviceMap.get(n);
        if (deviceType == null) {
            return "Unknown code:" + n;
        }
        return deviceType.getCType();
    }

    public static String getDisplayType(int n, boolean bl) {
        if (n == 5) {
            return bl ? DISPLAY_TYPE_DX : DISPLAY_TYPE_MIG;
        }
        DeviceType deviceType = (DeviceType)deviceMap.get(n);
        if (deviceType == null) {
            return "?" + n + '?';
        }
        return deviceType.getDType();
    }

    public static TypeInfo getTypeInfo(int n, boolean bl) {
        if (n == 5) {
            return bl ? BTypeSpec.make((String)"jcin2:JciDx9100Device").getTypeInfo() : BTypeSpec.make((String)"jcin2:JciN2ODevice").getTypeInfo();
        }
        DeviceType deviceType = (DeviceType)deviceMap.get(n);
        if (deviceType == null) {
            return null;
        }
        return deviceType.getTInfo();
    }

    public static String getDeviceFirmwareVersion(BJciN2Network bJciN2Network, int n, int n2) {
        String string = "-";
        int n3 = 0;
        BRelTime bRelTime = BRelTime.make((long)100L);
        try {
            N2OVersionResponse n2OVersionResponse = (N2OVersionResponse)bJciN2Network.sendSync(new N2OVersionMessage(n), bRelTime, n3);
            if (n2OVersionResponse != null) {
                if (n2OVersionResponse.isNakError()) {
                    string = "-";
                } else if (!n2OVersionResponse.isError()) {
                    string = "";
                    if (n2 == 16) {
                        int n4 = 0;
                        int n5 = 0;
                        while (n5 < 7) {
                            n4 = n2OVersionResponse.getIn().read();
                            string = string + (char)n4;
                            ++n5;
                        }
                    } else {
                        int n6 = n2OVersionResponse.getIn().readByte();
                        char c = (char)(n6 &= 0xFF);
                        string = string + c;
                        n6 = n2OVersionResponse.getIn().readByte();
                        c = (char)(n6 &= 0xFF);
                        string = string + c;
                        n6 = n2OVersionResponse.getIn().readByte();
                        c = (char)(n6 &= 0xFF);
                        string = string + c;
                        n6 = n2OVersionResponse.getIn().readByte();
                        c = (char)(n6 &= 0xFF);
                        string = string + '.' + c;
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
            System.out.println("Discover Device Version ERROR: " + runtimeException.getMessage());
            runtimeException.printStackTrace();
        }
        return string;
    }

    static final void d(String string) {
        System.out.println(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.needsId = true;
        this.lastTimeSync = null;
    }

    public BJciN2Device() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$jcin2$BJciN2Device;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$BJciN2Device = BJciN2Device.class("[Lcom.tridium.jcin2.BJciN2Device;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        deviceMap = new IntHashMap();
        try {
            BOrd bOrd = BOrd.make((String)"module://jcin2/com/tridium/jcin2/deviceTypes.xml");
            BIFile bIFile = (BIFile)bOrd.resolve().get();
            XElem xElem = XParser.make((InputStream)bIFile.getInputStream()).parse();
            XElem[] xElemArray = xElem.elems("device");
            int n = 0;
            while (n < xElemArray.length) {
                int n2 = xElemArray[n].geti("code", 0);
                DeviceType deviceType = new DeviceType(xElemArray[n].get("n", "??"), xElemArray[n].get("controllerType", "??"), xElemArray[n].get("t", null));
                deviceMap.put(n2, (Object)deviceType);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Error Loading JCI N2 Device Types!");
            exception.printStackTrace();
        }
    }

    static class DeviceType {
        private String cType;
        private String dType;
        private TypeInfo ti;

        public String getCType() {
            return this.cType;
        }

        public String getDType() {
            return this.dType;
        }

        public TypeInfo getTInfo() {
            return this.ti;
        }

        public String toString() {
            return this.cType + " (" + this.dType + ')';
        }

        public DeviceType(String string, String string2, String string3) {
            this.cType = string;
            this.dType = string2;
            this.ti = BTypeSpec.make((String)("jcin2:" + string3)).getTypeInfo();
        }
    }
}

