/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jcin2;

import com.tridium.jcin2.BJciS91Device;
import com.tridium.jcin2.messages.Dx9100WriteTimeMessage;
import com.tridium.jcin2.messages.JciN2Response;
import com.tridium.jcin2.messages.JciS91InputStream;
import com.tridium.jcin2.messages.JciS91Response;
import com.tridium.jcin2.messages.S91ReadBlockMessage;
import com.tridium.jcin2.messages.S91ReadSingleItemExtMessage;
import com.tridium.jcin2.messages.S91ReadSingleItemMessage;
import com.tridium.jcin2.messages.S91WriteSingleItemExtMessage;
import com.tridium.jcin2.point.BJciN2PointDeviceExt;
import com.tridium.jcin2.point.BJciS91ProxyExt;
import com.tridium.jcin2.util.BJciPollGroup;
import com.tridium.jcin2.util.JciDx9100MapData;
import javax.baja.control.BControlPoint;
import javax.baja.log.Log;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJciDx9100Device
extends BJciS91Device {
    public static final Property xtMask = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property sup = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE, (int)16));
    public static final Property dis = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property ais = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)((char)-1), (int)16));
    public static final Property lrst1 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)((char)-1), (int)16));
    public static final Property lrst2 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)((char)-1), (int)16));
    public static final Property lrst3 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)((char)-1), (int)16));
    public static final Property lrst4 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)((char)-1), (int)16));
    public static final Property lcos1 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)((char)-1), (int)16));
    public static final Property lcos2 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)((char)-1), (int)16));
    public static final Property xtstc1 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property xtstc2 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property xtstc3 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property xtstc4 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property xtstc5 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property xtstc6 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property xtstc7 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Property xtstc8 = BJciDx9100Device.newProperty((int)3, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)255, (int)16));
    public static final Type TYPE;
    private Log dxlog;
    int backgroundPollCount;
    int xtToPoll;
    BJciPollGroup xt1di;
    static /* synthetic */ Class class$com$tridium$jcin2$BJciDx9100Device;

    public int getXtMask() {
        return this.getInt(xtMask);
    }

    public void setXtMask(int n) {
        this.setInt(xtMask, n, null);
    }

    public int getSup() {
        return this.getInt(sup);
    }

    public void setSup(int n) {
        this.setInt(sup, n, null);
    }

    public int getDis() {
        return this.getInt(dis);
    }

    public void setDis(int n) {
        this.setInt(dis, n, null);
    }

    public int getAis() {
        return this.getInt(ais);
    }

    public void setAis(int n) {
        this.setInt(ais, n, null);
    }

    public int getLrst1() {
        return this.getInt(lrst1);
    }

    public void setLrst1(int n) {
        this.setInt(lrst1, n, null);
    }

    public int getLrst2() {
        return this.getInt(lrst2);
    }

    public void setLrst2(int n) {
        this.setInt(lrst2, n, null);
    }

    public int getLrst3() {
        return this.getInt(lrst3);
    }

    public void setLrst3(int n) {
        this.setInt(lrst3, n, null);
    }

    public int getLrst4() {
        return this.getInt(lrst4);
    }

    public void setLrst4(int n) {
        this.setInt(lrst4, n, null);
    }

    public int getLcos1() {
        return this.getInt(lcos1);
    }

    public void setLcos1(int n) {
        this.setInt(lcos1, n, null);
    }

    public int getLcos2() {
        return this.getInt(lcos2);
    }

    public void setLcos2(int n) {
        this.setInt(lcos2, n, null);
    }

    public int getXtstc1() {
        return this.getInt(xtstc1);
    }

    public void setXtstc1(int n) {
        this.setInt(xtstc1, n, null);
    }

    public int getXtstc2() {
        return this.getInt(xtstc2);
    }

    public void setXtstc2(int n) {
        this.setInt(xtstc2, n, null);
    }

    public int getXtstc3() {
        return this.getInt(xtstc3);
    }

    public void setXtstc3(int n) {
        this.setInt(xtstc3, n, null);
    }

    public int getXtstc4() {
        return this.getInt(xtstc4);
    }

    public void setXtstc4(int n) {
        this.setInt(xtstc4, n, null);
    }

    public int getXtstc5() {
        return this.getInt(xtstc5);
    }

    public void setXtstc5(int n) {
        this.setInt(xtstc5, n, null);
    }

    public int getXtstc6() {
        return this.getInt(xtstc6);
    }

    public void setXtstc6(int n) {
        this.setInt(xtstc6, n, null);
    }

    public int getXtstc7() {
        return this.getInt(xtstc7);
    }

    public void setXtstc7(int n) {
        this.setInt(xtstc7, n, null);
    }

    public int getXtstc8() {
        return this.getInt(xtstc8);
    }

    public void setXtstc8(int n) {
        this.setInt(xtstc8, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isDeviceCodeValid() {
        switch (this.getDeviceCode()) {
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 18: 
            case 21: 
            case 117: 
            case 133: {
                return true;
            }
        }
        return false;
    }

    protected boolean identify() {
        boolean bl = this.getDxLog().isTraceOn();
        S91ReadSingleItemExtMessage s91ReadSingleItemExtMessage = new S91ReadSingleItemExtMessage(this.getAddress(), 0);
        BRelTime bRelTime = this.getN2Network().getResponseTimeout();
        long l = bRelTime.getMillis();
        BRelTime bRelTime2 = BRelTime.make((long)(l * (long)4));
        JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemExtMessage, bRelTime2, this.getN2Network().getRetryCount());
        if (jciS91Response != null) {
            if (!jciS91Response.isError()) {
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                int n = jciS91InputStream.readByte();
                int n2 = this.getDeviceCode();
                this.setDeviceCode(n);
                if (this.isDeviceCodeValid()) {
                    this.setNeedsId(false);
                } else {
                    this.setFaultCause("Invalid Device Code: " + n);
                }
                if (bl) {
                    this.getDxLog().trace("Identify on " + this + ": Saved DevCode = 0x" + Integer.toHexString(n2) + " Read Code = 0x" + Integer.toHexString(n) + "\n...debug = " + s91ReadSingleItemExtMessage.toDebugString() + jciS91Response.recieveMsgDebug);
                }
            } else if (bl) {
                this.getDxLog().trace("Identify on " + this + ": Error:" + jciS91Response.getError());
            }
            return true;
        }
        if (bl) {
            this.getDxLog().trace("Identify on DX " + this + ": Error:null response!");
        }
        if (bl) {
            this.getDxLog().trace("         msg = " + s91ReadSingleItemExtMessage.toDebugString());
        }
        return false;
    }

    protected void transitionToOnline() {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        if (this.identify()) {
            l2 = System.currentTimeMillis() - l;
            this.timeSync();
            l2 = System.currentTimeMillis() - l;
            int n = 1;
            while (n < 9) {
                this.getXtStatus(n);
                ++n;
            }
            l2 = System.currentTimeMillis() - l;
            S91ReadSingleItemMessage s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 1);
            JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
            if (jciS91Response == null || jciS91Response.isError()) {
                this.getDxLog().trace("transition to online read failed: SUP");
                l2 = System.currentTimeMillis() - l;
            } else {
                this.getDxLog().trace("transition to online read succeeded: SUP");
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setSup(jciS91InputStream.readInt());
                l2 = System.currentTimeMillis() - l;
            }
        }
    }

    public boolean isValidPointForDeviceType(int n, int n2) {
        if (n2 < 0) {
            return false;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                return n2 < 72;
            }
            case 5: {
                return n2 < 8;
            }
            case 7: {
                return n2 < 32;
            }
            case 8: {
                return n2 < 64;
            }
            case 9: {
                return n2 < 240;
            }
            case 10: 
            case 11: 
            case 12: {
                return n2 < 96;
            }
        }
        return false;
    }

    protected void timeSync() {
        Dx9100WriteTimeMessage dx9100WriteTimeMessage = new Dx9100WriteTimeMessage(this.getAddress());
        JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(dx9100WriteTimeMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (jciS91Response == null || jciS91Response.isError()) {
            this.getDxLog().trace("time sync failed");
        } else {
            this.getDxLog().trace("time sync succeeded");
            this.lastTimeSync = BAbsTime.make();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void backgroundPoll() {
        if (this.isDown()) {
            return;
        }
        boolean bl = true;
        block0 : switch (this.backgroundPollCount) {
            case 0: {
                S91WriteSingleItemExtMessage s91WriteSingleItemExtMessage = new S91WriteSingleItemExtMessage(this.getAddress(), 1, 197, 32768, 2);
                JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91WriteSingleItemExtMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciS91Response == null || jciS91Response.isError()) {
                    this.getDxLog().trace("Background set SAS failed: SUP");
                } else {
                    this.getDxLog().trace("Set SAS succeeded");
                    JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                }
                S91ReadSingleItemMessage s91ReadSingleItemMessage = new S91ReadSingleItemMessage(this.getAddress(), 1);
                jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciS91Response == null || jciS91Response.isError()) {
                    this.getDxLog().trace("Background read failed: SUP");
                    break;
                }
                this.getDxLog().trace("Read SUP succeeded");
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setSup(jciS91InputStream.readInt());
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                S91ReadBlockMessage s91ReadBlockMessage = new S91ReadBlockMessage(this.getAddress(), 6, 2);
                JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadBlockMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciS91Response == null || jciS91Response.isError()) {
                    this.getDxLog().trace("Background read failed: DIS/AIS");
                    this.failPollListeners(6);
                    this.failPollListeners(7);
                    break;
                }
                this.getDxLog().trace("Read Succeeded: DIS/AIS");
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setDis(jciS91InputStream.readByte());
                this.setAis(jciS91InputStream.readInt());
                this.updatePollListeners(6, this.getDis());
                this.updatePollListeners(7, this.getAis());
                break;
            }
            case 2: {
                S91ReadBlockMessage s91ReadBlockMessage = new S91ReadBlockMessage(this.getAddress(), 8, 2);
                JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadBlockMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciS91Response == null || jciS91Response.isError()) {
                    this.getDxLog().trace("Background read failed: LRST1/LRST2");
                    this.failPollListeners(8);
                    this.failPollListeners(9);
                    break;
                }
                this.getDxLog().trace("Read Succeeded: LRST1/LRST2");
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setLrst1(jciS91InputStream.readInt());
                this.setLrst2(jciS91InputStream.readInt());
                this.updatePollListeners(8, this.getLrst1());
                this.updatePollListeners(9, this.getLrst2());
                break;
            }
            case 4: {
                S91ReadBlockMessage s91ReadBlockMessage = new S91ReadBlockMessage(this.getAddress(), 44, 2);
                JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadBlockMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciS91Response == null || jciS91Response.isError()) {
                    this.getDxLog().trace("Background read failed: LRST3/LRST4");
                    this.failPollListeners(44);
                    this.failPollListeners(45);
                    break;
                }
                this.getDxLog().trace("Read Succeeded: LRST3/LRST4");
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setLrst3(jciS91InputStream.readInt());
                this.setLrst4(jciS91InputStream.readInt());
                this.updatePollListeners(44, this.getLrst3());
                this.updatePollListeners(45, this.getLrst4());
                break;
            }
            case 6: {
                S91ReadBlockMessage s91ReadBlockMessage = new S91ReadBlockMessage(this.getAddress(), 10, 2);
                JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadBlockMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciS91Response == null || jciS91Response.isError()) {
                    this.getDxLog().trace("Background read failed: LCOS1/LCOS2");
                    this.failPollListeners(10);
                    this.failPollListeners(11);
                    break;
                }
                this.getDxLog().trace("Read Succeeded: LCOS1/LCOS2");
                JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
                this.setLcos1(jciS91InputStream.readInt());
                this.setLcos2(jciS91InputStream.readInt());
                this.updatePollListeners(10, this.getLcos1());
                this.updatePollListeners(11, this.getLcos2());
                break;
            }
            case 8: {
                this.updateXtMask();
                if (this.getXtMask() == 0) break;
                while (true) {
                    if ((this.getXtMask() >>> this.xtToPoll - 1 & 1) == 1) {
                        this.getXtStatus(this.xtToPoll);
                        ++this.xtToPoll;
                        if (this.xtToPoll != 9) break block0;
                        this.xtToPoll = 1;
                        break block0;
                    }
                    ++this.xtToPoll;
                    if (this.xtToPoll != 9) continue;
                    this.xtToPoll = 1;
                }
            }
            default: {
                S91WriteSingleItemExtMessage s91WriteSingleItemExtMessage = new S91WriteSingleItemExtMessage(this.getAddress(), 1, 198, 16384, 2);
                JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91WriteSingleItemExtMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
                if (jciS91Response == null || jciS91Response.isError()) {
                    this.getDxLog().trace("Background clear DIAL failed");
                    break;
                }
                this.getDxLog().trace("Clear DIAL succeeded.");
            }
        }
        ++this.backgroundPollCount;
        this.backgroundPollCount %= 11;
    }

    private final void getXtStatus(int n) {
        Property property;
        int n2;
        if (n < 1 || n > 8) {
            return;
        }
        switch (n) {
            case 1: {
                n2 = 1544;
                property = this.getProperty("xtstc1");
                break;
            }
            case 2: {
                n2 = 1624;
                property = this.getProperty("xtstc2");
                break;
            }
            case 3: {
                n2 = 1704;
                property = this.getProperty("xtstc3");
                break;
            }
            case 4: {
                n2 = 1784;
                property = this.getProperty("xtstc4");
                break;
            }
            case 5: {
                n2 = 1864;
                property = this.getProperty("xtstc5");
                break;
            }
            case 6: {
                n2 = 1944;
                property = this.getProperty("xtstc6");
                break;
            }
            case 7: {
                n2 = 2024;
                property = this.getProperty("xtstc7");
                break;
            }
            case 8: {
                n2 = 2104;
                property = this.getProperty("xtstc8");
                break;
            }
            default: {
                return;
            }
        }
        S91ReadSingleItemExtMessage s91ReadSingleItemExtMessage = new S91ReadSingleItemExtMessage(this.getAddress(), n2);
        JciS91Response jciS91Response = (JciS91Response)this.getN2Network().sendSync(s91ReadSingleItemExtMessage, this.getN2Network().getResponseTimeout(), this.getN2Network().getRetryCount());
        if (jciS91Response == null || jciS91Response.isError()) {
            this.getDxLog().trace("Background read failed: XTSTC for XT " + n);
            this.failPollListeners(n2);
        } else {
            this.getDxLog().trace("Read Succeeded: XTSTC " + n);
            JciS91InputStream jciS91InputStream = (JciS91InputStream)jciS91Response.getIn();
            this.set(property, (BValue)BInteger.make((int)jciS91InputStream.readByte()), null);
            this.updatePollListeners(n2, ((BInteger)this.get(property)).getInt());
        }
    }

    public void updatePollListeners(int n, int n2) {
        int n3 = 0;
        while (n3 < this.v.size()) {
            BJciS91ProxyExt bJciS91ProxyExt = (BJciS91ProxyExt)this.v.get(n3);
            JciDx9100MapData jciDx9100MapData = (JciDx9100MapData)bJciS91ProxyExt.getMapData();
            if (n == jciDx9100MapData.getItemValueAddress()) {
                bJciS91ProxyExt.setValueFromBackgroundPoll(n2);
            }
            ++n3;
        }
    }

    protected void failPollListeners(int n) {
        int n2 = 0;
        while (n2 < this.v.size()) {
            BJciS91ProxyExt bJciS91ProxyExt = (BJciS91ProxyExt)this.v.get(n2);
            JciDx9100MapData jciDx9100MapData = (JciDx9100MapData)bJciS91ProxyExt.getMapData();
            if (n == jciDx9100MapData.getItemValueAddress()) {
                bJciS91ProxyExt.readFail("background poll failed");
            }
            ++n2;
        }
    }

    public int getXtstc(int n) {
        Property property;
        switch (n / 8) {
            case 1: {
                property = this.getProperty("xtstc1");
                break;
            }
            case 2: {
                property = this.getProperty("xtstc2");
                break;
            }
            case 3: {
                property = this.getProperty("xtstc3");
                break;
            }
            case 4: {
                property = this.getProperty("xtstc4");
                break;
            }
            case 5: {
                property = this.getProperty("xtstc5");
                break;
            }
            case 6: {
                property = this.getProperty("xtstc6");
                break;
            }
            case 7: {
                property = this.getProperty("xtstc7");
                break;
            }
            case 8: {
                property = this.getProperty("xtstc8");
                break;
            }
            default: {
                return 0;
            }
        }
        return ((BInteger)this.get(property)).getInt();
    }

    public void updateXtMask() {
        int n = 0;
        BJciN2PointDeviceExt bJciN2PointDeviceExt = this.getPoints();
        BControlPoint[] bControlPointArray = bJciN2PointDeviceExt.getPoints();
        int n2 = 0;
        while (n2 < bControlPointArray.length) {
            if (bControlPointArray[n2].getProxyExt() instanceof BJciS91ProxyExt) {
                int n3 = ((BJciS91ProxyExt)bControlPointArray[n2].getProxyExt()).getNetworkPointAddress() - 1;
                int n4 = ((BJciS91ProxyExt)bControlPointArray[n2].getProxyExt()).getNetworkPointType().getOrdinal();
                switch (n4) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        if (n3 < 8) break;
                        if (n3 < 16) {
                            n |= 1;
                            break;
                        }
                        if (n3 < 24) {
                            n |= 2;
                            break;
                        }
                        if (n3 < 32) {
                            n |= 4;
                            break;
                        }
                        if (n3 < 40) {
                            n |= 8;
                            break;
                        }
                        if (n3 < 48) {
                            n |= 0x10;
                            break;
                        }
                        if (n3 < 56) {
                            n |= 0x20;
                            break;
                        }
                        if (n3 < 64) {
                            n |= 0x40;
                            break;
                        }
                        if (n3 >= 72) break;
                        n |= 0x80;
                        break;
                    }
                }
            }
            ++n2;
        }
        if (this.getDxLog().isTraceOn()) {
            n2 = n;
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = 0;
            while (n5 < 8) {
                if ((n2 & 1) == 1) {
                    stringBuffer.append(" " + (n5 + 1));
                }
                n2 >>>= 1;
                ++n5;
            }
            this.getDxLog().trace("polling enabled for following xtModules:" + stringBuffer.toString());
        }
        this.setXtMask(n);
    }

    public void setValue(JciN2Response jciN2Response, BJciS91ProxyExt bJciS91ProxyExt) {
        JciS91InputStream jciS91InputStream = (JciS91InputStream)jciN2Response.getIn();
        int n = bJciS91ProxyExt.getMapData().getNpt();
        boolean bl = false;
        switch (bJciS91ProxyExt.getMapData().getNpt()) {
            case 1: {
                double d = jciS91InputStream.readN(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric(d);
                if (bJciS91ProxyExt.getNetworkPointAddress() - 1 < 8) {
                    int n2 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToStatus());
                    int n3 = bJciS91ProxyExt.getMapData().getFaultMask();
                    boolean bl2 = false;
                    if ((n2 & n3) != 0) {
                        bl2 = true;
                    }
                    bl = bl2;
                } else {
                    int n4 = this.getXtstc(bJciS91ProxyExt.getNetworkPointAddress() - 1);
                    boolean bl3 = false;
                    if ((n4 & 0x10) != 16 || (n4 & 0x29) != 0) {
                        bl3 = true;
                    }
                    bl = bl3;
                }
                bStatusNumeric.setStatusFault(bl);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
            case 2: {
                int n5 = bJciS91ProxyExt.getMapData().getItemValueMask();
                int n6 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                boolean bl4 = false;
                if ((n6 & n5) != 0) {
                    bl4 = true;
                }
                BStatusBoolean bStatusBoolean = new BStatusBoolean(bl4);
                if (bJciS91ProxyExt.getNetworkPointAddress() - 1 > 7) {
                    int n7 = this.getXtstc(bJciS91ProxyExt.getNetworkPointAddress() - 1);
                    boolean bl5 = false;
                    if ((n7 & 0x10) != 16 || (n7 & 0x29) != 0) {
                        bl5 = true;
                    }
                    bl = bl5;
                }
                bStatusBoolean.setStatusFault(bl);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusBoolean);
                break;
            }
            case 3: {
                boolean bl6;
                double d = jciS91InputStream.readN(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric(d);
                int n8 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToStatus());
                int n9 = bJciS91ProxyExt.getMapData().getOverrideMask();
                boolean bl7 = false;
                if ((n8 & n9) != 0) {
                    bl7 = bl6 = true;
                }
                if (this.getN2Network().getUseMessageOverrideFlag()) {
                    bStatusNumeric.setStatusOverridden(bl6);
                }
                if (bJciS91ProxyExt.getMapData().getNpa() > 7) {
                    n8 = this.getXtstc(bJciS91ProxyExt.getNetworkPointAddress() - 1);
                    boolean bl8 = false;
                    if ((n8 & 0x10) != 16 || (n8 & 0x29) != 0) {
                        bl8 = true;
                    }
                    bl = bl8;
                }
                bStatusNumeric.setStatusFault(bl);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
            case 4: {
                boolean bl9;
                int n10 = bJciS91ProxyExt.getMapData().getItemValueMask();
                int n11 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                boolean bl10 = false;
                if ((n11 & n10) != 0) {
                    bl10 = true;
                }
                BStatusBoolean bStatusBoolean = new BStatusBoolean(bl10);
                int n12 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToStatus());
                int n13 = bJciS91ProxyExt.getMapData().getOverrideMask();
                boolean bl11 = false;
                if ((n12 & n13) != 0) {
                    bl11 = bl9 = true;
                }
                if (this.getN2Network().getUseMessageOverrideFlag()) {
                    bStatusBoolean.setStatusOverridden(bl9);
                }
                if (bJciS91ProxyExt.getNetworkPointAddress() - 1 > 7) {
                    n12 = this.getXtstc(bJciS91ProxyExt.getNetworkPointAddress() - 1);
                    boolean bl12 = false;
                    if ((n12 & 0x10) != 16 || (n12 & 0x29) != 0) {
                        bl12 = true;
                    }
                    bl = bl12;
                }
                bStatusBoolean.setStatusFault(bl);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusBoolean);
                break;
            }
            case 5: {
                double d = jciS91InputStream.readN(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric(d);
                int n14 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToStatus());
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
            case 6: {
                long l = jciS91InputStream.readL(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric((double)l);
                if (bJciS91ProxyExt.getNetworkPointAddress() - 1 > 7) {
                    int n15 = this.getXtstc(bJciS91ProxyExt.getNetworkPointAddress() - 1);
                    boolean bl13 = false;
                    if ((n15 & 0x10) != 16 || (n15 & 0x29) != 0) {
                        bl13 = true;
                    }
                    bl = bl13;
                    bStatusNumeric.setStatusFault(bl);
                }
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
            case 7: {
                int n16 = bJciS91ProxyExt.getMapData().getItemValueMask();
                int n17 = jciS91InputStream.readW(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                boolean bl14 = false;
                if ((n17 & n16) != 0) {
                    bl14 = true;
                }
                BStatusBoolean bStatusBoolean = new BStatusBoolean(bl14);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusBoolean);
                this.getN2Log().trace("setValue on " + bJciS91ProxyExt + ", value = " + bStatusBoolean);
                break;
            }
            case 8: {
                int n18 = bJciS91ProxyExt.getMapData().getItemValueMask();
                int n19 = jciS91InputStream.readW(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                boolean bl15 = false;
                if ((n19 & n18) != 0) {
                    bl15 = true;
                }
                BStatusBoolean bStatusBoolean = new BStatusBoolean(bl15);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusBoolean);
                break;
            }
            case 9: {
                double d = jciS91InputStream.readN(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric(d);
                int n20 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToStatus());
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
            case 10: {
                boolean bl16;
                double d = jciS91InputStream.readN(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric(d);
                int n21 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToStatus());
                int n22 = bJciS91ProxyExt.getMapData().getOverrideMask();
                boolean bl17 = false;
                if ((n21 & n22) != 0) {
                    bl17 = bl16 = true;
                }
                if (this.getN2Network().getUseMessageOverrideFlag()) {
                    bStatusNumeric.setStatusOverridden(bl16);
                }
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
            case 11: {
                boolean bl18;
                int n23 = bJciS91ProxyExt.getMapData().getItemValueMask();
                int n24 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                boolean bl19 = false;
                if ((n24 & n23) != 0) {
                    bl19 = true;
                }
                BStatusBoolean bStatusBoolean = new BStatusBoolean(bl19);
                int n25 = jciS91InputStream.readB(bJciS91ProxyExt.getMapData().getResponseOffsetToStatus());
                int n26 = bJciS91ProxyExt.getMapData().getOverrideMask();
                boolean bl20 = false;
                if ((n25 & n26) != 0) {
                    bl20 = bl18 = true;
                }
                if (this.getN2Network().getUseMessageOverrideFlag()) {
                    bStatusBoolean.setStatusOverridden(bl18);
                }
                bJciS91ProxyExt.setValue((BStatusValue)bStatusBoolean);
                break;
            }
            case 12: {
                long l = jciS91InputStream.readL(bJciS91ProxyExt.getMapData().getResponseOffsetToValue());
                BStatusNumeric bStatusNumeric = new BStatusNumeric((double)l);
                bJciS91ProxyExt.setValue((BStatusValue)bStatusNumeric);
                break;
            }
        }
    }

    public void write(BStatusValue bStatusValue, BJciS91ProxyExt bJciS91ProxyExt) {
        boolean bl;
        boolean bl2;
        this.getN2Log().trace("write callback received on: " + bJciS91ProxyExt);
        int n = this.getDeviceCode();
        int n2 = bJciS91ProxyExt.getNetworkPointType().getOrdinal();
        int n3 = bJciS91ProxyExt.getNetworkPointAddress() - 1;
        int n4 = bJciS91ProxyExt.getMapData().getItemStatusAddress();
        int n5 = bJciS91ProxyExt.getMapData().getOverrideMask();
        int n6 = bJciS91ProxyExt.getMapData().getStatusMaskSize();
        boolean bl3 = false;
        if (bJciS91ProxyExt.getMapData().getItemStatusAddress() != -1) {
            bl3 = bl2 = true;
        }
        if (!bJciS91ProxyExt.isValid()) {
            return;
        }
        int n7 = bJciS91ProxyExt.getMapData().getResponseOffsetToStatus();
        int n8 = bJciS91ProxyExt.getMapData().getOverrideMask();
        boolean bl4 = false;
        if ((n7 & n8) != 0) {
            bl4 = bl = true;
        }
        if (this.getN2Log().isTraceOn()) {
            this.getN2Log().trace("DX9100 Write, pt = " + bJciS91ProxyExt + "\n  statusByte = " + Integer.toHexString(n7) + ", overrideMask = " + Integer.toHexString(n8) + ", isOverridden = " + bJciS91ProxyExt.isOverridden() + ", override = " + bl);
        }
        if (bStatusValue == null || bStatusValue.getStatus().isNull()) {
            if (bJciS91ProxyExt.isOverridden() & bl2) {
                S91WriteSingleItemExtMessage s91WriteSingleItemExtMessage = new S91WriteSingleItemExtMessage(this.getAddress(), n4, 198, n5, n6);
                if (!bJciS91ProxyExt.sendWrite(s91WriteSingleItemExtMessage, bStatusValue)) {
                    return;
                }
                bJciS91ProxyExt.setOverridden(false);
            } else {
                this.getN2Log().trace("writeValue is null, but we are not overridden! do nothing...");
            }
        } else {
            S91WriteSingleItemExtMessage s91WriteSingleItemExtMessage;
            this.getN2Log().trace("Overriding " + bJciS91ProxyExt + ": " + bStatusValue);
            if (bl2) {
                s91WriteSingleItemExtMessage = new S91WriteSingleItemExtMessage(this.getAddress(), n4, 197, n5, n6);
                if (!bJciS91ProxyExt.sendWrite(s91WriteSingleItemExtMessage, bStatusValue)) {
                    return;
                }
                bJciS91ProxyExt.setOverridden(true);
            }
            switch (n2) {
                case 3: 
                case 5: 
                case 9: 
                case 10: {
                    s91WriteSingleItemExtMessage = new S91WriteSingleItemExtMessage(this.getAddress(), bJciS91ProxyExt.getMapData().getItemValueAddress(), 196, BJciS91ProxyExt.getReal((BValue)bStatusValue));
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    s91WriteSingleItemExtMessage = new S91WriteSingleItemExtMessage(this.getAddress(), bJciS91ProxyExt.getMapData().getItemValueAddress(), 198 - BJciS91ProxyExt.getBinary((BValue)bStatusValue), bJciS91ProxyExt.getMapData().getItemValueMask(), bJciS91ProxyExt.getMapData().getValueMaskSize());
                    break;
                }
                case 6: 
                case 12: {
                    s91WriteSingleItemExtMessage = new S91WriteSingleItemExtMessage(this.getAddress(), bJciS91ProxyExt.getMapData().getItemValueAddress(), 196, BJciS91ProxyExt.getLong((BValue)bStatusValue));
                    break;
                }
                default: {
                    this.getN2Log().trace("Point type is not writable!");
                    bJciS91ProxyExt.writeFail("Point type is not writable!");
                    return;
                }
            }
            bJciS91ProxyExt.sendWrite(s91WriteSingleItemExtMessage, bStatusValue);
            bJciS91ProxyExt.doForceRead();
            this.getN2Log().trace("N2 DX doForceRead on: " + bJciS91ProxyExt + ": " + bStatusValue);
        }
    }

    public String toString(Context context) {
        return "JciDx9100Device:" + this.getName() + " addr:" + this.getAddress();
    }

    public Log getDxLog() {
        String string = "jcin2." + this.getName();
        if (this.dxlog != null && string.equals(this.dxlog.getLogName())) {
            return this.dxlog;
        }
        this.dxlog = Log.getLog((String)string);
        return this.dxlog;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.backgroundPollCount = 0;
        this.xtToPoll = 1;
    }

    public BJciDx9100Device() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$jcin2$BJciDx9100Device;
        if (clazz == null) {
            clazz = class$com$tridium$jcin2$BJciDx9100Device = BJciDx9100Device.class("[Lcom.tridium.jcin2.BJciDx9100Device;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

