/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lontunnel;

import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.loncomm.RawMessage;
import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QueryDomainResponse;
import com.tridium.lonworks.netmessages.QueryStatusResponse;
import com.tridium.lonworks.util.LonByteArrayUtil;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.tunnel.BTunnel;
import com.tridium.tunnel.BTunnelConnection;
import com.tridium.tunnel.TunnelConst;
import java.io.IOException;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonListener;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BLocal;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonTunnel
extends BTunnel
implements LonListener,
TunnelConst,
NetMessages {
    public static final Property identifier = BLonTunnel.newProperty((int)1, (String)"none", null);
    public static final Property deviceName = BLonTunnel.newProperty((int)0, (String)"LON1", null);
    public static final Type TYPE;
    private static final int ADDRESS_TABLE_LEN = 15;
    private static final int ADDRESS_ENTRY_LEN = 5;
    private static final int DOMAIN_TABLE_LEN = 15;
    private static final int CONFIG_TABLE_LEN = 27;
    private static final int READ_ONLY_TABLE_LEN = 48;
    public static final int MAX_EXPICIT_MSG_CODE = 78;
    private boolean[] tagOutstanding;
    private byte[] lastEscapeReq;
    private boolean statusInitialized;
    private int reset_cause;
    private int state;
    private int version;
    private int model;
    private byte[][] adrTab;
    private boolean adrTabInitialized;
    private byte[] domain0;
    private byte[] domain1;
    private boolean domainInitialized;
    private byte[] config;
    private boolean configInitialized;
    private byte[] readOnly;
    private boolean readOnlyInitialized;
    private Log log;
    private boolean connected;
    private NLonComm lonComm;
    private BTunnelConnection[] conns;
    static /* synthetic */ Class class$com$tridium$lontunnel$BLonTunnel;
    static /* synthetic */ Class class$com$tridium$lonworks$loncomm$RawMessage;

    public String getIdentifier() {
        return this.getString(identifier);
    }

    public void setIdentifier(String string) {
        this.setString(identifier, string, null);
    }

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String string) {
        this.setString(deviceName, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.setIdentifier(this.getDeviceName());
        super.started();
        this.log();
    }

    public void stopped() throws Exception {
        this.doDisconnectAll();
        super.stopped();
    }

    public void service(BTunnelConnection bTunnelConnection) throws IOException {
        this.log().message("service(TunnelConnection)::thread=" + Thread.currentThread().getName());
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[300];
        Vector vector = new Vector(10);
        while (bTunnelConnection.isConnected()) {
            if (bTunnelConnection.read(byArray, 0, 2) != 2) {
                bTunnelConnection.disconnect();
                break;
            }
            int n = (byArray[0] << 8) + (byArray[1] & 0xFF);
            byte[] byArray3 = new byte[n];
            int n2 = bTunnelConnection.read(byArray3, 0, n);
            try {
                this.processMessage(byArray3, vector);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            while (!vector.isEmpty()) {
                byte[] byArray4 = (byte[])vector.elementAt(0);
                vector.removeElementAt(0);
                if (byArray4 == null) continue;
                this.writeMessage(byArray2, bTunnelConnection, byArray4);
            }
        }
    }

    private final void writeMessage(byte[] byArray, BTunnelConnection bTunnelConnection, byte[] byArray2) throws IOException {
        int n = byArray2.length;
        byArray[0] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n & 0xFF);
        System.arraycopy(byArray2, 0, byArray, 2, n);
        bTunnelConnection.write(byArray, 0, n + 2);
    }

    public void sessionClosed(BTunnelConnection bTunnelConnection) {
        this.log().message(" session closed");
        this.doDisconnectAll();
    }

    public boolean supportsConcurrentConnections() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addConnection(BTunnelConnection bTunnelConnection) {
        super.addConnection(bTunnelConnection);
        this.startLonTunnel();
        BLonTunnel bLonTunnel = this;
        synchronized (bLonTunnel) {
            this.conns = this.getTunnelConnectionsArray();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeConnection(BTunnelConnection bTunnelConnection) {
        super.removeConnection(bTunnelConnection);
        this.stopLonTunnel();
        BLonTunnel bLonTunnel = this;
        synchronized (bLonTunnel) {
            this.conns = this.getTunnelConnectionsArray();
            return;
        }
    }

    public void changed(Property property, Context context) {
        if (context != Context.decoding && property == deviceName) {
            this.setIdentifier(this.getDeviceName());
        }
        super.changed(property, context);
    }

    public boolean startLonTunnel() {
        if (!this.getEnabled() || this.connected) {
            return true;
        }
        BComponent[] bComponentArray = Sys.getServices((Type)BLonNetwork.TYPE);
        int n = 0;
        while (n < bComponentArray.length) {
            BLonNetwork bLonNetwork = (BLonNetwork)bComponentArray[n];
            if (bLonNetwork.getLonCommConfig().getDeviceName().equals(this.getDeviceName())) {
                this.lonComm = (NLonComm)bLonNetwork.lonComm();
                this.connected = true;
                break;
            }
            ++n;
        }
        if (!this.connected) {
            return false;
        }
        Class clazz = class$com$tridium$lonworks$loncomm$RawMessage;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$loncomm$RawMessage = BLonTunnel.class("[Lcom.tridium.lonworks.loncomm.RawMessage;", false);
        }
        this.lonComm.registerLonListener((LonListener)this, 127, null, clazz);
        Class clazz2 = class$com$tridium$lonworks$loncomm$RawMessage;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$lonworks$loncomm$RawMessage = BLonTunnel.class("[Lcom.tridium.lonworks.loncomm.RawMessage;", false);
        }
        this.lonComm.registerLonListener((LonListener)this, 125, null, clazz2);
        n = 0;
        while (n < 78) {
            Class clazz3 = class$com$tridium$lonworks$loncomm$RawMessage;
            if (clazz3 == null) {
                clazz3 = BLonTunnel.class("[Lcom.tridium.lonworks.loncomm.RawMessage;", false);
            }
            this.lonComm.registerLonListener((LonListener)this, n, null, clazz3);
            ++n;
        }
        return false;
    }

    public void stopLonTunnel() {
        if (!this.connected) {
            return;
        }
        this.lonComm.unregisterLonListener((LonListener)this, 127, null);
        this.lonComm.unregisterLonListener((LonListener)this, 125, null);
        int n = 0;
        while (n < 78) {
            this.lonComm.unregisterLonListener((LonListener)this, n, null);
            ++n;
        }
        this.connected = false;
        this.lonComm = null;
        this.log().message("BLonTunnel.stopLonTunnel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receiveLonMessage(LonMessage lonMessage) {
        byte[] byArray = this.lastEscapeReq;
        try {
            byte[] byArray2 = ((RawMessage)lonMessage).getRawData();
            if (byArray2[16] == 125 && byArray != null) {
                byArray2[2] = (byte)(byArray2[2] & 0xF0 | byArray[2] & 0xF);
            }
            if ((byArray2[2] & 0x60) == 96) {
                this.tagOutstanding[byArray2[2] & 0xF] = true;
            }
            this.log().trace("returning unsolicited message(" + this.msgToString(byArray2) + ')');
            BLonTunnel bLonTunnel = this;
            synchronized (bLonTunnel) {
                byte[] byArray3 = new byte[300];
                int n = 0;
                while (true) {
                    if (n >= this.conns.length) {
                        return;
                    }
                    this.writeMessage(byArray3, this.conns[n], byArray2);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            this.log().error("Exception in VlonService.receiveLonMessage  " + exception);
            exception.printStackTrace();
        }
    }

    private final void initTagOutstanding() {
        int n = 0;
        while (n < 16) {
            this.tagOutstanding[n] = false;
            ++n;
        }
    }

    private final boolean processMessage(byte[] byArray, Vector vector) {
        boolean bl;
        if (this.log().isTraceOn()) {
            this.log().trace("*****\nVlonService.processMessage    (" + this.msgToString(byArray) + ')');
        }
        if ((bl = this.doProcessMessage(byArray, vector)) && this.log().isTraceOn()) {
            int n = 0;
            while (n < vector.size()) {
                this.log().trace("returning response message   (" + this.msgToString((byte[])vector.elementAt(n)) + ')');
                ++n;
            }
        }
        return bl;
    }

    private final boolean doProcessMessage(byte[] byArray, Vector vector) {
        if (byArray.length == 0) {
            this.log().error("*** Zero length message received. ***");
            return false;
        }
        int n = byArray[0] & 0xFF;
        switch (n) {
            case 80: 
            case 96: {
                vector.addElement(byArray);
                return true;
            }
            case 112: {
                return false;
            }
            case 224: {
                byte[] byArray2 = new byte[]{-32, 1, 35};
                vector.addElement(byArray2);
                return true;
            }
            case 144: {
                byte[] byArray3 = new byte[2];
                byArray3[0] = 96;
                byte[] byArray4 = byArray3;
                vector.addElement(byArray4);
                return true;
            }
        }
        if (byArray.length <= 16) {
            if (this.log().isTraceOn()) {
                this.log().trace("*** Ignoring local command in VlonService.terminalInput(). ***");
                this.log().trace(this.msgToString(byArray));
            }
            return false;
        }
        if (this.isLocal(byArray)) {
            if (this.isProcessLonMaker3(byArray, vector)) {
                this.log().trace("Create response to lon maker3 message.");
                return true;
            }
            if (this.isProcessNetMgmtMsg(byArray, vector)) {
                this.log().trace("Create response to network management message.");
                return true;
            }
        }
        int n2 = byArray[2] & 0xF;
        if ((byArray[3] & 1) == 1) {
            if (!this.tagOutstanding[n2]) {
                this.log().trace("Rejected response with no outstanding request:" + this.msgToString(byArray));
                return false;
            }
            this.tagOutstanding[n2] = false;
        }
        try {
            NAppBuffer nAppBuffer = NAppBuffer.makeAppBuffer((byte[])byArray);
            NAppBuffer nAppBuffer2 = null;
            if (nAppBuffer.isResp()) {
                this.lonComm.doSendResponse(nAppBuffer);
                return false;
            }
            if (nAppBuffer.isLocalAddress() && nAppBuffer.isImplicitAddress()) {
                nAppBuffer.setExplicitAddress(true);
            }
            if (byArray[16] == 125) {
                this.lastEscapeReq = byArray;
            }
            boolean bl = nAppBuffer.isExplicitAddress();
            nAppBuffer2 = nAppBuffer.isRequest() ? this.lonComm.doLonCommSendRequest(nAppBuffer, n2 == 15 ? 15 : -1) : this.lonComm.doLonCommSendNormal(nAppBuffer);
            if (nAppBuffer2 == null) {
                return false;
            }
            NAppBuffer nAppBuffer3 = nAppBuffer2;
            while (nAppBuffer3 != null) {
                nAppBuffer3.setTag(n2);
                nAppBuffer3.setExplicitAddress(bl);
                byte[] byArray5 = nAppBuffer3.toNetworkBytes();
                vector.addElement(byArray5);
                nAppBuffer3 = nAppBuffer3.nextAppBuffer;
            }
            nAppBuffer2.releaseAppBuffer();
            this.lastEscapeReq = null;
            return true;
        }
        catch (Exception exception) {
            this.log().error("Exception in VlonService.terminalInput  " + exception);
            exception.printStackTrace();
            return false;
        }
    }

    private final boolean isProcessLonMaker3(byte[] byArray, Vector vector) {
        if (byArray[16] == 96) {
            byte[] byArray2 = new byte[17];
            byArray2[0] = 22;
            byArray2[1] = 15;
            byArray2[2] = 115;
            byArray2[3] = 1;
            byArray2[4] = 1;
            byte[] byArray3 = byArray2;
            byArray3[2] = byArray[2];
            vector.addElement(byArray3);
            return true;
        }
        if (byArray[16] == 112) {
            byte[] byArray4 = new byte[17];
            System.arraycopy(byArray, 0, byArray4, 0, byArray4.length);
            byArray4[0] = 24;
            byArray4[1] = 15;
            vector.addElement(byArray4);
            return true;
        }
        if (byArray[16] != 125) {
            return false;
        }
        if (byArray[17] == 1 && byArray[18] == 1) {
            byte[] byArray5 = new byte[22];
            byArray5[0] = 22;
            byArray5[1] = 20;
            byArray5[2] = 112;
            byArray5[3] = 1;
            byArray5[4] = 6;
            byArray5[16] = 61;
            byArray5[17] = 3;
            byArray5[18] = 1;
            byArray5[19] = 28;
            byArray5[21] = 4;
            byte[] byArray6 = byArray5;
            byArray6[2] = byArray[2];
            vector.addElement(byArray6);
        } else if (byArray[17] == 3 && byArray[18] == 10) {
            byte[] byArray7 = new byte[17];
            byArray7[0] = 22;
            byArray7[1] = 15;
            byArray7[2] = 127;
            byArray7[3] = 1;
            byArray7[4] = 1;
            byte[] byArray8 = byArray7;
            vector.addElement(byArray8);
        } else if (byArray[17] == 3 && byArray[18] == 15) {
            byte[] byArray9 = new byte[31];
            byArray9[0] = 22;
            byArray9[1] = 29;
            byArray9[2] = 127;
            byArray9[3] = 1;
            byArray9[4] = 15;
            byArray9[16] = 61;
            byArray9[17] = 64;
            byArray9[18] = 35;
            byArray9[19] = -15;
            byArray9[20] = -32;
            byArray9[23] = 1;
            byArray9[24] = 4;
            byArray9[27] = 14;
            byArray9[28] = 28;
            byArray9[29] = -4;
            byArray9[30] = 4;
            byte[] byArray10 = byArray9;
            vector.addElement(byArray10);
        } else if (byArray[17] == 3 && byArray[18] == 102) {
            byte[] byArray11 = new byte[37];
            byArray11[0] = 22;
            byArray11[1] = 35;
            byArray11[2] = 127;
            byArray11[3] = 1;
            byArray11[4] = 21;
            byArray11[16] = 61;
            byArray11[18] = 1;
            byArray11[19] = 1;
            byArray11[20] = 108;
            byArray11[21] = 111;
            byArray11[22] = 110;
            byArray11[24] = -60;
            byArray11[25] = 88;
            byArray11[26] = -60;
            byArray11[28] = 17;
            byArray11[32] = 65;
            byArray11[36] = 72;
            byte[] byArray12 = byArray11;
            vector.addElement(byArray12);
        } else if (byArray[17] == 3 && (byArray[18] == 7 || byArray[18] == 100)) {
            byte[] byArray13 = new byte[17];
            byArray13[0] = 22;
            byArray13[1] = 15;
            byArray13[2] = 127;
            byArray13[3] = 1;
            byArray13[4] = 1;
            byArray13[16] = 61;
            byte[] byArray14 = byArray13;
            vector.addElement(byArray14);
        } else {
            return false;
        }
        return true;
    }

    private final void createResponse(byte[] byArray, Vector vector) {
        vector.addElement(this.createResponseMsg(byArray));
        if (!this.isLocal(byArray)) {
            vector.addElement(this.createCompletionMsg(byArray));
        }
    }

    private final byte[] createResponseMsg(byte[] byArray) {
        return this.createResponseMsg(byArray, 1);
    }

    private final byte[] createResponseMsg(byte[] byArray, int n) {
        byte[] byArray2 = new byte[16 + n];
        byArray2[0] = 22;
        byArray2[1] = (byte)(14 + n);
        byArray2[2] = byArray[2];
        byArray2[3] = (byte)(byArray[3] | 1);
        byArray2[4] = (byte)n;
        byArray2[16] = (byte)(byArray[16] & 0xFFFFFF3F | 0x20);
        return byArray2;
    }

    private final byte[] createCompletionMsg(byte[] byArray) {
        byArray[0] = 22;
        byArray[3] = (byte)(byArray[3] & 0xFFFFFFCF | 0x10);
        return byArray;
    }

    private final boolean isProcessNetMgmtMsg(byte[] byArray, Vector vector) {
        if (!this.isLocal(byArray)) {
            return false;
        }
        int n = byArray[16] & 0xFF;
        switch (n) {
            case 99: {
                this.storeDomain(byArray);
                vector.addElement(this.createResponseMsg(byArray));
                return true;
            }
            case 106: {
                vector.addElement(this.getDomain(byArray));
                return true;
            }
            case 100: {
                this.leaveDomain(byArray);
                vector.addElement(this.createResponseMsg(byArray));
                return true;
            }
            case 110: {
                if (byArray[17] == 1) {
                    this.storeReadOnly(byArray);
                    if (byArray[21] != 3) {
                        vector.addElement(this.createResponseMsg(byArray));
                    }
                    return true;
                }
                if (byArray[17] == 2) {
                    this.storeConfig(byArray);
                    vector.addElement(this.createResponseMsg(byArray));
                    return true;
                }
                vector.addElement(this.createResponseMsg(byArray));
                return true;
            }
            case 109: {
                if (byArray[17] == 1) {
                    byte[] byArray2 = this.readReadOnly(byArray);
                    if (byArray2 != null) {
                        vector.addElement(byArray2);
                    }
                    return true;
                }
                if (byArray[17] == 2) {
                    byte[] byArray3 = this.readConfig(byArray);
                    if (byArray3 != null) {
                        vector.addElement(byArray3);
                    }
                    return true;
                }
                return false;
            }
            case 102: {
                this.storeAddress(byArray);
                vector.addElement(this.createResponseMsg(byArray));
                return true;
            }
            case 103: {
                vector.addElement(this.getAddress(byArray));
                return true;
            }
            case 108: {
                this.updateMode(byArray);
                vector.addElement(this.createResponseMsg(byArray));
                return true;
            }
            case 81: {
                vector.addElement(this.getStatus(byArray));
                return true;
            }
            case 83: {
                this.clearStatus();
                vector.addElement(this.createResponseMsg(byArray));
                return true;
            }
            case 84: 
            case 97: 
            case 104: 
            case 114: 
            case 115: {
                return false;
            }
        }
        vector.addElement(this.createResponseMsg(byArray));
        return true;
    }

    private final boolean isLocal(byte[] byArray) {
        boolean bl = false;
        if ((byArray[0] & 0xF0) == 32 || byArray[5] == 0 || byArray[5] == 127) {
            bl = true;
        }
        return bl;
    }

    private final void updateMode(byte[] byArray) {
        this.initStatus();
        byte by = byArray[17];
        switch (by) {
            case 0: {
                if (this.state != 4) break;
                this.state = 12;
                break;
            }
            case 1: {
                if (this.state == 12) {
                    this.state = 4;
                }
                if (this.state != 140) break;
                this.state = 4;
                break;
            }
            case 2: {
                if (this.state == 12) {
                    this.state = 4;
                }
                if (this.state == 140) {
                    this.state = 4;
                }
                this.reset_cause = 20;
                break;
            }
            case 3: {
                this.state = byArray[18];
                break;
            }
        }
    }

    private final byte[] getStatus(byte[] byArray) {
        this.initStatus();
        byte[] byArray2 = this.createResponseMsg(byArray, 16);
        byArray2[27] = (byte)this.reset_cause;
        byArray2[28] = (byte)this.state;
        byArray2[29] = (byte)this.version;
        byArray2[30] = 0;
        byArray2[31] = (byte)this.model;
        return byArray2;
    }

    private final void clearStatus() {
        this.reset_cause = 0;
    }

    private final void initStatus() {
        if (this.statusInitialized) {
            return;
        }
        this.state = 4;
        try {
            QueryStatusResponse queryStatusResponse = NmUtil.queryStatus((LonComm)this.lonComm, (LonAddress)BLocal.local, (int)0, (boolean)false, (boolean)false);
            this.reset_cause = queryStatusResponse.getResetCause();
            this.version = queryStatusResponse.getVersionNumber();
            this.model = queryStatusResponse.getModelNumber();
        }
        catch (LonException lonException) {}
        this.statusInitialized = true;
    }

    public void setStatusVersion(int n) {
        this.initStatus();
        this.version = n;
    }

    public void setStatusModel(int n) {
        this.initStatus();
        this.model = n;
    }

    private final void initAdrTab() {
        if (this.adrTabInitialized) {
            return;
        }
        this.adrTab = new byte[15][];
        int n = 0;
        while (n < 15) {
            this.adrTab[n] = new byte[5];
            ++n;
        }
        this.adrTabInitialized = true;
    }

    private final void storeAddress(byte[] byArray) {
        this.initAdrTab();
        byte by = byArray[17];
        if (by >= 15 || byArray.length < 23) {
            return;
        }
        System.arraycopy(byArray, 18, this.adrTab[by], 0, 5);
    }

    private final byte[] getAddress(byte[] byArray) {
        this.initAdrTab();
        byte by = byArray[17];
        byte[] byArray2 = this.createResponseMsg(byArray, 6);
        if (by < 15) {
            System.arraycopy(this.adrTab[by], 0, byArray2, 17, 5);
        }
        return byArray2;
    }

    private final void initDomain() {
        if (this.domainInitialized) {
            return;
        }
        try {
            this.initDom(0, this.domain0);
            this.initDom(1, this.domain1);
        }
        catch (Exception exception) {
            this.log().error("ERROR: Failed attempt to initialize domains in VlonService.\n" + exception);
            return;
        }
        this.domainInitialized = true;
    }

    private final void initDom(int n, byte[] byArray) throws LonException {
        QueryDomainResponse queryDomainResponse = NmUtil.queryDomain((LonComm)this.lonComm, (LonAddress)BLocal.local, (int)n, (boolean)false, (boolean)false);
        System.arraycopy(queryDomainResponse.getDomainId(), 0, byArray, 0, 6);
        byArray[6] = (byte)queryDomainResponse.getSubnet();
        byArray[7] = (byte)(queryDomainResponse.getNodeId() | 0x80);
        byArray[8] = (byte)queryDomainResponse.len;
        System.arraycopy(queryDomainResponse.getKey(), 0, byArray, 9, 6);
    }

    private final void storeDomain(byte[] byArray) {
        this.initDomain();
        byte by = byArray[17];
        if (by == 0) {
            this.compareDomain(by, this.domain0, byArray);
            System.arraycopy(byArray, 18, this.domain0, 0, 15);
        } else {
            this.compareDomain(by, this.domain1, byArray);
            System.arraycopy(byArray, 18, this.domain1, 0, 15);
        }
    }

    private final void compareDomain(int n, byte[] byArray, byte[] byArray2) {
        if (byArray[6] != byArray2[24] || byArray[7] != byArray2[25]) {
            this.log().warning("Attempt to change subnet/node address for domain entry " + n + " from " + byArray[6] + '/' + (byArray[7] & 0x7F) + " to " + byArray2[24] + '/' + (byArray2[25] & 0x7F));
        }
        boolean bl = false;
        int n2 = byArray[8] & 0xFF;
        int n3 = byArray2[26] & 0xFF;
        if (n2 != n3) {
            bl = true;
        } else if (n2 > 0 && n2 <= 6) {
            int n4 = 0;
            while (n4 < n2) {
                if (byArray[n4] != byArray2[18 + n4]) {
                    bl = true;
                }
                ++n4;
            }
        }
        if (bl) {
            this.log().warning("Attempt to change domain id for domain entry " + n + " from {" + this.domainToString(byArray, n2, 0) + "} to {" + this.domainToString(byArray2, n3, 18) + '}');
        }
    }

    private final String domainToString(byte[] byArray, int n, int n2) {
        if (n < 0 || n > 6) {
            return "not in use";
        }
        return LonByteArrayUtil.toString((byte[])byArray, (int)16, (char)'.', (int)n, (int)n2);
    }

    private final byte[] getDomain(byte[] byArray) {
        this.initDomain();
        byte[] byArray2 = this.createResponseMsg(byArray, 16);
        byte by = byArray[17];
        if (by == 0) {
            System.arraycopy(this.domain0, 0, byArray2, 17, 15);
        } else {
            System.arraycopy(this.domain1, 0, byArray2, 17, 15);
        }
        return byArray2;
    }

    private final void leaveDomain(byte[] byArray) {
        byte[] byArray2;
        this.initDomain();
        byte by = byArray[17];
        byte[] byArray3 = byArray2 = by == 0 ? this.domain0 : this.domain1;
        if ((byArray2[8] & 0xFF) != 255) {
            this.log().warning("Attempt to leave domain " + by);
        }
        byArray2[8] = -1;
    }

    private final void initConfig() {
        if (this.configInitialized) {
            return;
        }
        this.config = new byte[27];
        try {
            this.config = Neuron.getConfigStruct((LonComm)this.lonComm, (LonAddress)BLocal.local, (boolean)false, (boolean)false);
        }
        catch (Exception exception) {
            this.log().error("ERROR: Failed attempt to initialize config in VlonService.\n" + exception);
            return;
        }
        this.configInitialized = true;
    }

    private final void storeConfig(byte[] byArray) {
        this.initConfig();
        int n = (byArray[18] << 8) + byArray[19];
        byte by = byArray[20];
        if (n + by + 1 > 27) {
            return;
        }
        System.arraycopy(byArray, 22, this.config, n, by);
    }

    private final byte[] readConfig(byte[] byArray) {
        this.initConfig();
        int n = (byArray[18] << 8) + byArray[19];
        byte by = byArray[20];
        if (n + by + 1 > 27) {
            return null;
        }
        byte[] byArray2 = this.createResponseMsg(byArray, by + 1);
        System.arraycopy(this.config, n, byArray2, 17, by);
        return byArray2;
    }

    private final void initReadOnly() {
        if (this.readOnlyInitialized) {
            return;
        }
        this.readOnly = new byte[48];
        try {
            BLocal bLocal = BLocal.local;
            int n = 48;
            int n2 = 16;
            int n3 = 0;
            while (n3 < n) {
                if (n2 > n - n3) {
                    n2 = n - n3;
                }
                byte[] byArray = Neuron.readMemory((LonComm)this.lonComm, (int)1, (LonAddress)bLocal, (int)n3, (int)n2, (boolean)false, (boolean)false);
                System.arraycopy(byArray, 0, this.readOnly, n3, n2);
                n3 += n2;
            }
        }
        catch (Exception exception) {
            this.log().error("ERROR: Failed attempt to initialize readOnly in VlonService.\n" + exception);
            return;
        }
        this.readOnlyInitialized = true;
    }

    private final void storeReadOnly(byte[] byArray) {
        this.initReadOnly();
        int n = (byArray[18] << 8) + byArray[19];
        byte by = byArray[20];
        if (n + by + 1 > 48) {
            return;
        }
        System.arraycopy(byArray, 22, this.readOnly, n, by);
    }

    private final byte[] readReadOnly(byte[] byArray) {
        this.initReadOnly();
        int n = (byArray[18] << 8) + byArray[19];
        byte by = byArray[20];
        if (n + by + 1 > 48) {
            return null;
        }
        byte[] byArray2 = this.createResponseMsg(byArray, by + 1);
        System.arraycopy(this.readOnly, n, byArray2, 17, by);
        return byArray2;
    }

    public String msgToString(byte[] byArray) {
        if (byArray.length == 0) {
            return "";
        }
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        if (n > byArray.length) {
            n = byArray.length;
        }
        if (n == 0) {
            return "";
        }
        int n2 = 0;
        while (n2 < n) {
            if (n2 == 2 || n2 == 5 || n2 == 16) {
                stringBuffer.append(' ');
            }
            if ((byArray[n2] & 0xFF) < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString(byArray[n2] & 0xFF, 16)).append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Log log() {
        if (this.log == null) {
            this.log = Log.getLog((String)("v" + this.getDeviceName().toLowerCase()));
        }
        return this.log;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.tagOutstanding = new boolean[16];
        this.lastEscapeReq = null;
        this.statusInitialized = false;
        this.adrTabInitialized = false;
        this.domain0 = new byte[15];
        this.domain1 = new byte[15];
        this.domainInitialized = false;
        this.configInitialized = false;
        this.readOnlyInitialized = false;
        this.log = null;
        this.connected = false;
        this.lonComm = null;
        this.conns = null;
    }

    public BLonTunnel() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$lontunnel$BLonTunnel;
        if (clazz == null) {
            clazz = class$com$tridium$lontunnel$BLonTunnel = BLonTunnel.class("[Lcom.tridium.lontunnel.BLonTunnel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

