/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.virtual;

import com.tridium.sys.schema.ComponentSlotMap;
import java.util.HashMap;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualComponentSpace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VirtualCacheCallbacks {
    public static final BRelTime MAX_CACHE_LIFE = BRelTime.make(Long.getLong("niagara.virtual.cache.maxLifeDefault", 45000L));
    public static final BRelTime MIN_CACHE_LIFE = BRelTime.make(Long.getLong("niagara.virtual.cache.minLifeDefault", 25000L));
    public static final int VIRTUAL_THRESHOLD = Integer.getInteger("niagara.virtual.cache.threshold", 1000);
    public static final long VIRTUAL_THRESHOLD_SCAN_RATE = Long.getLong("niagara.virtual.cache.thresholdScanRate", 1000L);
    public static final int THREAD_POOL_SIZE = Integer.getInteger("niagara.virtual.cache.threadPoolSize", 10);
    public static final int SPACES_PER_THREAD = Integer.getInteger("niagara.virtual.cache.spacesPerThread", 5);
    static VirtualCleanupThread[] vcThreadPool = new VirtualCleanupThread[THREAD_POOL_SIZE];
    static VirtualThresholdThread vThresholdThread = null;
    static Context virtualRemoveContext = BFacets.make("virtualCacheRemove", BBoolean.TRUE);
    static final Log log = Log.getLog("virtual.cache");
    BVirtualComponentSpace space;
    static /* synthetic */ Class class$javax$baja$virtual$VirtualCacheCallbacks$VirtualComponentInfo;

    public synchronized void start() {
        if (vThresholdThread == null) {
            vThresholdThread = new VirtualThresholdThread();
            vThresholdThread.start();
            if (log.isTraceOn()) {
                log.trace("Virtual:Threshold Thread started");
            }
        }
        vThresholdThread.register(this.space, this);
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = 0;
        while (n3 < THREAD_POOL_SIZE) {
            int n4;
            if (vcThreadPool[n3] == null) {
                VirtualCacheCallbacks.vcThreadPool[n3] = new VirtualCleanupThread(n3);
                vcThreadPool[n3].start();
                if (log.isTraceOn()) {
                    log.trace("Virtual:Cleanup" + n3 + " Thread started");
                }
            }
            if ((n4 = vcThreadPool[n3].size()) < SPACES_PER_THREAD) {
                vcThreadPool[n3].register(this.space, this);
                return;
            }
            if (n4 < n) {
                n = n4;
                n2 = n3;
            }
            ++n3;
        }
        vcThreadPool[n2].register(this.space, this);
    }

    public synchronized void stop() {
        int n = 0;
        while (n < THREAD_POOL_SIZE) {
            if (vcThreadPool[n] != null && vcThreadPool[n].contains(this.space)) {
                if (vcThreadPool[n].unregister(this.space) > 0) break;
                vcThreadPool[n].kill();
                VirtualCacheCallbacks.vcThreadPool[n] = null;
                if (!log.isTraceOn()) break;
                log.trace("Virtual:Cleanup" + n + " Thread stopped");
                break;
            }
            ++n;
        }
        if (vThresholdThread != null && vThresholdThread.unregister(this.space) <= 0) {
            vThresholdThread.kill();
            vThresholdThread = null;
            if (log.isTraceOn()) {
                log.trace("Virtual:Threshold Thread stopped");
            }
        }
    }

    public BRelTime getMaxVirtualCacheLife() {
        return MAX_CACHE_LIFE;
    }

    public BRelTime getMinVirtualCacheLife() {
        return MIN_CACHE_LIFE;
    }

    public BVirtualComponentSpace getSpace() {
        return this.space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void spy(SpyWriter var1_1) throws Exception {
        var1_1.startProps();
        var1_1.trTitle("VirtualCacheCallbacks", 2);
        var1_1.prop((Object)"MAX_CACHE_LIFE", VirtualCacheCallbacks.MAX_CACHE_LIFE);
        var1_1.prop((Object)"MIN_CACHE_LIFE", VirtualCacheCallbacks.MIN_CACHE_LIFE);
        var1_1.prop((Object)"THREAD_POOL_SIZE", VirtualCacheCallbacks.THREAD_POOL_SIZE);
        var1_1.prop((Object)"SPACES_PER_THREAD", VirtualCacheCallbacks.SPACES_PER_THREAD);
        var1_1.prop((Object)"VIRTUAL_THRESHOLD", VirtualCacheCallbacks.VIRTUAL_THRESHOLD);
        if (VirtualCacheCallbacks.VIRTUAL_THRESHOLD_SCAN_RATE <= 0L) {
            var1_1.prop((Object)"VIRTUAL_THRESHOLD_SCAN_RATE", VirtualCacheCallbacks.VIRTUAL_THRESHOLD_SCAN_RATE + " (disabled)");
        } else {
            var1_1.prop((Object)"VIRTUAL_THRESHOLD_SCAN_RATE", VirtualCacheCallbacks.VIRTUAL_THRESHOLD_SCAN_RATE + " (" + BRelTime.make(VirtualCacheCallbacks.VIRTUAL_THRESHOLD_SCAN_RATE) + ')');
        }
        var1_1.prop((Object)"maxVirtualCacheLife", this.getMaxVirtualCacheLife());
        var1_1.prop((Object)"minVirtualCacheLife", this.getMinVirtualCacheLife());
        var1_1.prop((Object)"vThresholdThread", VirtualCacheCallbacks.vThresholdThread.toString());
        var1_1.prop((Object)"__totalSpacesManaged", "" + VirtualCacheCallbacks.vThresholdThread.size());
        var2_2 = VirtualCacheCallbacks.vThresholdThread;
        synchronized (var2_2) {
            var1_1.prop((Object)"__numScans", "" + VirtualCacheCallbacks.vThresholdThread.numScans);
            var1_1.prop((Object)"__lastScanTicks", VirtualCacheCallbacks.vThresholdThread.lastScanTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vThresholdThread.lastScanTicks) + ')');
            var1_1.prop((Object)"__minScanTicks", VirtualCacheCallbacks.vThresholdThread.minScanTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vThresholdThread.minScanTicks) + ')');
            var1_1.prop((Object)"__maxScanTicks", VirtualCacheCallbacks.vThresholdThread.maxScanTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vThresholdThread.maxScanTicks) + ')');
            if (VirtualCacheCallbacks.vThresholdThread.numScans > 0L) {
                var4_3 = (double)VirtualCacheCallbacks.vThresholdThread.sumScanTicks / (double)VirtualCacheCallbacks.vThresholdThread.numScans;
                var1_1.prop((Object)"__avgScanTicks", var4_3 + " (" + BRelTime.make((long)var4_3) + ')');
            }
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl44 : MonitorExitStatement: MONITOREXIT : var2_2
            var4_4 = 0;
            if (true) ** GOTO lbl103
        }
        do {
            block19: {
                block18: {
                    if (VirtualCacheCallbacks.vcThreadPool[var4_4] == null) break block19;
                    var1_1.prop((Object)("Thread '" + VirtualCacheCallbacks.vcThreadPool[var4_4].getName() + '\''), "Spaces managed: " + VirtualCacheCallbacks.vcThreadPool[var4_4].size() + (VirtualCacheCallbacks.vcThreadPool[var4_4].contains(this.space) != false ? " (includes this space)" : ""));
                    var5_5 = new StringBuffer();
                    var6_6 = null;
                    var7_7 = VirtualCacheCallbacks.vcThreadPool[var4_4].map;
                    synchronized (var7_7) {
                        var6_6 = VirtualCacheCallbacks.vcThreadPool[var4_4].map.values().toArray(new VirtualCacheCallbacks[VirtualCacheCallbacks.vcThreadPool[var4_4].map.size()]);
                        // MONITOREXIT @DISABLED, blocks:[1, 4, 9] lbl60 : MonitorExitStatement: MONITOREXIT : var7_7
                        if (var6_6 == null) break block18;
                        var9_8 = 0;
                        if (true) ** GOTO lbl73
                    }
                    do {
                        if ((var10_11 = var6_6[var9_8].space.getVirtualGateway()) != null) {
                            if (var9_8 > 0) {
                                var5_5.append("; ");
                            }
                            var5_5.append(var10_11.getSlotPath().getBody());
                        }
                        ++var9_8;
lbl73:
                        // 2 sources

                    } while (var9_8 < var6_6.length);
                }
                var1_1.prop((Object)"__spaces", var5_5.toString());
                var7_7 = VirtualCacheCallbacks.vcThreadPool[var4_4];
                synchronized (var7_7) {
                    var1_1.prop((Object)"__numScans", "" + VirtualCacheCallbacks.vcThreadPool[var4_4].numScans);
                    var1_1.prop((Object)"__lastScanTicks", VirtualCacheCallbacks.vcThreadPool[var4_4].lastScanTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vcThreadPool[var4_4].lastScanTicks) + ')');
                    var1_1.prop((Object)"__minScanTicks", VirtualCacheCallbacks.vcThreadPool[var4_4].minScanTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vcThreadPool[var4_4].minScanTicks) + ')');
                    var1_1.prop((Object)"__maxScanTicks", VirtualCacheCallbacks.vcThreadPool[var4_4].maxScanTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vcThreadPool[var4_4].maxScanTicks) + ')');
                    if (VirtualCacheCallbacks.vcThreadPool[var4_4].numScans > 0L) {
                        var9_9 = (double)VirtualCacheCallbacks.vcThreadPool[var4_4].sumScanTicks / (double)VirtualCacheCallbacks.vcThreadPool[var4_4].numScans;
                        var1_1.prop((Object)"__avgScanTicks", var9_9 + " (" + BRelTime.make((long)var9_9) + ')');
                    }
                    var1_1.prop((Object)"__lastSleepTicks", VirtualCacheCallbacks.vcThreadPool[var4_4].lastSleepTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vcThreadPool[var4_4].lastSleepTicks) + ')');
                    if (VirtualCacheCallbacks.vcThreadPool[var4_4].numScans > 0L) {
                        var9_10 = (double)VirtualCacheCallbacks.vcThreadPool[var4_4].sumSleepTicks / (double)VirtualCacheCallbacks.vcThreadPool[var4_4].numScans;
                        var1_1.prop((Object)"__avgSleepTicks", var9_10 + " (" + BRelTime.make((long)var9_10) + ')');
                    }
                }
            }
            ++var4_4;
lbl103:
            // 2 sources

        } while (var4_4 < VirtualCacheCallbacks.THREAD_POOL_SIZE);
        var1_1.endProps();
    }

    private static final VirtualChildInfo cleanupExpiredVirtuals(BComponent bComponent, BComponent bComponent2, long l) {
        BComponent[] bComponentArray;
        long l2 = -1;
        boolean bl = false;
        if (bComponent2 != null && (bComponentArray = bComponent2.getChildComponents()) != null) {
            int n = 0;
            while (n < bComponentArray.length) {
                BComponent bComponent3 = bComponentArray[n];
                VirtualChildInfo virtualChildInfo = VirtualCacheCallbacks.cleanupExpiredVirtuals(bComponent, bComponent3, l);
                long l3 = virtualChildInfo.cleanupTicks;
                bl |= virtualChildInfo.hasActiveChildren;
                if (l3 >= 0L) {
                    long l4 = l2 = l2 < 0L ? l3 : Math.min(l2, l3);
                }
                if (!bComponent3.isSubscribed()) {
                    if (bComponent3 != bComponent && bComponent3 instanceof BVirtualComponent && ((BVirtualComponent)bComponent3).performAutoRemoval() && !virtualChildInfo.hasActiveChildren) {
                        long l5 = Clock.ticks() - ((BVirtualComponent)bComponent3).getLastActiveTicks();
                        if (l5 >= l) {
                            try {
                                BComponent bComponent4 = bComponent3.getParent().asComponent();
                                if (bComponent4 != null) {
                                    if (log.isTraceOn()) {
                                        log.trace("Virtual cache max life expired, auto removing " + bComponent3.getNavOrd());
                                    }
                                    bComponent4.remove(bComponent3.getPropertyInParent(), virtualRemoveContext);
                                    ((ComponentSlotMap)bComponent4.fw(1)).setBrokerPropsLoaded(false);
                                }
                            }
                            catch (Exception exception) {}
                        } else if (l5 >= 0L) {
                            long l6 = l - l5;
                            l2 = l2 < 0L ? l6 : Math.min(l6, l2);
                            bl = true;
                        }
                    } else if (bComponent3 instanceof BVirtualComponent) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                ++n;
            }
        }
        return new VirtualChildInfo(l2, bl);
    }

    private static final VirtualThresholdInfo mapVirtualsIntoTierBuckets(IntHashMap intHashMap, BComponent bComponent, BComponent bComponent2, long l) {
        Object object;
        int n = 0;
        int n2 = 0;
        if (bComponent2 != null && (object = bComponent2.getChildComponents()) != null && ((BComponent[])object).length > 0) {
            ++n;
            int n3 = 0;
            int n4 = 0;
            while (n4 < ((BComponent[])object).length) {
                BComponent bComponent3 = object[n4];
                VirtualThresholdInfo virtualThresholdInfo = VirtualCacheCallbacks.mapVirtualsIntoTierBuckets(intHashMap, bComponent, bComponent3, l);
                n3 = Math.max(n3, virtualThresholdInfo.tier);
                n2 += virtualThresholdInfo.size;
                ++n4;
            }
            n += n3;
        }
        if (bComponent2 instanceof BVirtualComponent && bComponent2 != bComponent) {
            object = (BVirtualComponent)bComponent2;
            ++n2;
            Array array = (Array)intHashMap.get(n);
            if (array == null) {
                Class clazz = class$javax$baja$virtual$VirtualCacheCallbacks$VirtualComponentInfo;
                if (clazz == null) {
                    clazz = class$javax$baja$virtual$VirtualCacheCallbacks$VirtualComponentInfo = VirtualCacheCallbacks.class("[Ljavax.baja.virtual.VirtualCacheCallbacks$VirtualComponentInfo;", false);
                }
                array = new Array(clazz);
                intHashMap.put(n, (Object)array);
            }
            array.add((Object)new VirtualComponentInfo((BVirtualComponent)object, l));
        }
        return new VirtualThresholdInfo(n, n2);
    }

    static final /* synthetic */ VirtualThresholdInfo access$1(IntHashMap intHashMap, BComponent bComponent, BComponent bComponent2, long l) {
        return VirtualCacheCallbacks.mapVirtualsIntoTierBuckets(intHashMap, bComponent, bComponent2, l);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public VirtualCacheCallbacks(BVirtualComponentSpace bVirtualComponentSpace) {
        this.space = bVirtualComponentSpace;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class VirtualThresholdThread
    extends Thread {
        boolean alive;
        HashMap map;
        long lastScanTicks;
        long minScanTicks;
        long maxScanTicks;
        long sumScanTicks;
        long numScans;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void kill() {
            VirtualThresholdThread virtualThresholdThread = this;
            synchronized (virtualThresholdThread) {
                if (this.alive) {
                    this.alive = false;
                    this.interrupt();
                    try {
                        this.wait(5000L);
                    }
                    catch (Exception exception) {}
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void register(BVirtualComponentSpace bVirtualComponentSpace, VirtualCacheCallbacks virtualCacheCallbacks) {
            if (log.isTraceOn()) {
                log.trace(this.getName() + " registering " + bVirtualComponentSpace.getNavOrd());
            }
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                this.map.put(bVirtualComponentSpace, virtualCacheCallbacks);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        int unregister(BVirtualComponentSpace bVirtualComponentSpace) {
            if (log.isTraceOn()) {
                log.trace(this.getName() + " unregistering " + bVirtualComponentSpace.getNavOrd());
            }
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                this.map.remove(bVirtualComponentSpace);
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        int size() {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean contains(BVirtualComponentSpace bVirtualComponentSpace) {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                return this.map.containsKey(bVirtualComponentSpace);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (VirtualCacheCallbacks.VIRTUAL_THRESHOLD_SCAN_RATE > 0L) ** GOTO lbl116
            return;
lbl-1000:
            // 1 sources

            {
                block25: {
                    try {
                        var1_1 = Clock.ticks();
                        var3_4 = null;
                        var4_5 = this.map;
                        synchronized (var4_5) {
                            var3_4 = this.map.values().toArray(new VirtualCacheCallbacks[this.map.size()]);
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 6, 14] lbl10 : MonitorExitStatement: MONITOREXIT : var4_5
                            if (var3_4 == null) break block25;
                        }
                        var6_6 = new IntHashMap();
                        var7_7 = -1;
                        var8_8 = 0;
                        var9_9 = 0;
                        while (true) {
                            block27: {
                                if (var9_9 < var3_4.length) break block27;
                                var9_9 = var8_8 - VirtualCacheCallbacks.VIRTUAL_THRESHOLD;
                                if (var9_9 <= 0 || var7_7 < 0) break block25;
                                var10_11 = 0;
                                if (true) ** GOTO lbl102
                            }
                            var10_10 = var3_4[var9_9].space.getRootComponent();
                            var11_12 = VirtualCacheCallbacks.access$1(var6_6, var10_10, var10_10, var3_4[var9_9].getMinVirtualCacheLife().getMillis());
                            var8_8 += var11_12.size;
                            var7_7 = Math.max(var11_12.tier, var7_7);
                            ++var9_9;
                        }
                    }
                    catch (InterruptedException v1) {
                        continue;
                    }
                    catch (Exception var1_2) {
                        var1_2.printStackTrace();
                        continue;
                    }
                    do {
                        var11_12 = (Array)var6_6.get(var10_11);
                        var12_13 = (VirtualComponentInfo[])var11_12.trim();
                        var13_14 = var12_13.length;
                        var14_15 = new Long[var13_14];
                        var15_16 = 0;
                        while (var15_16 < var13_14) {
                            var16_17 = -1;
                            if (!var12_13[var15_16].vComp.isSubscribed() && var12_13[var15_16].vComp.performAutoRemoval() && (var18_20 = Clock.ticks() - var12_13[var15_16].vComp.getLastActiveTicks()) >= var12_13[var15_16].minLife && ((var20_21 = var12_13[var15_16].vComp.getChildComponents()) == null || var20_21.length == 0)) {
                                var16_17 = var12_13[var15_16].vComp.getLastActiveTicks();
                            }
                            var14_15[var15_16] = new Long(var16_17);
                            ++var15_16;
                        }
                        SortUtil.sort((Object[])var14_15, (Object[])var12_13);
                        var15_16 = 0;
                        while (var15_16 < var12_13.length) {
                            block26: {
                                if (var14_15[var15_16].longValue() < 0L || !var12_13[var15_16].vComp.isRunning()) break block26;
                                try {
                                    var16_18 = var12_13[var15_16].vComp.getParent().asComponent();
                                    if (var16_18 == null) break block26;
                                    if (VirtualCacheCallbacks.log.isTraceOn()) {
                                        VirtualCacheCallbacks.log.trace("Virtual cache min life expired, auto removing " + var12_13[var15_16].vComp.getNavOrd());
                                    }
                                    var16_18.remove(var12_13[var15_16].vComp.getPropertyInParent(), VirtualCacheCallbacks.virtualRemoveContext);
                                    ((ComponentSlotMap)var16_18.fw(1)).setBrokerPropsLoaded(false);
                                    if (--var9_9 <= 0) break;
                                    var17_19 = var16_18.getChildComponents();
                                    if (!(var16_18 instanceof BVirtualComponent) || var16_18.isSubscribed() || !((BVirtualComponent)var16_18).performAutoRemoval() || var17_19 != null && var17_19.length != 0 || (var18_20 = Clock.ticks() - ((BVirtualComponent)var16_18).getLastActiveTicks()) < var12_13[var15_16].minLife) break block26;
                                    var20_22 = var12_13.length;
                                    var21_23 = var20_22 + 1;
                                    var22_24 = ((BVirtualComponent)var16_18).getLastActiveTicks();
                                    var24_26 = var15_16 + 1;
                                    while (var24_26 < var12_13.length) {
                                        if (var14_15[var24_26].longValue() > var22_24) {
                                            var20_22 = var24_26;
                                            break;
                                        }
                                        ++var24_26;
                                    }
                                    var24_25 = new VirtualComponentInfo[var21_23];
                                    var25_27 = new Long[var21_23];
                                    var26_28 = 0;
                                    while (true) {
                                        block28: {
                                            if (var26_28 < var20_22) break block28;
                                            var24_25[var20_22] = new VirtualComponentInfo((BVirtualComponent)var16_18, var12_13[var15_16].minLife);
                                            var25_27[var20_22] = new Long(var22_24);
                                            var26_28 = var20_22;
                                            if (true) ** GOTO lbl94
                                        }
                                        var24_25[var26_28] = var12_13[var26_28];
                                        var25_27[var26_28] = var14_15[var26_28];
                                        ++var26_28;
                                    }
                                }
                                catch (Exception v2) {}
                                break block26;
                                do {
                                    var24_25[var26_28 + 1] = var12_13[var26_28];
                                    var25_27[var26_28 + 1] = var14_15[var26_28];
                                    ++var26_28;
lbl94:
                                    // 2 sources

                                } while (var26_28 < var21_23 - 1);
                                var12_13 = var24_25;
                                var14_15 = var25_27;
                            }
                            ++var15_16;
                        }
                        if (var9_9 <= 0) break;
                        ++var10_11;
lbl102:
                        // 2 sources

                    } while (var10_11 < var7_7);
                }
                var4_5 = this;
                synchronized (var4_5) {
                    this.lastScanTicks = Clock.ticks() - var1_1;
                    this.minScanTicks = Math.min(this.lastScanTicks, this.minScanTicks);
                    this.maxScanTicks = Math.max(this.lastScanTicks, this.maxScanTicks);
                    this.sumScanTicks += this.lastScanTicks;
                    ++this.numScans;
                }
                Thread.sleep(VirtualCacheCallbacks.VIRTUAL_THRESHOLD_SCAN_RATE);
lbl116:
                // 4 sources

                ** while (this.alive)
            }
lbl117:
            // 1 sources

            var1_3 = this;
            synchronized (var1_3) {
                this.notifyAll();
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.alive = true;
            this.map = new HashMap();
            this.lastScanTicks = 0L;
            this.minScanTicks = Long.MAX_VALUE;
            this.maxScanTicks = Long.MIN_VALUE;
            this.sumScanTicks = 0L;
            this.numScans = 0L;
        }

        VirtualThresholdThread() {
            super("Virtual:Threshold");
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class VirtualCleanupThread
    extends Thread {
        boolean alive;
        HashMap map;
        long lastScanTicks;
        long minScanTicks;
        long maxScanTicks;
        long sumScanTicks;
        long numScans;
        long lastSleepTicks;
        long sumSleepTicks;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void kill() {
            VirtualCleanupThread virtualCleanupThread = this;
            synchronized (virtualCleanupThread) {
                if (this.alive) {
                    this.alive = false;
                    this.interrupt();
                    try {
                        this.wait(5000L);
                    }
                    catch (Exception exception) {}
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void register(BVirtualComponentSpace bVirtualComponentSpace, VirtualCacheCallbacks virtualCacheCallbacks) {
            if (log.isTraceOn()) {
                log.trace(this.getName() + " registering " + bVirtualComponentSpace.getNavOrd());
            }
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                this.map.put(bVirtualComponentSpace, virtualCacheCallbacks);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        int unregister(BVirtualComponentSpace bVirtualComponentSpace) {
            if (log.isTraceOn()) {
                log.trace(this.getName() + " unregistering " + bVirtualComponentSpace.getNavOrd());
            }
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                this.map.remove(bVirtualComponentSpace);
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        int size() {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean contains(BVirtualComponentSpace bVirtualComponentSpace) {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                return this.map.containsKey(bVirtualComponentSpace);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            long l = 1000L;
            while (this.alive) {
                try {
                    long l2 = Clock.ticks();
                    VirtualCacheCallbacks[] virtualCacheCallbacksArray = null;
                    Object object = this.map;
                    synchronized (object) {
                        virtualCacheCallbacksArray = this.map.values().toArray(new VirtualCacheCallbacks[this.map.size()]);
                    }
                    long l3 = -1;
                    if (virtualCacheCallbacksArray != null) {
                        int n = 0;
                        while (n < virtualCacheCallbacksArray.length) {
                            BComponent bComponent = virtualCacheCallbacksArray[n].space.getRootComponent();
                            long l4 = virtualCacheCallbacksArray[n].getMaxVirtualCacheLife().getMillis();
                            l = n > 0 ? Math.min(l4, l) : l4;
                            VirtualChildInfo virtualChildInfo = VirtualCacheCallbacks.cleanupExpiredVirtuals(bComponent, bComponent, l4);
                            long l5 = virtualChildInfo.cleanupTicks;
                            if (l5 >= 0L) {
                                l3 = l3 >= 0L ? Math.min(l3, l5) : l5;
                            } else if (!virtualChildInfo.hasActiveChildren) {
                                ((ComponentSlotMap)bComponent.fw(1)).setBrokerPropsLoaded(false);
                            }
                            ++n;
                        }
                    }
                    if (l3 >= 0L) {
                        l = l3 + 1000L;
                    }
                    object = this;
                    synchronized (object) {
                        this.lastScanTicks = Clock.ticks() - l2;
                        this.minScanTicks = Math.min(this.lastScanTicks, this.minScanTicks);
                        this.maxScanTicks = Math.max(this.lastScanTicks, this.maxScanTicks);
                        this.sumScanTicks += this.lastScanTicks;
                        this.lastSleepTicks = l;
                        this.sumSleepTicks += this.lastSleepTicks;
                        ++this.numScans;
                    }
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            VirtualCleanupThread virtualCleanupThread = this;
            synchronized (virtualCleanupThread) {
                this.notifyAll();
                return;
            }
        }

        private final /* synthetic */ void this() {
            this.alive = true;
            this.map = new HashMap();
            this.lastScanTicks = 0L;
            this.minScanTicks = Long.MAX_VALUE;
            this.maxScanTicks = Long.MIN_VALUE;
            this.sumScanTicks = 0L;
            this.numScans = 0L;
            this.lastSleepTicks = 0L;
            this.sumSleepTicks = 0L;
        }

        VirtualCleanupThread(int n) {
            super("Virtual:Cleanup" + n);
            this.this();
        }
    }

    static class VirtualChildInfo {
        long cleanupTicks;
        boolean hasActiveChildren;

        VirtualChildInfo(long l, boolean bl) {
            this.cleanupTicks = l;
            this.hasActiveChildren = bl;
        }
    }

    static class VirtualThresholdInfo {
        int tier;
        int size;

        VirtualThresholdInfo(int n, int n2) {
            this.tier = n;
            this.size = n2;
        }
    }

    static class VirtualComponentInfo {
        BVirtualComponent vComp;
        long minLife;

        VirtualComponentInfo(BVirtualComponent bVirtualComponent, long l) {
            this.vComp = bVirtualComponent;
            this.minLife = l;
        }
    }
}

