/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.util.StringTokenizer;

public class Version
implements Comparable {
    public static Version ZERO;
    public static Version NULL;
    private int[] versions;

    public int major() {
        if (this.versions.length < 1) {
            return -1;
        }
        return this.versions[0];
    }

    public int minor() {
        if (this.versions.length < 2) {
            return -1;
        }
        return this.versions[1];
    }

    public int build() {
        if (this.versions.length < 3) {
            return -1;
        }
        return this.versions[2];
    }

    public int patch() {
        if (this.versions.length < 4) {
            return -1;
        }
        return this.versions[3];
    }

    public int get(int n) {
        return this.versions[n];
    }

    public int size() {
        return this.versions.length;
    }

    public boolean isNull() {
        if (this.versions.length == 1) {
            boolean bl = false;
            if (this.versions[0] == 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int compareTo(Object object) {
        Version version = (Version)object;
        int n = this.versions.length;
        int n2 = version.versions.length;
        int n3 = 0;
        while (n3 < n && n3 < n2) {
            if (this.versions[n3] > version.versions[n3]) {
                return 1;
            }
            if (this.versions[n3] < version.versions[n3]) {
                return -1;
            }
            ++n3;
        }
        if (n == n2) {
            return 0;
        }
        if (n > n2) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object instanceof Version) {
            Version version = (Version)object;
            if (this.versions.length != version.versions.length) {
                return false;
            }
            int n = 0;
            while (n < this.versions.length) {
                if (this.versions[n] != version.versions[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.versions.length) {
            n += this.versions[n2];
            n <<= 8;
            ++n2;
        }
        return n += this.versions.length;
    }

    public String toString() {
        return this.toString(this.versions.length);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n && n2 < this.versions.length) {
            if (n2 > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.versions[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Version version = new Version(stringArray[0]);
        Version version2 = new Version(stringArray[1]);
        System.out.println("v1: " + version);
        System.out.println("v2: " + version2);
        System.out.println("v1.equals(v2):    " + version.equals(version2));
        System.out.println("v1.compareTo(v2): " + version.compareTo(version2));
        System.out.println("str:              " + version.toString().compareTo(version2.toString()));
    }

    public Version(int[] nArray) {
        this.versions = new int[nArray.length];
        System.arraycopy(nArray, 0, this.versions, 0, nArray.length);
    }

    public Version(String string) {
        try {
            int[] nArray = new int[16];
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 < 0) {
                    throw new IllegalArgumentException();
                }
                nArray[n++] = n2;
            }
            this.versions = new int[n];
            System.arraycopy(nArray, 0, this.versions, 0, n);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid version string \"" + string + '\"');
        }
    }

    static {
        NULL = ZERO = new Version("0");
    }
}

