/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ThreadPoolWorker
extends Worker {
    static final long IDLE_THREAD_EXPIRATION = Long.getLong("niagara.threadPoolWorker.idleExpiration", 10000L);
    private static final long SPY_MAX_THREAD_COUNT = Long.getLong("niagara.threadPoolWorker.spyMaxThreadCount", 1000L);
    int maxThreads;
    ThreadPool pool;
    volatile int expiredWorkers;
    static /* synthetic */ Class class$javax$baja$util$ThreadPoolWorker$WorkerThread;

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(n + " < 1");
        }
        this.maxThreads = n;
    }

    public void start(ThreadGroup threadGroup, String string) {
        if (this.isAlive) {
            return;
        }
        this.pool.start();
        super.start(threadGroup, string);
    }

    public void stop() {
        this.isAlive = false;
        this.pool.stop();
        super.stop();
    }

    protected void process(Runnable runnable) throws Exception {
        this.pool.run(runnable);
    }

    protected void threadStarted() {
    }

    protected void threadStopped() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeThread(WorkerThread workerThread) {
        try {
            Array array = this.pool.threads;
            synchronized (array) {
                this.pool.threads.remove((Object)workerThread);
            }
        }
        catch (Exception exception) {}
        ++this.expiredWorkers;
    }

    void spyImpl(SpyWriter spyWriter) {
        super.spyImpl(spyWriter);
        spyWriter.prop((Object)"maxThreads", "" + this.maxThreads);
        Array array = this.pool.threads;
        spyWriter.prop((Object)"currentThreadCount", array != null ? "" + array.size() : "null");
        spyWriter.prop((Object)"busyThreadCount", "" + this.getBusyThreadCount());
        spyWriter.prop((Object)"expiredThreadCount", "" + this.expiredWorkers);
        spyWriter.prop((Object)"spyMaxThreadCount", String.valueOf(SPY_MAX_THREAD_COUNT));
        if (array != null) {
            int n = 0;
            while (n < array.size()) {
                if ((long)n > SPY_MAX_THREAD_COUNT) break;
                WorkerThread workerThread = (WorkerThread)array.get(n);
                spyWriter.trTitle("Worker[" + n + "] " + workerThread.getName(), 2);
                spyWriter.prop((Object)"work", String.valueOf(workerThread.work));
                ThreadPoolWorker.spy(spyWriter, workerThread.startTime, workerThread.startTicks, workerThread.processingTicks, workerThread.numProcessed);
                ++n;
            }
        }
    }

    private final int getBusyThreadCount() {
        Array array = this.pool.threads;
        if (array == null) {
            return 0;
        }
        WorkerThread[] workerThreadArray = (WorkerThread[])array.array();
        int n = workerThreadArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            try {
                if (workerThreadArray[n3].work != null) {
                    ++n2;
                }
            }
            catch (Exception exception) {}
            ++n3;
        }
        return n2;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.maxThreads = 4;
        this.pool = new ThreadPool();
        this.expiredWorkers = 0;
    }

    public ThreadPoolWorker(Worker.ITodo iTodo) {
        super(iTodo);
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ThreadPool {
        Array threads;

        void start() {
            if (this.threads != null) {
                throw new IllegalStateException();
            }
            Class clazz = class$javax$baja$util$ThreadPoolWorker$WorkerThread;
            if (clazz == null) {
                clazz = class$javax$baja$util$ThreadPoolWorker$WorkerThread = ThreadPoolWorker.class("[Ljavax.baja.util.ThreadPoolWorker$WorkerThread;", false);
            }
            this.threads = new Array(clazz);
        }

        void stop() {
            if (this.threads == null) {
                return;
            }
            WorkerThread[] workerThreadArray = (WorkerThread[])this.threads.trim();
            if (workerThreadArray != null) {
                int n = 0;
                while (n < workerThreadArray.length) {
                    try {
                        workerThreadArray[n].interrupt();
                    }
                    catch (Exception exception) {}
                    ++n;
                }
            }
            this.threads = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void run(Runnable runnable) throws InterruptedException {
            while (ThreadPoolWorker.this.isAlive) {
                block8: {
                    Array array = this.threads;
                    // MONITORENTER : array
                    {
                        Object object;
                        while (this.threads.size() > ThreadPoolWorker.this.maxThreads) {
                            WorkerThread workerThread = (WorkerThread)this.threads.remove(this.threads.size() - 1);
                            workerThread.reduce();
                        }
                        int n = 0;
                        while (n < this.threads.size()) {
                            object = (WorkerThread)this.threads.get(n);
                            if (!((WorkerThread)object).isBusy()) {
                                ((WorkerThread)object).run(runnable);
                                // MONITOREXIT : array
                                return;
                            }
                            ++n;
                        }
                        if (this.threads.size() >= ThreadPoolWorker.this.maxThreads) break block8;
                        ThreadGroup threadGroup = ThreadPoolWorker.this.thread.getThreadGroup();
                        object = ThreadPoolWorker.this.thread.getName() + '-' + this.threads.size();
                        WorkerThread workerThread = new WorkerThread(threadGroup, (String)object);
                        this.threads.add((Object)workerThread);
                        workerThread.start();
                        workerThread.run(runnable);
                        // MONITOREXIT : array
                        return;
                    }
                }
                Thread.sleep(250L);
            }
        }

        ThreadPool() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WorkerThread
    extends Thread {
        volatile Runnable work;
        volatile boolean reduced;
        long startTime = Clock.millis();
        long startTicks;
        int numProcessed;
        long processingTicks;
        long lastJobTicks = this.startTicks = Clock.ticks();

        synchronized void run(Runnable runnable) {
            if (this.work != null) {
                throw new IllegalStateException();
            }
            this.work = runnable;
            this.notifyAll();
        }

        boolean isBusy() {
            boolean bl = false;
            if (this.work != null || this.reduced) {
                bl = true;
            }
            return bl;
        }

        synchronized void reduce() {
            System.out.println("ThreadPoolWorker reduce: " + this);
            this.reduced = true;
            this.notifyAll();
        }

        boolean isActive() {
            boolean bl = false;
            if (ThreadPoolWorker.this.isAlive && !this.reduced) {
                bl = true;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                ThreadPoolWorker.this.threadStarted();
                ** GOTO lbl35
                {
                    var3_1 = this;
                    // MONITORENTER : var3_1
                    {
                        try {
                            this.wait(ThreadPoolWorker.IDLE_THREAD_EXPIRATION);
                        }
                        catch (Exception v0) {}
                        if (ThreadPoolWorker.IDLE_THREAD_EXPIRATION > 0L && Clock.ticks() - this.lastJobTicks > ThreadPoolWorker.IDLE_THREAD_EXPIRATION && this.work == null) {
                            this.reduced = true;
                        }
                        // MONITOREXIT : var3_1
                    }
                    do {
                        if (this.isActive() && this.work == null) continue block13;
                        if (this.isActive()) {
                            try {
                                var3_2 = Clock.ticks();
                                this.work.run();
                                this.lastJobTicks = var5_5 = Clock.ticks();
                                ++this.numProcessed;
                                this.processingTicks += var5_5 - var3_2;
                            }
                            catch (Throwable var3_3) {
                                var3_3.printStackTrace();
                            }
                            var3_1 = this;
                            // MONITORENTER : var3_1
                            this.work = null;
                            // MONITOREXIT : var3_1
                            continue;
                        }
                        break;
lbl35:
                        // 2 sources

                    } while (this.isActive());
                }
                var2_8 = null;
                ThreadPoolWorker.this.removeThread(this);
                ThreadPoolWorker.this.threadStopped();
                return;
            }
            catch (Throwable var1_6) {
                var2_7 = null;
                ThreadPoolWorker.this.removeThread(this);
                ThreadPoolWorker.this.threadStopped();
                throw var1_6;
            }
        }

        WorkerThread(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
        }
    }
}

