/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class StringToIntMap {
    private Entry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.count == 0) {
            bl = true;
        }
        return bl;
    }

    public Iterator keys() {
        return new StringToIntMapIterator();
    }

    public int get(String string) {
        return this.get(string, -1);
    }

    public synchronized int get(String string, int n) {
        Entry[] entryArray = this.table;
        int n2 = string.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key.equals(string)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return n;
    }

    private final void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public synchronized void put(String string, int n) {
        Entry[] entryArray = this.table;
        int n2 = string.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key.equals(string)) {
                entry.value = n;
                return;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            this.put(string, n);
            return;
        }
        entry = new Entry();
        entry.hash = n2;
        entry.key = string;
        entry.value = n;
        entry.next = entryArray[n3];
        entryArray[n3] = entry;
        ++this.count;
    }

    public synchronized void remove(String string) {
        Entry[] entryArray = this.table;
        int n = string.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(string)) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                return;
            }
            entry2 = entry;
            entry = entry.next;
        }
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StringToIntMap)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        StringToIntMap stringToIntMap = (StringToIntMap)object;
        int n = 0;
        while (n < this.table.length) {
            Entry entry = this.table[n];
            while (entry != null) {
                int n2 = entry.value;
                int n3 = stringToIntMap.get(entry.key);
                if (n3 != n2) {
                    return false;
                }
                entry = entry.next;
            }
            ++n;
        }
        return true;
    }

    public synchronized Object clone() {
        StringToIntMap stringToIntMap = new StringToIntMap(this.size() * 3);
        int n = 0;
        while (n < this.table.length) {
            Entry entry = this.table[n];
            while (entry != null) {
                stringToIntMap.put(entry.key, entry.value);
                entry = entry.next;
            }
            ++n;
        }
        return stringToIntMap;
    }

    public StringToIntMap() {
        this(31, 0.75f);
    }

    public StringToIntMap(int n) {
        this(n, 0.75f);
    }

    public StringToIntMap(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class StringToIntMapIterator
    implements Iterator {
        private int index;
        private Entry entry;

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.entry == null) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                this.entry = StringToIntMap.access$0(StringToIntMap.this)[this.index];
                if (this.entry == null) continue;
                return true;
lbl6:
                // 2 sources

                ** while (this.index-- > 0)
            }
lbl7:
            // 1 sources

            return false;
        }

        public Object next() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = StringToIntMap.this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                Entry entry = this.entry;
                this.entry = entry.next;
                return entry.key;
            }
            throw new NoSuchElementException("IntHashtable");
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private final /* synthetic */ void this() {
            this.index = StringToIntMap.this.table.length;
        }

        StringToIntMapIterator() {
            this.this();
        }
    }

    static class Entry {
        int hash;
        String key;
        int value;
        Entry next;

        Entry() {
        }
    }
}

