/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BUuid
extends BSimple
implements BIComparable {
    static final char[] compactMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '$', '*'};
    public static final BUuid NULL = new BUuid(0L, 0L);
    public static final BUuid MIN = new BUuid(Long.MIN_VALUE, Long.MIN_VALUE);
    public static final BUuid MAX = new BUuid(Long.MAX_VALUE, Long.MAX_VALUE);
    public static final BUuid DEFAULT = NULL;
    public static final Type TYPE;
    private static Object nonNativeLock;
    private static boolean nonNativeInit;
    private static int ipAddress;
    private static int counter1;
    private static int counter2;
    private long mostSig;
    private long leastSig;
    private String string;
    static /* synthetic */ Class class$javax$baja$util$BUuid;

    public static final BUuid make(String string) {
        if (string.length() != 36 || string.charAt(8) != '-' || string.charAt(13) != '-' || string.charAt(18) != '-' || string.charAt(23) != '-') {
            throw new BajaRuntimeException("Invalid format for BUuid: " + string);
        }
        long l = BUuid.parse(string, 0, 8) << 32 | BUuid.parse(string, 9, 4) << 16 | BUuid.parse(string, 14, 4);
        long l2 = BUuid.parse(string, 19, 4) << 48 | BUuid.parse(string, 24, 12);
        return new BUuid(l, l2);
    }

    public static final BUuid make(long l, long l2) {
        return new BUuid(l, l2);
    }

    public static final BUuid make(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Array length mismatch.");
        }
        long l = 0L;
        int n = 15;
        while (n >= 8) {
            l <<= 8;
            l |= (long)(byArray[n] & 0xFF);
            --n;
        }
        long l2 = 0L;
        int n2 = 7;
        while (n2 >= 0) {
            l2 <<= 8;
            l2 |= (long)(byArray[n2] & 0xFF);
            --n2;
        }
        return new BUuid(l, l2);
    }

    public static final BUuid make() {
        BUuid bUuid = new BUuid(0L, 0L);
        if (NreLib.nativesLoaded) {
            bUuid.init0();
        } else {
            bUuid.initNonNative();
        }
        return bUuid;
    }

    private final native void init0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void initNonNative() {
        Object object = nonNativeLock;
        synchronized (object) {
            if (!nonNativeInit) {
                nonNativeInit = true;
                Random random = new Random(System.currentTimeMillis() ^ Nre.bootTime);
                ipAddress = random.nextInt();
                counter1 = Math.abs(random.nextInt());
                counter2 = Math.abs(random.nextInt());
                try {
                    byte[] byArray = Sys.getLocalHost().getAddress();
                    ipAddress = ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
                }
                catch (Exception exception) {
                    System.out.println("ERROR: BUuid.initNonNative: " + exception);
                }
            }
            this.mostSig = (long)counter1 | (long)ipAddress << 32;
            this.leastSig = (long)counter2 << 50 | System.currentTimeMillis();
            ++counter1;
            ++counter2;
            return;
        }
    }

    public final long getMostSignificant() {
        return this.mostSig;
    }

    public final long getLeastSignificant() {
        return this.leastSig;
    }

    public final byte[] getBytes() {
        byte[] byArray = new byte[16];
        long l = this.mostSig;
        int n = 8;
        while (n < 16) {
            byArray[n] = (byte)(l & 0xFFL);
            l >>>= 8;
            ++n;
        }
        long l2 = this.leastSig;
        int n2 = 0;
        while (n2 < 8) {
            byArray[n2] = (byte)(l2 & 0xFFL);
            l2 >>>= 8;
            ++n2;
        }
        return byArray;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this.mostSig == 0L && this.leastSig == 0L) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return (int)(this.mostSig >> 32 ^ this.mostSig ^ this.leastSig >> 32 ^ this.leastSig);
    }

    public final int compareTo(Object object) {
        BUuid bUuid = (BUuid)object;
        if (this.mostSig == bUuid.mostSig) {
            if (this.leastSig == bUuid.leastSig) {
                return 0;
            }
            return this.leastSig < bUuid.leastSig ? -1 : 1;
        }
        return this.mostSig < bUuid.mostSig ? -1 : 1;
    }

    public final boolean equals(Object object) {
        if (object instanceof BUuid) {
            BUuid bUuid = (BUuid)object;
            boolean bl = false;
            if (this.mostSig == bUuid.mostSig && this.leastSig == bUuid.leastSig) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.mostSig);
        dataOutput.writeLong(this.leastSig);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return new BUuid(dataInput.readLong(), dataInput.readLong());
    }

    public final String encodeToString() throws IOException {
        if (this.string == null) {
            this.string = BUuid.digits(this.mostSig >> 32, 8) + '-' + BUuid.digits(this.mostSig >> 16, 4) + '-' + BUuid.digits(this.mostSig, 4) + '-' + BUuid.digits(this.leastSig >> 48, 4) + '-' + BUuid.digits(this.leastSig, 12);
        }
        return this.string;
    }

    public final String toCompactString() {
        StringBuffer stringBuffer = new StringBuffer(28);
        stringBuffer.append(compactMap[(int)(this.mostSig >> 58) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.mostSig >> 52) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.mostSig >> 46) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.mostSig >> 40) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.mostSig >> 34) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.mostSig >> 38) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.mostSig >> 32) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.mostSig >> 36) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.mostSig >> 30) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.mostSig >> 24) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.mostSig >> 18) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.mostSig >> 12) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.mostSig >> 6) & 0x3F]);
        stringBuffer.append(compactMap[(int)this.mostSig & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.leastSig >> 58) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.leastSig >> 52) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.leastSig >> 46) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.leastSig >> 40) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.leastSig >> 34) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.leastSig >> 38) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.leastSig >> 32) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.leastSig >> 36) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.leastSig >> 30) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.leastSig >> 24) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.leastSig >> 18) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.leastSig >> 12) & 0x3F]);
        stringBuffer.append(compactMap[(int)(this.leastSig >> 6) & 0x3F]);
        stringBuffer.append(compactMap[(int)this.leastSig & 0x3F]);
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        return BUuid.make(string);
    }

    private static final String digits(long l, int n) {
        long l2 = 1L << n * 4;
        return Long.toHexString(l2 | l & l2 - 1L).substring(1);
    }

    private static final long parse(String string, int n, int n2) {
        long l = 0L;
        int n3 = 0;
        while (n3 < n2) {
            l <<= 4;
            l |= (long)BUuid.hexCharToInt(string, n + n3);
            ++n3;
        }
        return l;
    }

    private static final int hexCharToInt(String string, int n) {
        char c = string.charAt(n);
        int n2 = c - 48;
        if (n2 >= 0 && n2 <= 9) {
            return n2;
        }
        n2 = c - 65 + 10;
        if (n2 >= 10 && n2 <= 15) {
            return n2;
        }
        n2 = c - 97 + 10;
        if (n2 >= 10 && n2 <= 15) {
            return n2;
        }
        throw new BajaRuntimeException("Invalid format for BUuid: " + string);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BUuid(long l, long l2) {
        this.mostSig = l;
        this.leastSig = l2;
    }

    static {
        Class clazz = class$javax$baja$util$BUuid;
        if (clazz == null) {
            clazz = class$javax$baja$util$BUuid = BUuid.class("[Ljavax.baja.util.BUuid;", false);
        }
        TYPE = Sys.loadType(clazz);
        nonNativeLock = new Object();
    }
}

