/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import com.tridium.util.EscUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.baja.io.BIEncodable;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIFormatPropertyHandler;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BFormat
extends BSimple {
    public static final BFormat DEFAULT = new BFormat("");
    public static final Type TYPE;
    static final Class[] paramNone;
    static final Class[] paramContext;
    static final Class[] paramString;
    String format;
    Object[] segments;
    private int hashCode;
    static /* synthetic */ Class class$javax$baja$util$BFormat;
    static /* synthetic */ Class class$javax$baja$sys$Context;
    static /* synthetic */ Class class$java$lang$String;

    public static final String format(String string, Object object) {
        return BFormat.make(string).format(object, null);
    }

    public static final String format(String string, Object object, Context context) {
        return BFormat.make(string).format(object, context);
    }

    public static final String getEncodedPattern(BIEncodable bIEncodable) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("%decodeFromString(");
        stringBuffer.append(bIEncodable.getType().getModule().getModuleName());
        stringBuffer.append(':');
        stringBuffer.append(bIEncodable.getType().getTypeName());
        stringBuffer.append(':');
        stringBuffer.append(SlotPath.escape(bIEncodable.encodeToString()));
        stringBuffer.append(")%");
        return stringBuffer.toString();
    }

    public static final String getLexiconPattern(String string, String string2, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("%lexicon(");
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(string2);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(':');
                stringBuffer.append(SlotPath.escape(stringArray[n]));
                ++n;
            }
        }
        stringBuffer.append(")%");
        return stringBuffer.toString();
    }

    public static final BFormat make(String string) {
        if (string.length() == 0) {
            return DEFAULT;
        }
        return (BFormat)new BFormat(string).intern();
    }

    public final String getFormat() {
        return this.format;
    }

    public final String format(Object object) {
        return this.format(object, null);
    }

    public final String format(Object object, Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.parse();
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            if (object2 instanceof String) {
                stringBuffer.append(object2);
            } else {
                Call call = (Call)object2;
                try {
                    stringBuffer.append(call.eval(object, object, context));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    stringBuffer.append(call.toErrorString(object, object, context));
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected static final Object[] parse(String string) {
        try {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c != '%') {
                    stringBuffer.append(c);
                } else if ((c = string.charAt(++n2)) == '%') {
                    stringBuffer.append('%');
                } else {
                    String string2 = stringBuffer.toString();
                    if (string2.length() > 0) {
                        arrayList.add(string2);
                    }
                    stringBuffer.setLength(0);
                    Call call = null;
                    Call call2 = null;
                    int n3 = -1;
                    int n4 = 0;
                    while (n4 > 0 || string.charAt(n2) != '%' && string.charAt(n2) != '?') {
                        if ((c = string.charAt(n2++)) == '(') {
                            if (n3 < 0) {
                                n3 = stringBuffer.length();
                            }
                            ++n4;
                        }
                        if (c == ')') {
                            --n4;
                        }
                        if (c != '.' || n4 > 0) {
                            stringBuffer.append(c);
                            continue;
                        }
                        call2 = BFormat.parseCall(call2, stringBuffer.toString(), n3);
                        if (call == null) {
                            call = call2;
                        }
                        stringBuffer.setLength(0);
                        n3 = -1;
                    }
                    call2 = BFormat.parseCall(call2, stringBuffer.toString(), n3);
                    if (call == null) {
                        call = call2;
                    }
                    stringBuffer.setLength(0);
                    if (string.charAt(n2) == '?') {
                        Call call3 = null;
                        Call call4 = null;
                        n3 = -1;
                        n4 = 0;
                        stringBuffer.setLength(0);
                        ++n2;
                        while (n4 > 0 || string.charAt(n2) != '%') {
                            if ((c = string.charAt(n2++)) == '(') {
                                if (n3 < 0) {
                                    n3 = stringBuffer.length();
                                }
                                ++n4;
                            }
                            if (c == ')') {
                                --n4;
                            }
                            if (c != '.' || n4 > 0) {
                                stringBuffer.append(c);
                                continue;
                            }
                            call4 = BFormat.parseCall(call4, stringBuffer.toString(), n3);
                            if (call3 == null) {
                                call3 = call4;
                            }
                            stringBuffer.setLength(0);
                            n3 = -1;
                        }
                        call4 = BFormat.parseCall(call4, stringBuffer.toString(), n3);
                        if (call3 == null) {
                            call3 = call4;
                        }
                        stringBuffer.setLength(0);
                        call.error = call3;
                        Call call5 = call;
                        while (call5 != call2) {
                            call5 = call5.next;
                            call5.error = call.error;
                        }
                    }
                    arrayList.add(call);
                }
                ++n2;
            }
            String string3 = stringBuffer.toString();
            if (string3.length() > 0) {
                arrayList.add(string3);
            }
            return arrayList.toArray();
        }
        catch (Exception exception) {
            return new Object[]{"ERROR " + string};
        }
    }

    final Object[] parse() {
        if (this.segments == null) {
            this.segments = BFormat.parse(this.format);
        }
        return this.segments;
    }

    static final Call parseCall(Call call, String string, int n) throws IOException {
        if (string.length() == 0) {
            return new IdentityCall(call, string);
        }
        if (n > 0) {
            if (string.equals("time()")) {
                return new TimeCall(call, string);
            }
            if (string.equals("user()")) {
                return new UserCall(call, string);
            }
            if (string.equals("sys()")) {
                return new SysCall(call, string);
            }
            if (string.startsWith("escape(")) {
                return new EscapeCall(call, string);
            }
            if (string.startsWith("unescape(")) {
                return new UnescapeCall(call, string);
            }
            String string2 = string.substring(n + 1, string.length() - 1);
            if (string.startsWith("lexicon(")) {
                return new LexiconCall(call, string, string2);
            }
            if (string.startsWith("substring(")) {
                return new SubstringCall(call, string, string2);
            }
            if (string.startsWith("decodeFromString(")) {
                return new DecodeFromStringCall(call, string, string2);
            }
        }
        return new ReflectCall(call, string);
    }

    public final void dump() {
        System.out.println("BFormat: " + this.format);
        int n = 0;
        while (n < this.parse().length) {
            Object object = this.segments[n];
            if (object instanceof String) {
                System.out.println(" [" + n + "] \"" + object + '\"');
            } else if (object instanceof Call) {
                System.out.println(" [" + n + "] " + object + ' ' + TextUtil.getClassName(object.getClass()));
                Call call = (Call)object;
                if (call.error != null) {
                    System.out.println("     - err: " + object + ' ' + TextUtil.getClassName(object.getClass()));
                }
            } else {
                System.out.println(" [" + n + "] " + object + ' ' + TextUtil.getClassName(object.getClass()));
            }
            ++n;
        }
    }

    public static final void main(String[] stringArray) throws Exception {
        new BFormat(stringArray[0]).dump();
        BStatusNumeric bStatusNumeric = new BStatusNumeric();
        bStatusNumeric.setStatus(BStatus.make(0, BFacets.make("min", BDouble.make(33.0))));
        System.out.println(BFormat.format(stringArray[0], bStatusNumeric));
    }

    private static final boolean hasPermission(BComplex bComplex, Slot slot, Context context) {
        if (!bComplex.getType().is(BIProtected.TYPE)) {
            return true;
        }
        BPermissions bPermissions = ((BIProtected)((Object)bComplex)).getPermissions(context);
        if (slot == null) {
            return bPermissions.hasOperatorRead();
        }
        if (Flags.isOperator(bComplex, slot)) {
            if (slot.isAction()) {
                return bPermissions.hasOperatorInvoke();
            }
            boolean bl = false;
            if (bPermissions.hasOperatorRead() && BFormat.checkProtectedSlot(bComplex, slot, context)) {
                bl = true;
            }
            return bl;
        }
        if (slot.isAction()) {
            return bPermissions.hasAdminInvoke();
        }
        boolean bl = false;
        if (bPermissions.hasAdminRead() && BFormat.checkProtectedSlot(bComplex, slot, context)) {
            bl = true;
        }
        return bl;
    }

    private static final boolean checkProtectedSlot(BComplex bComplex, Slot slot, Context context) {
        BValue bValue;
        if (slot.isProperty() && (bValue = bComplex.get((Property)slot)).getType().is(BIProtected.TYPE)) {
            BPermissions bPermissions = ((BIProtected)((Object)bValue)).getPermissions(context);
            return bPermissions.hasOperatorRead();
        }
        return true;
    }

    static final Object reflect(Object object, String string, Class[] classArray, Object object2) throws Throwable {
        try {
            Object[] objectArray;
            Method method = object.getClass().getMethod(string, classArray);
            if (classArray.length == 0) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = object2;
            }
            Object[] objectArray3 = objectArray;
            return method.invoke(object, objectArray3);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    public final int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception exception) {
            return System.identityHashCode(this);
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof BFormat) {
            BFormat bFormat = (BFormat)object;
            return this.format.equals(bFormat.format);
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.format);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BFormat.make(dataInput.readUTF());
    }

    public final String encodeToString() throws IOException {
        return this.format;
    }

    public final BObject decodeFromString(String string) throws IOException {
        return BFormat.make(string);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.hashCode = -1;
    }

    private BFormat(String string) {
        this.this();
        this.format = string;
    }

    static {
        Class clazz = class$javax$baja$util$BFormat;
        if (clazz == null) {
            clazz = class$javax$baja$util$BFormat = BFormat.class("[Ljavax.baja.util.BFormat;", false);
        }
        TYPE = Sys.loadType(clazz);
        paramNone = new Class[0];
        Class[] classArray = new Class[1];
        Class clazz2 = class$javax$baja$sys$Context;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$sys$Context = BFormat.class("[Ljavax.baja.sys.Context;", false);
        }
        classArray[0] = clazz2;
        paramContext = classArray;
        Class[] classArray2 = new Class[1];
        Class clazz3 = class$java$lang$String;
        if (clazz3 == null) {
            clazz3 = class$java$lang$String = BFormat.class("[Ljava.lang.String;", false);
        }
        classArray2[0] = clazz3;
        paramString = classArray2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static abstract class Call {
        String id;
        Call next;
        Call error;

        public final String toString() {
            if (this.next == null) {
                return this.id;
            }
            return this.id + '.' + this.next;
        }

        String toString(Object object, Context context) {
            if (object instanceof BObject) {
                return ((BObject)object).toString(context);
            }
            return String.valueOf(object);
        }

        String toErrorString(Object object, Object object2, Context context) {
            if (this.error != null) {
                try {
                    return this.error.eval(object2, object2, context).toString();
                }
                catch (Throwable throwable) {}
            }
            String string = object == null ? "null" : (object instanceof BObject ? ((BObject)object).getType().toString() : TextUtil.getClassName(object.getClass()));
            return "%err:" + string + ':' + this.id + '%';
        }

        abstract Object eval(Object var1, Object var2, Context var3) throws Throwable;

        final Object chain(Object object, Object object2, Context context) throws Throwable {
            if (this.next != null) {
                return this.next.eval(object, object2, context);
            }
            return this.toString(object, context);
        }

        private final /* synthetic */ void this() {
            this.error = null;
        }

        Call(Call call, String string) {
            this.this();
            if (call != null) {
                call.next = this;
            }
            this.id = string;
        }
    }

    static class IdentityCall
    extends Call {
        Object eval(Object object, Object object2, Context context) throws Throwable {
            if (object instanceof BObject) {
                return ((BObject)object).toString(context);
            }
            return object;
        }

        IdentityCall(Call call, String string) {
            super(call, string);
        }
    }

    static class TimeCall
    extends Call {
        Object eval(Object object, Object object2, Context context) throws Throwable {
            return this.chain(Clock.time(), object2, context);
        }

        TimeCall(Call call, String string) {
            super(call, string);
        }
    }

    static class UserCall
    extends Call {
        Object eval(Object object, Object object2, Context context) throws Throwable {
            if (object instanceof BComponent) {
                String string;
                BComponent bComponent = (BComponent)object;
                Context context2 = bComponent.getSession().getSessionContext();
                if (context2 != null) {
                    string = ((BFacets)context2).gets("username", null);
                } else if (context.getUser() != null) {
                    string = context.getUser().getUsername();
                } else {
                    throw new BajaRuntimeException("Username unavailable");
                }
                if (string != null && string.length() > 0) {
                    return this.chain(string, object2, context);
                }
            }
            return this.chain(null, object2, context);
        }

        UserCall(Call call, String string) {
            super(call, string);
        }
    }

    static class SysCall
    extends Call {
        Object eval(Object object, Object object2, Context context) throws Throwable {
            return this.chain(new Sys(), object2, context);
        }

        SysCall(Call call, String string) {
            super(call, string);
        }
    }

    static class EscapeCall
    extends Call {
        Object eval(Object object, Object object2, Context context) {
            return EscUtil.slot.escape(this.toString(object, context));
        }

        EscapeCall(Call call, String string) throws IOException {
            super(call, string);
        }
    }

    static class UnescapeCall
    extends Call {
        String str;

        Object eval(Object object, Object object2, Context context) {
            return EscUtil.slot.unescape(this.toString(object, context));
        }

        UnescapeCall(Call call, String string) throws IOException {
            super(call, string);
        }
    }

    static class LexiconCall
    extends Call {
        String module;
        String key;
        String[] argFormats;

        Object eval(Object object, Object object2, Context context) throws Throwable {
            if (this.argFormats == null) {
                return this.chain(Lexicon.make(this.module, context).getText(this.key, new Object[]{object}), object2, context);
            }
            Object[] objectArray = new String[this.argFormats.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = BFormat.format(SlotPath.unescape(this.argFormats[n]), object, context);
                ++n;
            }
            return this.chain(Lexicon.make(this.module, context).getText(this.key, objectArray), object2, context);
        }

        LexiconCall(Call call, String string, String string2) {
            super(call, string);
            int n = string2.indexOf(58);
            this.module = string2.substring(0, n);
            string2 = string2.substring(n + 1);
            n = string2.indexOf(58);
            if (n >= 0) {
                this.key = string2.substring(0, n);
                this.argFormats = TextUtil.split((String)string2.substring(n + 1), (char)':');
            } else {
                this.key = string2;
                this.argFormats = null;
            }
        }
    }

    static class SubstringCall
    extends Call {
        String[] args;

        Object eval(Object object, Object object2, Context context) throws Throwable {
            int n;
            String string = this.toString(object, context);
            string = this.args.length == 1 ? ((n = Integer.parseInt(this.args[0])) >= 0 ? string.substring(n) : string.substring(string.length() + n, string.length())) : string.substring(Integer.parseInt(this.args[0]), Integer.parseInt(this.args[1]));
            return this.chain(string, object2, context);
        }

        SubstringCall(Call call, String string, String string2) {
            super(call, string);
            this.args = TextUtil.splitAndTrim((String)string2, (char)',');
        }
    }

    static class DecodeFromStringCall
    extends Call {
        BObject obj;

        Object eval(Object object, Object object2, Context context) {
            return this.obj;
        }

        DecodeFromStringCall(Call call, String string, String string2) throws IOException {
            super(call, string);
            int n = string2.indexOf(58);
            String string3 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
            n = string2.indexOf(58);
            String string4 = string2.substring(0, n);
            BIEncodable bIEncodable = (BIEncodable)((Object)Sys.getType(string3 + ':' + string4).getInstance());
            this.obj = bIEncodable.decodeFromString(SlotPath.unescape(string2.substring(n + 1)));
        }
    }

    static class ReflectCall
    extends Call {
        Object eval(Object object, Object object2, Context context) throws Throwable {
            Object object3;
            Object object4;
            if (object instanceof BComplex) {
                object4 = (BComplex)object;
                if (!BFormat.hasPermission((BComplex)object4, null, context)) {
                    return this.toErrorString(object, object2, context);
                }
                object3 = null;
                if (object instanceof BIFormatPropertyHandler) {
                    object3 = ((BIFormatPropertyHandler)object).getFormatPropertyByName(this.id);
                }
                if (object3 == null) {
                    object3 = ((BComplex)object4).getProperty(this.id);
                }
                if (object3 == null) {
                    Slot slot;
                    String string = null;
                    if (this.id.startsWith("get")) {
                        string = TextUtil.decapitalize((String)this.id.substring(3));
                    } else if (this.id.startsWith("do")) {
                        string = TextUtil.decapitalize((String)this.id.substring(2));
                    } else if (this.id.startsWith("fire")) {
                        string = TextUtil.decapitalize((String)this.id.substring(4));
                    }
                    if (string != null && (slot = ((BComplex)object4).getSlot(string)) != null && slot.isFrozen() && !BFormat.hasPermission((BComplex)object4, slot, context)) {
                        return this.toErrorString(object, object2, context);
                    }
                }
                if (object3 != null) {
                    if (!BFormat.hasPermission((BComplex)object4, (Slot)object3, context)) {
                        return this.toErrorString(object, object2, context);
                    }
                    context = new BasicContext(context, ((BComplex)object4).getSlotFacets((Slot)object3));
                    if (this.next == null) {
                        return ((BComplex)object4).get((Property)object3).toString(context);
                    }
                }
            }
            object4 = "get" + TextUtil.capitalize((String)this.id);
            object3 = null;
            if (object instanceof BPassword) {
                return this.toErrorString(object, object2, context);
            }
            object3 = BFormat.reflect(object, (String)object4, paramContext, context);
            if (object3 != null) {
                return this.chain(object3, object2, context);
            }
            object3 = BFormat.reflect(object, (String)object4, paramNone, null);
            if (object3 != null) {
                return this.chain(object3, object2, context);
            }
            object3 = BFormat.reflect(object, this.id, paramContext, context);
            if (object3 != null) {
                return this.chain(object3, object2, context);
            }
            object3 = BFormat.reflect(object, this.id, paramNone, null);
            if (object3 != null) {
                return this.chain(object3, object2, context);
            }
            object3 = BFormat.reflect(object, "get", paramString, this.id);
            if (object3 != null) {
                return this.chain(object3, object2, context);
            }
            object3 = BFormat.reflect(object, "getFormatValue", paramString, this.id);
            if (object3 != null) {
                return this.chain(object3, object2, context);
            }
            return this.toErrorString(object, object2, context);
        }

        ReflectCall(Call call, String string) {
            super(call, string);
        }
    }
}

