/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBitSet
extends BSimple {
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final BBitSet EMPTY;
    public static final BBitSet DEFAULT;
    public static final Type TYPE;
    private byte[] bits;
    private int hashCode;
    static /* synthetic */ Class class$javax$baja$util$BBitSet;

    public static final BBitSet make(BBitSet bBitSet, int n, boolean bl) {
        if (bBitSet.getBit(n) == bl) {
            return bBitSet;
        }
        int n2 = n >> 3;
        int n3 = 1 << n % 8;
        int n4 = Math.max(bBitSet.bits.length, n2 + 1);
        byte[] byArray = new byte[n4];
        System.arraycopy(bBitSet.bits, 0, byArray, 0, bBitSet.bits.length);
        if (bl) {
            int n5 = n2;
            byArray[n5] = (byte)(byArray[n5] | n3);
        } else {
            int n6 = n2;
            byArray[n6] = (byte)(byArray[n6] & ~n3);
        }
        return (BBitSet)new BBitSet(byArray).intern();
    }

    public final boolean getBit(int n) {
        int n2 = n >> 3;
        int n3 = 1 << n % 8;
        if (n2 >= this.bits.length) {
            return false;
        }
        boolean bl = false;
        if ((this.bits[n2] & n3) != 0) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            int n = 31;
            byte[] byArray = this.bits;
            int n2 = 0;
            while (n2 < byArray.length) {
                n = 31 * n + byArray[n2];
                ++n2;
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        if (object instanceof BBitSet) {
            BBitSet bBitSet = (BBitSet)object;
            int n = Math.min(this.bits.length, bBitSet.bits.length);
            int n2 = 0;
            while (n2 < n) {
                if (this.bits[n2] != bBitSet.bits[n2]) {
                    return false;
                }
                ++n2;
            }
            BBitSet bBitSet2 = n == this.bits.length ? bBitSet : this;
            int n3 = n;
            while (n3 < bBitSet2.bits.length) {
                if (bBitSet2.bits[n3] != 0) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    public final String toString(Context context) {
        return "0x" + this.encodeToString();
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() {
        StringBuffer stringBuffer = new StringBuffer(this.bits.length * 2 + 2);
        boolean bl = false;
        int n = this.bits.length - 1;
        while (n >= 0) {
            block8: {
                int n2;
                block7: {
                    n2 = this.bits[n] & 0xFF;
                    if (bl) break block7;
                    if (n2 == 0) break block8;
                    bl = true;
                }
                if (n2 < 16) {
                    stringBuffer.append('0');
                } else {
                    stringBuffer.append(hexChars[n2 >> 4 & 0xF]);
                }
                stringBuffer.append(hexChars[n2 & 0xF]);
            }
            --n;
        }
        if (!bl) {
            return "00";
        }
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            byte[] byArray = new byte[string.length() / 2];
            int n = 0;
            while (n < string.length()) {
                int n2 = TextUtil.hexCharToInt((char)string.charAt(n));
                int n3 = TextUtil.hexCharToInt((char)string.charAt(n + 1));
                byArray[byArray.length - n / 2 - 1] = (byte)(n2 << 4 | n3);
                n += 2;
            }
            return (BBitSet)new BBitSet(byArray).intern();
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("Invalid BBitSet: " + string);
        }
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.hashCode = 0;
    }

    private BBitSet(byte[] byArray) {
        this.this();
        this.bits = byArray;
    }

    static {
        DEFAULT = EMPTY = (BBitSet)new BBitSet(new byte[0]).intern();
        Class clazz = class$javax$baja$util$BBitSet;
        if (clazz == null) {
            clazz = class$javax$baja$util$BBitSet = BBitSet.class("[Ljavax.baja.util.BBitSet;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

