/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.user;

import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.user.BUser;
import javax.baja.user.BUserEvent;
import javax.baja.user.BUserService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class UserMonitor {
    private BComponent comp;
    private UserSubscriber subscriber;
    static /* synthetic */ Class class$javax$baja$user$BUser;

    final void fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 13: {
                this.fwDecendantsStarted();
                break;
            }
            case 14: {
                this.fwDecendantsStopped();
                break;
            }
            case 3: {
                this.fwAdded((Property)object, (Context)object2);
                break;
            }
            case 4: {
                this.fwRemoved((Property)object, (BValue)object2, (Context)object3);
                break;
            }
            case 5: {
                this.fwRenamed((Property)object, (String)object2, (Context)object3);
                break;
            }
            case 2: {
                this.fwChanged((Property)object, (Context)object2);
            }
        }
    }

    final void setModified(BUser bUser) {
        bUser.updateVersion();
        this.fireUserEvent(new BUserEvent(2, bUser));
    }

    private final void fwDecendantsStarted() {
        this.subscribeToAllUsers();
    }

    private final void fwDecendantsStopped() {
        this.subscriber.unsubscribeAll();
    }

    private final void fwAdded(Property property, Context context) {
        if (!this.comp.isRunning()) {
            return;
        }
        if (property.getType().is(BUser.TYPE)) {
            BUser bUser = (BUser)this.comp.get(property);
            if (bUser.getParent() instanceof BUserService) {
                bUser.convertToPbkdf2Password();
            }
            this.subscriber.subscribe(bUser, 10);
            this.cleanupSubscriptions();
            this.fireUserEvent(BUserEvent.makeAdded(bUser));
        }
    }

    private final void fwRemoved(Property property, BValue bValue, Context context) {
        if (!this.comp.isRunning()) {
            return;
        }
        if (property.getType().is(BUser.TYPE)) {
            BUser bUser = (BUser)bValue;
            this.subscriber.unsubscribe(bUser);
            this.cleanupSubscriptions();
            this.fireUserEvent(BUserEvent.makeRemoved(bUser, property.getName()));
        }
    }

    private final void fwRenamed(Property property, String string, Context context) {
        if (!this.comp.isRunning()) {
            return;
        }
        if (property.getType().is(BUser.TYPE)) {
            BUser bUser = (BUser)this.comp.get(property);
            this.cleanupSubscriptions();
            this.fireUserEvent(BUserEvent.makeRenamed(bUser, string));
        }
    }

    private final void fwChanged(Property property, Context context) {
        if (!this.comp.isRunning()) {
            return;
        }
        if (property.getType().is(BUser.TYPE)) {
            BUser bUser = (BUser)this.comp.get(property);
            if (bUser.getParent() instanceof BUserService) {
                bUser.convertToPbkdf2Password();
            }
            this.subscriber.subscribe(bUser, 10);
            this.cleanupSubscriptions();
            this.fireUserEvent(BUserEvent.makeModified(bUser));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void subscribeToAllUsers() {
        this.subscriber.unsubscribeAll();
        var1_1 = this.comp.getProperties();
        if (true) ** GOTO lbl7
        do {
            var2_2 = (BUser)var1_1.get();
            this.subscriber.subscribe(var2_2, 10);
lbl7:
            // 2 sources

            if ((v0 = UserMonitor.class$javax$baja$user$BUser) != null) continue;
            v0 = UserMonitor.class("[Ljavax.baja.user.BUser;", false);
        } while (var1_1.next(v0));
    }

    private final void cleanupSubscriptions() {
        BComponent[] bComponentArray = this.subscriber.getSubscriptions();
        int n = 0;
        while (n < bComponentArray.length) {
            if (!bComponentArray[n].isMounted()) {
                this.subscriber.unsubscribe(bComponentArray[n]);
            }
            ++n;
        }
    }

    private final void fireUserEvent(BUserEvent bUserEvent) {
        this.comp.fire(this.comp.getTopic("userEvent"), bUserEvent);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.subscriber = new UserSubscriber();
    }

    UserMonitor(BComponent bComponent) {
        this.this();
        if (bComponent.getTopic("userEvent") == null) {
            throw new BajaRuntimeException("Component must implement userEvent Topic!");
        }
        this.comp = bComponent;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class UserSubscriber
    extends Subscriber {
        public void event(BComponentEvent bComponentEvent) {
            int n = bComponentEvent.getId();
            BUser bUser = this.getUser(bComponentEvent);
            if (bUser == null) {
                return;
            }
            switch (n) {
                case 0: 
                case 1: {
                    if (bComponentEvent.getSlot() == BUser.version) break;
                }
                case 2: 
                case 3: 
                case 6: {
                    BUserEvent bUserEvent = new BUserEvent(2, bUser);
                    bUser.updateVersion();
                    UserMonitor.this.fireUserEvent(bUserEvent);
                    break;
                }
            }
        }

        private final BUser getUser(BComponentEvent bComponentEvent) {
            BComponent bComponent = bComponentEvent.getSourceComponent();
            if (bComponent instanceof BUser) {
                return (BUser)bComponent;
            }
            BComplex bComplex = bComponent.getParent();
            while (bComplex != null && !(bComplex instanceof BUser)) {
                bComplex = bComplex.getParent();
            }
            return (BUser)bComplex;
        }

        private UserSubscriber() {
        }
    }
}

