/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.user;

import com.tridium.nre.auth.SecurityUtil;
import com.tridium.sys.station.Station;
import com.tridium.user.BUserPasswordConfiguration;
import com.tridium.user.BUserServicePasswordConfiguration;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BHttpFoxCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordHistory;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.user.BAuthAgent;
import javax.baja.user.BIDefaultAuthAgent;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUser;
import javax.baja.user.BUserEvent;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.PermissionsManager;
import javax.baja.user.UserMonitor;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BUserService
extends BComponent
implements BIService {
    public static final Property requireStrongPasswords = BUserService.newProperty(5, true, null);
    public static final Property passwordStrength = BUserService.newProperty(0, BPasswordStrength.DEFAULT, null);
    public static final Property lockOutEnabled = BUserService.newProperty(0, true, null);
    public static final Property lockOutPeriod = BUserService.newProperty(0, BRelTime.make(10000L), null);
    public static final Property maxBadLoginsBeforeLockOut = BUserService.newProperty(0, 5, BFacets.make(BFacets.make("min", 1), BFacets.make("max", 10)));
    public static final Property lockOutWindow = BUserService.newProperty(0, BRelTime.makeSeconds(30), BFacets.make(BFacets.make("min", BRelTime.makeSeconds(1)), BFacets.make("max", BRelTime.makeHours(24))));
    public static final Property admin = BUserService.newProperty(0, BUser.makeAdmin(), null);
    public static final Property guest = BUserService.newProperty(0, BUser.makeGuest(), null);
    public static final Property userPrototypes = BUserService.newProperty(0, new BUserPrototypes(), null);
    public static final Topic userEvent = BUserService.newTopic(0, null);
    public static final Type TYPE;
    private static Type[] serviceTypes;
    private static final BIcon icon;
    private static final Version PASSWORD_STRENGTH_VERSION;
    public static HttpCredentialsHandler httpHandler;
    static final Log log;
    private UserMonitor monitor;
    private PermissionsManager[] permissionsManagers;
    static /* synthetic */ Class class$javax$baja$user$BUserService;
    static /* synthetic */ Class class$com$tridium$user$BUserPasswordConfiguration;
    static /* synthetic */ Class class$com$tridium$user$BUserServicePasswordConfiguration;
    static /* synthetic */ Class class$javax$baja$user$BUser;

    public boolean getRequireStrongPasswords() {
        return this.getBoolean(requireStrongPasswords);
    }

    public void setRequireStrongPasswords(boolean bl) {
        this.setBoolean(requireStrongPasswords, bl, null);
    }

    public BPasswordStrength getPasswordStrength() {
        return (BPasswordStrength)this.get(passwordStrength);
    }

    public void setPasswordStrength(BPasswordStrength bPasswordStrength) {
        this.set(passwordStrength, (BValue)bPasswordStrength, null);
    }

    public boolean getLockOutEnabled() {
        return this.getBoolean(lockOutEnabled);
    }

    public void setLockOutEnabled(boolean bl) {
        this.setBoolean(lockOutEnabled, bl, null);
    }

    public BRelTime getLockOutPeriod() {
        return (BRelTime)this.get(lockOutPeriod);
    }

    public void setLockOutPeriod(BRelTime bRelTime) {
        this.set(lockOutPeriod, (BValue)bRelTime, null);
    }

    public int getMaxBadLoginsBeforeLockOut() {
        return this.getInt(maxBadLoginsBeforeLockOut);
    }

    public void setMaxBadLoginsBeforeLockOut(int n) {
        this.setInt(maxBadLoginsBeforeLockOut, n, null);
    }

    public BRelTime getLockOutWindow() {
        return (BRelTime)this.get(lockOutWindow);
    }

    public void setLockOutWindow(BRelTime bRelTime) {
        this.set(lockOutWindow, (BValue)bRelTime, null);
    }

    public BUser getAdmin() {
        return (BUser)this.get(admin);
    }

    public void setAdmin(BUser bUser) {
        this.set(admin, (BValue)bUser, null);
    }

    public BUser getGuest() {
        return (BUser)this.get(guest);
    }

    public void setGuest(BUser bUser) {
        this.set(guest, (BValue)bUser, null);
    }

    public BUserPrototypes getUserPrototypes() {
        return (BUserPrototypes)this.get(userPrototypes);
    }

    public void setUserPrototypes(BUserPrototypes bUserPrototypes) {
        this.set(userPrototypes, (BValue)bUserPrototypes, null);
    }

    public void fireUserEvent(BUserEvent bUserEvent) {
        this.fire(userEvent, bUserEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BUserService getService() {
        return (BUserService)Sys.getService(TYPE);
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() throws Exception {
        this.checkUsersForPbkdf2PasswordConversion();
        if (!Flags.isUserDefined4(this, requireStrongPasswords)) {
            if (!this.getRequireStrongPasswords()) {
                this.setPasswordStrength((BPasswordStrength)BPasswordStrength.OFF.newCopy(true));
            }
            this.setFlags(requireStrongPasswords, this.getFlags(requireStrongPasswords) | Integer.MIN_VALUE);
        }
        this.getComponentSpace().enableMixIn(BUserPasswordConfiguration.TYPE);
        this.getComponentSpace().enableMixIn(BUserServicePasswordConfiguration.TYPE);
    }

    public void serviceStopped() throws Exception {
        this.getComponentSpace().disableMixIn(BUserPasswordConfiguration.TYPE);
        this.getComponentSpace().disableMixIn(BUserServicePasswordConfiguration.TYPE);
    }

    public boolean isDistributable() {
        return true;
    }

    public String getDisplayName(Slot slot, Context context) {
        if (slot.equals(admin)) {
            return "admin";
        }
        if (slot.equals(guest)) {
            return "guest";
        }
        return super.getDisplayName(slot, context);
    }

    public BUser getGuestUser() {
        return this.getGuest();
    }

    public BUser getUser(String string) {
        BUser bUser = (BUser)this.get(SlotPath.escape(string));
        if (bUser == null) {
            return null;
        }
        if (!SecurityUtil.equals((String)bUser.getUsername(), (String)string)) {
            return null;
        }
        return bUser;
    }

    public final BUser authenticateBasic(String string, String string2) throws AuthenticationException {
        return this.authenticateBasic(string, string2, null);
    }

    public BUser authenticateBasic(String string, String string2, Context context) throws AuthenticationException {
        BIDefaultAuthAgent bIDefaultAuthAgent = (BIDefaultAuthAgent)((Object)this.getAuthAgent(BIDefaultAuthAgent.TYPE));
        if (bIDefaultAuthAgent != null) {
            return bIDefaultAuthAgent.authenticateBasic(string, string2, context);
        }
        throw new AuthenticationException();
    }

    public boolean canLogin(BUser bUser) {
        if (!bUser.getEnabled()) {
            return false;
        }
        if (bUser.getLockOut()) {
            return false;
        }
        if (bUser.isExpired()) {
            return false;
        }
        if (bUser.getName().equals("BACnet")) {
            return false;
        }
        if (this.canUsePasswordFeatures(bUser)) {
            BAbsTime bAbsTime;
            BUserPasswordConfiguration[] bUserPasswordConfigurationArray;
            Class clazz = class$com$tridium$user$BUserPasswordConfiguration;
            if (clazz == null) {
                clazz = class$com$tridium$user$BUserPasswordConfiguration = BUserService.class("[Lcom.tridium.user.BUserPasswordConfiguration;", false);
            }
            if ((bUserPasswordConfigurationArray = (BUserPasswordConfiguration[])bUser.getChildren(clazz)).length > 0 && !(bAbsTime = bUserPasswordConfigurationArray[0].getExpiration()).isNull() && bAbsTime.isBefore(BAbsTime.now())) {
                return false;
            }
        }
        return true;
    }

    public static void checkStrongPassword(String string) throws Exception {
        BUserService bUserService = null;
        try {
            bUserService = (BUserService)Sys.getService(TYPE);
        }
        catch (Exception exception) {
            bUserService = null;
        }
        if (bUserService != null) {
            bUserService.checkPassword(string);
            return;
        }
        log.warning("The static call to checkStrongPassword has been deprecated!\nUpdate to use the user service instance method checkPassword!");
        BUserService.checkLegacyPassword(string);
    }

    public void checkPassword(String string) throws Exception {
        Version version = (Version)this.fw(404, "baja", null, null, null);
        if (version.compareTo(PASSWORD_STRENGTH_VERSION) >= 0) {
            this.getPasswordStrength().isPasswordValid(string);
        } else {
            if (!this.getRequireStrongPasswords()) {
                return;
            }
            BUserService.checkLegacyPassword(string);
        }
    }

    public boolean isDuplicatePassword(String string, BUser bUser) throws Exception {
        if (this.canUsePasswordFeatures(bUser)) {
            BUserPasswordConfiguration bUserPasswordConfiguration = this.getUserPasswordConfig(bUser);
            BUserServicePasswordConfiguration bUserServicePasswordConfiguration = this.getPasswordConfig();
            if (bUserPasswordConfiguration != null) {
                BPasswordHistory bPasswordHistory = bUserPasswordConfiguration.getPasswordHistory();
                int n = bUserServicePasswordConfiguration != null ? bUserServicePasswordConfiguration.getPasswordHistoryLength() : bPasswordHistory.getSize();
                if (bPasswordHistory.contains(bUser.getName(), BPassword.make(string, "plain/text"), n)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static final void checkLegacyPassword(String string) throws Exception {
        if (string.length() < 8) {
            throw new LocalizableException("baja", "user.strongPassword.tooShort");
        }
        boolean bl = true;
        int n = 0;
        while (n < string.length()) {
            if (!Character.isLetter(string.charAt(n))) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            throw new LocalizableException("baja", "user.strongPassword.allAlpha");
        }
    }

    public boolean canUsePasswordFeatures(BUser bUser) {
        return true;
    }

    public BUserPasswordConfiguration getUserPasswordConfig(BUser bUser) {
        Object[] objectArray;
        Class clazz = class$com$tridium$user$BUserPasswordConfiguration;
        if (clazz == null) {
            clazz = class$com$tridium$user$BUserPasswordConfiguration = BUserService.class("[Lcom.tridium.user.BUserPasswordConfiguration;", false);
        }
        if ((objectArray = bUser.getChildren(clazz)).length > 0) {
            return (BUserPasswordConfiguration)objectArray[0];
        }
        return null;
    }

    public BUserServicePasswordConfiguration getPasswordConfig() {
        Object[] objectArray;
        Class clazz = class$com$tridium$user$BUserServicePasswordConfiguration;
        if (clazz == null) {
            clazz = class$com$tridium$user$BUserServicePasswordConfiguration = BUserService.class("[Lcom.tridium.user.BUserServicePasswordConfiguration;", false);
        }
        if ((objectArray = this.getChildren(clazz)).length > 0) {
            return (BUserServicePasswordConfiguration)objectArray[0];
        }
        return null;
    }

    public final void auditLoginAttempt(boolean bl, BUser bUser, Context context) {
        if (context == null) {
            return;
        }
        try {
            Auditor auditor = Sys.getAuditor();
            if (auditor != null) {
                BFacets bFacets = context.getFacets();
                auditor.audit(new AuditEvent(bl ? "Login" : "Login Failure", bFacets.gets("target", ""), bFacets.gets("slotName", ""), bFacets.gets("oldValue", ""), bl ? "" : Integer.toString(bUser.authFailTimes.size()), bUser.getUsername()));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void checkAdd(String string, BValue bValue, int n, BFacets bFacets, Context context) {
        if (bValue instanceof BUser && ((BUser)bValue).getPermissions().isSuperUser() && context != null && context.getUser() != null && !context.getUser().getPermissions().isSuperUser()) {
            throw new LocalizableRuntimeException("wbutil", "superUser.canNotCreateSuperuser");
        }
        super.checkAdd(string, bValue, n, bFacets, context);
    }

    public void checkRename(Property property, String string, Context context) {
        BValue bValue = this.get(property);
        if (bValue instanceof BUser && ((BUser)bValue).getPermissions().isSuperUser() && context != null && context.getUser() != null && !context.getUser().getPermissions().isSuperUser()) {
            throw new LocalizableRuntimeException("wbutil", "superUser.canNotRenameSuperuser");
        }
        super.checkRename(property, string, context);
    }

    public synchronized void addPermissionsManager(PermissionsManager permissionsManager) {
        if (this.permissionsManagers.length == 0) {
            this.permissionsManagers = new PermissionsManager[]{permissionsManager};
        } else {
            Array array = new Array((Object[])this.permissionsManagers);
            array.add((Object)permissionsManager);
            this.permissionsManagers = (PermissionsManager[])array.trim();
        }
    }

    public synchronized void removePermissionsManager(PermissionsManager permissionsManager) {
        Array array = new Array((Object[])this.permissionsManagers);
        array.remove((Object)permissionsManager);
        this.permissionsManagers = (PermissionsManager[])array.trim();
    }

    public synchronized PermissionsManager[] getPermissionsManagers() {
        return this.permissionsManagers;
    }

    public void setModified(BUser bUser) {
        this.monitor.setModified(bUser);
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (this.monitor != null) {
            this.monitor.fw(n, object, object2, object3, object4);
        }
        return super.fw(n, object, object2, object3, object4);
    }

    public final BAuthAgent getAuthAgent(Type type) {
        BAuthAgent bAuthAgent = null;
        AgentList agentList = Sys.getRegistry().getSpecificAgents(this.getType().getTypeInfo());
        if (agentList == null || agentList.size() == 0) {
            log.error(this.getType().toString() + " does not have an associated AuthAgent.");
            return null;
        }
        if ((agentList = agentList.filter(AgentFilter.is(type))) == null || agentList.size() == 0) {
            log.error(this.getType().toString() + " does not have an associated AuthAgent.");
            return null;
        }
        AgentInfo agentInfo = agentList.get(0);
        bAuthAgent = (BAuthAgent)agentInfo.getInstance();
        return bAuthAgent;
    }

    private final void checkUsersForPbkdf2PasswordConversion() {
        boolean bl = false;
        log.trace("checking passwords for pbkdf2 format in user service");
        Class clazz = class$javax$baja$user$BUser;
        if (clazz == null) {
            clazz = class$javax$baja$user$BUser = BUserService.class("[Ljavax.baja.user.BUser;", false);
        }
        BUser[] bUserArray = (BUser[])this.getChildren(clazz);
        int n = 0;
        while (n < bUserArray.length) {
            if (bUserArray[n].convertToPbkdf2Password()) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            try {
                Station.saveAsync(null);
            }
            catch (Exception exception) {}
        }
        log.trace("check for pbkdf2 password conversion in user service completed");
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.monitor = new UserMonitor(this);
        this.permissionsManagers = new PermissionsManager[0];
    }

    public BUserService() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$user$BUserService;
        if (clazz == null) {
            clazz = class$javax$baja$user$BUserService = BUserService.class("[Ljavax.baja.user.BUserService;", false);
        }
        TYPE = Sys.loadType(clazz);
        serviceTypes = new Type[]{TYPE};
        icon = BIcon.std("user.png");
        PASSWORD_STRENGTH_VERSION = new Version("3.7.30");
        httpHandler = new HttpCredentialsHandler();
        log = Log.getLog("sys.service");
    }

    public static class HttpCredentialsHandler {
        public BUser processCredentials(BHttpFoxCredentials bHttpFoxCredentials, String string) {
            throw new UnsupportedOperationException("Method not implemented");
        }
    }
}

