/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.units;

import com.tridium.sys.Nre;
import java.io.InputStream;
import javax.baja.log.Log;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class UnitDatabase {
    private static UnitDatabase db;
    private Quantity[] quantities;

    public static BUnit getUnit(String string) {
        UnitDatabase.getDefault();
        return BUnit.getUnit(string);
    }

    public static UnitDatabase getDefault() {
        if (db == null) {
            db = new UnitDatabase();
            try {
                db.load();
            }
            catch (Exception exception) {
                Log.getLog("sys.unitdb").error("Cannot load database", exception);
            }
        }
        return db;
    }

    public Quantity[] getQuantities() {
        Quantity[] quantityArray = new Quantity[this.quantities.length];
        System.arraycopy(this.quantities, 0, quantityArray, 0, quantityArray.length);
        return quantityArray;
    }

    public Quantity getQuantity(BUnit bUnit) {
        return bUnit.quantity;
    }

    public void dump() {
        Quantity[] quantityArray = this.getQuantities();
        int n = 0;
        while (n < quantityArray.length) {
            System.out.println(quantityArray[n].getName());
            BUnit[] bUnitArray = quantityArray[n].getUnits();
            int n2 = 0;
            while (n2 < bUnitArray.length) {
                System.out.println("   " + bUnitArray[n2].encodeToString());
                ++n2;
            }
            ++n;
        }
    }

    private final void load() throws Exception {
        XElem xElem = XParser.make((InputStream)Nre.bootEnv.read("/lib/units.xml")).parse();
        XElem[] xElemArray = xElem.elems("quantity");
        this.quantities = new Quantity[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            String string = xElemArray[n].get("n");
            BDimension bDimension = null;
            try {
                bDimension = (BDimension)BDimension.DEFAULT.decodeFromString(xElemArray[n].get("dim"));
            }
            catch (Exception exception) {
                throw new Exception("Error parsing quanitity \"" + string + "\" [line " + xElemArray[n].line() + "] " + exception);
            }
            XElem[] xElemArray2 = xElemArray[n].elems("unit");
            BUnit[] bUnitArray = new BUnit[xElemArray2.length];
            int n2 = 0;
            while (n2 < xElemArray2.length) {
                bUnitArray[n2] = this.parseUnit(bDimension, xElemArray2[n2]);
                ++n2;
            }
            this.quantities[n] = new Quantity(string, bDimension, bUnitArray);
            n2 = 0;
            while (n2 < bUnitArray.length) {
                if (bUnitArray[n2] != null) {
                    bUnitArray[n2].quantity = this.quantities[n];
                }
                ++n2;
            }
            ++n;
        }
    }

    private final BUnit parseUnit(BDimension bDimension, XElem xElem) throws Exception {
        String string = xElem.get("n");
        try {
            String string2 = xElem.get("s", null);
            double d = 1.0;
            String string3 = xElem.get("scale", null);
            if (string3 != null) {
                d = Double.parseDouble(string3);
            }
            double d2 = 0.0;
            String string4 = xElem.get("offset", null);
            if (string4 != null) {
                d2 = Double.parseDouble(string4);
            }
            boolean bl = false;
            String string5 = xElem.get("prefix", null);
            if (string5 != null) {
                bl = string5.equalsIgnoreCase("true");
            }
            return BUnit.make(string, string2, bDimension, d, d2, bl);
        }
        catch (Exception exception) {
            Log.getLog("sys.unitdb").warning("Error parsing unit \"" + string + "\" [line " + xElem.line() + "] ", exception);
            return null;
        }
    }

    public static class Quantity {
        final String name;
        final BDimension dim;
        final BUnit[] units;

        public String getName() {
            return this.name;
        }

        public BUnit[] getUnits() {
            BUnit[] bUnitArray = new BUnit[this.units.length];
            System.arraycopy(this.units, 0, bUnitArray, 0, bUnitArray.length);
            return bUnitArray;
        }

        public String toString() {
            return this.name + " (" + this.dim + ')';
        }

        Quantity(String string, BDimension bDimension, BUnit[] bUnitArray) {
            this.name = string;
            this.dim = bDimension;
            this.units = bUnitArray;
        }
    }
}

