/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.units;

import com.tridium.sys.Nre;
import java.io.InputStream;
import java.util.HashMap;
import javax.baja.log.Log;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BUnitConversion
extends BFrozenEnum {
    public static final int NONE = 0;
    public static final int METRIC = 1;
    public static final int ENGLISH = 2;
    public static final BUnitConversion none = new BUnitConversion(0);
    public static final BUnitConversion metric = new BUnitConversion(1);
    public static final BUnitConversion english = new BUnitConversion(2);
    public static final Type TYPE;
    public static final BUnitConversion DEFAULT;
    static HashMap byMetric;
    static HashMap byEnglish;
    static boolean loaded;
    static /* synthetic */ Class class$javax$baja$units$BUnitConversion;

    public final Type getType() {
        return TYPE;
    }

    public static final BUnitConversion make(int n) {
        return (BUnitConversion)none.getRange().get(n, false);
    }

    public static final BUnitConversion make(String string) {
        return (BUnitConversion)none.getRange().get(string);
    }

    public final BUnit getDesiredUnit(BUnit bUnit) {
        BUnit bUnit2;
        if (bUnit == null) {
            return null;
        }
        if (this == none) {
            return bUnit;
        }
        if (!loaded) {
            BUnitConversion.load();
        }
        if (this == metric) {
            BUnit bUnit3 = (BUnit)byEnglish.get(bUnit.getUnitName());
            if (bUnit3 != null) {
                return bUnit3;
            }
        } else if (this == english && (bUnit2 = (BUnit)byMetric.get(bUnit.getUnitName())) != null) {
            return bUnit2;
        }
        return bUnit;
    }

    static final void load() {
        if (loaded) {
            return;
        }
        loaded = true;
        try {
            XElem xElem = XParser.make((InputStream)Nre.bootEnv.read("/lib/unitConversion.xml")).parse();
            XElem[] xElemArray = xElem.elems();
            int n = 0;
            while (n < xElemArray.length) {
                XElem xElem2 = xElemArray[n];
                try {
                    BUnit bUnit = UnitDatabase.getUnit(xElem2.get("metric"));
                    BUnit bUnit2 = UnitDatabase.getUnit(xElem2.get("english"));
                    byMetric.put(bUnit.getUnitName(), bUnit2);
                    byEnglish.put(bUnit2.getUnitName(), bUnit);
                }
                catch (Exception exception) {
                    Log.getLog("sys.unitConversion").warning("Parsing convert [line " + xElem2.line() + ']', exception);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Log.getLog("sys.unitConversion").error("Error parsing unitConversion.xml", exception);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BUnitConversion(int n) {
        super(n);
    }

    static {
        Class clazz = class$javax$baja$units$BUnitConversion;
        if (clazz == null) {
            clazz = class$javax$baja$units$BUnitConversion = BUnitConversion.class("[Ljavax.baja.units.BUnitConversion;", false);
        }
        TYPE = Sys.loadType(clazz);
        DEFAULT = none;
        byMetric = new HashMap();
        byEnglish = new HashMap();
        loaded = false;
    }
}

