/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.units;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.UnitDatabase;
import javax.baja.units.UnitDifferentialConverter;
import javax.baja.units.UnitException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BUnit
extends BSimple
implements BIDataValue {
    private static final HashMap cache = new HashMap();
    public static final BUnit NULL;
    public static final BUnit DEFAULT;
    public static final Type TYPE;
    private BDimension dimension;
    private String unitName;
    private String symbol;
    private double scale;
    private double offset;
    private String string;
    private boolean prefix;
    UnitDatabase.Quantity quantity;
    static /* synthetic */ Class class$javax$baja$units$BUnit;

    public static final BUnit getUnit(String string) {
        BUnit bUnit = (BUnit)cache.get(string);
        if (bUnit == null) {
            UnitDatabase.getDefault();
            bUnit = (BUnit)cache.get(string);
            if (bUnit == null) {
                throw new UnitException("Unknown unit: " + string);
            }
        }
        return bUnit;
    }

    public static final BUnit make(String string, BDimension bDimension) {
        return BUnit.make(string, null, bDimension, 1.0, 0.0);
    }

    public static final BUnit make(String string, String string2, BDimension bDimension) {
        return BUnit.make(string, string2, bDimension, 1.0, 0.0);
    }

    public static final BUnit make(String string, String string2, BDimension bDimension, double d) {
        return BUnit.make(string, string2, bDimension, d, 0.0);
    }

    public static final BUnit make(String string, BDimension bDimension, double d) {
        return BUnit.make(string, null, bDimension, d, 0.0);
    }

    public static final BUnit make(String string, String string2, BDimension bDimension, double d, double d2) {
        return BUnit.make(string, string2, bDimension, d, d2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final BUnit make(String string, String string2, BDimension bDimension, double d, double d2, boolean bl) {
        if (string == null || bDimension == null) {
            throw new NullPointerException();
        }
        if (string.indexOf(59) >= 0) {
            throw new UnitException("Invalid unitName: " + string);
        }
        if (string2 == null) {
            string2 = string;
        } else if (string2.indexOf(59) >= 0) {
            throw new UnitException("Invalid symbol: " + string2);
        }
        HashMap hashMap = cache;
        synchronized (hashMap) {
            BUnit bUnit = (BUnit)cache.get(string);
            if (bUnit == null) {
                bUnit = new BUnit();
                bUnit.unitName = string;
                bUnit.symbol = string2;
                bUnit.dimension = bDimension;
                bUnit.scale = d;
                bUnit.offset = d2;
                bUnit.prefix = bl;
                cache.put(string, bUnit);
                return bUnit;
            }
            if (!bUnit.dimension.equals(bDimension)) {
                throw new UnitException("Duplicate unit is incompatible: " + string);
            }
            return bUnit;
        }
    }

    public final BDimension getDimension() {
        return this.dimension;
    }

    public final String getUnitName() {
        return this.unitName;
    }

    public final String getUnitName(Context context) {
        return this.unitName;
    }

    public final String getSymbol() {
        return this.symbol;
    }

    public final String getSymbol(Context context) {
        return this.symbol;
    }

    public final double getScale() {
        return this.scale;
    }

    public final double getOffset() {
        return this.offset;
    }

    public final boolean getIsPrefix() {
        return this.prefix;
    }

    public final boolean isConvertible(BUnit bUnit) {
        return this.dimension.equals(bUnit.dimension);
    }

    public final double toNormal(double d) {
        return d * this.scale + this.offset;
    }

    public final double fromNormal(double d) {
        return (d - this.offset) / this.scale;
    }

    public final double convertTo(BUnit bUnit, double d) {
        if (!this.dimension.equals(bUnit.dimension)) {
            throw new UnitException("Not convertible: " + this + " -> " + bUnit);
        }
        return (d * this.scale + this.offset - bUnit.offset) / bUnit.scale;
    }

    public final BUnit getDifferentialUnit() {
        return UnitDifferentialConverter.getInstance().getDifferential(this);
    }

    public final BUnit getAbsoluteUnit() {
        return UnitDifferentialConverter.getInstance().getAbsolute(this);
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this == NULL) {
            bl = true;
        }
        return bl;
    }

    public final String toString(Context context) {
        return this.getSymbol(context);
    }

    public final int hashCode() {
        return this.unitName.hashCode();
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        }
        return bl;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.unitName).append(';');
            if (this.symbol != this.unitName) {
                stringBuffer.append(this.symbol);
            }
            stringBuffer.append(';');
            stringBuffer.append(this.dimension.encodeToString()).append(';');
            if (this.scale != 1.0) {
                stringBuffer.append('*').append(this.scale);
            }
            if (this.offset != 0.0) {
                stringBuffer.append('+').append(this.offset);
            }
            stringBuffer.append(';');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            int n = 0;
            int n2 = string.indexOf(59);
            String string2 = string.substring(n, n2);
            n = n2;
            n2 = string.indexOf(59, n2 + 1);
            String string3 = n + 1 == n2 ? null : string.substring(n + 1, n2);
            n = n2;
            n2 = string.indexOf(59, n2 + 1);
            BDimension bDimension = (BDimension)this.dimension.decodeFromString(string.substring(n + 1, n2));
            n = n2;
            n2 = string.indexOf(59, n2 + 1);
            String string4 = string.substring(n + 1, n2);
            double d = 1.0;
            double d2 = 0.0;
            int n3 = string4.length();
            if (n3 > 0) {
                int n4 = 0;
                if (string4.charAt(0) == '*') {
                    n4 = string4.indexOf(43);
                    if (n4 < 0) {
                        n4 = n3;
                    }
                    d = Double.parseDouble(string4.substring(1, n4));
                }
                if (n4 < n3 && string4.charAt(n4) == '+') {
                    d2 = Double.parseDouble(string4.substring(n4 + 1, n3));
                }
            }
            return BUnit.make(string2, string3, bDimension, d, d2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IOException(string);
        }
    }

    public final BIDataValue toDataValue() {
        return this;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BUnit() {
    }

    static {
        DEFAULT = NULL = BUnit.make("null", BDimension.DEFAULT);
        Class clazz = class$javax$baja$units$BUnit;
        if (clazz == null) {
            clazz = class$javax$baja$units$BUnit = BUnit.class("[Ljavax.baja.units.BUnit;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

