/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.timezone;

import com.tridium.timezone.HistoricalDstRule;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DstRule {
    public static final int UNDEFINED = -1;
    public static final short WALL_TIME = 0;
    public static final short STANDARD_TIME = 1;
    public static final short UTC_TIME = 2;
    public static final int WEEKDAY = -1;
    public static final short EXACT = 0;
    public static final short ON_OR_AFTER = 1;
    public static final short ON_OR_BEFORE = 2;
    public static final short FIRST = 0;
    public static final short SECOND = 1;
    public static final short THIRD = 2;
    public static final short FOURTH = 3;
    public static final short FIFTH = 4;
    public static final short LAST = 5;
    public static final int START = 0;
    public static final int END = 1;
    private int cacheYear;
    private int cacheBoundary;
    private BTimeZone cacheTimeZone;
    private BAbsTime cachedTime;
    private BTime timeOfDay;
    private int timeMode;
    private BMonth month;
    private int day;
    private int dayMode;
    private BWeekday weekday;
    private int week;

    public static final Object fw(int n, Object object) {
        if (n == 1103 && object != null) {
            return DstRule.makeFromHistorical((HistoricalDstRule)object);
        }
        return null;
    }

    private static final DstRule makeFromHistorical(HistoricalDstRule historicalDstRule) {
        short s = historicalDstRule.getOccursOnAnnualDate().getTheDay().getDayExpressedAs();
        short s2 = historicalDstRule.getOccursOnAnnualDate().getTheDay().getCalendarDay();
        if (s == 0 && s2 != 0) {
            return DstRule.makeExact(historicalDstRule.getOccursOnAnnualDate().getTheTimeOfDay(), historicalDstRule.getOccursOnAnnualDate().getTheTimeOfDayIsExpressedAs(), historicalDstRule.getOccursOnAnnualDate().getTheMonth(), historicalDstRule.getOccursOnAnnualDate().getTheDay().getCalendarDay());
        }
        if (s == 1 && s2 != 0) {
            return DstRule.makeOnOrAfter(historicalDstRule.getOccursOnAnnualDate().getTheTimeOfDay(), historicalDstRule.getOccursOnAnnualDate().getTheTimeOfDayIsExpressedAs(), historicalDstRule.getOccursOnAnnualDate().getTheMonth(), historicalDstRule.getOccursOnAnnualDate().getTheDay().getCalendarDay(), historicalDstRule.getOccursOnAnnualDate().getTheDay().getDayOfWeek());
        }
        if (s == 2 && s2 != 0) {
            return DstRule.makeOnOrBefore(historicalDstRule.getOccursOnAnnualDate().getTheTimeOfDay(), historicalDstRule.getOccursOnAnnualDate().getTheTimeOfDayIsExpressedAs(), historicalDstRule.getOccursOnAnnualDate().getTheMonth(), historicalDstRule.getOccursOnAnnualDate().getTheDay().getCalendarDay(), historicalDstRule.getOccursOnAnnualDate().getTheDay().getDayOfWeek());
        }
        if (s == 0 || s == 1 || s == 2 || s == 3 || s == 4 || s == 5) {
            return DstRule.makeWeekday(historicalDstRule.getOccursOnAnnualDate().getTheTimeOfDay(), historicalDstRule.getOccursOnAnnualDate().getTheTimeOfDayIsExpressedAs(), historicalDstRule.getOccursOnAnnualDate().getTheDay().getDayExpressedAs(), historicalDstRule.getOccursOnAnnualDate().getTheDay().getDayOfWeek(), historicalDstRule.getOccursOnAnnualDate().getTheMonth());
        }
        return null;
    }

    public static final DstRule makeExact(BTime bTime, BMonth bMonth, int n) {
        return DstRule.makeExact(bTime, 0, bMonth, n);
    }

    public static final DstRule makeExact(BTime bTime, int n, BMonth bMonth, int n2) {
        DstRule dstRule = new DstRule();
        dstRule.timeOfDay = bTime;
        dstRule.timeMode = n;
        dstRule.month = bMonth;
        dstRule.day = n2;
        dstRule.dayMode = 0;
        dstRule.weekday = null;
        dstRule.week = -1;
        return dstRule;
    }

    public static final DstRule makeWeekday(BTime bTime, int n, BWeekday bWeekday, BMonth bMonth) {
        return DstRule.makeWeekday(bTime, 0, n, bWeekday, bMonth);
    }

    public static final DstRule makeWeekday(BTime bTime, int n, int n2, BWeekday bWeekday, BMonth bMonth) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid time mode: " + n);
        }
        DstRule dstRule = new DstRule();
        dstRule.timeOfDay = bTime;
        dstRule.timeMode = n;
        dstRule.month = bMonth;
        dstRule.weekday = bWeekday;
        dstRule.week = n2;
        dstRule.day = 0;
        dstRule.dayMode = -1;
        return dstRule;
    }

    public static final DstRule makeOnOrAfter(BTime bTime, BMonth bMonth, int n, BWeekday bWeekday) {
        return DstRule.makeOnOrAfter(bTime, 0, bMonth, n, bWeekday);
    }

    public static final DstRule makeOnOrAfter(BTime bTime, int n, BMonth bMonth, int n2, BWeekday bWeekday) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid time mode: " + n);
        }
        DstRule dstRule = new DstRule();
        dstRule.timeOfDay = bTime;
        dstRule.timeMode = n;
        dstRule.month = bMonth;
        dstRule.day = n2;
        dstRule.dayMode = 1;
        dstRule.weekday = bWeekday;
        dstRule.week = -1;
        return dstRule;
    }

    public static final DstRule makeOnOrBefore(BTime bTime, BMonth bMonth, int n, BWeekday bWeekday) {
        return DstRule.makeOnOrBefore(bTime, 0, bMonth, n, bWeekday);
    }

    public static final DstRule makeOnOrBefore(BTime bTime, int n, BMonth bMonth, int n2, BWeekday bWeekday) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid time mode: " + n);
        }
        DstRule dstRule = new DstRule();
        dstRule.timeOfDay = bTime;
        dstRule.timeMode = n;
        dstRule.month = bMonth;
        dstRule.day = n2;
        dstRule.dayMode = 2;
        dstRule.weekday = bWeekday;
        dstRule.week = -1;
        return dstRule;
    }

    public final BTime getTime() {
        return this.timeOfDay;
    }

    public final int getTimeMode() {
        return this.timeMode;
    }

    public final int getWeek() {
        return this.week;
    }

    public final BWeekday getWeekday() {
        return this.weekday;
    }

    public final BMonth getMonth() {
        return this.month;
    }

    public final int getDay() {
        return this.day;
    }

    public final int getDayMode() {
        return this.dayMode;
    }

    public final synchronized BAbsTime getTime(int n, BTimeZone bTimeZone, int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Invalid boundary: " + n2);
        }
        if (this.cacheYear == n && bTimeZone.equals(this.cacheTimeZone) && this.cacheBoundary == n2) {
            return this.cachedTime;
        }
        this.cacheYear = n;
        this.cacheTimeZone = bTimeZone;
        this.cacheBoundary = n2;
        this.cachedTime = this.calculateTime(n, bTimeZone, n2);
        return this.cachedTime;
    }

    private final BAbsTime calculateTime(int n, BTimeZone bTimeZone, int n2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
        gregorianCalendar.clear();
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(2, this.month.getOrdinal());
        if (this.dayMode == -1) {
            if (this.week == 5 || this.week == 4) {
                gregorianCalendar.set(5, BAbsTime.getDaysInMonth(n, this.month));
                gregorianCalendar.setLenient(false);
                while (gregorianCalendar.get(7) != this.weekday.getOrdinal() + 1) {
                    ((Calendar)gregorianCalendar).add(5, -1);
                }
            } else {
                int n3;
                if (this.week == 0) {
                    n3 = 1;
                } else if (this.week == 1) {
                    n3 = 8;
                } else if (this.week == 2) {
                    n3 = 15;
                } else if (this.week == 3) {
                    n3 = 22;
                } else {
                    throw new IllegalArgumentException("Invalid week: " + this.week);
                }
                gregorianCalendar.set(5, n3);
                gregorianCalendar.setLenient(false);
                while (gregorianCalendar.get(7) != this.weekday.getOrdinal() + 1) {
                    ((Calendar)gregorianCalendar).add(5, 1);
                }
            }
        } else if (this.dayMode == 0) {
            gregorianCalendar.set(5, this.day);
        } else if (this.dayMode == 1 || this.dayMode == 2) {
            gregorianCalendar.set(5, this.day);
            gregorianCalendar.setLenient(false);
            while (gregorianCalendar.get(7) != this.weekday.getOrdinal() + 1) {
                if (this.dayMode == 1) {
                    ((Calendar)gregorianCalendar).add(5, 1);
                    continue;
                }
                ((Calendar)gregorianCalendar).add(5, -1);
            }
        } else {
            throw new IllegalStateException("Cannot compute dst rule time.");
        }
        gregorianCalendar.set(11, this.timeOfDay.getHour());
        gregorianCalendar.set(12, this.timeOfDay.getMinute());
        gregorianCalendar.set(13, this.timeOfDay.getSecond());
        gregorianCalendar.set(14, this.timeOfDay.getSecond());
        if (this.timeMode == 2) {
            return BAbsTime.make(gregorianCalendar.getTimeInMillis(), bTimeZone);
        }
        if (this.timeMode == 1) {
            return BAbsTime.make(gregorianCalendar.getTimeInMillis() - (long)bTimeZone.getUtcOffset(gregorianCalendar.getTimeInMillis()), bTimeZone);
        }
        if (this.timeMode == 0) {
            long l = gregorianCalendar.getTimeInMillis() - (long)bTimeZone.getUtcOffset(gregorianCalendar.getTimeInMillis());
            if (n2 == 1) {
                l -= (long)bTimeZone.getDaylightAdjustment(gregorianCalendar.getTimeInMillis());
            }
            return BAbsTime.make(l, bTimeZone);
        }
        throw new IllegalArgumentException("Invalid time mode: " + this.timeMode);
    }

    public static final DstRule getWallTimeRule(DstRule dstRule, int n, BTimeZone bTimeZone) {
        return dstRule == null ? null : dstRule.asWallTimeRule(n, bTimeZone);
    }

    private final TimeZone getJavaTimeZone(long l) {
        if (l == 0L) {
            return BTimeZone.getJavaUTCInstance();
        }
        StringBuffer stringBuffer = new StringBuffer("GMT");
        if (l > 0L) {
            stringBuffer.append('+');
        }
        stringBuffer.append(String.valueOf(l / 3600000L));
        stringBuffer.append(":00");
        TimeZone timeZone = TimeZone.getTimeZone(stringBuffer.toString());
        if (timeZone == null) {
            return new SimpleTimeZone((int)l, stringBuffer.toString());
        }
        return timeZone;
    }

    public final DstRule asWallTimeRule(int n, BTimeZone bTimeZone) {
        GregorianCalendar gregorianCalendar;
        block57: {
            block56: {
                if (this.getTimeMode() == 0) {
                    return this;
                }
                if (this.getTimeMode() == 1 && n == 0) {
                    DstRule dstRule = new DstRule();
                    dstRule.timeOfDay = this.timeOfDay;
                    dstRule.timeMode = 0;
                    dstRule.month = this.month;
                    dstRule.day = this.day;
                    dstRule.dayMode = this.dayMode;
                    dstRule.weekday = this.weekday;
                    dstRule.week = this.week;
                    return dstRule;
                }
                gregorianCalendar = this.getTimeMode() == 2 ? new GregorianCalendar(BTimeZone.getJavaUTCInstance()) : new GregorianCalendar(this.getJavaTimeZone(bTimeZone.getUtcOffset()));
                int n2 = gregorianCalendar.get(1);
                gregorianCalendar.clear();
                gregorianCalendar.set(1, n2);
                gregorianCalendar.set(2, this.getMonth().getOrdinal());
                gregorianCalendar.setLenient(false);
                if (this.getDayMode() != -1) break block56;
                switch (this.getWeek()) {
                    case 0: {
                        gregorianCalendar.set(5, 1);
                        while (gregorianCalendar.get(7) != this.getWeekday().getOrdinal() + 1) {
                            ((Calendar)gregorianCalendar).add(5, 1);
                        }
                        break block57;
                    }
                    case 1: {
                        gregorianCalendar.set(5, 8);
                        while (gregorianCalendar.get(7) != this.getWeekday().getOrdinal() + 1) {
                            ((Calendar)gregorianCalendar).add(5, 1);
                        }
                        break block57;
                    }
                    case 2: {
                        gregorianCalendar.set(5, 15);
                        while (gregorianCalendar.get(7) != this.getWeekday().getOrdinal() + 1) {
                            ((Calendar)gregorianCalendar).add(5, 1);
                        }
                        break block57;
                    }
                    case 3: {
                        gregorianCalendar.set(5, 22);
                        while (gregorianCalendar.get(7) != this.getWeekday().getOrdinal() + 1) {
                            ((Calendar)gregorianCalendar).add(5, 1);
                        }
                        break block57;
                    }
                    case 4: 
                    case 5: {
                        gregorianCalendar.set(5, ((Calendar)gregorianCalendar).getActualMaximum(5));
                        while (gregorianCalendar.get(7) != this.getWeekday().getOrdinal() + 1) {
                            ((Calendar)gregorianCalendar).add(5, -1);
                        }
                        break block57;
                    }
                }
                break block57;
            }
            switch (this.getDayMode()) {
                case 0: {
                    gregorianCalendar.set(5, this.getDay());
                    break;
                }
                case 1: {
                    gregorianCalendar.set(5, this.getDay());
                    while (gregorianCalendar.get(7) != this.getWeekday().getOrdinal() + 1) {
                        ((Calendar)gregorianCalendar).add(5, 1);
                    }
                    break;
                }
                case 2: {
                    gregorianCalendar.set(5, this.getDay());
                    while (gregorianCalendar.get(7) != this.getWeekday().getOrdinal() + 1) {
                        ((Calendar)gregorianCalendar).add(5, -1);
                    }
                    break;
                }
            }
        }
        gregorianCalendar.set(11, this.getTime().getHour());
        gregorianCalendar.set(12, this.getTime().getMinute());
        gregorianCalendar.set(13, this.getTime().getSecond());
        gregorianCalendar.set(14, this.getTime().getMillisecond());
        int n3 = gregorianCalendar.get(5);
        int n4 = 0;
        if (1 <= n3 && n3 < 8) {
            n4 = 0;
        } else if (8 <= n3 && n3 < 15) {
            n4 = 1;
        } else if (15 <= n3 && n3 < 22) {
            n4 = 2;
        } else if (22 <= n3 && n3 < 29) {
            if (this.getWeek() != -1) {
                if (this.getWeek() == 5) {
                    n4 = 5;
                } else if (this.getWeek() == 3) {
                    n4 = 3;
                }
            } else {
                n4 = ((Calendar)gregorianCalendar).getActualMaximum(5) <= 28 ? 5 : (n3 + 7 > ((Calendar)gregorianCalendar).getActualMaximum(5) ? 5 : 3);
            }
        } else if (29 <= n3 && n3 < 32) {
            n4 = 5;
        }
        BMonth bMonth = BMonth.make(gregorianCalendar.get(2));
        long l = 0L;
        if (this.getTimeMode() == 1) {
            l = gregorianCalendar.getTime().getTime() + (long)bTimeZone.getDaylightAdjustment(gregorianCalendar.getTime().getTime());
        } else {
            l = gregorianCalendar.getTime().getTime() + (long)bTimeZone.getUtcOffset(gregorianCalendar.getTime().getTime());
            if (n == 1) {
                l += (long)bTimeZone.getDaylightAdjustment(gregorianCalendar.getTime().getTime());
            }
        }
        gregorianCalendar.setTimeInMillis(l);
        int n5 = gregorianCalendar.get(5);
        BWeekday bWeekday = BWeekday.make(gregorianCalendar.get(7) - 1);
        int n6 = 0;
        if (1 <= n5 && n5 < 8) {
            n6 = 0;
        } else if (8 <= n5 && n5 < 15) {
            n6 = 1;
        } else if (15 <= n5 && n5 < 22) {
            n6 = 2;
        } else if (22 <= n5 && n5 < 29) {
            n6 = ((Calendar)gregorianCalendar).getActualMaximum(5) <= 28 ? 5 : (n5 + 7 > ((Calendar)gregorianCalendar).getActualMaximum(5) ? 5 : 3);
        } else if (29 <= n5 && n5 < 32) {
            n6 = 5;
        }
        BMonth bMonth2 = BMonth.make(gregorianCalendar.get(2));
        if (n3 != n5) {
            if (!bMonth.equals(bMonth2)) {
                return null;
            }
            if (this.getDayMode() != 0) {
                if (this.getDayMode() == 1) {
                    return null;
                }
                if (this.getDayMode() == 2) {
                    return null;
                }
                if (n6 != n4) {
                    return null;
                }
                return null;
            }
        }
        if (this.getDayMode() == -1) {
            return DstRule.makeWeekday(BTime.make(gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(14)), 0, n6, bWeekday, bMonth2);
        }
        if (this.getDayMode() == 0) {
            return DstRule.makeExact(BTime.make(gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(14)), 0, bMonth2, n5);
        }
        if (this.getDayMode() == 2) {
            return DstRule.makeOnOrBefore(BTime.make(gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(14)), 0, this.month, this.day, this.weekday);
        }
        return DstRule.makeOnOrAfter(BTime.make(gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(14)), 0, this.month, this.day, this.weekday);
    }

    public static final DstRule asWeekdayRule(DstRule dstRule) throws TimeZoneException {
        if (dstRule == null) {
            return dstRule;
        }
        if (dstRule.getDayMode() == -1) {
            return dstRule;
        }
        if (dstRule.getDayMode() == 0) {
            throw new TimeZoneException("Can't convert rule from exact to nth weekday");
        }
        int n = dstRule.getDay();
        int n2 = 0;
        if (dstRule.getDayMode() == 1) {
            switch (n) {
                case 1: {
                    n2 = 0;
                    break;
                }
                case 8: {
                    n2 = 1;
                    break;
                }
                case 15: {
                    n2 = 2;
                    break;
                }
                case 22: {
                    n2 = 3;
                    break;
                }
                case 29: {
                    n2 = 5;
                    break;
                }
                default: {
                    throw new TimeZoneException("Day = " + n + ". Can not accurately convert from ON_OR_AFTER to NTH day");
                }
            }
        }
        if (dstRule.getDayMode() == 2) {
            switch (n) {
                case 7: {
                    n2 = 0;
                    break;
                }
                case 14: {
                    n2 = 1;
                    break;
                }
                case 21: {
                    n2 = 2;
                    break;
                }
                case 28: {
                    n2 = 3;
                    break;
                }
                default: {
                    throw new TimeZoneException("Day = " + n + ". Can not accurately convert from ON_OR_BEFORE to NTH day");
                }
            }
        }
        return DstRule.makeWeekday(dstRule.getTime(), dstRule.getTimeMode(), n2, dstRule.getWeekday(), dstRule.getMonth());
    }

    public static final boolean equals(DstRule dstRule, DstRule dstRule2) {
        if (dstRule == null) {
            boolean bl = false;
            if (dstRule2 == null) {
                bl = true;
            }
            return bl;
        }
        if (dstRule2 == null) {
            return false;
        }
        boolean bl = false;
        if (dstRule.timeOfDay.equals(dstRule2.timeOfDay) && dstRule.timeMode == dstRule2.timeMode && dstRule.month.equals(dstRule2.month) && dstRule.day == dstRule2.day && dstRule.dayMode == dstRule2.dayMode && dstRule.weekday == dstRule2.weekday && dstRule.week == dstRule2.week) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isEquivalent(DstRule dstRule, DstRule dstRule2, BTimeZone bTimeZone, int n) {
        if (dstRule == null) {
            boolean bl = false;
            if (dstRule2 == null) {
                bl = true;
            }
            return bl;
        }
        if (dstRule == dstRule2) {
            return true;
        }
        DstRule dstRule3 = null;
        DstRule dstRule4 = null;
        try {
            dstRule3 = DstRule.asWeekdayRule(dstRule);
        }
        catch (TimeZoneException timeZoneException) {
            dstRule3 = dstRule;
        }
        try {
            dstRule4 = DstRule.asWeekdayRule(dstRule2);
        }
        catch (TimeZoneException timeZoneException) {
            dstRule4 = dstRule2;
        }
        int n2 = dstRule3.week;
        int n3 = dstRule4.week;
        if (n2 == 4) {
            n2 = 5;
        }
        if (n3 == 4) {
            n3 = 5;
        }
        if (dstRule3.month.equals(dstRule4.month) && dstRule3.day == dstRule4.day && dstRule3.dayMode == dstRule4.dayMode && dstRule3.weekday == dstRule4.weekday && n2 == n3) {
            if (dstRule3.timeMode == dstRule4.timeMode && dstRule3.timeOfDay.equals(dstRule4.timeOfDay)) {
                return true;
            }
            dstRule3 = dstRule3.asWallTimeRule(n, bTimeZone);
            dstRule4 = dstRule4.asWallTimeRule(n, bTimeZone);
            boolean bl = false;
            if (dstRule3 != null && dstRule4 != null && dstRule3.timeOfDay.equals(dstRule4.timeOfDay)) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DstRule && DstRule.equals(this, (DstRule)object)) {
            bl = true;
        }
        return bl;
    }

    public final boolean isEquivalent(DstRule dstRule, BTimeZone bTimeZone, int n) {
        return DstRule.isEquivalent(this, dstRule, bTimeZone, n);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        this.timeOfDay.encode(dataOutput);
        dataOutput.writeInt(this.timeMode);
        this.month.encode(dataOutput);
        dataOutput.writeInt(this.day);
        dataOutput.writeInt(this.dayMode);
        boolean bl = false;
        if (this.weekday != null) {
            bl = true;
        }
        dataOutput.writeBoolean(bl);
        if (this.weekday != null) {
            this.weekday.encode(dataOutput);
        }
        dataOutput.writeInt(this.week);
    }

    public static final DstRule decode(DataInput dataInput) throws IOException {
        DstRule dstRule = new DstRule();
        dstRule.timeOfDay = (BTime)BTime.DEFAULT.decode(dataInput);
        dstRule.timeMode = dataInput.readInt();
        dstRule.month = (BMonth)BMonth.january.decode(dataInput);
        dstRule.day = dataInput.readInt();
        dstRule.dayMode = dataInput.readInt();
        if (dataInput.readBoolean()) {
            dstRule.weekday = (BWeekday)BWeekday.sunday.decode(dataInput);
        }
        dstRule.week = dataInput.readInt();
        return dstRule;
    }

    public final String encodeToString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this.timeOfDay.encodeToString());
        stringBuffer.append(',');
        stringBuffer.append(DstRule.encodeTimeMode(this.timeMode));
        stringBuffer.append(',');
        stringBuffer.append(this.month.encodeToString());
        stringBuffer.append(',');
        stringBuffer.append(this.day);
        stringBuffer.append(',');
        stringBuffer.append(DstRule.encodeDayMode(this.dayMode));
        stringBuffer.append(',');
        stringBuffer.append(this.weekday == null ? "null" : this.weekday.encodeToString());
        stringBuffer.append(',');
        stringBuffer.append(DstRule.encodeWeek(this.week));
        return stringBuffer.toString();
    }

    public static final DstRule decodeFromString(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        DstRule dstRule = new DstRule();
        dstRule.timeOfDay = (BTime)BTime.DEFAULT.decodeFromString(stringTokenizer.nextToken());
        dstRule.timeMode = DstRule.decodeTimeMode(stringTokenizer.nextToken());
        dstRule.month = (BMonth)BMonth.january.decodeFromString(stringTokenizer.nextToken());
        dstRule.day = Integer.parseInt(stringTokenizer.nextToken());
        dstRule.dayMode = DstRule.decodeDayMode(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        if (!string2.equals("null")) {
            dstRule.weekday = (BWeekday)BWeekday.sunday.decodeFromString(string2);
        }
        dstRule.week = DstRule.decodeWeek(stringTokenizer.nextToken());
        return dstRule;
    }

    public static final String encodeDayMode(int n) {
        switch (n) {
            case -1: {
                return "undefined";
            }
            case 0: {
                return "exact";
            }
            case 2: {
                return "on or before";
            }
            case 1: {
                return "on or after";
            }
        }
        return "invalid: " + n;
    }

    public static final int decodeDayMode(String string) {
        if (string.equals("undefined")) {
            return -1;
        }
        if (string.equals("exact")) {
            return 0;
        }
        if (string.equals("on or before")) {
            return 2;
        }
        if (string.equals("on or after")) {
            return 1;
        }
        return -1;
    }

    public static final String encodeWeek(int n) {
        switch (n) {
            case 0: {
                return "first";
            }
            case 1: {
                return "second";
            }
            case 2: {
                return "third";
            }
            case 3: {
                return "fourth";
            }
            case 4: {
                return "fifth";
            }
            case 5: {
                return "last";
            }
            case -1: {
                return "undefined";
            }
        }
        throw new IllegalArgumentException("Invalid week specification: " + n);
    }

    public static final int decodeWeek(String string) {
        if (string.equals("first")) {
            return 0;
        }
        if (string.equals("second")) {
            return 1;
        }
        if (string.equals("third")) {
            return 2;
        }
        if (string.equals("fourth")) {
            return 3;
        }
        if (string.equals("fifth")) {
            return 4;
        }
        if (string.equals("last")) {
            return 5;
        }
        if (string.equals("undefined")) {
            return -1;
        }
        throw new IllegalArgumentException("Invalid week specification: " + string);
    }

    public static final String encodeTimeMode(int n) {
        switch (n) {
            case 0: {
                return "wall";
            }
            case 1: {
                return "standard";
            }
            case 2: {
                return "utc";
            }
        }
        return "invalid: " + n;
    }

    public static final int decodeTimeMode(String string) {
        if (string.equals("wall")) {
            return 0;
        }
        if (string.equals("standard")) {
            return 1;
        }
        if (string.equals("utc")) {
            return 2;
        }
        return -1;
    }

    private final /* synthetic */ void this() {
        this.cacheYear = -1;
        this.cacheBoundary = -1;
    }

    private DstRule() {
        this.this();
    }
}

