/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.timezone;

import com.tridium.sys.Nre;
import com.tridium.timezone.HistoricalDstRule;
import com.tridium.timezone.HistoricalTimeZone;
import com.tridium.timezone.HistoricalTimeZoneDate;
import com.tridium.timezone.HistoricalTimeZoneEra;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.DstRule;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.timezone.TimeZoneException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BTimeZone
extends BSimple
implements BIDataValue {
    public static final BTimeZone UTC;
    public static final BTimeZone GMT;
    public static final BTimeZone NULL;
    public static final BTimeZone DEFAULT;
    private static SimpleTimeZone JAVA_UTC;
    private static BTimeZone localTimeZone;
    private static final Log logger;
    public static final Type TYPE;
    private String id;
    private String stringEncoding;
    private TimeZone jzone;
    private boolean isHistoricalZone;
    private String fixedStdName;
    private String fixedStdShort;
    private String fixedDstName;
    private String fixedDstShort;
    private int fixedUtcOffset;
    private int fixedDstDelta;
    private DstRule fixedStartRule;
    private DstRule fixedEndRule;
    private LinkedHashMap cachedStartTimes;
    private LinkedHashMap cachedEndTimes;
    private int hashCode;
    private ArrayList eraCache;
    private HistoricalTimeZoneEra currentlyLoadedEra;
    private long lastLoadedMillis;
    static /* synthetic */ Class class$javax$baja$timezone$BTimeZone;

    public static final BTimeZone getTimeZone(String string) {
        TimeZoneDatabase timeZoneDatabase = TimeZoneDatabase.get();
        HistoricalTimeZone historicalTimeZone = timeZoneDatabase.getHistoricalTimeZone(string);
        if (historicalTimeZone != null && historicalTimeZone.getHistoricalTimeZoneName().equals(string)) {
            return BTimeZone.makeFromHistorical(historicalTimeZone);
        }
        logger.trace("Could not find tz: " + string + " in timezones.jar, returning UTC.");
        throw new TimeZoneException("Unknown timezone: " + string);
    }

    public static final BTimeZone make(String string, int n) {
        return BTimeZone.make(string, string, string, string, string, n, 0, null, null);
    }

    public static final BTimeZone makeIgnoringCache(String string, int n) {
        return BTimeZone.makeIgnoringCache(string, string, string, string, string, n, 0, null, null);
    }

    public static final BTimeZone make(String string, int n, int n2, DstRule dstRule, DstRule dstRule2) {
        return BTimeZone.make(string, string, string, string, string, n, n2, dstRule, dstRule2);
    }

    public static final BTimeZone make(String string, String string2, String string3, String string4, String string5, int n, int n2, DstRule dstRule, DstRule dstRule2) {
        try {
            BTimeZone bTimeZone = BTimeZone.getTimeZone(string);
            if (bTimeZone != null && string.equals(bTimeZone.id)) {
                return bTimeZone;
            }
        }
        catch (TimeZoneException timeZoneException) {}
        return BTimeZone.makeIgnoringCache(string, string2, string3, string4, string5, n, n2, dstRule, dstRule2);
    }

    public static final BTimeZone makeIgnoringCache(String string, String string2, String string3, String string4, String string5, int n, int n2, DstRule dstRule, DstRule dstRule2) {
        BTimeZone bTimeZone = new BTimeZone();
        bTimeZone.id = string;
        bTimeZone.isHistoricalZone = false;
        bTimeZone.fixedUtcOffset = n;
        bTimeZone.fixedStdName = string2 == null ? string : string2;
        bTimeZone.fixedStdShort = string3 == null ? bTimeZone.fixedStdName : string3;
        bTimeZone.fixedDstName = string4 == null ? string : string4;
        bTimeZone.fixedDstShort = string5 == null ? bTimeZone.fixedDstName : string5;
        bTimeZone.fixedDstDelta = n2;
        bTimeZone.fixedStartRule = dstRule;
        bTimeZone.fixedEndRule = dstRule2;
        return bTimeZone;
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 1102 && object != null) {
            return BTimeZone.makeFromHistorical((HistoricalTimeZone)object);
        }
        if (n == 1101 && object != null) {
            Long l = (Long)object;
            return this.retrieveEraForMillis(l);
        }
        return super.fw(n, object, object2, object3, object4);
    }

    private static final BTimeZone makeFromHistorical(HistoricalTimeZone historicalTimeZone) {
        BTimeZone bTimeZone = new BTimeZone();
        bTimeZone.id = historicalTimeZone.getHistoricalTimeZoneName();
        if (historicalTimeZone.getNumberEras() == 0) {
            logger.error("cannot construct BTimeZone from HistoricalTimeZone " + historicalTimeZone.getHistoricalTimeZoneName() + " without at least one era, returning UTC");
            return UTC;
        }
        if (historicalTimeZone.getNumberEras() > 1) {
            bTimeZone.isHistoricalZone = true;
            if (bTimeZone.eraCache == null) {
                bTimeZone.eraCache = new ArrayList();
            }
            short s = 0;
            while (s < historicalTimeZone.getNumberEras()) {
                bTimeZone.eraCache.add(historicalTimeZone.getEraAtIndex(s));
                s = (short)(s + 1);
            }
            bTimeZone.currentlyLoadedEra = bTimeZone.retrieveEraForMillis(System.currentTimeMillis());
            bTimeZone.lastLoadedMillis = System.currentTimeMillis();
        } else {
            HistoricalTimeZoneEra historicalTimeZoneEra = historicalTimeZone.getFirstEra();
            bTimeZone.id = historicalTimeZone.getHistoricalTimeZoneName();
            bTimeZone.isHistoricalZone = false;
            bTimeZone.fixedUtcOffset = historicalTimeZoneEra.getActiveUtcOffsetMillis();
            bTimeZone.fixedStdName = historicalTimeZoneEra.getShortName(false) == null ? bTimeZone.id : historicalTimeZone.getFirstEra().getShortName(false);
            bTimeZone.fixedStdShort = historicalTimeZoneEra.getShortName(false) == null ? bTimeZone.fixedStdName : historicalTimeZone.getFirstEra().getShortName(false);
            bTimeZone.fixedDstName = historicalTimeZoneEra.getShortName(true) == null ? bTimeZone.id : historicalTimeZone.getFirstEra().getShortName(true);
            bTimeZone.fixedDstShort = historicalTimeZoneEra.getShortName(true) == null ? bTimeZone.fixedDstName : historicalTimeZone.getFirstEra().getShortName(true);
            int n = 0;
            if (historicalTimeZoneEra.getStartRule() != null) {
                n = historicalTimeZone.getFirstEra().getStartRule().getDaylightAdjMillis();
            }
            bTimeZone.fixedDstDelta = n;
            bTimeZone.fixedStartRule = historicalTimeZoneEra.getStartRule() == null ? null : (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getStartRule());
            bTimeZone.fixedEndRule = historicalTimeZoneEra.getEndRule() == null ? null : (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getEndRule());
        }
        return bTimeZone;
    }

    public final boolean isNull() {
        return this.equals(NULL);
    }

    public final String getId() {
        return this.id;
    }

    public final String getDisplayName(BAbsTime bAbsTime, Context context) {
        if (this.isHistoricalZone) {
            return this.getDisplayName(bAbsTime.inDaylightTime(), context, bAbsTime.getMillis());
        }
        return this.getDisplayName(bAbsTime.inDaylightTime(), context);
    }

    public final String getDisplayName(boolean bl, Context context) {
        if (this.isHistoricalZone) {
            return this.getDisplayName(bl, context, System.currentTimeMillis());
        }
        return bl ? this.fixedDstName : this.fixedStdName;
    }

    public final String getDisplayName(boolean bl, Context context, long l) {
        if (this.isHistoricalZone) {
            HistoricalTimeZoneEra historicalTimeZoneEra = this.retrieveEraForMillis(l);
            return historicalTimeZoneEra == null ? null : historicalTimeZoneEra.getShortName(bl);
        }
        return bl ? this.fixedDstName : this.fixedStdName;
    }

    public final String getShortDisplayName(BAbsTime bAbsTime, Context context) {
        if (this.isHistoricalZone) {
            return this.getShortDisplayName(bAbsTime.inDaylightTime(), context, bAbsTime.getMillis());
        }
        return this.getShortDisplayName(bAbsTime.inDaylightTime(), context);
    }

    public final String getShortDisplayName(boolean bl, Context context) {
        if (this.isHistoricalZone) {
            return this.getShortDisplayName(bl, context, System.currentTimeMillis());
        }
        return bl ? this.fixedDstShort : this.fixedStdShort;
    }

    public final String getShortDisplayName(boolean bl, Context context, long l) {
        if (this.isHistoricalZone) {
            HistoricalTimeZoneEra historicalTimeZoneEra = this.retrieveEraForMillis(l);
            return historicalTimeZoneEra == null ? null : historicalTimeZoneEra.getShortName(bl);
        }
        return bl ? this.fixedDstShort : this.fixedStdShort;
    }

    public final int getUtcOffset() {
        return this.isHistoricalZone ? this.getUtcOffset(System.currentTimeMillis()) : this.fixedUtcOffset;
    }

    public final int getUtcOffset(long l) {
        if (this.isHistoricalZone) {
            HistoricalTimeZoneEra historicalTimeZoneEra = this.retrieveEraForMillis(l);
            int n = 0;
            if (historicalTimeZoneEra != null) {
                n = historicalTimeZoneEra.getActiveUtcOffsetMillis();
            }
            return n;
        }
        return this.fixedUtcOffset;
    }

    public final int getDaylightAdjustment() {
        return this.isHistoricalZone ? this.getDaylightAdjustment(System.currentTimeMillis()) : this.fixedDstDelta;
    }

    public final int getDaylightAdjustment(long l) {
        if (this.isHistoricalZone) {
            HistoricalTimeZoneEra historicalTimeZoneEra = this.retrieveEraForMillis(l);
            if (historicalTimeZoneEra == null) {
                return 0;
            }
            if (historicalTimeZoneEra.getStartRule() == null) {
                return 0;
            }
            return historicalTimeZoneEra.getStartRule().getDaylightAdjMillis();
        }
        return this.fixedDstDelta;
    }

    public final BAbsTime getDaylightTimeStart(int n) {
        BAbsTime bAbsTime = this.checkCache(n, 0);
        if (bAbsTime != null) {
            return bAbsTime;
        }
        if (this.isHistoricalZone) {
            HistoricalTimeZoneEra historicalTimeZoneEra = this.retrieveEraForMillis(BAbsTime.getMiddleOfYear(n));
            if (historicalTimeZoneEra == null || historicalTimeZoneEra.getStartRule() == null || historicalTimeZoneEra.getEndRule() == null) {
                return BAbsTime.NULL;
            }
            DstRule dstRule = (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getStartRule());
            bAbsTime = dstRule.getTime(n, this, 0);
        } else {
            if (this.fixedStartRule == null) {
                return BAbsTime.NULL;
            }
            bAbsTime = this.fixedStartRule.getTime(n, this, 0);
        }
        this.updateCache(bAbsTime, n, 0);
        return bAbsTime;
    }

    public final int getDay(int n, DstRule dstRule) {
        if (dstRule.getDayMode() == -1) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
            gregorianCalendar.set(1, n);
            gregorianCalendar.set(2, dstRule.getMonth().getOrdinal());
            if (dstRule.getWeek() == 5 || dstRule.getWeek() == 4) {
                gregorianCalendar.set(5, BAbsTime.getDaysInMonth(n, dstRule.getMonth()));
                gregorianCalendar.setLenient(false);
                while (gregorianCalendar.get(7) != dstRule.getWeekday().getOrdinal() + 1) {
                    ((Calendar)gregorianCalendar).add(5, -1);
                }
            } else {
                int n2;
                if (dstRule.getWeek() == 0) {
                    n2 = 1;
                } else if (dstRule.getWeek() == 1) {
                    n2 = 8;
                } else if (dstRule.getWeek() == 2) {
                    n2 = 15;
                } else if (dstRule.getWeek() == 3) {
                    n2 = 22;
                } else {
                    throw new IllegalArgumentException("Invalid week: " + dstRule.getWeek());
                }
                gregorianCalendar.set(5, n2);
                gregorianCalendar.setLenient(false);
                while (gregorianCalendar.get(7) != dstRule.getWeekday().getOrdinal() + 1) {
                    ((Calendar)gregorianCalendar).add(5, 1);
                }
            }
            return gregorianCalendar.get(5);
        }
        if (dstRule.getDayMode() == 0) {
            return dstRule.getDay();
        }
        if (dstRule.getDayMode() == 1 || dstRule.getDayMode() == 2) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(JAVA_UTC);
            gregorianCalendar.set(n, dstRule.getMonth().getOrdinal(), dstRule.getDay());
            gregorianCalendar.setLenient(false);
            while (gregorianCalendar.get(7) != dstRule.getWeekday().getOrdinal() + 1) {
                if (dstRule.getDayMode() == 2) {
                    ((Calendar)gregorianCalendar).add(5, -1);
                    continue;
                }
                ((Calendar)gregorianCalendar).add(5, 1);
            }
            return gregorianCalendar.get(5);
        }
        throw new IllegalArgumentException("");
    }

    public final BAbsTime getDaylightTimeStart(long l) {
        if (this.isHistoricalZone) {
            HistoricalTimeZoneEra historicalTimeZoneEra = this.retrieveEraForMillis(l);
            if (historicalTimeZoneEra == null || historicalTimeZoneEra.getStartRule() == null || historicalTimeZoneEra.getEndRule() == null) {
                return BAbsTime.NULL;
            }
            HistoricalDstRule historicalDstRule = historicalTimeZoneEra.getStartRule();
            HistoricalDstRule historicalDstRule2 = historicalTimeZoneEra.getEndRule();
            HistoricalTimeZoneDate historicalTimeZoneDate = historicalDstRule.getOccursOnAnnualDate();
            HistoricalTimeZoneDate historicalTimeZoneDate2 = historicalDstRule2.getOccursOnAnnualDate();
            HistoricalTimeZoneDate historicalTimeZoneDate3 = HistoricalTimeZoneDate.makeFromEpochMillis(l);
            boolean bl = historicalTimeZoneDate2.occursBeforeForYear(historicalTimeZoneDate, (short)1970);
            long l2 = historicalTimeZoneEra.getActiveUtcOffsetMillis();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(JAVA_UTC);
            gregorianCalendar.clear();
            if (bl && (historicalTimeZoneDate3.getTheMonth() == BMonth.december && historicalTimeZoneDate3.getTheDay().getCalendarDay() == 31 || historicalTimeZoneDate3.getTheMonth() == BMonth.january && historicalTimeZoneDate3.getTheDay().getCalendarDay() == 1)) {
                l2 += (long)historicalDstRule.getDaylightAdjMillis();
            }
            gregorianCalendar.setTimeInMillis(l + l2);
            BAbsTime bAbsTime = this.checkCache(gregorianCalendar.get(1), 0);
            if (bAbsTime != null) {
                return bAbsTime;
            }
            DstRule dstRule = (DstRule)DstRule.fw(1103, historicalDstRule);
            bAbsTime = dstRule.getTime(gregorianCalendar.get(1), this, 0);
            this.updateCache(bAbsTime, gregorianCalendar.get(1), 0);
            return bAbsTime;
        }
        if (this.fixedStartRule == null || this.fixedEndRule == null) {
            return BAbsTime.NULL;
        }
        HistoricalTimeZoneDate historicalTimeZoneDate = HistoricalTimeZoneDate.makeFromEpochMillis(l);
        boolean bl = this.getDaylightTimeEnd(1970).isBefore(this.getDaylightTimeStart(1970));
        long l3 = this.fixedUtcOffset;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(JAVA_UTC);
        gregorianCalendar.clear();
        if (bl && (historicalTimeZoneDate.getTheMonth() == BMonth.december && historicalTimeZoneDate.getTheDay().getCalendarDay() == 31 || historicalTimeZoneDate.getTheMonth() == BMonth.january && historicalTimeZoneDate.getTheDay().getCalendarDay() == 1)) {
            l3 += (long)this.fixedDstDelta;
        }
        gregorianCalendar.setTimeInMillis(l + l3);
        BAbsTime bAbsTime = this.checkCache(gregorianCalendar.get(1), 0);
        if (bAbsTime != null) {
            return bAbsTime;
        }
        bAbsTime = this.fixedStartRule.getTime(gregorianCalendar.get(1), this, 0);
        this.updateCache(bAbsTime, gregorianCalendar.get(1), 0);
        return bAbsTime;
    }

    public final DstRule getDaylightStartRule() {
        return this.isHistoricalZone ? this.getDaylightStartRule(System.currentTimeMillis()) : this.fixedStartRule;
    }

    public final DstRule getDaylightStartRule(long l) {
        if (this.isHistoricalZone) {
            HistoricalTimeZoneEra historicalTimeZoneEra = this.retrieveEraForMillis(l);
            if (historicalTimeZoneEra == null) {
                return null;
            }
            if (historicalTimeZoneEra.getStartRule() == null) {
                return null;
            }
            return (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getStartRule());
        }
        return this.fixedStartRule;
    }

    public final BAbsTime getDaylightTimeEnd(int n) {
        BAbsTime bAbsTime = this.checkCache(n, 1);
        if (bAbsTime != null) {
            return bAbsTime;
        }
        if (this.isHistoricalZone) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(JAVA_UTC);
            gregorianCalendar.clear();
            gregorianCalendar.set(n, 6, 1);
            HistoricalTimeZoneEra historicalTimeZoneEra = this.retrieveEraForMillis(gregorianCalendar.getTimeInMillis());
            if (historicalTimeZoneEra == null || historicalTimeZoneEra.getStartRule() == null || historicalTimeZoneEra.getEndRule() == null) {
                return BAbsTime.NULL;
            }
            DstRule dstRule = (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getEndRule());
            bAbsTime = dstRule.getTime(n, this, 1);
        } else {
            if (this.fixedEndRule == null) {
                return BAbsTime.NULL;
            }
            bAbsTime = this.fixedEndRule.getTime(n, this, 1);
        }
        this.updateCache(bAbsTime, n, 1);
        return bAbsTime;
    }

    public final BAbsTime getDaylightTimeEnd(long l) {
        if (this.isHistoricalZone) {
            HistoricalTimeZoneEra historicalTimeZoneEra = this.retrieveEraForMillis(l);
            if (historicalTimeZoneEra == null || historicalTimeZoneEra.getStartRule() == null || historicalTimeZoneEra.getEndRule() == null) {
                return BAbsTime.NULL;
            }
            HistoricalDstRule historicalDstRule = historicalTimeZoneEra.getStartRule();
            HistoricalDstRule historicalDstRule2 = historicalTimeZoneEra.getEndRule();
            HistoricalTimeZoneDate historicalTimeZoneDate = historicalDstRule.getOccursOnAnnualDate();
            HistoricalTimeZoneDate historicalTimeZoneDate2 = historicalDstRule2.getOccursOnAnnualDate();
            HistoricalTimeZoneDate historicalTimeZoneDate3 = HistoricalTimeZoneDate.makeFromEpochMillis(l);
            boolean bl = historicalTimeZoneDate2.occursBeforeForYear(historicalTimeZoneDate, (short)1970);
            long l2 = historicalTimeZoneEra.getActiveUtcOffsetMillis();
            GregorianCalendar gregorianCalendar = new GregorianCalendar(JAVA_UTC);
            gregorianCalendar.clear();
            if (bl && (historicalTimeZoneDate3.getTheMonth() == BMonth.december && historicalTimeZoneDate3.getTheDay().getCalendarDay() == 31 || historicalTimeZoneDate3.getTheMonth() == BMonth.january && historicalTimeZoneDate3.getTheDay().getCalendarDay() == 1)) {
                l2 += (long)historicalDstRule.getDaylightAdjMillis();
            }
            gregorianCalendar.setTimeInMillis(l + l2);
            BAbsTime bAbsTime = this.checkCache(gregorianCalendar.get(1), 1);
            if (bAbsTime != null) {
                return bAbsTime;
            }
            DstRule dstRule = (DstRule)DstRule.fw(1103, historicalDstRule2);
            bAbsTime = dstRule.getTime(gregorianCalendar.get(1), this, 1);
            this.updateCache(bAbsTime, gregorianCalendar.get(1), 1);
            return bAbsTime;
        }
        if (this.fixedStartRule == null || this.fixedEndRule == null) {
            return BAbsTime.NULL;
        }
        HistoricalTimeZoneDate historicalTimeZoneDate = HistoricalTimeZoneDate.makeFromEpochMillis(l);
        boolean bl = this.getDaylightTimeEnd(1970).isBefore(this.getDaylightTimeStart(1970));
        long l3 = this.fixedUtcOffset;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(JAVA_UTC);
        gregorianCalendar.clear();
        if (bl && (historicalTimeZoneDate.getTheMonth() == BMonth.december && historicalTimeZoneDate.getTheDay().getCalendarDay() == 31 || historicalTimeZoneDate.getTheMonth() == BMonth.january && historicalTimeZoneDate.getTheDay().getCalendarDay() == 1)) {
            l3 += (long)this.fixedDstDelta;
        }
        gregorianCalendar.setTimeInMillis(l + l3);
        BAbsTime bAbsTime = this.checkCache(gregorianCalendar.get(1), 1);
        if (bAbsTime != null) {
            return bAbsTime;
        }
        bAbsTime = this.fixedEndRule.getTime(gregorianCalendar.get(1), this, 1);
        this.updateCache(bAbsTime, gregorianCalendar.get(1), 1);
        return bAbsTime;
    }

    public final DstRule getDaylightEndRule() {
        return this.isHistoricalZone ? this.getDaylightEndRule(System.currentTimeMillis()) : this.fixedEndRule;
    }

    public final DstRule getDaylightEndRule(long l) {
        if (this.isHistoricalZone) {
            HistoricalTimeZoneEra historicalTimeZoneEra = this.retrieveEraForMillis(l);
            if (historicalTimeZoneEra == null) {
                return null;
            }
            if (historicalTimeZoneEra.getEndRule() == null) {
                return null;
            }
            return (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getEndRule());
        }
        return this.fixedEndRule;
    }

    public final TimeZone getJavaTimeZone() {
        return (TimeZone)this.tzSupport();
    }

    public final Object tzSupport() {
        if (this.jzone == null) {
            if (!this.isHistoricalZone && this.fixedDstDelta == 0) {
                this.jzone = new SimpleTimeZone(this.fixedUtcOffset, this.id);
            } else if (!this.isHistoricalZone) {
                if ((long)this.fixedDstDelta == 3600000L) {
                    int n = this.fixedUtcOffset;
                    int n2 = this.fixedStartRule.getMonth().getOrdinal();
                    DstRule dstRule = this.fixedStartRule.asWallTimeRule(0, this);
                    if (dstRule != null) {
                        int n3;
                        int n4;
                        int n5 = (int)dstRule.getTime().getTimeOfDayMillis();
                        if (dstRule.getDayMode() == 0) {
                            n4 = dstRule.getDay();
                            n3 = 0;
                        } else if (dstRule.getDayMode() == -1) {
                            n3 = dstRule.getWeekday().getOrdinal() + 1;
                            if (dstRule.getWeek() == 5) {
                                n4 = -1;
                            } else {
                                n4 = dstRule.getWeek() * 7 + 1;
                                n3 *= -1;
                            }
                        } else if (dstRule.getDayMode() == 2) {
                            n4 = -1 * dstRule.getDay();
                            n3 = -1 * (dstRule.getWeekday().getOrdinal() + 1);
                        } else {
                            n4 = dstRule.getDay();
                            n3 = -1 * (dstRule.getWeekday().getOrdinal() + 1);
                        }
                        DstRule dstRule2 = this.fixedEndRule.asWallTimeRule(1, this);
                        if (dstRule2 != null) {
                            int n6;
                            int n7;
                            int n8 = dstRule2.getMonth().getOrdinal();
                            int n9 = (int)dstRule2.getTime().getTimeOfDayMillis();
                            if (dstRule2.getDayMode() == 0) {
                                n7 = dstRule2.getDay();
                                n6 = 0;
                            } else if (dstRule2.getDayMode() == -1) {
                                n6 = dstRule2.getWeekday().getOrdinal() + 1;
                                if (dstRule2.getWeek() == 5) {
                                    n7 = -1;
                                } else {
                                    n7 = dstRule2.getWeek() * 7 + 1;
                                    n6 *= -1;
                                }
                            } else if (dstRule2.getDayMode() == 2) {
                                n7 = -1 * dstRule2.getDay();
                                n6 = -1 * (dstRule2.getWeekday().getOrdinal() + 1);
                            } else {
                                n7 = dstRule2.getDay();
                                n6 = -1 * (dstRule2.getWeekday().getOrdinal() + 1);
                            }
                            try {
                                this.jzone = new SimpleTimeZone(n, this.id, n2, n4, n3, n5, n8, n7, n6, n9);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                System.out.println("rawOffset=" + n);
                                System.out.println("id=" + this.id);
                                System.out.println("startMonth=" + n2);
                                System.out.println("startDay=" + n4);
                                System.out.println("startDayOfWeek=" + n3);
                                System.out.println("startTime=" + n5);
                                System.out.println("endMonth=" + n8);
                                System.out.println("endDay=" + n7);
                                System.out.println("endDayOfWeek=" + n6);
                                System.out.println("endTime=" + n9);
                                illegalArgumentException.printStackTrace();
                            }
                        }
                    }
                }
                if (this.jzone == null) {
                    this.jzone = new Support();
                }
            } else {
                this.jzone = new Support();
            }
        }
        return this.jzone;
    }

    public final BIDataValue toDataValue() {
        return this;
    }

    public final int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception exception) {
            return System.identityHashCode(this);
        }
    }

    public final boolean equals(Object object) {
        try {
            DstRule dstRule;
            DstRule dstRule2;
            long l;
            long l2;
            DstRule dstRule3;
            DstRule dstRule4;
            long l3;
            long l4;
            if (!(object instanceof BTimeZone)) {
                return false;
            }
            BTimeZone bTimeZone = (BTimeZone)object;
            HistoricalTimeZoneEra historicalTimeZoneEra = null;
            long l5 = System.currentTimeMillis();
            Object object2 = null;
            if (this.isHistoricalZone) {
                historicalTimeZoneEra = this.retrieveEraForMillis(l5);
                int n = 0;
                if (historicalTimeZoneEra.getStartRule() != null) {
                    n = historicalTimeZoneEra.getStartRule().getDaylightAdjMillis();
                }
                l4 = n;
                l3 = historicalTimeZoneEra.getActiveUtcOffsetMillis();
                object2 = DstRule.fw(1103, historicalTimeZoneEra.getStartRule());
                if (object2 != null && !(object2 instanceof DstRule)) {
                    return false;
                }
                dstRule4 = (DstRule)object2;
                object2 = DstRule.fw(1103, historicalTimeZoneEra.getEndRule());
                if (object2 != null && !(object2 instanceof DstRule)) {
                    return false;
                }
                dstRule3 = (DstRule)object2;
            } else {
                l4 = this.fixedDstDelta;
                l3 = this.fixedUtcOffset;
                dstRule4 = this.fixedStartRule;
                dstRule3 = this.fixedEndRule;
            }
            if (bTimeZone.isHistoricalZone) {
                historicalTimeZoneEra = bTimeZone.retrieveEraForMillis(l5);
                int n = 0;
                if (historicalTimeZoneEra.getStartRule() != null) {
                    n = historicalTimeZoneEra.getStartRule().getDaylightAdjMillis();
                }
                l2 = n;
                l = historicalTimeZoneEra.getActiveUtcOffsetMillis();
                object2 = DstRule.fw(1103, historicalTimeZoneEra.getStartRule());
                if (object2 != null && !(object2 instanceof DstRule)) {
                    return false;
                }
                dstRule2 = (DstRule)object2;
                object2 = DstRule.fw(1103, historicalTimeZoneEra.getEndRule());
                if (object2 != null && !(object2 instanceof DstRule)) {
                    return false;
                }
                dstRule = (DstRule)object2;
            } else {
                l2 = bTimeZone.fixedDstDelta;
                l = bTimeZone.fixedUtcOffset;
                dstRule2 = bTimeZone.fixedStartRule;
                dstRule = bTimeZone.fixedEndRule;
            }
            boolean bl = false;
            if (bTimeZone.id.equals(this.id) && l == l3 && l2 == l4 && DstRule.equals(dstRule2, dstRule4) && DstRule.equals(dstRule, dstRule3)) {
                bl = true;
            }
            return bl;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public final boolean isEquivalent(BTimeZone bTimeZone) {
        DstRule dstRule;
        DstRule dstRule2;
        int n;
        int n2;
        DstRule dstRule3;
        DstRule dstRule4;
        int n3;
        int n4;
        HistoricalTimeZoneEra historicalTimeZoneEra = null;
        long l = System.currentTimeMillis();
        if (this.isHistoricalZone) {
            historicalTimeZoneEra = this.retrieveEraForMillis(l);
            int n5 = 0;
            if (historicalTimeZoneEra.getStartRule() != null) {
                n5 = historicalTimeZoneEra.getStartRule().getDaylightAdjMillis();
            }
            n4 = n5;
            n3 = historicalTimeZoneEra.getActiveUtcOffsetMillis();
            dstRule4 = (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getStartRule());
            dstRule3 = (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getEndRule());
        } else {
            n4 = this.fixedDstDelta;
            n3 = this.fixedUtcOffset;
            dstRule4 = this.fixedStartRule;
            dstRule3 = this.fixedEndRule;
        }
        if (bTimeZone.isHistoricalZone) {
            historicalTimeZoneEra = bTimeZone.retrieveEraForMillis(l);
            int n6 = 0;
            if (historicalTimeZoneEra.getStartRule() != null) {
                n6 = historicalTimeZoneEra.getStartRule().getDaylightAdjMillis();
            }
            n2 = n6;
            n = historicalTimeZoneEra.getActiveUtcOffsetMillis();
            dstRule2 = (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getStartRule());
            dstRule = (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getEndRule());
        } else {
            n2 = bTimeZone.fixedDstDelta;
            n = bTimeZone.fixedUtcOffset;
            dstRule2 = bTimeZone.fixedStartRule;
            dstRule = bTimeZone.fixedEndRule;
        }
        boolean bl = false;
        if (n == n3 && n2 == n4 && DstRule.isEquivalent(dstRule2, dstRule4, this, 0) && DstRule.isEquivalent(dstRule, dstRule3, this, 1)) {
            bl = true;
        }
        return bl;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        DstRule dstRule;
        DstRule dstRule2;
        int n;
        int n2;
        dataOutput.writeUTF(this.id);
        if (this.isHistoricalZone) {
            HistoricalTimeZoneEra historicalTimeZoneEra = this.retrieveEraForMillis(System.currentTimeMillis());
            n2 = historicalTimeZoneEra.getActiveUtcOffsetMillis();
            int n3 = 0;
            if (historicalTimeZoneEra.getStartRule() != null) {
                n3 = historicalTimeZoneEra.getStartRule().getDaylightAdjMillis();
            }
            n = n3;
            dstRule2 = (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getStartRule());
            dstRule = (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getEndRule());
        } else {
            n2 = this.fixedUtcOffset;
            n = this.fixedDstDelta;
            dstRule2 = this.fixedStartRule;
            dstRule = this.fixedEndRule;
        }
        dataOutput.writeInt(n2);
        dataOutput.writeInt(n);
        boolean bl = false;
        if (dstRule2 != null) {
            bl = true;
        }
        dataOutput.writeBoolean(bl);
        if (dstRule2 != null) {
            dstRule2.encode(dataOutput);
        }
        boolean bl2 = false;
        if (dstRule != null) {
            bl2 = true;
        }
        dataOutput.writeBoolean(bl2);
        if (dstRule != null) {
            dstRule.encode(dataOutput);
        }
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        DstRule dstRule = dataInput.readBoolean() ? DstRule.decode(dataInput) : null;
        DstRule dstRule2 = dataInput.readBoolean() ? DstRule.decode(dataInput) : null;
        return BTimeZone.make(string, string, string, string, string, n, n2, dstRule, dstRule2);
    }

    public final String encodeToString() throws IOException {
        if (this.stringEncoding == null) {
            DstRule dstRule;
            DstRule dstRule2;
            int n;
            int n2;
            StringBuffer stringBuffer = new StringBuffer(128);
            if (this.isHistoricalZone) {
                HistoricalTimeZoneEra historicalTimeZoneEra = this.retrieveEraForMillis(System.currentTimeMillis());
                n2 = historicalTimeZoneEra.getActiveUtcOffsetMillis();
                int n3 = 0;
                if (historicalTimeZoneEra.getStartRule() != null) {
                    n3 = historicalTimeZoneEra.getStartRule().getDaylightAdjMillis();
                }
                n = n3;
                dstRule2 = (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getStartRule());
                dstRule = (DstRule)DstRule.fw(1103, historicalTimeZoneEra.getEndRule());
            } else {
                n2 = this.fixedUtcOffset;
                n = this.fixedDstDelta;
                dstRule2 = this.fixedStartRule;
                dstRule = this.fixedEndRule;
            }
            stringBuffer.append(this.id);
            stringBuffer.append(';');
            stringBuffer.append(n2);
            stringBuffer.append(';');
            stringBuffer.append(n);
            stringBuffer.append(';');
            stringBuffer.append(dstRule2 != null ? dstRule2.encodeToString() : "null");
            stringBuffer.append(';');
            stringBuffer.append(dstRule != null ? dstRule.encodeToString() : "null");
            this.stringEncoding = stringBuffer.toString();
        }
        return this.stringEncoding;
    }

    public final BObject decodeFromString(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string2 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            return BTimeZone.getTimeZone(string2);
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        String string3 = stringTokenizer.nextToken();
        DstRule dstRule = !string3.equals("null") ? DstRule.decodeFromString(string3) : null;
        string3 = stringTokenizer.nextToken();
        DstRule dstRule2 = !string3.equals("null") ? DstRule.decodeFromString(string3) : null;
        return BTimeZone.make(string2, string2, string2, string2, string2, n, n2, dstRule, dstRule2);
    }

    public final String toString(Context context) {
        int n;
        int n2;
        if (this.isHistoricalZone) {
            HistoricalTimeZoneEra historicalTimeZoneEra = this.retrieveEraForMillis(System.currentTimeMillis());
            n2 = historicalTimeZoneEra.getActiveUtcOffsetMillis();
            int n3 = 0;
            if (historicalTimeZoneEra.getStartRule() != null) {
                n3 = historicalTimeZoneEra.getStartRule().getDaylightAdjMillis();
            }
            n = n3;
        } else {
            n2 = this.fixedUtcOffset;
            n = this.fixedDstDelta;
        }
        long l = (long)n2 / 3600000L;
        long l2 = (long)n2 % 3600000L;
        long l3 = Math.abs(l2 / 60000L);
        StringBuffer stringBuffer = new StringBuffer(this.getId());
        stringBuffer.append(" (");
        if (n2 >= 0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(String.valueOf(l));
        if (l3 != 0L) {
            stringBuffer.append(":");
            if (l3 < 10L) {
                stringBuffer.append("0");
            }
            stringBuffer.append(String.valueOf(l3));
        }
        if (n != 0) {
            stringBuffer.append("/");
            if (n2 + n >= 0) {
                stringBuffer.append("+");
            }
            long l4 = (long)(n2 + n) / 3600000L;
            l2 = (long)(n2 + n) % 3600000L;
            long l5 = Math.abs(l2 / 60000L);
            stringBuffer.append(String.valueOf(l4));
            if (l5 != 0L) {
                stringBuffer.append(":");
                if (l5 < 10L) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(String.valueOf(l5));
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public final boolean isHistorical() {
        return this.isHistoricalZone;
    }

    public static final SimpleTimeZone getJavaUTCInstance() {
        if (JAVA_UTC == null) {
            JAVA_UTC = new SimpleTimeZone(0, "UTC");
        }
        return JAVA_UTC;
    }

    public static final BTimeZone getLocal() {
        return localTimeZone;
    }

    public final Type getType() {
        return TYPE;
    }

    private final synchronized HistoricalTimeZoneEra retrieveEraForMillis(long l) {
        if (this.lastLoadedMillis != (long)-1 && this.currentlyLoadedEra != null && Math.abs(l - this.lastLoadedMillis) < TimeZoneDatabase.TOLERANCE) {
            return this.currentlyLoadedEra;
        }
        if (this.currentlyLoadedEra != null && this.currentlyLoadedEra.isValidForEpochMillis(l)) {
            return this.currentlyLoadedEra;
        }
        HistoricalTimeZoneEra historicalTimeZoneEra = null;
        if (this.eraCache != null) {
            int n = 0;
            while (n < this.eraCache.size() - 1) {
                historicalTimeZoneEra = (HistoricalTimeZoneEra)this.eraCache.get(n);
                if (historicalTimeZoneEra != this.currentlyLoadedEra && historicalTimeZoneEra.isValidForEpochMillis(l)) {
                    this.currentlyLoadedEra = historicalTimeZoneEra;
                    this.lastLoadedMillis = l;
                    return this.currentlyLoadedEra;
                }
                ++n;
            }
            this.currentlyLoadedEra = historicalTimeZoneEra = (HistoricalTimeZoneEra)this.eraCache.get(n);
            this.lastLoadedMillis = l;
            return this.currentlyLoadedEra;
        }
        logger.error("no such timezone " + this.id + " for the epoch millis: " + l);
        return null;
    }

    private final synchronized void updateCache(BAbsTime bAbsTime, int n, int n2) {
        if (n2 == 0) {
            if (this.cachedStartTimes == null) {
                this.cachedStartTimes = new LinkedHashMap();
            }
            this.cachedStartTimes.put(new Integer(n), bAbsTime);
        } else {
            if (this.cachedEndTimes == null) {
                this.cachedEndTimes = new LinkedHashMap();
            }
            this.cachedEndTimes.put(new Integer(n), bAbsTime);
        }
    }

    private final synchronized BAbsTime checkCache(int n, int n2) {
        if (n2 == 0) {
            if (this.cachedStartTimes == null) {
                return null;
            }
            return (BAbsTime)this.cachedStartTimes.get(new Integer(n));
        }
        if (this.cachedEndTimes == null) {
            return null;
        }
        return (BAbsTime)this.cachedEndTimes.get(new Integer(n));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.hashCode = -1;
        this.currentlyLoadedEra = null;
        this.lastLoadedMillis = -1;
    }

    private BTimeZone() {
        this.this();
    }

    static {
        Class clazz;
        UTC = BTimeZone.makeIgnoringCache("UTC", 0);
        GMT = BTimeZone.makeIgnoringCache("GMT", 0);
        NULL = BTimeZone.makeIgnoringCache("NULL", 0);
        DEFAULT = UTC;
        JAVA_UTC = null;
        logger = Log.getLog("timezone");
        TimeZoneDatabase.get();
        String string = System.getProperty("timezonedb.load", "true");
        if (string.equals("true")) {
            String string2 = System.getProperty("niagara.timezone");
            boolean bl = true;
            if (string2 == null) {
                bl = false;
                if (!Nre.bootEnv.isRemote()) {
                    logger.warning("No niagara.timezone in !/lib/system.properties, set one using the Platform Administrator");
                }
                string2 = TimeZone.getDefault().getID().replace('\\', '/');
            }
            try {
                localTimeZone = BTimeZone.getTimeZone(string2);
            }
            catch (TimeZoneException timeZoneException) {
                System.err.println(timeZoneException);
                if (bl) {
                    logger.warning("Local definition for niagara.timezone=" + string2 + " not found, initializing to JVM Default");
                } else {
                    logger.warning("Local definition for JVM Time Zone \"" + string2 + "\" not found, approximating instead.");
                }
                localTimeZone = BTimeZone.make(TimeZone.getDefault().getID(), TimeZone.getDefault().getOffset(System.currentTimeMillis()));
            }
        } else {
            logger.warning("timezonedb.load=false, Using UTC for local timezone.");
            localTimeZone = BTimeZone.makeIgnoringCache("UTC", 0);
        }
        if ((clazz = class$javax$baja$timezone$BTimeZone) == null) {
            clazz = class$javax$baja$timezone$BTimeZone = BTimeZone.class("[Ljavax.baja.timezone.BTimeZone;", false);
        }
        TYPE = Sys.loadType(clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Support
    extends TimeZone {
        public String getDisplayName(boolean bl, int n, Locale locale) {
            if (n == 0) {
                return BTimeZone.this.getShortDisplayName(bl, null);
            }
            return BTimeZone.this.getDisplayName(bl, null);
        }

        public String getID() {
            return BTimeZone.this.id;
        }

        public int getRawOffset() {
            return BTimeZone.this.getUtcOffset();
        }

        public boolean useDaylightTime() {
            boolean bl = false;
            if (BTimeZone.this.getDaylightAdjustment() != 0) {
                bl = true;
            }
            return bl;
        }

        public int getDSTSavings() {
            return BTimeZone.this.getDaylightAdjustment();
        }

        public int getOffset(long l) {
            int n;
            int n2;
            if (BTimeZone.this.isHistoricalZone) {
                HistoricalTimeZoneEra historicalTimeZoneEra = BTimeZone.this.retrieveEraForMillis(l);
                n2 = historicalTimeZoneEra.getActiveUtcOffsetMillis();
                int n3 = 0;
                if (historicalTimeZoneEra.getStartRule() != null) {
                    n3 = historicalTimeZoneEra.getStartRule().getDaylightAdjMillis();
                }
                n = n3;
            } else {
                n2 = BTimeZone.this.fixedUtcOffset;
                n = BTimeZone.this.fixedDstDelta;
            }
            if (n == 0) {
                return n2;
            }
            if (this.inDaylightTime(new Date(l))) {
                return n2 + n;
            }
            return n2;
        }

        public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
            int n7;
            int n8;
            long l;
            GregorianCalendar gregorianCalendar = new GregorianCalendar(JAVA_UTC);
            gregorianCalendar.clear();
            gregorianCalendar.set(0, n);
            gregorianCalendar.set(n2, n3, n4);
            if (BTimeZone.this.isHistoricalZone) {
                HistoricalTimeZoneEra historicalTimeZoneEra = BTimeZone.this.retrieveEraForMillis(gregorianCalendar.getTimeInMillis() + (long)n6);
                l = gregorianCalendar.getTimeInMillis() + (long)n6 - (long)historicalTimeZoneEra.getActiveUtcOffsetMillis();
                n8 = historicalTimeZoneEra.getActiveUtcOffsetMillis();
                int n9 = 0;
                if (historicalTimeZoneEra.getStartRule() != null) {
                    n9 = historicalTimeZoneEra.getStartRule().getDaylightAdjMillis();
                }
                n7 = n9;
            } else {
                l = gregorianCalendar.getTimeInMillis() + (long)n6 - (long)BTimeZone.this.fixedUtcOffset;
                n8 = BTimeZone.this.fixedUtcOffset;
                n7 = BTimeZone.this.fixedDstDelta;
            }
            if (n7 == 0) {
                return n8;
            }
            if (this.inDaylightTime(new Date(l))) {
                return n8 + n7;
            }
            return n8;
        }

        public boolean hasSameRules(TimeZone timeZone) {
            if (timeZone instanceof Support) {
                ((Support)timeZone).getBTimeZone().isEquivalent(this.getBTimeZone());
            }
            return false;
        }

        public boolean inDaylightTime(Date date) {
            if (BTimeZone.this.isHistoricalZone) {
                BAbsTime bAbsTime;
                HistoricalTimeZoneEra historicalTimeZoneEra = BTimeZone.this.retrieveEraForMillis(date.getTime());
                HistoricalDstRule historicalDstRule = historicalTimeZoneEra.getStartRule();
                if (historicalDstRule == null) {
                    return false;
                }
                HistoricalDstRule historicalDstRule2 = historicalTimeZoneEra.getEndRule();
                if (historicalDstRule2 == null) {
                    return false;
                }
                HistoricalTimeZoneDate historicalTimeZoneDate = historicalDstRule.getOccursOnAnnualDate();
                HistoricalTimeZoneDate historicalTimeZoneDate2 = historicalDstRule2.getOccursOnAnnualDate();
                HistoricalTimeZoneDate historicalTimeZoneDate3 = HistoricalTimeZoneDate.makeFromEpochMillis(date.getTime());
                boolean bl = false;
                boolean bl2 = false;
                if (HistoricalTimeZoneDate.canBeCompared(historicalTimeZoneDate3, historicalTimeZoneDate)) {
                    bl = historicalTimeZoneDate3.occursAfterOrOnAbsolute(historicalTimeZoneDate);
                } else {
                    bAbsTime = BTimeZone.this.getDaylightTimeStart(historicalTimeZoneDate3.getTheYear());
                    boolean bl3 = false;
                    if (bAbsTime.getMillis() <= date.getTime()) {
                        bl3 = bl = true;
                    }
                }
                if (HistoricalTimeZoneDate.canBeCompared(historicalTimeZoneDate3, historicalTimeZoneDate2)) {
                    bl2 = historicalTimeZoneDate3.occursBeforeAbsolute(historicalTimeZoneDate2);
                } else {
                    bAbsTime = BTimeZone.this.getDaylightTimeEnd(historicalTimeZoneDate3.getTheYear());
                    boolean bl4 = false;
                    if (bAbsTime.getMillis() > date.getTime()) {
                        bl4 = bl2 = true;
                    }
                }
                if (historicalTimeZoneDate.occursBeforeForYear(historicalTimeZoneDate2, (short)1970)) {
                    boolean bl5 = false;
                    if (bl && bl2) {
                        bl5 = true;
                    }
                    return bl5;
                }
                boolean bl6 = false;
                if (bl || bl2) {
                    bl6 = true;
                }
                return bl6;
            }
            if (BTimeZone.this.fixedStartRule == null || BTimeZone.this.fixedEndRule == null) {
                return false;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(JAVA_UTC);
            gregorianCalendar.clear();
            gregorianCalendar.setTime(date);
            BAbsTime bAbsTime = BTimeZone.this.getDaylightTimeStart(gregorianCalendar.get(1));
            if (bAbsTime.isNull()) {
                return false;
            }
            BAbsTime bAbsTime2 = BTimeZone.this.getDaylightTimeEnd(gregorianCalendar.get(1));
            if (bAbsTime2.isNull()) {
                return false;
            }
            if (bAbsTime.getMillis() < bAbsTime2.getMillis()) {
                boolean bl = false;
                if (date.getTime() >= bAbsTime.getMillis() && date.getTime() < bAbsTime2.getMillis()) {
                    bl = true;
                }
                return bl;
            }
            boolean bl = false;
            if (date.getTime() >= bAbsTime.getMillis() || date.getTime() < bAbsTime2.getMillis()) {
                bl = true;
            }
            return bl;
        }

        public void setID(String string) {
            throw new UnsupportedOperationException();
        }

        public void setRawOffset(int n) {
            throw new UnsupportedOperationException();
        }

        private final BTimeZone getBTimeZone() {
            return BTimeZone.this;
        }

        public String toString() {
            try {
                return BTimeZone.this.encodeToString();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        private Support() {
        }
    }
}

