/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.license.NLicenseManager;
import com.tridium.sys.module.NModule;
import com.tridium.sys.station.Station;
import java.io.File;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.baja.license.LicenseException;
import javax.baja.license.LicenseManager;
import javax.baja.registry.Registry;
import javax.baja.security.Auditor;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BStation;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;

public final class Sys {
    public static final String getLanguage() {
        return Nre.language;
    }

    public static final void setLanguage(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        Nre.language = string;
    }

    public static final File getBajaHome() {
        return Nre.bajaHome;
    }

    public static final File getUserHome() {
        return Nre.userHome;
    }

    public static final File getCredentialsHome() {
        return Nre.credentialsHome;
    }

    public static final File getStationHome() {
        return Nre.stationHome;
    }

    public static final InetAddress getLocalHost() {
        return NreLib.getLocalHost();
    }

    public static final BStation getStation() {
        return Station.station;
    }

    public static final boolean isStationStarted() {
        return Station.stationStarted;
    }

    public static final boolean atSteadyState() {
        return Station.atSteadyState;
    }

    public static final Registry getRegistry() {
        return Nre.registryManager;
    }

    public static final LicenseManager getLicenseManager() {
        NLicenseManager nLicenseManager = Nre.licenseManager;
        if (!nLicenseManager.getClass().getName().equals("com.tridium.sys.license.NodeLockedLicenseManager") && !nLicenseManager.getClass().getName().equals("com.tridium.sys.license.FloatingLicenseManager")) {
            throw new LicenseException();
        }
        return nLicenseManager;
    }

    public static final String getHostId() {
        return NreLib.getHostId();
    }

    public static final BModule getBajaModule() {
        return BBoolean.TYPE.getModule();
    }

    public static final BModule getModuleForClass(Class clazz) {
        NModule nModule = Nre.moduleManager.getModuleForClass(clazz);
        if (nModule != null) {
            return nModule.bmodule();
        }
        return null;
    }

    public static final BModule loadModule(String string) throws ModuleNotFoundException, ModuleException {
        return Nre.moduleManager.loadModule(string).bmodule();
    }

    public static final Class loadClass(String string, String string2) throws ClassNotFoundException, ModuleException {
        return Sys.loadModule(string).loadClass(string2);
    }

    public static final Object newInstance(String string, String string2) throws ClassNotFoundException, ModuleException, InstantiationException, IllegalAccessException {
        return Sys.loadClass(string, string2).newInstance();
    }

    public static final BComponent getService(Type type) throws ServiceNotFoundException {
        return Nre.serviceManager.getService(type.toString());
    }

    public static final BComponent[] getServices(Type type) throws ServiceNotFoundException {
        return Nre.serviceManager.getServices(type.toString());
    }

    public static final Type getType(int n) throws TypeNotFoundException {
        return Nre.schemaManager.getType(n);
    }

    public static final Type getType(Class clazz) throws TypeNotFoundException {
        return Nre.schemaManager.getType(clazz);
    }

    public static final Type getType(String string) throws ModuleException, TypeException {
        return BTypeSpec.make(string).getResolvedType();
    }

    public static final Type[] getTypes() {
        return Nre.schemaManager.getTypes();
    }

    public static final Type loadType(final Class clazz) {
        Type type = (Type)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                return Nre.schemaManager.load(clazz);
            }
        });
        return type;
    }

    public static final Auditor getAuditor() {
        return Nre.auditor;
    }

    public static final void setAuditor(Auditor auditor) {
        Nre.auditor = auditor;
    }
}

