/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BConversionLink;
import javax.baja.sys.BLink;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BCompositeAction;
import javax.baja.util.BCompositeTopic;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

public final class LinkCheck {
    static final LinkCheck VALID = new LinkCheck(true);
    private static final Version CONVERSION_LINK_VERSION = new Version(new int[]{3, 6, 13});
    private boolean valid;
    private String invalidReason;

    public static final LinkCheck makeValid() {
        return VALID;
    }

    public static final LinkCheck makeInvalid(String string) {
        return new LinkCheck(string);
    }

    static final LinkCheck make(BComponent bComponent, Slot slot, BComponent bComponent2, Slot slot2, Context context) {
        if (LinkCheck.isDuplicate(bComponent, slot, bComponent2, slot2)) {
            return LinkCheck.invalid("linkcheck.duplicate", context);
        }
        if (slot.isAction()) {
            if (slot2.isAction()) {
                return LinkCheck.make(bComponent, slot.asAction(), bComponent2, slot2.asAction(), context);
            }
            if (slot2.isTopic()) {
                return LinkCheck.make(bComponent, slot.asAction(), bComponent2, slot2.asTopic(), context);
            }
            if (slot2.isProperty()) {
                return LinkCheck.make(bComponent, slot.asAction(), bComponent2, slot2.asProperty(), context);
            }
            throw new IllegalStateException();
        }
        if (slot.isTopic()) {
            if (slot2.isAction()) {
                return LinkCheck.make(bComponent, slot.asTopic(), bComponent2, slot2.asAction(), context);
            }
            if (slot2.isTopic()) {
                return LinkCheck.make(bComponent, slot.asTopic(), bComponent2, slot2.asTopic(), context);
            }
            if (slot2.isProperty()) {
                return LinkCheck.make(bComponent, slot.asTopic(), bComponent2, slot2.asProperty(), context);
            }
            throw new IllegalStateException();
        }
        if (slot.isProperty()) {
            if (slot2.isAction()) {
                return LinkCheck.make(bComponent, slot.asProperty(), bComponent2, slot2.asAction(), context);
            }
            if (slot2.isTopic()) {
                return LinkCheck.make(bComponent, slot.asProperty(), bComponent2, slot2.asTopic(), context);
            }
            if (slot2.isProperty()) {
                return LinkCheck.make(bComponent, slot.asProperty(), bComponent2, slot2.asProperty(), context);
            }
            throw new IllegalStateException();
        }
        throw new IllegalStateException();
    }

    private static final boolean isDuplicate(BComponent bComponent, Slot slot, BComponent bComponent2, Slot slot2) {
        BLink[] bLinkArray = bComponent2.getLinks(slot2);
        int n = 0;
        while (n < bLinkArray.length) {
            BLink bLink = bLinkArray[n];
            if (bLink.isDirect() ? bLink.getSourceComponent() == bComponent && bLink.getSourceSlot() == slot : bLink.getSourceOrd().equals(bComponent.getHandleOrd()) && bLink.getSourceSlotName().equals(slot.getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final LinkCheck make(BComponent bComponent, Property property, BComponent bComponent2, Property property2, Context context) {
        if (Flags.isReadonly(bComponent2, property2)) {
            return LinkCheck.invalid("linkcheck.propReadonly", context);
        }
        if (property.getType().is(BComponent.TYPE) && !property.getType().is(BVector.TYPE)) {
            return LinkCheck.invalid("linkcheck.propComponent", context);
        }
        if (bComponent2.isLinkTarget(property2) && !Flags.isFanIn(bComponent2, property2)) {
            return LinkCheck.invalid("linkcheck.propAlreadyLinked", context);
        }
        return LinkCheck.checkType(bComponent, property, property.getType(), property2, property2.getType(), context);
    }

    private static final LinkCheck make(BComponent bComponent, Property property, BComponent bComponent2, Action action, Context context) {
        Type type = action.getParameterType();
        if (type == null) {
            return VALID;
        }
        return LinkCheck.checkType(bComponent, property, property.getType(), action, type, context);
    }

    private static final LinkCheck make(BComponent bComponent, Property property, BComponent bComponent2, Topic topic, Context context) {
        return LinkCheck.invalid("linkcheck.propToTopic", context);
    }

    private static final LinkCheck make(BComponent bComponent, Action action, BComponent bComponent2, Property property, Context context) {
        return LinkCheck.invalid("linkcheck.actionToProp", context);
    }

    private static final LinkCheck make(BComponent bComponent, Action action, BComponent bComponent2, Action action2, Context context) {
        if (LinkCheck.isCompositeAction(action)) {
            return VALID;
        }
        Type type = action.getParameterType();
        Type type2 = action2.getParameterType();
        if (type2 == null) {
            return VALID;
        }
        if (type == null) {
            return LinkCheck.invalid("linkcheck.actionToActionNoArg", context);
        }
        return LinkCheck.checkType(bComponent, action, type, action2, type2, context);
    }

    private static final LinkCheck make(BComponent bComponent, Action action, BComponent bComponent2, Topic topic, Context context) {
        if (LinkCheck.isCompositeTopic(topic)) {
            return VALID;
        }
        Type type = action.getParameterType();
        Type type2 = topic.getEventType();
        if (type2 == null) {
            return VALID;
        }
        if (type == null) {
            return LinkCheck.invalid("linkcheck.actionToTopicNoEvent", context);
        }
        return LinkCheck.checkType(bComponent, action, type, topic, type2, context);
    }

    private static final LinkCheck make(BComponent bComponent, Topic topic, BComponent bComponent2, Property property, Context context) {
        return LinkCheck.invalid("linkcheck.topicToProp", context);
    }

    private static final LinkCheck make(BComponent bComponent, Topic topic, BComponent bComponent2, Action action, Context context) {
        Type type = topic.getEventType();
        Type type2 = action.getParameterType();
        if (type2 == null) {
            return VALID;
        }
        if (type == null) {
            return LinkCheck.invalid("linkcheck.topicToActionNoEvent", context);
        }
        return LinkCheck.checkType(bComponent, topic, type, action, type2, context);
    }

    private static final LinkCheck make(BComponent bComponent, Topic topic, BComponent bComponent2, Topic topic2, Context context) {
        if (LinkCheck.isCompositeTopic(topic2)) {
            return VALID;
        }
        Type type = topic.getEventType();
        Type type2 = topic2.getEventType();
        if (type2 == null) {
            return VALID;
        }
        if (type == null) {
            return LinkCheck.invalid("linkcheck.topicToTopicNoEvent", context);
        }
        return LinkCheck.checkType(bComponent, topic, type, topic2, type2, context);
    }

    private static final LinkCheck checkType(BComponent bComponent, Slot slot, Type type, Slot slot2, Type type2, Context context) {
        Object[] objectArray;
        Object object;
        if (type.is(type2)) {
            return VALID;
        }
        Version version = (Version)bComponent.fw(404, "baja", null, null, null);
        if (version != null && version.compareTo(CONVERSION_LINK_VERSION) != -1 && (object = bComponent.makeLink(bComponent, slot, slot2, context)) != null && object instanceof BConversionLink) {
            objectArray = Sys.getRegistry();
            TypeInfo[] typeInfoArray = objectArray.getAdapters(type.getTypeInfo(), type2.getTypeInfo());
            int n = 0;
            while (n < typeInfoArray.length) {
                if (objectArray.isAgent(typeInfoArray[n], BConversionLink.TYPE.getTypeInfo())) {
                    return VALID;
                }
                ++n;
            }
        }
        object = Lexicon.make(Sys.getBajaModule(), context.getLanguage());
        objectArray = new Object[]{type, type2};
        return LinkCheck.makeInvalid(((Lexicon)object).getText("linkcheck.mismatchedTypes", objectArray));
    }

    private static final LinkCheck invalid(String string, Context context) {
        Lexicon lexicon = Lexicon.make(Sys.getBajaModule(), context);
        return LinkCheck.makeInvalid(lexicon.getText(string));
    }

    private static final boolean isCompositeAction(Action action) {
        if (action instanceof Property) {
            return ((Property)((Object)action)).getDefaultValue() instanceof BCompositeAction;
        }
        return false;
    }

    private static final boolean isCompositeTopic(Topic topic) {
        if (topic instanceof Property) {
            return ((Property)((Object)topic)).getDefaultValue() instanceof BCompositeTopic;
        }
        return false;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final String getInvalidReason() {
        return this.invalidReason;
    }

    private LinkCheck(String string) {
        this.valid = false;
        this.invalidReason = string;
    }

    private LinkCheck(boolean bl) {
        this.valid = bl;
    }
}

