/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.util.HashMap;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public final class Flags {
    public static final int READONLY = 1;
    public static final int TRANSIENT = 2;
    public static final int HIDDEN = 4;
    public static final int SUMMARY = 8;
    public static final int ASYNC = 16;
    public static final int NO_RUN = 32;
    public static final int DEFAULT_ON_CLONE = 64;
    public static final int CONFIRM_REQUIRED = 128;
    public static final int OPERATOR = 256;
    public static final int EXECUTE_ON_CHANGE = 512;
    public static final int FAN_IN = 1024;
    public static final int NO_AUDIT = 2048;
    public static final int COMPOSITE = 4096;
    public static final int REMOVE_ON_CLONE = 8192;
    public static final int METADATA = 16384;
    public static final int LINK_TARGET = 32768;
    public static final int NON_CRITICAL = 65536;
    public static final int USER_DEFINED_1 = 0x10000000;
    public static final int USER_DEFINED_2 = 0x20000000;
    public static final int USER_DEFINED_3 = 0x40000000;
    public static final int USER_DEFINED_4 = Integer.MIN_VALUE;
    private static final Flag[] FLAGS = new Flag[]{new Flag(1, 'r', "readonly"), new Flag(2, 't', "transient"), new Flag(4, 'h', "hidden"), new Flag(8, 's', "summary"), new Flag(16, 'a', "async"), new Flag(32, 'n', "noRun"), new Flag(64, 'd', "defaultOnClone"), new Flag(128, 'c', "confirmRequired"), new Flag(256, 'o', "operator"), new Flag(512, 'x', "executeOnChange"), new Flag(1024, 'f', "fanIn"), new Flag(2048, 'A', "noAudit"), new Flag(4096, 'p', "composite"), new Flag(8192, 'R', "removeOnClone"), new Flag(16384, 'm', "metadata"), new Flag(65536, 'N', "nonCritical"), new Flag(32768, 'L', "linkTarget"), new Flag(0x10000000, '1', "userDefined1"), new Flag(0x20000000, '2', "userDefined2"), new Flag(0x40000000, '3', "userDefined3"), new Flag(Integer.MIN_VALUE, '4', "userDefined4")};
    private static final IntHashMap byBit = new IntHashMap();
    private static final HashMap byName = new HashMap();
    private static final Flag[] bySymbol = new Flag[128];

    public static final Flag[] getFlags() {
        return (Flag[])FLAGS.clone();
    }

    public static final Flag getByBit(int n) {
        return (Flag)byBit.get(n);
    }

    public static final Flag getByName(String string) {
        return (Flag)byName.get(string);
    }

    public static final Flag getBySymbol(char c) {
        if (c < '\u0080') {
            return bySymbol[c];
        }
        return null;
    }

    public static final boolean isTransient(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isReadonly(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isHidden(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isSummary(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isAsync(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x10) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isNoRun(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x20) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isDefaultOnClone(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x40) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isConfirmRequired(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x80) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isOperator(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x100) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isAdmin(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x100) == 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isExecuteOnChange(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x200) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isFanIn(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x400) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isNoAudit(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x800) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isComposite(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x1000) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isRemoveOnClone(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x2000) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isMetadata(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x4000) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isLinkTarget(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x8000) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isNonCritical(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x10000) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isUserDefined1(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x10000000) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isUserDefined2(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x20000000) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isUserDefined3(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & 0x40000000) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isUserDefined4(BComplex bComplex, Slot slot) {
        boolean bl = false;
        if ((bComplex.getFlags(slot) & Integer.MIN_VALUE) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final void setAllReadonly(BComponent bComponent, boolean bl, Context context) {
        Context context2 = Transaction.start(bComponent, context);
        Property[] propertyArray = bComponent.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            BValue bValue = bComponent.get(property);
            if (!(bValue instanceof BComponent)) {
                int n2 = bComponent.getFlags(property);
                if (bl) {
                    if ((n2 & 1) == 0) {
                        bComponent.setFlags(property, n2 | 1, context2);
                    }
                } else if ((n2 & 1) != 0 && (property.isDynamic() || (property.getDefaultFlags() & 1) == 0)) {
                    bComponent.setFlags(property, n2 & 0xFFFFFFFE, context2);
                }
            }
            ++n;
        }
        try {
            Transaction.end(bComponent, context2);
        }
        catch (Exception exception) {
            throw new BajaRuntimeException("setAllReadonly failed", exception);
        }
    }

    public static final String encodeToString(int n) {
        StringBuffer stringBuffer = new StringBuffer(32);
        int n2 = 0;
        while (n2 < FLAGS.length) {
            if ((Flags.FLAGS[n2].mask & n) != 0) {
                stringBuffer.append(Flags.FLAGS[n2].symbol);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final int decodeFromString(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            Flag flag = Flags.getBySymbol(string.charAt(n2));
            if (flag != null) {
                n |= flag.mask;
            }
            ++n2;
        }
        return n;
    }

    public static final String toDisplayString(int n, Context context) {
        if (n == 0) {
            return Lexicon.make(Sys.getBajaModule(), context).getText("flag.none");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < FLAGS.length) {
            Flag flag = FLAGS[n2];
            if ((flag.mask & n) != 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',').append(' ');
                }
                stringBuffer.append(flag.getDisplayName(context));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    static {
        int n = 0;
        while (n < FLAGS.length) {
            Flag flag = FLAGS[n];
            byBit.put(flag.mask, (Object)flag);
            byName.put(flag.name, flag);
            Flags.bySymbol[flag.symbol] = flag;
            ++n;
        }
    }

    public static class Flag {
        String name;
        char symbol;
        int mask;
        String lexKey;

        public int getMask() {
            return this.mask;
        }

        public char getSymbol() {
            return this.symbol;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName(Context context) {
            return Lexicon.make(Sys.getBajaModule(), context).getText(this.lexKey);
        }

        public String toString() {
            return this.name;
        }

        Flag(int n, char c, String string) {
            this.mask = n;
            this.symbol = c;
            this.name = string;
            this.lexKey = "flag." + string;
        }
    }
}

