/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.nre.util.PlatformUtil;
import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import javax.baja.log.Log;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;

public class Clock {
    private static Log log = Log.getLog("sys.clock");
    private static Object timeLock = new Object();
    private static long lastMillis;
    private static BAbsTime lastTime;
    public static final Ticket expiredTicket;

    public static long ticks() {
        return PlatformUtil.ticks();
    }

    public static long nanoTicks() {
        try {
            if (NreLib.nativesLoaded) {
                return Clock.nanoTicks0();
            }
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: Clock.nanoTicks(): " + throwable);
        }
        return System.currentTimeMillis() * 1000000L;
    }

    private static final native long nanoTicks0();

    public static long millis() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BAbsTime time(int n) {
        Object object = timeLock;
        synchronized (object) {
            long l = System.currentTimeMillis();
            long l2 = l - lastMillis;
            if (l2 > (long)n || -l2 > (long)n) {
                lastMillis = l;
                lastTime = BAbsTime.make(l);
            }
            return lastTime;
        }
    }

    public static BAbsTime time() {
        return Clock.time(100);
    }

    public static BAbsTime nextTopOfMinute() {
        long l = System.currentTimeMillis();
        BAbsTime bAbsTime = BAbsTime.make(l);
        return BAbsTime.make(l + 60000L - (long)(bAbsTime.getSecond() * 1000) - (long)bAbsTime.getMillisecond());
    }

    public static void setTime(BAbsTime bAbsTime) {
        log.message("Changing system time " + Clock.time(0) + " -> " + bAbsTime);
        Clock.setTime0(bAbsTime.getMillis());
    }

    private static final native void setTime0(long var0);

    public static Ticket schedule(BComponent bComponent, BRelTime bRelTime, Action action, BValue bValue) {
        return Nre.engineManager.schedule(bComponent, bRelTime, action, bValue);
    }

    public static Ticket schedule(BComponent bComponent, BAbsTime bAbsTime, Action action, BValue bValue) {
        return Nre.engineManager.schedule(bComponent, bAbsTime, action, bValue);
    }

    public static Ticket schedulePeriodically(BComponent bComponent, BRelTime bRelTime, Action action, BValue bValue) {
        return Nre.engineManager.schedulePeriodically(bComponent, bRelTime, action, bValue);
    }

    public static Ticket schedulePeriodically(BComponent bComponent, BAbsTime bAbsTime, BRelTime bRelTime, Action action, BValue bValue) {
        return Nre.engineManager.schedulePeriodically(bComponent, bAbsTime, bRelTime, action, bValue);
    }

    static {
        expiredTicket = new ExpiredTicket();
    }

    private static class ExpiredTicket
    implements Ticket {
        public void cancel() {
        }

        public boolean isExpired() {
            return true;
        }

        public BComponent getComponent() {
            return null;
        }

        public Action getAction() {
            return null;
        }

        public BValue getActionArgument() {
            return null;
        }

        public String toString() {
            return "Ticket: expired";
        }

        private ExpiredTicket() {
        }
    }

    public static interface Ticket {
        public void cancel();

        public boolean isExpired();

        public BComponent getComponent();

        public Action getAction();

        public BValue getActionArgument();
    }
}

