/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.util.TimeFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BITime;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BTime
extends BSimple
implements BITime,
BIComparable {
    public static final BTime DEFAULT;
    public static final BTime MIDNIGHT;
    public static final Type TYPE;
    private int bits;
    static /* synthetic */ Class class$javax$baja$sys$BTime;

    public static final BTime make(BAbsTime bAbsTime) {
        return BTime.make(bAbsTime.getHour(), bAbsTime.getMinute(), bAbsTime.getSecond(), bAbsTime.getMillisecond());
    }

    public static final BTime make(BRelTime bRelTime) {
        long l = bRelTime.getMillis();
        int n = (int)((l %= 86400000L) / 3600000L);
        int n2 = (int)((l %= 3600000L) / 60000L);
        int n3 = (int)((l %= 60000L) / 1000L);
        return BTime.make(n, n2, n3, (int)(l %= 1000L));
    }

    public static final BTime make(int n, int n2, int n3) {
        return BTime.make(n, n2, n3, 0);
    }

    public static final BTime make(int n, int n2, int n3, int n4) {
        if (n < 0 || n > 23 || n2 < 0 || n2 > 59 || n3 < 0 || n3 > 59 || n4 < 0 || n4 > 999) {
            throw new IllegalArgumentException("Invalid field: " + n + ':' + n2 + ':' + n3 + '.' + n4);
        }
        if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
            return DEFAULT;
        }
        return (BTime)new BTime(n, n2, n3, n4).intern();
    }

    public final int getHour() {
        return this.bits >> 27 & 0x1F;
    }

    public final int getMinute() {
        return this.bits >> 21 & 0x3F;
    }

    public final int getSecond() {
        return this.bits >> 15 & 0x3F;
    }

    public final int getMillisecond() {
        return this.bits & Short.MAX_VALUE;
    }

    public final long getTimeOfDayMillis() {
        long l = (long)this.getHour() * 3600000L;
        l += (long)this.getMinute() * 60000L;
        l += (long)this.getSecond() * 1000L;
        return l += (long)this.getMillisecond();
    }

    public final BTime add(BRelTime bRelTime) {
        return BTime.make(BRelTime.make(bRelTime.getMillis() + this.getTimeOfDayMillis()));
    }

    public final String toString(Context context) {
        return TimeFormat.format(this, context);
    }

    public final int compareTo(Object object) {
        if (!(object instanceof BTime)) {
            return 0;
        }
        long l = (long)this.bits & 0xFFFFFFFFFL;
        long l2 = (long)((BTime)object).bits & 0xFFFFFFFFFL;
        if (l < l2) {
            return -1;
        }
        if (l == l2) {
            return 0;
        }
        return 1;
    }

    public final boolean isBefore(BTime bTime) {
        boolean bl = false;
        if (this.compareTo(bTime) < 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAfter(BTime bTime) {
        boolean bl = false;
        if (this.compareTo(bTime) > 0) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return this.bits;
    }

    public final boolean equals(Object object) {
        if (object instanceof BTime) {
            boolean bl = false;
            if (((BTime)object).bits == this.bits) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.getHour());
        dataOutput.writeByte(this.getMinute());
        dataOutput.writeByte(this.getSecond());
        dataOutput.writeShort(this.getMillisecond());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BTime.make(dataInput.readUnsignedByte(), dataInput.readUnsignedByte(), dataInput.readUnsignedByte(), dataInput.readUnsignedShort());
    }

    public final String encodeToString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        int n = this.getHour();
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n).append(':');
        int n2 = this.getMinute();
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2).append(':');
        int n3 = this.getSecond();
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3).append('.');
        int n4 = this.getMillisecond();
        if (n4 < 10) {
            stringBuffer.append('0');
        }
        if (n4 < 100) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n4);
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        char[] cArray = string.toCharArray();
        try {
            int n = 0;
            int n2 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48);
            if (cArray[n++] != ':') {
                throw new Exception();
            }
            int n3 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48);
            if (cArray[n++] != ':') {
                throw new Exception();
            }
            int n4 = (cArray[n++] - 48) * 10 + (cArray[n++] - 48);
            if (cArray[n++] != '.') {
                throw new Exception();
            }
            int n5 = (cArray[n++] - 48) * 100 + (cArray[n++] - 48) * 10 + (cArray[n++] - 48);
            return BTime.make(n2, n3, n4, n5);
        }
        catch (Exception exception) {
            throw new IOException("Invalid BTime: " + string);
        }
    }

    public final Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 116) {
            if (this.getMillisecond() != 0) {
                return Boolean.TRUE;
            }
            return null;
        }
        return super.fw(n, object, object2, object3, object4);
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BTime(int n, int n2, int n3, int n4) {
        this.bits = n << 27 | n2 << 21 | n3 << 15 | n4;
    }

    static {
        MIDNIGHT = DEFAULT = new BTime(0, 0, 0, 0);
        Class clazz = class$javax$baja$sys$BTime;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BTime = BTime.class("[Ljavax.baja.sys.BTime;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

