/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.schema.ComponentSlotMap;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLink
extends BStruct {
    public static final Property sourceOrd = BLink.newProperty(0, BOrd.NULL, BFacets.make("targetType", "baja:Component"));
    public static final Property sourceSlotName = BLink.newProperty(0, "");
    public static final Property targetSlotName = BLink.newProperty(0, "");
    public static final Property enabled = BLink.newProperty(0, true);
    private static final BIcon icon = BIcon.std("link.png");
    public static final Type TYPE;
    private static final Log log;
    private static final Context SKIP_CRITICAL_CX;
    private BComponent direct;
    private BComponent indirect;
    private Slot sourceSlot;
    private Slot targetSlot;
    private boolean active;
    private Knob knob;
    private boolean fatalFault;
    static /* synthetic */ Class class$javax$baja$sys$BLink;

    public final BOrd getSourceOrd() {
        return (BOrd)this.get(sourceOrd);
    }

    public final void setSourceOrd(BOrd bOrd) {
        this.set(sourceOrd, (BValue)bOrd, null);
    }

    public final String getSourceSlotName() {
        return this.getString(sourceSlotName);
    }

    public final void setSourceSlotName(String string) {
        this.setString(sourceSlotName, string, null);
    }

    public final String getTargetSlotName() {
        return this.getString(targetSlotName);
    }

    public final void setTargetSlotName(String string) {
        this.setString(targetSlotName, string, null);
    }

    public final boolean isEnabled() {
        return this.getBoolean(enabled);
    }

    public final boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public final void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public final boolean isDirect() {
        boolean bl = false;
        if (this.direct != null) {
            bl = true;
        }
        return bl;
    }

    public final boolean isIndirect() {
        boolean bl = false;
        if (this.direct == null) {
            bl = true;
        }
        return bl;
    }

    public final BComponent getSourceComponent() {
        if (this.direct != null) {
            return this.direct;
        }
        if (!this.active) {
            throw new UnresolvedException();
        }
        return this.indirect;
    }

    public final Slot getSourceSlot() {
        if (this.direct != null) {
            return this.sourceSlot;
        }
        if (!this.active) {
            throw new UnresolvedException();
        }
        return this.sourceSlot;
    }

    public final BComponent getTargetComponent() {
        return (BComponent)this.getParent();
    }

    public final Slot getTargetSlot() {
        if (this.direct != null) {
            return this.targetSlot;
        }
        if (!this.active) {
            throw new UnresolvedException();
        }
        return this.targetSlot;
    }

    public final boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void activate() {
        block15: {
            block14: {
                if (BLink.runningInStation() && !Metrics.incrementLink()) {
                    this.fatalFault = true;
                    BLink.log.error("Exceeded link limit for globalCapacity");
                }
                if (this.active) {
                    return;
                }
                var1_1 = (BComponent)this.getParent();
                if (var1_1 == null) {
                    throw new IllegalStateException("not mounted in component");
                }
                var2_2 = this.isDirect() != false ? this.direct : this.resolve();
                var3_3 = var1_1.getSlot(this.getTargetSlotName());
                if (var3_3 != null && var3_3.isProperty() && ((var4_4 = var3_3.asProperty()).getType().is(BPassword.TYPE) || var4_4.getType().is(BPermissionsMap.TYPE))) {
                    BLink.log.warning("Link target can not be a BPassword or BPermissionsMap");
                    if (this.getParent().isComponent() == false) return;
                    this.getParent().asComponent().remove(this.getPropertyInParent());
                    return;
                }
                var4_4 = var2_2.getSlot(this.getSourceSlotName());
                if (var4_4 != null && var4_4.isProperty() && ((var5_5 = var4_4.asProperty()).getType().is(BPassword.TYPE) || var5_5.getType().is(BPermissionsMap.TYPE))) {
                    BLink.log.warning("Link source can not be a BPassword or BPermissionsMap");
                    if (this.getParent().isComponent() == false) return;
                    this.getParent().asComponent().remove(this.getPropertyInParent());
                    return;
                }
                try {
                    try {
                        this.active = true;
                        this.knob = ((ComponentSlotMap)var2_2.getSlotMap()).installKnob(this);
                    }
                    catch (RuntimeException var8_7) {
                        this.active = false;
                        throw var8_7;
                    }
                }
                catch (Throwable var5_6) {
                    var6_8 = null;
                    if (!this.active) {
                        this.recomputeSlotFlags(var1_1, var3_3);
                        throw var5_6;
                    }
                    try {
                        var1_1.setFlags(var3_3, var1_1.getFlags(var3_3) | 32768, BLink.SKIP_CRITICAL_CX);
                        throw var5_6;
                    }
                    catch (Exception var7_10) {
                        var7_10.printStackTrace();
                        throw var5_6;
                    }
                }
                {
                    var6_9 = null;
                    if (!this.active) break block14;
                }
                ** try [egrp 2[TRYBLOCK] [2 : 326->345)] { 
lbl45:
                // 1 sources

                var1_1.setFlags(var3_3, var1_1.getFlags(var3_3) | 32768, BLink.SKIP_CRITICAL_CX);
lbl47:
                // 1 sources

                catch (Exception var7_11) {
                    var7_11.printStackTrace();
                }
                break block15;
            }
            this.recomputeSlotFlags(var1_1, var3_3);
        }
        if (var4_4.isProperty() == false) return;
        if (var3_3.isProperty() == false) return;
        this.propagate(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void deactivate() {
        if (!this.active) {
            return;
        }
        BComponent bComponent = null;
        Slot slot = null;
        try {
            try {
                slot = this.getTargetSlot();
            }
            catch (Exception exception) {}
            if (this.active) {
                ((ComponentSlotMap)this.getSourceComponent().getSlotMap()).uninstallKnob(this);
                bComponent = this.getTargetComponent();
                ((ComponentSlotMap)bComponent.getSlotMap()).deactivating(this);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.active = false;
            this.knob = null;
            if (this.indirect != null) {
                this.indirect = null;
                this.sourceSlot = null;
                this.targetSlot = null;
            }
            this.recomputeSlotFlags(bComponent, slot);
            throw throwable;
        }
        {
            Object var4_5 = null;
            this.active = false;
            this.knob = null;
            if (this.indirect != null) {
                this.indirect = null;
                this.sourceSlot = null;
                this.targetSlot = null;
            }
            this.recomputeSlotFlags(bComponent, slot);
            return;
        }
    }

    private final void recomputeSlotFlags(BComponent bComponent, Slot slot) {
        if (bComponent == null) {
            return;
        }
        try {
            if (slot != null) {
                this.computeLinkTargetFlag(bComponent, slot);
            } else {
                SlotCursor slotCursor = bComponent.getSlots();
                while (slotCursor.nextObject()) {
                    this.computeLinkTargetFlag(bComponent, slotCursor.slot());
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private final void computeLinkTargetFlag(BComponent bComponent, Slot slot) {
        try {
            int n = bComponent.getFlags(slot);
            BLink[] bLinkArray = bComponent.getLinks(slot);
            int n2 = 0;
            if (bLinkArray != null) {
                n2 = bLinkArray.length;
            }
            int n3 = n2;
            boolean bl = false;
            int n4 = 0;
            while (n4 < n3) {
                if (bLinkArray[n4].isActive()) {
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (bl) {
                bComponent.setFlags(slot, n | 0x8000, SKIP_CRITICAL_CX);
            } else {
                bComponent.setFlags(slot, n & 0xFFFF7FFF, SKIP_CRITICAL_CX);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Knob getKnob() {
        if (!this.active) {
            throw new UnresolvedException();
        }
        return this.knob;
    }

    private final BComponent resolve() {
        this.indirect = null;
        try {
            BObject bObject = this.getSourceOrd().resolve(this.getParentComponent()).get();
            if (!(bObject instanceof BComponent)) {
                throw new BajaRuntimeException("Source ord must resolve to a component");
            }
            this.indirect = (BComponent)bObject;
        }
        catch (UnresolvedException unresolvedException) {
            throw new UnresolvedException("Cannot resolve source component");
        }
        this.sourceSlot = this.indirect.getSlot(this.getSourceSlotName());
        if (this.sourceSlot == null) {
            throw new UnresolvedException("Source slot does not exist");
        }
        this.targetSlot = this.getParent().getSlot(this.getTargetSlotName());
        if (this.targetSlot == null) {
            throw new UnresolvedException("Target slot does not exist");
        }
        return this.indirect;
    }

    public String toString(Context context) {
        Object object;
        String string = "null";
        BComponent bComponent = this.getTargetComponent();
        if (bComponent != null) {
            object = bComponent.getSlotPath();
            string = object == null ? bComponent.toString() : ((SlotPath)object).toString();
        }
        object = this.direct != null ? "Direct: " + this.direct.toDebugString() : "Indirect: " + this.getSourceOrd();
        return (String)object + '.' + this.getSourceSlotName() + " -> " + string + '.' + this.getTargetSlotName();
    }

    public void propagate(BValue bValue) {
        if (this.fatalFault) {
            return;
        }
        if (this.getTargetComponent() == this.getSourceComponent() && this.getTargetSlot() == this.getSourceSlot()) {
            System.out.println("WARNING: Infinite link: " + this);
            return;
        }
        if (this.sourceSlot.isAction()) {
            if (this.targetSlot.isAction()) {
                this.propagateActionToAction(bValue);
                return;
            }
            if (this.targetSlot.isTopic()) {
                this.propagateActionToTopic(bValue);
                return;
            }
        } else if (this.sourceSlot.isTopic()) {
            if (this.targetSlot.isAction()) {
                this.propagateTopicToAction(bValue);
                return;
            }
            if (this.targetSlot.isTopic()) {
                this.propagateTopicToTopic(bValue);
                return;
            }
        } else if (this.sourceSlot.isProperty()) {
            if (this.targetSlot.isAction()) {
                this.propagatePropertyToAction();
                return;
            }
            if (this.targetSlot.isProperty()) {
                this.propagatePropertyToProperty();
                return;
            }
        }
        throw new IllegalStateException("Invalid link config");
    }

    public void propagatePropertyToAction() {
        if (this.fatalFault) {
            return;
        }
        Action action = this.getTargetSlot().asAction();
        BValue bValue = null;
        if (action.getParameterType() != null) {
            bValue = this.getSourceComponent().get(this.getSourceSlot().asProperty());
        }
        this.getTargetComponent().invoke(action, bValue);
    }

    public void propagatePropertyToProperty() {
        if (this.fatalFault) {
            return;
        }
        BComponent bComponent = this.getSourceComponent();
        BComponent bComponent2 = this.getTargetComponent();
        Property property = this.sourceSlot.asProperty();
        Property property2 = this.targetSlot.asProperty();
        switch (property.getTypeAccess()) {
            case 0: {
                bComponent2.setBoolean(property2, bComponent.getBoolean(property), null);
                break;
            }
            case 2: {
                bComponent2.setInt(property2, bComponent.getInt(property), null);
                break;
            }
            case 3: {
                bComponent2.setLong(property2, bComponent.getLong(property), null);
                break;
            }
            case 4: {
                bComponent2.setFloat(property2, bComponent.getFloat(property), null);
                break;
            }
            case 5: {
                bComponent2.setDouble(property2, bComponent.getDouble(property), null);
                break;
            }
            case 6: {
                bComponent2.setString(property2, bComponent.getString(property), null);
                break;
            }
            case 7: {
                BValue bValue = bComponent.get(property);
                if (bValue.isSimple()) {
                    bComponent2.set(property2, bValue, null);
                    break;
                }
                bComponent2.get(property2).asComplex().copyFrom(bValue.asComplex());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void propagateActionToAction(BValue bValue) {
        if (this.fatalFault) {
            return;
        }
        Action action = this.getTargetSlot().asAction();
        this.getTargetComponent().invoke(action, bValue);
    }

    public void propagateActionToTopic(BValue bValue) {
        if (this.fatalFault) {
            return;
        }
        Topic topic = this.getTargetSlot().asTopic();
        this.getTargetComponent().fire(topic, bValue);
    }

    public void propagateTopicToAction(BValue bValue) {
        if (this.fatalFault) {
            return;
        }
        Action action = this.getTargetSlot().asAction();
        BValue bValue2 = null;
        if (action.getParameterType() != null) {
            bValue2 = bValue;
        }
        this.getTargetComponent().invoke(action, bValue2);
    }

    public void propagateTopicToTopic(BValue bValue) {
        if (this.fatalFault) {
            return;
        }
        Topic topic = this.getTargetSlot().asTopic();
        this.getTargetComponent().fire(topic, bValue);
    }

    public boolean isFatalFault() {
        return this.fatalFault;
    }

    private static final boolean runningInStation() {
        boolean bl = false;
        if (Sys.getStation() != null) {
            bl = true;
        }
        return bl;
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.fatalFault = false;
    }

    public BLink(BOrd bOrd, String string, String string2, boolean bl) {
        this.this();
        this.setSourceOrd(bOrd);
        this.setSourceSlotName(string);
        this.setTargetSlotName(string2);
        this.setEnabled(bl);
    }

    public BLink(BComponent bComponent, Slot slot, Slot slot2) {
        this.this();
        if (bComponent.getSlot(slot.getName()) == null) {
            log.warning("No Such Slot: " + bComponent.getType() + '.' + slot.getName());
        }
        this.direct = bComponent;
        this.setSourceSlotName(slot.getName());
        this.setTargetSlotName(slot2.getName());
        this.sourceSlot = slot;
        this.targetSlot = slot2;
    }

    public BLink() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$sys$BLink;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BLink = BLink.class("[Ljavax.baja.sys.BLink;", false);
        }
        TYPE = Sys.loadType(clazz);
        log = Log.getLog("sys.link");
        SKIP_CRITICAL_CX = BDataRecoveryComponentRecorder.SKIP_CRITICAL_CX;
    }
}

