/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.schema.EnumType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BEnumRange
extends BSimple
implements BIDataValue {
    static int[] noDynamic = new int[0];
    static String[] noTags = new String[0];
    static IntHashMap noByOrdinal = new IntHashMap();
    static HashMap noByTag = new HashMap();
    public static final BEnumRange NULL;
    public static final BEnumRange DEFAULT;
    public static final Type TYPE;
    static final BEnumRange BOOLEAN_RANGE;
    private EnumType frozen;
    private int[] dynamic;
    private IntHashMap byOrdinal;
    private HashMap byTag;
    private String string;
    private BFacets options;
    private String lexicon;
    BFacets asFacets;
    private int hashCode;
    static /* synthetic */ Class class$javax$baja$sys$BEnumRange;

    public static final BEnumRange make(Type type) {
        return BEnumRange.make(type, null, null, 0);
    }

    public static final BEnumRange make(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = n;
            ++n;
        }
        return BEnumRange.make(null, nArray, stringArray, nArray.length);
    }

    public static final BEnumRange make(int[] nArray, String[] stringArray) {
        return BEnumRange.make(null, nArray, stringArray, nArray.length);
    }

    public static final BEnumRange make(Type type, int[] nArray, String[] stringArray) {
        return BEnumRange.make(type, nArray, stringArray, nArray.length);
    }

    public static final BEnumRange make(Type type, int[] nArray, String[] stringArray, int n) {
        return BEnumRange.make(type, nArray, stringArray, n, null);
    }

    public static final BEnumRange make(Type type, int[] nArray, String[] stringArray, int n, BFacets bFacets) {
        if (bFacets == null) {
            bFacets = BFacets.DEFAULT;
        }
        if (nArray == null) {
            nArray = noDynamic;
        }
        if (stringArray == null) {
            stringArray = noTags;
        }
        EnumType enumType = null;
        if (type instanceof EnumType) {
            enumType = (EnumType)type;
        } else if (type != null) {
            throw new IllegalArgumentException("frozen type is not baja:FrozenEnum - " + type);
        }
        if (n == 0 && bFacets.isNull()) {
            if (enumType == null) {
                return DEFAULT;
            }
            if (enumType.getRange(false) != null) {
                return enumType.getRange(false);
            }
            return (BEnumRange)new BEnumRange(enumType, noDynamic, noByOrdinal, noByTag, bFacets).intern();
        }
        IntHashMap intHashMap = new IntHashMap();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n2 = 0;
        int[] nArray2 = new int[n];
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            String string = stringArray[n3];
            SlotPath.verifyValidName(string);
            if (enumType != null && enumType.isOrdinal(n4)) {
                Log.getLog("sys").warning("Ignoring dynamic enumeration " + n4 + ':' + string + " in fixed enum " + type.getTypeName());
            } else {
                if (intHashMap.get(n4) != null) {
                    throw new IllegalArgumentException("Duplicate ordinal: " + string + '=' + n4);
                }
                if (hashMap.get(string) != null) {
                    throw new IllegalArgumentException("Duplicate tag: " + string + '=' + n4);
                }
                intHashMap.put(n4, (Object)string);
                hashMap.put(string, new Integer(n4));
                nArray2[n2++] = n4;
            }
            ++n3;
        }
        int[] nArray3 = new int[n2];
        System.arraycopy(nArray2, 0, nArray3, 0, n2);
        return (BEnumRange)new BEnumRange(enumType, nArray3, intHashMap, hashMap, bFacets).intern();
    }

    public final int[] getOrdinals() {
        int[] nArray = noDynamic;
        if (this.frozen != null) {
            nArray = this.frozen.getOrdinals();
        }
        int[] nArray2 = new int[nArray.length + this.dynamic.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        System.arraycopy(this.dynamic, 0, nArray2, nArray.length, this.dynamic.length);
        return nArray2;
    }

    public final boolean isOrdinal(int n) {
        if (this.frozen != null && this.frozen.isOrdinal(n)) {
            return true;
        }
        boolean bl = false;
        if (this.byOrdinal.get(n) != null) {
            bl = true;
        }
        return bl;
    }

    public final String getTag(int n) {
        String string = (String)this.byOrdinal.get(n);
        if (string != null) {
            return string;
        }
        if (this.frozen != null && this.frozen.isOrdinal(n)) {
            return this.frozen.getTag(n);
        }
        return String.valueOf(n);
    }

    public final String getDisplayTag(int n, Context context) {
        if (this.frozen != null && this.frozen.isOrdinal(n)) {
            return this.frozen.get(n).getDisplayTag(context);
        }
        String string = (String)this.byOrdinal.get(n);
        if (string != null) {
            String string2;
            if (this.lexicon != null && (string2 = Lexicon.make(this.lexicon, context).get(string, null)) != null) {
                return string2;
            }
            if (string != null) {
                return SlotPath.unescape(string);
            }
        }
        return String.valueOf(n);
    }

    public final boolean isTag(String string) {
        if (this.frozen != null && this.frozen.isTag(string)) {
            return true;
        }
        boolean bl = false;
        if (this.byTag.get(string) != null) {
            bl = true;
        }
        return bl;
    }

    public final int tagToOrdinal(String string) {
        if (this.frozen != null && this.frozen.isTag(string)) {
            return this.frozen.tagToOrdinal(string);
        }
        Integer n = (Integer)this.byTag.get(string);
        if (n != null) {
            return n;
        }
        throw new InvalidEnumException(string);
    }

    public final BEnum get(int n) {
        return this.get(n, true);
    }

    public final BEnum get(int n, boolean bl) {
        if (this == BOOLEAN_RANGE) {
            return n == 0 ? BBoolean.FALSE : BBoolean.TRUE;
        }
        if (this.frozen != null && this.frozen.isOrdinal(n)) {
            return this.frozen.get(n);
        }
        if (bl) {
            return BDynamicEnum.make(n, this);
        }
        throw new InvalidEnumException(n);
    }

    public final BEnum get(String string) {
        if (this == BOOLEAN_RANGE) {
            return string.equals("false") ? BBoolean.FALSE : BBoolean.TRUE;
        }
        if (this.frozen != null && this.frozen.isTag(string)) {
            return this.frozen.get(string);
        }
        if (this.byTag.get(string) != null) {
            return BDynamicEnum.make((Integer)this.byTag.get(string), this);
        }
        throw new InvalidEnumException(string);
    }

    public final boolean isFrozenOrdinal(int n) {
        boolean bl = false;
        if (this.frozen != null && this.frozen.isOrdinal(n)) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDynamicOrdinal(int n) {
        boolean bl = false;
        if (this.byOrdinal.get(n) != null) {
            bl = true;
        }
        return bl;
    }

    public final Type getFrozenType() {
        return this.frozen;
    }

    public final BFacets getOptions() {
        return this.options;
    }

    public final boolean isNull() {
        boolean bl = false;
        if (this.frozen == null && this.dynamic.length == 0) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception exception) {
            return System.identityHashCode(this);
        }
    }

    public final boolean equals(Object object) {
        if (object instanceof BEnumRange) {
            EnumType enumType;
            BEnumRange bEnumRange = (BEnumRange)object;
            EnumType enumType2 = this.frozen == null ? null : this.frozen;
            EnumType enumType3 = enumType = bEnumRange.frozen == null ? null : bEnumRange.frozen;
            if (enumType2 != enumType) {
                return false;
            }
            return this.byOrdinal.equals((Object)bEnumRange.byOrdinal);
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final String encodeToString() throws IOException {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.frozen != null) {
                stringBuffer.append(this.frozen.getModule().getModuleName()).append(':').append(this.frozen.getTypeName());
            }
            if (this.dynamic.length > 0 || this.frozen == null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('+');
                }
                stringBuffer.append('{');
                int n = 0;
                while (n < this.dynamic.length) {
                    int n2 = this.dynamic[n];
                    String string = (String)this.byOrdinal.get(n2);
                    if (n > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(string).append('=').append(n2);
                    ++n;
                }
                stringBuffer.append('}');
            }
            if (!this.options.isNull()) {
                stringBuffer.append('?').append(this.options.encodeToString());
            }
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public final String encodeToStringExpanded() throws IOException {
        if (this.frozen == null) {
            return this.encodeToString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = this.getOrdinals();
        stringBuffer.append('{');
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            String string = this.getTag(n2);
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string).append('=').append(n2);
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            if (string.equals("{}")) {
                return DEFAULT;
            }
            BFacets bFacets = null;
            int n = string.indexOf(63);
            if (n > 0) {
                bFacets = BFacets.make(string.substring(n + 1));
                string = string.substring(0, n);
            }
            String[] stringArray = BEnumRange.splitFrozenDynamic(string);
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            Type type = null;
            if (string2 != null) {
                try {
                    type = Sys.getType(string2);
                }
                catch (ModuleNotFoundException moduleNotFoundException) {
                    return NULL;
                }
            }
            if (string3 == null) {
                return BEnumRange.make(type, null, null, 0, bFacets);
            }
            if (string3.charAt(0) != '{') {
                throw new IOException();
            }
            if (string3.charAt(string3.length() - 1) != '}') {
                throw new IOException();
            }
            string3 = string3.substring(1, string3.length() - 1);
            int n2 = string3.length() / 4 + 1;
            int[] nArray = new int[n2];
            String[] stringArray2 = new String[n2];
            n2 = BEnumRange.parseDynamic(string3, nArray, stringArray2);
            return BEnumRange.make(type, nArray, stringArray2, n2, bFacets);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(string);
        }
    }

    static final String[] splitFrozenDynamic(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(43);
        if (n < 0) {
            if (string.startsWith("{")) {
                string3 = string;
            } else {
                string2 = string;
            }
        } else if (string.startsWith("{")) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        return new String[]{string2, string3};
    }

    static final int parseDynamic(String string, int[] nArray, String[] stringArray) throws Exception {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=,");
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        return n;
    }

    public final BIDataValue toDataValue() {
        return this;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.hashCode = -1;
    }

    private BEnumRange(EnumType enumType, int[] nArray, IntHashMap intHashMap, HashMap hashMap, BFacets bFacets) {
        this.this();
        this.frozen = enumType;
        this.dynamic = nArray;
        this.byOrdinal = intHashMap;
        this.byTag = hashMap;
        this.options = bFacets;
        this.lexicon = bFacets.gets("lexicon", null);
    }

    static {
        DEFAULT = NULL = new BEnumRange(null, noDynamic, noByOrdinal, noByTag, BFacets.DEFAULT);
        Class clazz = class$javax$baja$sys$BEnumRange;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BEnumRange = BEnumRange.class("[Ljavax.baja.sys.BEnumRange;", false);
        }
        TYPE = Sys.loadType(clazz);
        BOOLEAN_RANGE = BEnumRange.make(new String[]{"false", "true"});
    }
}

