/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.Nre;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Locale;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BDouble
extends BNumber {
    public static final BDouble POSITIVE_INFINITY = new BDouble(Double.POSITIVE_INFINITY);
    public static final BDouble NEGATIVE_INFINITY = new BDouble(Double.NEGATIVE_INFINITY);
    public static final BDouble NaN = new BDouble(Double.NaN);
    public static final BDouble DEFAULT = new BDouble(0.0);
    public static final Type TYPE;
    private static HashMap formatters;
    private static DecimalFormat fSN;
    private static final long MAX_LONG_PREC = 0x20000000000000L;
    private double value;
    static /* synthetic */ Class class$javax$baja$sys$BDouble;

    public static final BDouble make(double d) {
        if (d == 0.0) {
            return DEFAULT;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (Double.isNaN(d)) {
            return NaN;
        }
        return new BDouble(d);
    }

    public static final BDouble make(String string) {
        return BDouble.make(BDouble.decode(string));
    }

    public final int getInt() {
        return (int)this.value;
    }

    public final float getFloat() {
        return (float)this.value;
    }

    public final long getLong() {
        return (long)this.value;
    }

    public final double getDouble() {
        return this.value;
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public final boolean equals(Object object) {
        if (object instanceof BDouble) {
            double d = ((BDouble)object).value;
            if (d == this.value) {
                return true;
            }
            if (Double.isNaN(d) && Double.isNaN(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean equals(double d, double d2) {
        if (d == d2) {
            return true;
        }
        return Double.isNaN(d) && Double.isNaN(d2);
    }

    public final int compareTo(Object object) {
        double d = this.value;
        double d2 = ((BNumber)object).getDouble();
        if (d == d2) {
            return 0;
        }
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            return 0;
        }
        if (d < d2) {
            return -1;
        }
        return 1;
    }

    public final String toString(Context context) {
        return BDouble.toString(this.value, context);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.value);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BDouble.make(dataInput.readDouble());
    }

    public final String encodeToString() throws IOException {
        return BDouble.encode(this.value);
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            return BDouble.make(string);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("Invalid double: " + string + '\n' + runtimeException.toString());
        }
    }

    public static final String encode(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return "+inf";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (Double.isNaN(d)) {
            return "nan";
        }
        return String.valueOf(d);
    }

    public static final double decode(String string) {
        if (string.equals("+inf")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equals("-inf")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (string.equals("nan")) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            try {
                ParsePosition parsePosition = new ParsePosition(0);
                Number number = fSN.parse(string, parsePosition);
                if (parsePosition.getIndex() != string.length()) {
                    System.out.println("WARNING: BDouble '" + string + "' appears to have a localized encoding. Will try localized decode:");
                    Locale[] localeArray = DecimalFormat.getAvailableLocales();
                    int n = 0;
                    while (n < localeArray.length) {
                        parsePosition.setIndex(0);
                        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance(localeArray[n]);
                        decimalFormat.applyPattern(fSN.toPattern());
                        System.out.print("  Trying locale: " + localeArray[n].getCountry() + " (" + localeArray[n].getDisplayCountry() + ") - " + decimalFormat.toLocalizedPattern());
                        number = decimalFormat.parse(string, parsePosition);
                        if (parsePosition.getIndex() == string.length()) {
                            System.out.println(" Success!");
                            return number.doubleValue();
                        }
                        System.out.println(" Failed.");
                        ++n;
                    }
                }
            }
            catch (Exception exception2) {
                exception.printStackTrace();
            }
        }
        throw new IllegalStateException("Unable to decode BDouble: " + string);
    }

    public static final String toString(double d, Context context) {
        BSimple bSimple;
        Object object;
        int n = 2;
        BUnit bUnit = null;
        int n2 = 10;
        int n3 = Nre.unitConversion;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (context != null) {
            object = (BNumber)context.getFacet("precision");
            if (object != null) {
                n = ((BNumber)object).getInt();
            }
            if ((bUnit = (BUnit)context.getFacet("units")) != null && bUnit.isNull()) {
                bUnit = null;
            }
            if ((bSimple = (BNumber)context.getFacet("radix")) != null) {
                n2 = ((BNumber)bSimple).getInt();
            }
            n3 = context.getFacets().geti("unitConversion", n3);
            bl = context.getFacets().getb("showUnits", bl);
            bl2 = context.getFacets().getb("showSeparators", bl2);
            bl3 = context.getFacets().getb("forceSign", bl3);
        }
        if (n3 != 0 && bUnit != null && (bSimple = ((BUnitConversion)(object = BUnitConversion.make(n3))).getDesiredUnit(bUnit)) != bUnit) {
            d = bUnit.convertTo((BUnit)bSimple, d);
            bUnit = bSimple;
        }
        Object object2 = object = bl3 && d > 0.0 ? "+" : "";
        if (bl && bUnit != null && bUnit.getIsPrefix()) {
            object = (String)object + bUnit.getSymbol() + ' ';
        }
        object = n2 != 10 ? (n2 == 2 ? Integer.toBinaryString((int)d) : (n2 == 8 ? Integer.toOctalString((int)d) : (n2 == 16 ? Integer.toHexString((int)d) : Integer.toString((int)d, n2)))) : (d == Double.POSITIVE_INFINITY ? "+inf" : (d == Double.NEGATIVE_INFINITY ? "-inf" : (Double.isNaN(d) ? "nan" : (Math.IEEEremainder(d, 1.0) == 0.0 ? ((long)Math.abs(d) >= 0x20000000000000L ? (String)object + fSN.format(d) : (String)object + BDouble.getFormatter(n, bl2).format(d)) : (String)object + BDouble.getFormatter(n, bl2).format(d)))));
        if (bl && bUnit != null && !bUnit.getIsPrefix()) {
            object = (String)object + ' ' + bUnit.getSymbol();
        }
        return object;
    }

    static final DecimalFormat getFormatter(int n, boolean bl) {
        String string = "" + n + bl;
        DecimalFormat decimalFormat = (DecimalFormat)formatters.get(string);
        if (decimalFormat == null) {
            StringBuffer stringBuffer = new StringBuffer(16);
            if (bl) {
                stringBuffer.append("#,##0");
            } else {
                stringBuffer.append("#0");
            }
            if (n > 0) {
                stringBuffer.append('.');
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append('0');
                    ++n2;
                }
            }
            decimalFormat = new DecimalFormat(stringBuffer.toString());
            formatters.put(string, decimalFormat);
        }
        return decimalFormat;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BDouble(double d) {
        this.value = d;
    }

    static {
        Class clazz = class$javax$baja$sys$BDouble;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BDouble = BDouble.class("[Ljavax.baja.sys.BDouble;", false);
        }
        TYPE = Sys.loadType(clazz);
        formatters = new HashMap();
        fSN = new DecimalFormat("0.###############E0");
    }
}

