/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.Nre;
import com.tridium.sys.engine.EngineUtil;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.sys.schema.NAction;
import com.tridium.sys.schema.NTopic;
import com.tridium.util.PxUtil;
import java.lang.reflect.Array;
import java.util.HashMap;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BICategorizable;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.registry.Registry;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BIProtected;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BConversionLink;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;
import javax.baja.util.BFolder;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BComponent
extends BComplex
implements BISpaceNode,
BIProtected,
BICategorizable,
BIPropertyContainer {
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 404) {
            BISession bISession = this.getSession();
            if (bISession != null && bISession instanceof BObject) {
                return ((BObject)((Object)bISession)).fw(n, object, object2, object3, object4);
            }
            return null;
        }
        return super.fw(n, object, object2, object3, object4);
    }

    public Object getHandle() {
        return this.slotMap.getHandle();
    }

    public SlotPath getSlotPath() {
        return this.slotMap.getSlotPath();
    }

    public void clearHandles() {
        if (this.isMounted()) {
            throw new IllegalStateException("Component is mounted");
        }
        ((ComponentSlotMap)this.slotMap).setHandle(null);
        BComponent[] bComponentArray = this.getChildComponents();
        int n = 0;
        while (n < bComponentArray.length) {
            bComponentArray[n].clearHandles();
            ++n;
        }
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean isRunning() {
        return this.slotMap.isRunning();
    }

    public final void start() {
        this.slotMap.start();
    }

    public final void stop() {
        this.slotMap.stop();
    }

    public void started() throws Exception {
    }

    public void descendantsStarted() throws Exception {
    }

    public void stopped() throws Exception {
    }

    public void descendantsStopped() throws Exception {
    }

    public void stationStarted() throws Exception {
    }

    public void atSteadyState() throws Exception {
    }

    public void clockChanged(BRelTime bRelTime) throws Exception {
    }

    public final boolean isSubscribed() {
        return this.slotMap.isSubscribed();
    }

    public final Subscriber[] getSubscribers() {
        return this.slotMap.getSubscribers();
    }

    public void subscribed() {
    }

    public void unsubscribed() {
    }

    public final boolean isPermanentlySubscribed() {
        return this.slotMap.isPermanentlySubscribed();
    }

    protected final void setPermanentlySubscribed(boolean bl) {
        this.slotMap.setPermanentlySubscribed(bl);
    }

    public final long getLeaseExpiration() {
        return Nre.leaseManager.getLeaseExpiration(this);
    }

    public final void lease() {
        this.lease(0, this.getDefaultLeaseTime());
    }

    public final void lease(int n) {
        this.lease(n, this.getDefaultLeaseTime());
    }

    public final void lease(int n, long l) {
        Nre.leaseManager.lease(this, n, l);
    }

    public static void lease(BComponent[] bComponentArray, int n) {
        BComponentSpace bComponentSpace;
        BComponent bComponent;
        long l = 60000L;
        if (bComponentArray != null && bComponentArray.length > 0 && (bComponent = bComponentArray[0]) != null && (bComponentSpace = bComponent.getComponentSpace()) != null) {
            l = bComponentSpace.getDefaultLeaseTime();
        }
        BComponent.lease(bComponentArray, n, l);
    }

    public static void lease(BComponent[] bComponentArray, int n, long l) {
        Nre.leaseManager.lease(bComponentArray, n, l);
    }

    private final long getDefaultLeaseTime() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace != null) {
            return bComponentSpace.getDefaultLeaseTime();
        }
        return 60000L;
    }

    public final boolean isMounted() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return false;
        }
        return bComponentSpace.isMounted();
    }

    public final BHost getHost() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace != null) {
            return bComponentSpace.getHost();
        }
        return null;
    }

    public final BISession getSession() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace != null) {
            return bComponentSpace.getSession();
        }
        return null;
    }

    public final BSpace getSpace() {
        return this.getComponentSpace();
    }

    public final BComponentSpace getComponentSpace() {
        return this.slotMap == null ? null : this.slotMap.getSpace();
    }

    public boolean isComponentReadonly() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return false;
        }
        return bComponentSpace.isSpaceReadonly();
    }

    public BOrd getAbsoluteOrd() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return null;
        }
        BOrd bOrd = bComponentSpace.getAbsoluteOrd();
        if (bOrd == null) {
            return null;
        }
        return BOrd.make(bOrd, this.getOrdInSpace());
    }

    public BOrd getOrdInHost() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return null;
        }
        BOrd bOrd = bComponentSpace.getOrdInHost();
        if (bOrd == null) {
            return null;
        }
        return BOrd.make(bOrd, this.getOrdInSpace());
    }

    public BOrd getOrdInSession() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return null;
        }
        BOrd bOrd = bComponentSpace.getOrdInSession();
        if (bOrd == null) {
            return null;
        }
        return BOrd.make(bOrd, this.getOrdInSpace());
    }

    public BOrd getOrdInSpace() {
        return this.getHandleOrd();
    }

    public BOrd getHandleOrd() {
        Object object = this.getHandle();
        if (object == null) {
            return null;
        }
        return BOrd.make("h:" + object);
    }

    public BOrd getSlotPathOrd() {
        SlotPath slotPath = this.getSlotPath();
        if (slotPath == null) {
            return null;
        }
        return BOrd.make(slotPath);
    }

    public final boolean isPendingMove() {
        return this.slotMap.isPendingMove();
    }

    public void setPendingMove(boolean bl) {
        this.slotMap.setPendingMove(bl);
    }

    public String toPathString() {
        SlotPath slotPath = this.getSlotPath();
        if (slotPath == null) {
            return "?" + this.getType() + '?';
        }
        return slotPath.getBody();
    }

    public String toDisplayPathString(Context context) {
        SlotPath slotPath = this.getSlotPath();
        if (slotPath == null) {
            return "?" + this.getType() + '?';
        }
        return slotPath.toDisplayString();
    }

    public String getNavName() {
        String string = this.getName();
        if (string != null) {
            return string;
        }
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace != null && bComponentSpace.getRootComponent() == this) {
            return bComponentSpace.getNavName();
        }
        return null;
    }

    public String getNavDisplayName(Context context) {
        return this.getDisplayName(context);
    }

    public BINavNode getNavParent() {
        BComponent bComponent = (BComponent)this.getParent();
        if (bComponent != null) {
            return bComponent;
        }
        return this.getComponentSpace();
    }

    public boolean hasNavChildren() {
        return true;
    }

    public BINavNode getNavChild(String string) {
        BValue bValue = this.get(string);
        if (bValue instanceof BINavNode) {
            return (BINavNode)((Object)bValue);
        }
        return null;
    }

    public BINavNode resolveNavChild(String string) {
        BINavNode bINavNode = this.getNavChild(string);
        if (bINavNode != null) {
            return bINavNode;
        }
        throw new UnresolvedException(string);
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] bINavNodeArray;
        this.loadSlots();
        BComponent[] bComponentArray = new BComponent[this.getSlotCount()];
        SlotCursor slotCursor = this.getProperties();
        int n = 0;
        while (slotCursor.nextComponent()) {
            bINavNodeArray = (BComponent)slotCursor.get();
            if (Flags.isHidden(this, slotCursor.property()) || !bINavNodeArray.isNavChild()) continue;
            bComponentArray[n++] = bINavNodeArray;
        }
        bINavNodeArray = new BComponent[n];
        System.arraycopy(bComponentArray, 0, bINavNodeArray, 0, n);
        return bINavNodeArray;
    }

    public boolean isNavChild() {
        return true;
    }

    public String getNavDescription(Context context) {
        return this.getType().toString();
    }

    public BOrd getNavOrd() {
        BComponentSpace bComponentSpace = this.getComponentSpace();
        if (bComponentSpace == null) {
            return null;
        }
        BOrd bOrd = bComponentSpace.getAbsoluteOrd();
        if (bOrd == null) {
            return null;
        }
        SlotPath slotPath = this.getSlotPath();
        if (slotPath == null) {
            return null;
        }
        return BOrd.make(bOrd, slotPath);
    }

    public BIcon getNavIcon() {
        return this.getIcon();
    }

    public final Property add(String string, BValue bValue, int n, BFacets bFacets, Context context) {
        return this.slotMap.add(string, n, bValue, bValue.getSlotMap(), bFacets, context, null);
    }

    public final Property add(String string, BValue bValue, int n, Context context) {
        return this.slotMap.add(string, n, bValue, bValue.getSlotMap(), null, context, null);
    }

    public final Property add(String string, BValue bValue, int n) {
        return this.slotMap.add(string, n, bValue, bValue.getSlotMap(), null, null, null);
    }

    public final Property add(String string, BValue bValue, Context context) {
        return this.slotMap.add(string, 0, bValue, bValue.getSlotMap(), null, context, null);
    }

    public final Property add(String string, BValue bValue) {
        return this.slotMap.add(string, 0, bValue, bValue.getSlotMap(), null, null, null);
    }

    public final void remove(String string, Context context) {
        Property property = this.getProperty(string);
        if (property == null) {
            throw new NoSuchSlotException(string);
        }
        this.remove(property, context);
    }

    public final void remove(Property property, Context context) {
        this.slotMap.remove(property, context);
    }

    public final void remove(String string) {
        this.remove(string, null);
    }

    public final void remove(Property property) {
        this.slotMap.remove(property, null);
    }

    public final void remove(BComplex bComplex) {
        if (bComplex.getParent() != this) {
            throw new IllegalArgumentException("Not my child");
        }
        this.slotMap.remove(bComplex.getPropertyInParent(), null);
    }

    public final void removeAll(Context context) {
        Property[] propertyArray = ((ComponentSlotMap)this.slotMap).getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            if (!propertyArray[n].isFrozen()) {
                this.remove(propertyArray[n], context);
            }
            ++n;
        }
    }

    public final void removeAll() {
        this.removeAll(null);
    }

    public final void rename(Property property, String string, Context context) {
        this.slotMap.rename(property, string, context);
    }

    public final void rename(Property property, String string) {
        this.slotMap.rename(property, string, null);
    }

    public BFormat getDisplayNameFormat(Property property) {
        BNameMap bNameMap = (BNameMap)this.get("displayNames");
        if (bNameMap == null) {
            return null;
        }
        return bNameMap.get(property.getName());
    }

    public final void setDisplayName(Property property, BFormat bFormat, Context context) {
        BNameMap bNameMap = (BNameMap)this.get("displayNames");
        HashMap<String, BFormat> hashMap = new HashMap<String, BFormat>();
        if (bNameMap != null) {
            String[] stringArray = bNameMap.list();
            int n = 0;
            while (n < stringArray.length) {
                hashMap.put(stringArray[n], bNameMap.get(stringArray[n]));
                ++n;
            }
        }
        if (bFormat == null || bFormat.getFormat().length() == 0) {
            hashMap.remove(property.getName());
        } else {
            hashMap.put(property.getName(), bFormat);
        }
        if (hashMap.size() == 0) {
            if (bNameMap != null) {
                this.remove("displayNames", context);
            }
        } else {
            boolean bl = false;
            if (bNameMap == null) {
                bl = true;
            }
            boolean bl2 = bl;
            bNameMap = BNameMap.make(hashMap);
            if (bl2) {
                this.add("displayNames", bNameMap, 4, context);
            } else {
                this.set("displayNames", (BValue)bNameMap, context);
            }
        }
    }

    public final void reorder(Property[] propertyArray, Context context) {
        this.slotMap.reorder(propertyArray, context);
    }

    public final void reorder(Property[] propertyArray) {
        this.slotMap.reorder(propertyArray, null);
    }

    public final void reorderToTop(Property property, Context context) {
        this.slotMap.reorderToTop(property, context);
    }

    public final void reorderToTop(Property property) {
        this.slotMap.reorderToTop(property, null);
    }

    public final void reorderToBottom(Property property, Context context) {
        this.slotMap.reorderToBottom(property, context);
    }

    public final void reorderToBottom(Property property) {
        this.slotMap.reorderToBottom(property, null);
    }

    public BValue getActionParameterDefault(Action action) {
        return action.getParameterDefault();
    }

    public final BValue invoke(Action action, BValue bValue, Context context) throws ActionInvokeException {
        return this.slotMap.invoke(action, bValue, context);
    }

    public final BValue invoke(Action action, BValue bValue) throws ActionInvokeException {
        return this.slotMap.invoke(action, bValue, null);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        Nre.engineManager.enqueueAction(this, action, bValue);
        return null;
    }

    public void doInvoke(Action action, BValue bValue, Context context) throws ActionInvokeException {
        EngineUtil.doInvoke(this, action, bValue, context);
    }

    public final void fire(Topic topic, BValue bValue, Context context) {
        this.slotMap.fire(topic, bValue, context);
    }

    public final void fire(Topic topic, BValue bValue) {
        this.slotMap.fire(topic, bValue, null);
    }

    public void checkAdd(String string, BValue bValue, int n, BFacets bFacets, Context context) {
    }

    public void checkRemove(Property property, Context context) {
    }

    public void checkRename(Property property, String string, Context context) {
    }

    public void checkReorder(Property[] propertyArray, Context context) {
    }

    public void checkSetFlags(Slot slot, int n, Context context) {
    }

    public void checkSetFacets(Slot slot, BFacets bFacets, Context context) {
    }

    public boolean isParentLegal(BComponent bComponent) {
        return true;
    }

    public boolean isChildLegal(BComponent bComponent) {
        return true;
    }

    public void changed(Property property, Context context) {
    }

    public void added(Property property, Context context) {
    }

    public void removed(Property property, BValue bValue, Context context) {
    }

    public void renamed(Property property, String string, Context context) {
    }

    public void reordered(Context context) {
    }

    public void flagsChanged(Slot slot, Context context) {
    }

    public void facetsChanged(Slot slot, Context context) {
    }

    public void recategorized(Context context) {
    }

    public void childParented(Property property, BValue bValue, Context context) {
    }

    public void childUnparented(Property property, BValue bValue, Context context) {
    }

    public void knobAdded(Knob knob, Context context) {
    }

    public void knobRemoved(Knob knob, Context context) {
    }

    public synchronized BComponent[] getChildComponents() {
        BComponent[] bComponentArray = new BComponent[this.getSlotCount()];
        SlotCursor slotCursor = this.getProperties();
        int n = 0;
        while (slotCursor.nextComponent()) {
            bComponentArray[n++] = (BComponent)slotCursor.get();
        }
        BComponent[] bComponentArray2 = new BComponent[n];
        System.arraycopy(bComponentArray, 0, bComponentArray2, 0, n);
        return bComponentArray2;
    }

    public synchronized Object[] getChildren(Class clazz) {
        Object[] objectArray = new Object[this.getSlotCount()];
        SlotCursor slotCursor = this.getProperties();
        int n = 0;
        while (slotCursor.next(clazz)) {
            objectArray[n++] = slotCursor.get();
        }
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    public BValue getMixIn(Type type) {
        return this.get(type.toString().replace(':', '_'));
    }

    public final LinkCheck checkLink(BComponent bComponent, Slot slot, Slot slot2, Context context) {
        Object object;
        if (slot2 != null && slot2.isProperty() && ((object = slot2.asProperty()).getType().is(BPassword.TYPE) || object.getType().is(BPermissionsMap.TYPE))) {
            return LinkCheck.makeInvalid("Invalid link target.");
        }
        if (slot != null && slot.isProperty() && ((object = slot.asProperty()).getType().is(BPassword.TYPE) || object.getType().is(BPermissionsMap.TYPE))) {
            return LinkCheck.makeInvalid("Invalid link source.");
        }
        object = LinkCheck.make(bComponent, slot, this, slot2, context);
        if (((LinkCheck)object).isValid()) {
            object = this.doCheckLink(bComponent, slot, slot2, context);
        }
        return object;
    }

    protected LinkCheck doCheckLink(BComponent bComponent, Slot slot, Slot slot2, Context context) {
        return LinkCheck.makeValid();
    }

    public BLink makeLink(BComponent bComponent, Slot slot, Slot slot2, Context context) {
        BOrd bOrd = bComponent.getHandleOrd();
        Type type = null;
        if (slot.isAction()) {
            type = slot.asAction().getParameterType();
        } else if (slot.isTopic()) {
            type = slot.asTopic().getEventType();
        } else if (slot.isProperty()) {
            type = slot.asProperty().getType();
        }
        Type type2 = null;
        if (slot2.isAction()) {
            type2 = slot2.asAction().getParameterType();
        } else if (slot2.isTopic()) {
            type2 = slot2.asTopic().getEventType();
        } else if (slot2.isProperty()) {
            type2 = slot2.asProperty().getType();
        }
        if (type != null && type2 != null && !type.is(type2)) {
            Registry registry = Sys.getRegistry();
            TypeInfo[] typeInfoArray = registry.getAdapters(type.getTypeInfo(), type2.getTypeInfo());
            int n = typeInfoArray.length - 1;
            while (n >= 0) {
                if (registry.isAgent(typeInfoArray[n], BConversionLink.TYPE.getTypeInfo())) {
                    return new BConversionLink(bOrd, slot.getName(), slot2.getName(), true, (BConverter)typeInfoArray[n].getInstance());
                }
                --n;
            }
        }
        return new BLink(bOrd, slot.getName(), slot2.getName(), true);
    }

    public synchronized BLink[] getLinks() {
        Object object;
        this.loadSlots();
        BLink[] bLinkArray = new BLink[this.getSlotCount()];
        int n = 0;
        SlotCursor slotCursor = this.slotMap.getProperties();
        while (slotCursor.nextObject()) {
            object = slotCursor.get();
            if (!(object instanceof BLink)) continue;
            bLinkArray[n++] = (BLink)object;
        }
        object = new BLink[n];
        System.arraycopy(bLinkArray, 0, object, 0, n);
        return object;
    }

    public synchronized BLink[] getLinks(Slot slot) {
        Object object;
        this.loadSlots();
        String string = slot.getName();
        BLink[] bLinkArray = new BLink[this.getSlotCount()];
        int n = 0;
        SlotCursor slotCursor = this.slotMap.getProperties();
        while (slotCursor.nextObject()) {
            BLink bLink;
            object = slotCursor.get();
            if (!(object instanceof BLink) || !(bLink = (BLink)object).getTargetSlotName().equals(string)) continue;
            bLinkArray[n++] = (BLink)object;
        }
        object = new BLink[n];
        System.arraycopy(bLinkArray, 0, object, 0, n);
        return object;
    }

    public synchronized int getKnobCount() {
        return this.slotMap.getKnobCount();
    }

    public synchronized Knob[] getKnobs() {
        return this.slotMap.getKnobs();
    }

    public synchronized Knob[] getKnobs(Slot slot) {
        return this.slotMap.getKnobs(slot);
    }

    public synchronized boolean isLinkTarget(Slot slot) {
        boolean bl = false;
        if (this.getLinks(slot).length > 0) {
            bl = true;
        }
        return bl;
    }

    public BLink linkTo(BComponent bComponent, Slot slot, Slot slot2) {
        return this.linkTo(null, bComponent, slot, slot2);
    }

    public BLink linkTo(String string, BComponent bComponent, Slot slot, Slot slot2) {
        BLink bLink = new BLink(bComponent, slot, slot2);
        this.add(string, (BValue)bLink, 2);
        bLink.activate();
        return bLink;
    }

    public BCategoryMask getAppliedCategoryMask() {
        return this.slotMap.getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        return this.slotMap.getCategoryMask();
    }

    public void setCategoryMask(BCategoryMask bCategoryMask, Context context) {
        this.slotMap.setCategoryMask(bCategoryMask, context);
    }

    public BPermissions getPermissions(Context context) {
        BPermissions bPermissions = this.slotMap.getCachedPermissions();
        if (bPermissions == null) {
            bPermissions = context != null && context.getUser() != null ? context.getUser().getPermissionsFor(this) : BPermissions.all;
        }
        return bPermissions;
    }

    public boolean canRead(OrdTarget ordTarget) {
        if (ordTarget.getComponent() != this) {
            throw new IllegalStateException();
        }
        Slot slot = ordTarget.getSlotInComponent();
        BPermissions bPermissions = ordTarget.getPermissionsForTarget();
        if (slot == null) {
            return bPermissions.has(1);
        }
        if (Flags.isOperator(this, slot)) {
            return bPermissions.has(1);
        }
        return bPermissions.has(16);
    }

    public boolean canWrite(OrdTarget ordTarget) {
        if (ordTarget.getComponent() != this) {
            throw new IllegalStateException();
        }
        Slot slot = ordTarget.getSlotInComponent();
        BPermissions bPermissions = ordTarget.getPermissionsForTarget();
        if (slot == null) {
            return bPermissions.has(2);
        }
        if (Flags.isReadonly(this, slot)) {
            return false;
        }
        if (Flags.isOperator(this, slot)) {
            return bPermissions.has(2);
        }
        return bPermissions.has(32);
    }

    public boolean canInvoke(OrdTarget ordTarget) {
        if (ordTarget.getComponent() != this) {
            throw new IllegalStateException();
        }
        Slot slot = ordTarget.getSlotInComponent();
        BPermissions bPermissions = ordTarget.getPermissionsForTarget();
        if (slot == null) {
            return bPermissions.has(4);
        }
        if (Flags.isOperator(this, slot)) {
            return bPermissions.has(4);
        }
        return bPermissions.has(64);
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        int n = agentList.indexOf("workbench:PropertySheet");
        int n2 = agentList.indexOf("wiresheet:WireSheet");
        if (n >= 0 && n2 >= 0) {
            if (this instanceof BFolder) {
                if (n < n2) {
                    agentList.swap(n, n2);
                }
            } else if (n2 < n) {
                agentList.swap(n, n2);
            }
        }
        agentList.toBottom("wbutil:CategorySheet");
        agentList.toBottom("workbench:SlotSheet");
        agentList.toBottom("workbench:LinkSheet");
        agentList.toBottom("pxEditor:PxEditor");
        int n3 = 0;
        while (n3 < agentList.size()) {
            AgentInfo agentInfo = agentList.get(n3);
            if (agentInfo.getAgentType().is(BAbstractPxView.TYPE)) {
                agentList.toTop(agentInfo);
            }
            ++n3;
        }
        Property[] propertyArray = this.getPropertiesArray();
        int n4 = propertyArray.length - 1;
        while (n4 >= 0) {
            BValue bValue;
            if (propertyArray[n4].getTypeAccess() == 7 && (bValue = this.get(propertyArray[n4])) instanceof AgentInfo) {
                agentList.add((AgentInfo)((Object)bValue));
            }
            --n4;
        }
        PxUtil.explode(agentList);
        return agentList;
    }

    public BIcon getIcon() {
        BValue bValue = this.get("icon");
        if (bValue instanceof BIcon) {
            return (BIcon)bValue;
        }
        return icon;
    }

    protected static Action newAction(int n, BValue bValue, BFacets bFacets) {
        if (bFacets == null) {
            bFacets = BFacets.NULL;
        }
        return new NAction(n, bValue, bFacets);
    }

    protected static Action newAction(int n, BValue bValue) {
        return BComponent.newAction(n, bValue, null);
    }

    protected static Action newAction(int n, BFacets bFacets) {
        return BComponent.newAction(n, null, bFacets);
    }

    protected static Action newAction(int n) {
        return BComponent.newAction(n, null, null);
    }

    protected static Topic newTopic(int n, BFacets bFacets) {
        if (bFacets == null) {
            bFacets = BFacets.NULL;
        }
        return new NTopic(n, bFacets);
    }

    protected static Topic newTopic(int n) {
        return BComponent.newTopic(n, null);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$sys$BComponent;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BComponent = BComponent.class("[Ljavax.baja.sys.BComponent;", false);
        }
        TYPE = Sys.loadType(clazz);
        icon = BIcon.std("object.png");
    }
}

