/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBoolean
extends BEnum
implements BIBoolean,
BIDataValue {
    public static final BBoolean TRUE = new BBoolean(true);
    public static final BBoolean FALSE;
    public static final BBoolean DEFAULT;
    public static final Type TYPE;
    private boolean value;
    BDynamicEnum asDynamic;
    static /* synthetic */ Class class$javax$baja$sys$BBoolean;

    public static final BBoolean make(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static final BBoolean make(String string) {
        return BBoolean.decode(string) ? TRUE : FALSE;
    }

    public final boolean getBoolean() {
        return this.value;
    }

    public final BFacets getBooleanFacets() {
        return BFacets.NULL;
    }

    public final BBoolean not() {
        return BBoolean.make(this.value ^ true);
    }

    public final BBoolean and(BBoolean bBoolean) {
        boolean bl = false;
        if (this.value && bBoolean.value) {
            bl = true;
        }
        return BBoolean.make(bl);
    }

    public final BBoolean or(BBoolean bBoolean) {
        boolean bl = false;
        if (this.value || bBoolean.value) {
            bl = true;
        }
        return BBoolean.make(bl);
    }

    public final int getOrdinal() {
        return this.value ? 1 : 0;
    }

    public final String getTag() {
        return this.value ? "true" : "false";
    }

    public final String getDisplayTag(Context context) {
        return this.getTag();
    }

    public final BEnumRange getRange() {
        return BEnumRange.BOOLEAN_RANGE;
    }

    public final boolean isActive() {
        return this.value;
    }

    public final int hashCode() {
        if (this.value) {
            return 1;
        }
        return 0;
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        }
        return bl;
    }

    public final String toString(Context context) {
        return BBoolean.toString(this.value, context);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.value);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return dataInput.readBoolean() ? TRUE : FALSE;
    }

    public final String encodeToString() throws IOException {
        return BBoolean.encode(this.value);
    }

    public final BObject decodeFromString(String string) throws IOException {
        return BBoolean.make(string);
    }

    public final BIDataValue toDataValue() {
        return this;
    }

    public static final String encode(boolean bl) {
        return bl ? "true" : "false";
    }

    public static final boolean decode(String string) {
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return false;
        }
        throw new IllegalArgumentException("Invalid boolean: " + string);
    }

    public static final String toString(boolean bl, Context context) {
        if (context != null) {
            if (bl) {
                BObject bObject = context.getFacet("trueText");
                if (bObject != null) {
                    return BFormat.format(bObject.toString(), null, context);
                }
            } else {
                BObject bObject = context.getFacet("falseText");
                if (bObject != null) {
                    return BFormat.format(bObject.toString(), null, context);
                }
            }
        }
        return Lexicon.make("baja", context).getText(bl ? "true" : "false");
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BBoolean(boolean bl) {
        this.value = bl;
    }

    static {
        DEFAULT = FALSE = new BBoolean(false);
        Class clazz = class$javax$baja$sys$BBoolean;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BBoolean = BBoolean.class("[Ljavax.baja.sys.BBoolean;", false);
        }
        TYPE = Sys.loadType(clazz);
    }
}

